/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.comparetables.impl.CompareTablesPortDescriptionModel;
import com.sas.etl.models.job.transforms.comparetables.impl.CompareTablesTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.comparetables.CompareTablesTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CompareTablesTransformAdapter
extends AbstractDataTransformAdapter {
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(CompareTablesTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(CompareTablesTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(CompareTablesTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(CompareTablesTransformModel.getTransformTypeID(), 24);
    public static final int CONTROL_PORT = 0;
    public static final int SOURCE_PORT = 1;
    public static final int COMPARISON_PORT = 2;
    public static final int CHANGED_RCDS_PORT = 1;
    public static final int NEW_RCDS_PORT = 2;
    public static final int UNCHANGED_RCDS_PORT = 3;
    public static final int MISSING_RCDS_PORT = 4;
    public static final int DUPLICATE_RCDS_PORT = 5;
    private CompareTablesTransformModel m_transform;

    public CompareTablesTransformAdapter(CompareTablesTransformModel transform) {
        super((IDataTransform)transform);
        this.m_transform = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        CompareTablesPortDescriptionModel[] aInputPorts = this.m_transform.getInputPortDescriptions();
        IPortDescription[] aPortDesc = new IPortDescription[aInputPorts.length + 1];
        aPortDesc[0] = PortDescriptionFactory.getInstance().createControlInputPortDescriptionForTransform(1);
        for (int i = 0; i < aInputPorts.length; ++i) {
            CompareTablesPortDescriptionModel inputPort = aInputPorts[i];
            aPortDesc[i + 1] = PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(inputPort.getTooltipText(), inputPort.getName(), 1, DEFAULT_TABLE_TYPES);
        }
        return aPortDesc;
    }

    @Override
    public int getInputPortIndex(IObject obj) {
        int[] iaPorts;
        if (obj instanceof IPhysicalTable && (iaPorts = this.m_transform.findInSourcePorts((IPhysicalTable)obj)).length > 0) {
            return iaPorts[0] + 1;
        }
        return -1;
    }

    @Override
    public int[] getInputPortIndexes(IObject obj) {
        int[] iaPorts = this.m_transform.findInSourcePorts((IPhysicalTable)obj);
        int i = 0;
        while (i < iaPorts.length) {
            int n = i++;
            iaPorts[n] = iaPorts[n] + 1;
        }
        return iaPorts;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        return portIndex == 0 ? obj instanceof ITransform : portIndex >= 1 && obj instanceof IPhysicalTable;
    }

    @Override
    public boolean connectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1) {
            if (obj instanceof IPhysicalTable) {
                this.m_transform.setSourceTable((IPhysicalTable)obj);
                return true;
            }
        } else if (portIndex == 2 && obj instanceof IPhysicalTable) {
            this.m_transform.setComparisonTable((IPhysicalTable)obj, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectFromInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1) {
            if (obj instanceof IPhysicalTable) {
                this.m_transform.setSourceTable(null);
                return true;
            }
        } else if (portIndex == 2 && obj instanceof IPhysicalTable) {
            this.m_transform.setComparisonTable(null, false);
            return true;
        }
        return false;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        CompareTablesPortDescriptionModel[] aOutputPorts = this.m_transform.getOutputPortDescriptions();
        IPortDescription[] aPortDesc = new IPortDescription[aOutputPorts.length + 1];
        aPortDesc[0] = PortDescriptionFactory.getInstance().createControlOutputPortDescriptionForTransform(1);
        for (int i = 0; i < aOutputPorts.length; ++i) {
            CompareTablesPortDescriptionModel outputPort = aOutputPorts[i];
            aPortDesc[i + 1] = PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(outputPort.getTooltipText(), outputPort.getName(), 1, DEFAULT_TABLE_TYPES);
        }
        return aPortDesc;
    }

    @Override
    public int getOutputPortIndex(IObject obj) {
        int[] iaPorts;
        if (obj instanceof IPhysicalTable && (iaPorts = this.m_transform.findInTargetPorts((IPhysicalTable)obj)).length > 0) {
            return iaPorts[0] + 1;
        }
        return -1;
    }

    @Override
    public int[] getOutputPortIndexes(IObject obj) {
        int[] iaPorts = this.m_transform.findInTargetPorts((IPhysicalTable)obj);
        int i = 0;
        while (i < iaPorts.length) {
            int n = i++;
            iaPorts[n] = iaPorts[n] + 1;
        }
        return iaPorts;
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        return portIndex == 0 ? obj instanceof ITransform : portIndex >= 1 && obj instanceof IPhysicalTable && !this.m_transform.containsInDataTargets((IDataObject)obj);
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (obj instanceof IPhysicalTable) {
            this.m_transform.setTargetTable((IPhysicalTable)obj, portIndex - 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectFromOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (obj instanceof IPhysicalTable) {
            this.m_transform.setTargetTable(null, portIndex - 1);
            return true;
        }
        return false;
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab optionsTab = new OptionsTab(this.m_transform.getOptionModel(), "options_tab_compare_tables", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_transform, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_transform));
            lTabs.add(new CompareTablesTab(this.m_transform));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(optionsTab);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_transform, true, false));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_transform));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_transform));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_transform));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_transform, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    protected WAPropertyTab createMappingsTab(boolean details) {
        MappingsTab.Configuration config = new MappingsTab.Configuration();
        config.setMultipleTargetTablesEnabled(true);
        config.setExpressionActionsVisible(false);
        config.setDragMultipleSourceColumnsEnabled(false);
        config.setHiddenColumnsInTargetColumnsTable(new int[]{4});
        config.setWhereUsedSettingsKeyPrefix(details ? "Details" : "Properties");
        config.setTargetTableSettingsKeyPrefix("CompareTables.TargetColumnsTable");
        return new MappingsTab((IMappingsContainer)this.m_transform, config);
    }
}

