/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IObject;
import com.sas.etl.models.job.ITransform;
import com.sas.wadmin.jobeditor.diagram.adapters.AbstractObjectAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.IndicatorFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.IControlTransformNodeAdapter;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AbstractControlTransformAdapter
extends AbstractObjectAdapter
implements IControlTransformNodeAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(AbstractControlTransformAdapter.class);
    protected static final String[] DEFAULT_TABLE_TYPES = new String[]{"PhysicalTable", "WorkTable"};
    protected static final IPortDescription DEFAULT_INPUT_CONTROL_PORT = PortDescriptionFactory.getInstance().createControlInputPortDescriptionForTransform(1);
    protected static final IPortDescription DEFAULT_OUTPUT_CONTROL_PORT = PortDescriptionFactory.getInstance().createControlOutputPortDescriptionForTransform(1);
    private static final IPortDescription[] INPUT_PORTS = new IPortDescription[]{DEFAULT_INPUT_CONTROL_PORT};
    private static final IPortDescription[] OUTPUT_PORTS = new IPortDescription[]{DEFAULT_OUTPUT_CONTROL_PORT};
    private ITransform m_transform;

    public AbstractControlTransformAdapter(ITransform transform) {
        super((IComplexPersistableObject)transform);
        this.m_transform = transform;
    }

    public ITransform getTransform() {
        return this.m_transform;
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return INPUT_PORTS;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return OUTPUT_PORTS;
    }

    @Override
    public boolean connectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        return false;
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        return false;
    }

    @Override
    public boolean disconnectFromInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        return false;
    }

    @Override
    public boolean disconnectFromOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        return false;
    }

    @Override
    public boolean isAutomaticAddToControlFlow() {
        return true;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof ITransform;
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof ITransform;
    }

    public IPortDescription addInputPortDescription(Object obj) {
        return null;
    }

    public IPortDescription addOutputPortDescription(Object obj) {
        return null;
    }

    public int deleteInputPort(Object obj) {
        return -1;
    }

    public int deleteOutputPort(Object obj) {
        return -1;
    }

    public List updateInputPort(Object obj) {
        return null;
    }

    public List updateOutputPort(Object obj) {
        return null;
    }

    public final JMenuItem[] getPopupMenuItems() {
        return null;
    }

    @Override
    public void addContextMenuItems(JPopupMenu mnuPopup) {
    }

    public void updateIndicatorButtons() {
    }

    @Override
    public String getNodeType() {
        return this.getName();
    }

    @Override
    public String getNodeTypeDescription() {
        return this.getName();
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return null;
    }

    @Override
    public int getInputPortIndex(IObject obj) {
        return -1;
    }

    @Override
    public int getOutputPortIndex(IObject obj) {
        return -1;
    }

    @Override
    public List getIndicatorButtons() {
        Integer iUserWritten = new Integer(1000);
        Integer iPrePost = new Integer(1001);
        Integer iDiagMode = new Integer(1002);
        Integer iCheckpointSet = new Integer(1003);
        if (this.m_transform.isUsingUserWrittenCode() && !this.getIndicatorsMap().containsKey(iUserWritten)) {
            this.getIndicatorsMap().put(iUserWritten, IndicatorFactory.getInstance().getIndicator(1000));
        } else if (!this.m_transform.isUsingUserWrittenCode() && this.getIndicatorsMap().containsKey(iUserWritten)) {
            this.getIndicatorsMap().remove(iUserWritten);
        }
        if ((this.m_transform.isUsingPostProcessCode() || this.m_transform.isUsingPreProcessCode()) && !this.getIndicatorsMap().containsKey(iPrePost)) {
            this.getIndicatorsMap().put(iPrePost, IndicatorFactory.getInstance().getIndicator(1001));
        } else if (!this.m_transform.isUsingPostProcessCode() && !this.m_transform.isUsingPreProcessCode() && this.getIndicatorsMap().containsKey(iPrePost)) {
            this.getIndicatorsMap().remove(iPrePost);
        }
        if (this.m_transform.isCollectingDiagnostics() && !this.getIndicatorsMap().containsKey(iDiagMode)) {
            this.getIndicatorsMap().put(iDiagMode, IndicatorFactory.getInstance().getIndicator(1002));
        } else if (!this.m_transform.isCollectingDiagnostics() && this.getIndicatorsMap().containsKey(iDiagMode)) {
            this.getIndicatorsMap().remove(iDiagMode);
        }
        if (this.m_transform.isCheckpointEnabled() && !this.getIndicatorsMap().containsKey(iCheckpointSet)) {
            this.getIndicatorsMap().put(iCheckpointSet, IndicatorFactory.getInstance().getIndicator(1003));
        } else if (!this.m_transform.isCheckpointEnabled() && this.getIndicatorsMap().containsKey(iCheckpointSet)) {
            this.getIndicatorsMap().remove(iCheckpointSet);
        }
        ArrayList buttons = new ArrayList();
        buttons.addAll(this.getIndicatorsMap().values());
        return buttons;
    }
}

