/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.data;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IMessageQueue;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.data.AbstractDataAdapter;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import javax.swing.Icon;

public class MessageQueueAdapter
extends AbstractDataAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(MessageQueueAdapter.class);
    protected static final String[] DEFAULT_MQ_TYPES = new String[]{"WSMQMessageQueue", "MessageQueue"};
    private static final IPortDescription INPUT_DATA_PORT = PortDescriptionFactory.getInstance().createInputPortDescriptionForDataObject("WSMQMessageQueue", Integer.MAX_VALUE);
    private static final IPortDescription OUTPUT_DATA_PORT = PortDescriptionFactory.getInstance().createOutputPortDescriptionForDataObject("WSMQMessageQueue");
    private static final IPortDescription[] INPUT_PORTS = new IPortDescription[]{INPUT_DATA_PORT};
    private static final IPortDescription[] OUTPUT_PORTS = new IPortDescription[]{OUTPUT_DATA_PORT};
    private static final Icon ICON_SMALL_MSMQ = AppIconFactory.getInstance().getIconForPublicType("MQM.MSMQ", 16);
    private static final Icon ICON_MEDIUM_MSMQ = AppIconFactory.getInstance().getIconForPublicType("MQM.MSMQ", 24);
    private static final Icon ICON_SMALL_WSMQ = AppIconFactory.getInstance().getIconForPublicType("MQM.MSMQ", 16);
    private static final Icon ICON_MEDIUM_WSMQ = AppIconFactory.getInstance().getIconForPublicType("MQM.MSMQ", 24);
    private IMessageQueue m_messageQueue;

    public MessageQueueAdapter(IMessageQueue messageQueue) {
        super((IDataObject)messageQueue);
        this.m_messageQueue = messageQueue;
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return INPUT_PORTS;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return OUTPUT_PORTS;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            if (this.m_messageQueue.getMessageQueueType() == 2) {
                return ICON_SMALL_MSMQ;
            }
            return ICON_SMALL_WSMQ;
        }
        if (size == 24) {
            if (this.m_messageQueue.getMessageQueueType() == 2) {
                return ICON_MEDIUM_MSMQ;
            }
            return ICON_MEDIUM_WSMQ;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
        lTabs.add(new GeneralTab((IObject)this.m_messageQueue, true, true));
        lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_messageQueue));
        this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_messageQueue, true);
        return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
    }
}

