/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram;

import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.graphics.components.pfd.PFDModelEvent;
import com.sas.graphics.components.pfd.PFDModelListener;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.actions.AppActionsManager;
import com.sas.wadmin.drill.DrillListener;
import com.sas.wadmin.drill.DrillableComponent;
import com.sas.wadmin.jobeditor.diagram.DiagramPanel;
import com.sas.wadmin.jobeditor.diagram.WADiagramModel;
import com.sas.wadmin.jobeditor.diagram.WADiagramPanel;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.ControlLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.StickyNoteNode;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsActionContext;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import com.sas.workspace.visuals.pfd.WsPFDPropertyTab;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class WADiagramTab
extends WsPFDPropertyTab
implements WsSelectionProvider,
DrillableComponent {
    private static final WAdminResource bundle = WAdminResource.getBundle(WADiagramTab.class);
    public static final String NOTE_COLOR_CHANGE = "fillColor";
    public static final String IS_COLLAPSED = "isCollapsed";
    private PFDModelListener m_lsnrDiagramModel;
    private PFDViewListener m_lsnrDiagram;
    private JToolBar m_tools;
    private JToolBar m_barDiagram;
    private WsAbstractAction m_actSelectAll;
    private WsAbstractAction m_actPopupAddStickyNote;
    private WsAbstractAction m_actAddStickyNote;
    private WsAbstractAction m_actCloseStickyNote;
    private WsAbstractAction m_actOpenStickyNote;
    private WsAbstractToggleAction m_actStickyNoteColorYellow;
    private WsAbstractToggleAction m_actStickyNoteColorBlue;
    private WsAbstractToggleAction m_actStickyNoteColorPink;
    private WsAbstractAction m_actAutoLayout;
    private WsAbstractToggleAction m_actLeftToRight;
    private WsAbstractToggleAction m_actTopToBottom;
    private WsAbstractToggleAction m_actBottomToTop;
    private WsAbstractToggleAction m_actZoomCustom;
    private WsAbstractToggleAction m_actZoom200;
    private WsAbstractToggleAction m_actZoom150;
    private WsAbstractToggleAction m_actZoom100;
    private WsAbstractToggleAction m_actZoom75;
    private WsAbstractToggleAction m_actZoom50;
    private WsAbstractToggleAction m_actZoom25;
    private WsAbstractToggleAction m_actZoom10;
    private WsAbstractToggleAction m_actZoomFitWidth;
    private WsAbstractToggleAction m_actZoomFitHeight;
    private WsAbstractToggleAction m_actZoomFitBoth;
    private WsAbstractToggleAction m_actShowGrid;
    private WsAbstractToggleAction m_actSnapToGrid;
    private WsAbstractToggleAction m_actGridStyleSolid;
    private WsAbstractToggleAction m_actGridStyleDot;
    private Object[] m_aSelectedObjects = new Object[0];
    private IDiagramStickyNote m_selectedStickyNote;
    private List m_lDrillListeners;
    private List m_lReferences;

    public WADiagramTab() {
        this.m_barDiagram = this.createDiagramToolBar();
        this.m_lsnrDiagramModel = new DiagramModelListener();
        this.getPFDModel().addPFDModelListener(this.m_lsnrDiagramModel);
        this.m_lsnrDiagram = this.createViewListener();
        this.getPFDComponent().addPFDViewListener(this.m_lsnrDiagram);
        this.m_lDrillListeners = new ArrayList();
        this.m_lReferences = new ArrayList();
    }

    protected PFDViewListener createViewListener() {
        return new DiagramListener();
    }

    private JToolBar createDiagramToolBar() {
        JToolBar barDiagram = WsUIUtilities.createToolBar();
        barDiagram.add((Action)this.m_actAddStickyNote);
        barDiagram.setVisible(true);
        return barDiagram;
    }

    public JToolBar getDiagramToolBar() {
        return this.m_barDiagram;
    }

    protected void createActions() {
        super.createActions();
        this.m_actSelectAll = new SelectAllAction();
        this.m_actPopupAddStickyNote = new AddStickyNotePopupMenuAction();
        this.m_actAddStickyNote = new AddStickyNoteAction();
        this.m_actCloseStickyNote = new CloseStickyNoteAction();
        this.m_actOpenStickyNote = new OpenStickyNoteAction();
        this.m_actStickyNoteColorYellow = new StickyNoteColorYellowAction();
        this.m_actStickyNoteColorBlue = new StickyNoteColorBlueAction();
        this.m_actStickyNoteColorPink = new StickyNoteColorPinkAction();
        this.m_actAutoLayout = new AutoLayoutAction();
        this.m_actLeftToRight = new FlowDirectionLeftToRightAction();
        this.m_actTopToBottom = new FlowDirectionTopToBottomAction();
        this.m_actBottomToTop = new FlowDirectionBottomToTopAction();
        this.m_actZoomCustom = new ZoomCustomAction();
        this.m_actZoom200 = new Zoom200Action();
        this.m_actZoom150 = new Zoom150Action();
        this.m_actZoom100 = new Zoom100Action();
        this.m_actZoom75 = new Zoom75Action();
        this.m_actZoom50 = new Zoom50Action();
        this.m_actZoom25 = new Zoom25Action();
        this.m_actZoom10 = new Zoom10Action();
        this.m_actZoomFitWidth = new ZoomFitWidthAction();
        this.m_actZoomFitHeight = new ZoomFitHeightAction();
        this.m_actZoomFitBoth = new ZoomFitBothAction();
        this.m_actShowGrid = new ShowGridAction();
        this.m_actSnapToGrid = new SnapToGridAction();
        this.m_actGridStyleSolid = new GridStyleSolidAction();
        this.m_actGridStyleDot = new GridStyleDotAction();
    }

    private void selectAll() {
        this.getDiagramPanel().selectAll();
    }

    public boolean save() {
        SaveRunnable run = new SaveRunnable();
        OpRequestUI op = new OpRequestUI();
        op.setTitle(this.getName());
        op.setMessage(bundle.getString("DiagramTab.Saving.txt"));
        op.execute((Runnable)run);
        return run.wasSuccessful();
    }

    private void addStickyNote() {
        StickyNoteNode note = new StickyNoteNode();
        note.setNoteStyleContext(DiagramPanel.getUserPreferenceForStickyNoteColor());
        Point pt = this.getSavedClickedPoint();
        this.getDiagramPanel().ViewToModel(pt);
        this.getDiagramPanel().addStickyNote(note, pt);
        note.expand();
    }

    public WADiagramPanel getDiagramPanel() {
        return (WADiagramPanel)this.getPFDComponent();
    }

    protected WsPFDModel createPFDModel() {
        return new WADiagramModel();
    }

    public void setToolBar(JToolBar tools) {
        if (this.m_tools == tools) {
            return;
        }
        if (this.m_tools != null) {
            this.remove(this.m_tools);
        }
        this.m_tools = tools;
        if (this.m_tools != null) {
            this.add(this.m_tools, "North");
        }
    }

    @Override
    public JToolBar getToolBar() {
        return this.m_tools;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actSelectAll.setActive(bActive);
        this.m_actAddStickyNote.setActive(bActive);
        this.m_actPopupAddStickyNote.setActive(bActive);
        this.m_actCloseStickyNote.setActive(bActive);
        this.m_actOpenStickyNote.setActive(bActive);
        this.m_actStickyNoteColorYellow.setActive(bActive);
        this.m_actStickyNoteColorBlue.setActive(bActive);
        this.m_actStickyNoteColorPink.setActive(bActive);
        this.m_actAutoLayout.setActive(bActive);
        this.m_actLeftToRight.setActive(bActive);
        this.m_actTopToBottom.setActive(bActive);
        this.m_actBottomToTop.setActive(bActive);
        this.m_actZoomCustom.setActive(bActive);
        this.m_actZoom200.setActive(bActive);
        this.m_actZoom150.setActive(bActive);
        this.m_actZoom100.setActive(bActive);
        this.m_actZoom75.setActive(bActive);
        this.m_actZoom50.setActive(bActive);
        this.m_actZoom25.setActive(bActive);
        this.m_actZoom10.setActive(bActive);
        this.m_actZoomFitWidth.setActive(bActive);
        this.m_actZoomFitHeight.setActive(bActive);
        this.m_actZoomFitBoth.setActive(bActive);
        this.m_actShowGrid.setActive(bActive);
        this.m_actSnapToGrid.setActive(bActive);
        this.m_actGridStyleSolid.setActive(bActive);
        this.m_actGridStyleDot.setActive(bActive);
    }

    protected void updateActions() {
        super.updateActions();
        this.m_actSelectAll.setEnabled(this.getDiagramPanel().getSelectionModel().getSelectionMode() == 1);
        boolean bEditable = this.isEditable();
        boolean bOnePrimitive = this.m_aSelectedObjects.length == 1;
        boolean bOneStickyNoteSelected = bOnePrimitive && this.m_aSelectedObjects[0] instanceof IDiagramStickyNote;
        boolean bStickyNoteCollapsed = bOneStickyNoteSelected && ((IDiagramStickyNote)this.m_aSelectedObjects[0]).isCollapsed();
        this.m_actAddStickyNote.setEnabled(bEditable);
        this.m_actPopupAddStickyNote.setEnabled(bEditable);
        this.m_actCloseStickyNote.setEnabled(bOneStickyNoteSelected && bEditable && !bStickyNoteCollapsed);
        this.m_actOpenStickyNote.setEnabled(bOneStickyNoteSelected && bEditable && bStickyNoteCollapsed);
        this.m_actStickyNoteColorYellow.setEnabled(bOneStickyNoteSelected && bEditable);
        this.m_actStickyNoteColorBlue.setEnabled(bOneStickyNoteSelected && bEditable);
        this.m_actStickyNoteColorPink.setEnabled(bOneStickyNoteSelected && bEditable);
        this.m_actBottomToTop.setSelected(this.getFlowDirection().equals("Up"));
        this.m_actTopToBottom.setSelected(this.getFlowDirection().equals("Down"));
        this.m_actLeftToRight.setSelected(this.getFlowDirection().equals("Right"));
        if (bOneStickyNoteSelected) {
            this.setSelectedStickyNoteColor();
        }
    }

    public IDiagramNode[] findNodes(IObject obj) {
        return this.getDiagramPanel().findNodes(obj);
    }

    private String getFlowDirection() {
        return this.getDiagramPanel().getFlowDirection();
    }

    private void setFlowDirection(String sFlowDirection) {
        this.getDiagramPanel().setFlowDirection(sFlowDirection);
    }

    public void selectObject(IObject obj) {
        this.getDiagramPanel().selectNodes(obj);
    }

    private void setShowGrid(boolean bShowGrid) {
        this.getDiagramPanel().setShowGrid(bShowGrid);
    }

    private boolean isShowGrid() {
        return this.getDiagramPanel().isShowGrid();
    }

    private void doAutoLayout() {
        this.getDiagramPanel().updateLayout();
    }

    public void setZoom(double iZoom) {
        if (iZoom == 2.0) {
            this.m_actZoom200.setSelected(true);
        } else if (iZoom == 1.5) {
            this.m_actZoom150.setSelected(true);
        } else if (iZoom == 1.0) {
            this.m_actZoom100.setSelected(true);
        } else if (iZoom == 0.75) {
            this.m_actZoom75.setSelected(true);
        } else if (iZoom == 0.5) {
            this.m_actZoom50.setSelected(true);
        } else if (iZoom == 0.25) {
            this.m_actZoom25.setSelected(true);
        } else if (iZoom == 0.1) {
            this.m_actZoom10.setSelected(true);
        } else {
            this.m_actZoom10.setSelected(false);
            this.m_actZoom25.setSelected(false);
            this.m_actZoom50.setSelected(false);
            this.m_actZoom100.setSelected(false);
            this.m_actZoom150.setSelected(false);
            this.m_actZoom200.setSelected(false);
            this.m_actZoom75.setSelected(false);
            this.m_actZoomCustom.setSelected(true);
        }
    }

    private void setZoom(String sZoom) {
        this.getDiagramPanel().setZoom(sZoom);
        if (sZoom.equals("FitBoth") || sZoom.equals("FitHeight") || sZoom.equals("FitWidth") || !this.getZoom().equals("2.0") && !this.getZoom().equals("1.5") && !this.getZoom().equals("1") && !this.getZoom().equals(".75") && !this.getZoom().equals(".5") && !this.getZoom().equals(".25") && !this.getZoom().equals(".1")) {
            this.m_actZoomCustom.setSelected(true);
        }
    }

    private String getZoom() {
        return this.getDiagramPanel().getZoom();
    }

    public void setSnapToGrid(boolean bSnapToGrid) {
        this.getDiagramPanel().setSnapToGrid(bSnapToGrid);
    }

    public boolean isSnapToGrid() {
        return this.getDiagramPanel().isSnapToGrid();
    }

    private void setGridStyle(int iGridStyle) {
        this.getDiagramPanel().setGridStyle(iGridStyle);
    }

    private int getGridStyle() {
        return this.getDiagramPanel().getGridStyle();
    }

    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.add(WsSelectionChangedListener.class, lsnr);
    }

    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.remove(WsSelectionChangedListener.class, lsnr);
    }

    protected boolean isContextForTypes(WsActionContextInterface context, String[] aTypes) {
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (!(aObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            String sType = ((SimpleObject)aObjects[iObject]).getPublicType();
            boolean bFound = false;
            for (int iType = 0; iType < aTypes.length && !bFound; ++iType) {
                bFound = aTypes[iType].equals(sType);
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    protected boolean isContextForType(WsActionContextInterface context, String sType) {
        return this.isContextForTypes(context, new String[]{sType});
    }

    public Object[] getSelectedObjects() {
        return this.m_aSelectedObjects;
    }

    protected void setSelectedStickyNote(IDiagramStickyNote note) {
        if (this.m_selectedStickyNote == note) {
            return;
        }
        this.m_selectedStickyNote = note;
    }

    protected IDiagramStickyNote getSelectedStickyNote() {
        return this.m_selectedStickyNote;
    }

    protected void setSelectedStickyNoteColor() {
        IDiagramStickyNote note = this.getSelectedStickyNote();
        if (note != null) {
            String style = note.getNoteStyleContext();
            if ("NoteStyleYellow".equals(style)) {
                this.m_actStickyNoteColorYellow.setSelected(true);
            } else if ("NoteStyleBlue".equals(style)) {
                this.m_actStickyNoteColorBlue.setSelected(true);
            } else if ("NoteStylePink".equals(style)) {
                this.m_actStickyNoteColorPink.setSelected(true);
            }
        }
    }

    protected JPopupMenu createCanvasPopupMenu() {
        this.m_aSelectedObjects = new Object[]{this.getDiagramPanel().getDiagramModel().getMainObject()};
        this.fireSelectionChangedEvent();
        WsActionContext context = new WsActionContext("DiagramTab", (WsSelectionProvider)this);
        JPopupMenu menuPopup = AppActionsManager.getInstance().createPopupMenuFor((WsActionContextInterface)context);
        return menuPopup;
    }

    protected JPopupMenu createPrimitivePopupMenu(PFDPrimitive prim) {
        if (prim instanceof IDiagramNode) {
            return this.createNodePopupMenu((IDiagramNode)prim);
        }
        if (prim instanceof StickyNoteNode) {
            return this.createStickyNotePopupMenu((StickyNoteNode)prim);
        }
        if (prim instanceof ControlLink) {
            return this.createControlLinkPopupMenu((ControlLink)prim);
        }
        if (prim instanceof DataLink) {
            return this.createDataLinkPopupMenu((DataLink)prim);
        }
        throw new UnsupportedOperationException("Unable to create popup menu for " + prim);
    }

    protected JPopupMenu createNodePopupMenu(IDiagramNode node) {
        return null;
    }

    protected JPopupMenu createStickyNotePopupMenu(IDiagramStickyNote note) {
        JPopupMenu mnuPopup = new JPopupMenu();
        mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actOpenStickyNote));
        mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actCloseStickyNote));
        mnuPopup.addSeparator();
        mnuPopup.add(WsUIUtilities.createRadioButtonMenuItem((WsAbstractToggleAction)this.m_actStickyNoteColorYellow));
        mnuPopup.add(WsUIUtilities.createRadioButtonMenuItem((WsAbstractToggleAction)this.m_actStickyNoteColorBlue));
        mnuPopup.add(WsUIUtilities.createRadioButtonMenuItem((WsAbstractToggleAction)this.m_actStickyNoteColorPink));
        return mnuPopup;
    }

    protected JPopupMenu createControlLinkPopupMenu(ControlLink link) {
        return null;
    }

    protected JPopupMenu createDataLinkPopupMenu(DataLink link) {
        return null;
    }

    protected JPopupMenu createPrimitivesPopupMenu(PFDPrimitive[] aPrimitives) {
        WsActionContext context = new WsActionContext("DiagramTab", (WsSelectionProvider)this);
        return AppActionsManager.getInstance().createPopupMenuFor((WsActionContextInterface)context);
    }

    protected void selectionChanged() {
        PFDPrimitive[] aPrimitives = this.getDiagramPanel().getSelectionModel().getPrimitives();
        this.m_aSelectedObjects = new Object[aPrimitives.length];
        for (int iPrimitive = 0; iPrimitive < aPrimitives.length; ++iPrimitive) {
            this.m_aSelectedObjects[iPrimitive] = aPrimitives[iPrimitive] instanceof IDiagramNode ? ((IDiagramNode)aPrimitives[iPrimitive]).getObject() : aPrimitives[iPrimitive];
        }
        if (this.m_aSelectedObjects.length == 1 && this.m_aSelectedObjects[0] instanceof IDiagramStickyNote) {
            this.setSelectedStickyNote((IDiagramStickyNote)this.m_aSelectedObjects[0]);
        } else if (this.m_aSelectedObjects.length == 0) {
            this.m_aSelectedObjects = new Object[]{this.getDiagramPanel().getDiagramModel().getMainObject()};
        }
        this.fireSelectionChangedEvent();
        this.updateActions();
    }

    protected void fireSelectionChangedEvent() {
        WsSelectionChangedListener[] aListeners = (WsSelectionChangedListener[])this.listenerList.getListeners(WsSelectionChangedListener.class);
        if (aListeners.length == 0) {
            return;
        }
        WsSelectionChangedEvent ev = new WsSelectionChangedEvent((WsSelectionProvider)this);
        for (int iListener = 0; iListener < aListeners.length; ++iListener) {
            aListeners[iListener].selectionChanged(ev);
        }
    }

    public void saveSettingsAndCleanUp() {
        this.getPFDModel().removePFDModelListener(this.m_lsnrDiagramModel);
        this.getPFDComponent().removePFDViewListener(this.m_lsnrDiagram);
        super.saveSettingsAndCleanUp();
    }

    protected boolean isContextForMainObject(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        return aObjects.length == 1 && aObjects[0] == this.getDiagramPanel().getDiagramModel().getMainObject();
    }

    protected IPersistableObject getMainObject() {
        return this.getDiagramPanel().getDiagramModel().getMainObject();
    }

    private void closeStickyNote() {
        this.getDiagramPanel().closeStickyNote();
    }

    private void openStickyNote() {
        this.getDiagramPanel().openStickyNote();
    }

    @Override
    public WAPanel getPanel() {
        return this;
    }

    @Override
    public void addReference(Object referrer) {
        this.m_lReferences.add(referrer);
        Workspace.getDefaultLogger().debug((Object)("Reference added to " + this + ": " + referrer));
    }

    @Override
    public void removeReference(Object referrer) {
        if (!this.m_lReferences.remove(referrer)) {
            throw new IllegalStateException("Attempt to remove a reference that does not exist: " + referrer);
        }
        Workspace.getDefaultLogger().debug((Object)("Reference removed from " + this + ": " + referrer));
        if (this.m_lReferences.isEmpty()) {
            this.saveSettingsAndCleanUp();
        }
    }

    @Override
    public WsAbstractAction[] getSharedActions() {
        return new WsAbstractAction[0];
    }

    @Override
    public void addDrillListener(DrillListener lsnr) {
        this.m_lDrillListeners.add(lsnr);
    }

    @Override
    public void removeDrillListener(DrillListener lsnr) {
        this.m_lDrillListeners.remove(lsnr);
    }

    private class DiagramModelListener
    implements PFDModelListener {
        private DiagramModelListener() {
        }

        public void modelChanged(PFDModelEvent ev) {
            if (ev.getType() == 1001) {
                String sFlowDirection = null;
                WADiagramTab.this.getDiagramPanel().setDoLayout(false);
                if (ev.getProperty().equals("Down")) {
                    WADiagramTab.this.m_actTopToBottom.setSelected(true);
                    sFlowDirection = "Down";
                } else if (ev.getProperty().equals("Right")) {
                    WADiagramTab.this.m_actLeftToRight.setSelected(true);
                    sFlowDirection = "Right";
                } else if (ev.getProperty().equals("Up")) {
                    WADiagramTab.this.m_actBottomToTop.setSelected(true);
                    sFlowDirection = "Up";
                }
                WADiagramTab.this.getDiagramPanel().setFlowDirection(sFlowDirection);
                WADiagramTab.this.getDiagramPanel().setDoLayout(true);
            } else if (ev.getType() == 7) {
                if (ev.getProperty().equals(WADiagramTab.NOTE_COLOR_CHANGE)) {
                    WADiagramTab.this.setSelectedStickyNoteColor();
                } else if (ev.getProperty().equals(WADiagramTab.IS_COLLAPSED) && ev.getPrimitive() instanceof IDiagramStickyNote) {
                    WADiagramTab.this.updateActions();
                }
            }
        }
    }

    private class DiagramListener
    implements PFDViewListener {
        private DiagramListener() {
        }

        public void viewChanged(PFDViewEvent ev) {
            switch (ev.getType()) {
                case 0: {
                    this.onTransformChangedAction(ev);
                    break;
                }
                case 3: {
                    this.onLayoutAction(ev);
                    break;
                }
                default: {
                    Workspace.getDefaultLogger().debug((Object)("Event type=" + ev.getType() + ", Event property = " + ev.getProperty()));
                }
            }
        }

        private void onLayoutAction(PFDViewEvent ev) {
            WADiagramTab.this.updateActions();
        }

        private void onTransformChangedAction(PFDViewEvent ev) {
            WADiagramTab.this.setZoom(WADiagramTab.this.getPFDComponent().getScale());
        }
    }

    private class SelectAllAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public SelectAllAction() {
            this.setMenuSupportId("Edit:SelectAll");
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.selectAll();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return true;
        }
    }

    private class AddStickyNotePopupMenuAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public AddStickyNotePopupMenuAction() {
            super(bundle, "DiagramTab.Action.AddStickyNote", 256);
            this.setMenuSupportId("Context:StickyNote:Add");
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setSavedClickedPoint(WADiagramTab.this.getPFDComponent().getClickedPoint());
            WADiagramTab.this.addStickyNote();
            WADiagramTab.this.setSavedClickedPoint(new Point());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return WADiagramTab.this.isContextForMainObject(context);
        }
    }

    private class AddStickyNoteAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public AddStickyNoteAction() {
            super(bundle, "DiagramTab.Action.AddStickyNote", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:StickyNote:Add"));
            this.setMenuSupportId("Actions:StickyNote:Add");
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setSavedClickedPoint(new Point());
            WADiagramTab.this.addStickyNote();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return WADiagramTab.this.isContextForMainObject(context);
        }
    }

    private class CloseStickyNoteAction
    extends WsAbstractAction {
        public CloseStickyNoteAction() {
            super(bundle, "WADiagramTab.Action.CloseStickyNote", 257);
            this.setMenuSupportId("Actions:StickyNote:Close");
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.closeStickyNote();
        }
    }

    private class OpenStickyNoteAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public OpenStickyNoteAction() {
            super(bundle, "WADiagramTab.Action.OpenStickyNote", 257);
            this.setMenuSupportId("Actions:StickyNote:Open");
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.openStickyNote();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length != 1) {
                return false;
            }
            return aObjects[0] instanceof IDiagramStickyNote;
        }
    }

    private class StickyNoteColorYellowAction
    extends WsAbstractToggleAction {
        public StickyNoteColorYellowAction() {
            super(bundle, "WADiagramTab.Action.YellowStickyNote", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:StickyNote:Yellow"));
            this.setMenuSupportId("Actions:StickyNote:Yellow");
            this.setSelected(false);
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.getSelectedStickyNote().setNoteStyleContext("NoteStyleYellow");
        }
    }

    private class StickyNoteColorBlueAction
    extends WsAbstractToggleAction {
        public StickyNoteColorBlueAction() {
            super(bundle, "WADiagramTab.Action.BlueStickyNote", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:StickyNote:Blue"));
            this.setMenuSupportId("Actions:StickyNote:Blue");
            this.setSelected(false);
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.getSelectedStickyNote().setNoteStyleContext("NoteStyleBlue");
        }
    }

    private class StickyNoteColorPinkAction
    extends WsAbstractToggleAction {
        public StickyNoteColorPinkAction() {
            super(bundle, "WADiagramTab.Action.PinkStickyNote", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:StickyNote:Pink"));
            this.setMenuSupportId("Actions:StickyNote:Pink");
            this.setSelected(false);
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.getSelectedStickyNote().setNoteStyleContext("NoteStylePink");
        }
    }

    private class AutoLayoutAction
    extends WsAbstractToggleAction {
        public AutoLayoutAction() {
            this.setMenuSupportId("View:Layout:DoLayout");
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.doAutoLayout();
        }
    }

    private class FlowDirectionLeftToRightAction
    extends WsAbstractToggleAction {
        public FlowDirectionLeftToRightAction() {
            this.setMenuSupportId("View:Layout:LeftToRight");
            this.setSelected(WADiagramTab.this.getFlowDirection().equals("Right"));
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setFlowDirection("Right");
        }
    }

    private class FlowDirectionTopToBottomAction
    extends WsAbstractToggleAction {
        public FlowDirectionTopToBottomAction() {
            this.setMenuSupportId("View:Layout:TopToBottom");
            this.setSelected(WADiagramTab.this.getFlowDirection().equals("Down"));
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setFlowDirection("Down");
        }
    }

    private class FlowDirectionBottomToTopAction
    extends WsAbstractToggleAction {
        public FlowDirectionBottomToTopAction() {
            this.setMenuSupportId("View:Layout:BottomToTop");
            this.setSelected(WADiagramTab.this.getFlowDirection().equals("Up"));
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setFlowDirection("Up");
        }
    }

    private class ZoomCustomAction
    extends WsAbstractToggleAction {
        public ZoomCustomAction() {
            this.setMenuSupportId("Hidden:Zoom:Custom");
            this.setSelected(!WADiagramTab.this.getZoom().equals("2.0") && !WADiagramTab.this.getZoom().equals("1.5") && !WADiagramTab.this.getZoom().equals("1") && !WADiagramTab.this.getZoom().equals(".75") && !WADiagramTab.this.getZoom().equals(".5") && !WADiagramTab.this.getZoom().equals(".25") && !WADiagramTab.this.getZoom().equals(".1"));
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class Zoom200Action
    extends WsAbstractToggleAction {
        public Zoom200Action() {
            this.setMenuSupportId("View:Zoom:200%");
            this.setSelected(WADiagramTab.this.getZoom().equals("2.0"));
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setZoom("2.0");
        }
    }

    private class Zoom150Action
    extends WsAbstractToggleAction {
        public Zoom150Action() {
            this.setMenuSupportId("View:Zoom:150%");
            this.setSelected(WADiagramTab.this.getZoom().equals("1.5"));
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setZoom("1.5");
        }
    }

    private class Zoom100Action
    extends WsAbstractToggleAction {
        public Zoom100Action() {
            this.setMenuSupportId("View:Zoom:100%");
            this.setSelected(WADiagramTab.this.getZoom().equals("1"));
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setZoom("1");
        }
    }

    private class Zoom75Action
    extends WsAbstractToggleAction {
        public Zoom75Action() {
            this.setMenuSupportId("View:Zoom:75%");
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setZoom(".75");
            this.setSelected(WADiagramTab.this.getZoom().equals(".75"));
        }
    }

    private class Zoom50Action
    extends WsAbstractToggleAction {
        public Zoom50Action() {
            this.setMenuSupportId("View:Zoom:50%");
            this.setSelected(WADiagramTab.this.getZoom().equals(".5"));
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setZoom(".5");
        }
    }

    private class Zoom25Action
    extends WsAbstractToggleAction {
        public Zoom25Action() {
            this.setMenuSupportId("View:Zoom:25%");
            this.setSelected(WADiagramTab.this.getZoom().equals(".25"));
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setZoom(".25");
        }
    }

    private class Zoom10Action
    extends WsAbstractToggleAction {
        public Zoom10Action() {
            this.setMenuSupportId("View:Zoom:10%");
            this.setSelected(WADiagramTab.this.getZoom().equals(".1"));
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setZoom(".1");
        }
    }

    private class ZoomFitWidthAction
    extends WsAbstractToggleAction {
        public ZoomFitWidthAction() {
            this.setMenuSupportId("View:Zoom:FitWidth");
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setZoom("FitWidth");
        }
    }

    private class ZoomFitHeightAction
    extends WsAbstractToggleAction {
        public ZoomFitHeightAction() {
            this.setMenuSupportId("View:Zoom:FitHeight");
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setZoom("FitHeight");
        }
    }

    private class ZoomFitBothAction
    extends WsAbstractToggleAction {
        public ZoomFitBothAction() {
            this.setMenuSupportId("View:Zoom:FitBoth");
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setZoom("FitBoth");
        }
    }

    private class ShowGridAction
    extends WsAbstractToggleAction {
        public ShowGridAction() {
            this.setMenuSupportId("View:Grid:ShowGrid");
            this.setSelected(WADiagramTab.this.isShowGrid());
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setShowGrid(this.isSelected());
        }
    }

    private class SnapToGridAction
    extends WsAbstractToggleAction {
        public SnapToGridAction() {
            this.setMenuSupportId("View:Grid:SnapToGrid");
            this.setSelected(WADiagramTab.this.isSnapToGrid());
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setSnapToGrid(this.isSelected());
        }
    }

    private class GridStyleSolidAction
    extends WsAbstractToggleAction {
        public GridStyleSolidAction() {
            this.setMenuSupportId("View:Grid:Solid");
            this.setSelected(WADiagramTab.this.getGridStyle() == 0);
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setGridStyle(0);
        }
    }

    private class GridStyleDotAction
    extends WsAbstractToggleAction {
        public GridStyleDotAction() {
            this.setMenuSupportId("View:Grid:Dot");
            this.setSelected(WADiagramTab.this.getGridStyle() == 1);
        }

        public void actionPerformed(ActionEvent ev) {
            WADiagramTab.this.setGridStyle(1);
        }
    }

    private class SaveRunnable
    extends AbstractWasSuccessfulRunnable {
        private SaveRunnable() {
        }

        @Override
        public void run() {
            this.setSuccessful(false);
            boolean success = WADiagramTab.this.getDiagramPanel().save();
            this.setSuccessful(success);
            WADiagramTab.this.setDataChanged(!success);
        }
    }

    private abstract class AbstractWasSuccessfulRunnable
    implements Runnable {
        private boolean m_bSuccessful;

        private AbstractWasSuccessfulRunnable() {
        }

        public boolean wasSuccessful() {
            return this.m_bSuccessful;
        }

        protected void setSuccessful(boolean bSuccessful) {
            this.m_bSuccessful = bSuccessful;
        }
    }
}

