/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ObjectFactoryException;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModelEvent;
import com.sas.graphics.components.pfd.PFDModelListener;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDScrollView;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppFrameworkManager;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.app.actions.AppActionsManager;
import com.sas.wadmin.drill.DrillComponent;
import com.sas.wadmin.drill.DrillEvent;
import com.sas.wadmin.drill.DrillListener;
import com.sas.wadmin.drill.DrillableComponent;
import com.sas.wadmin.jobeditor.diagram.AbstractWasSuccessfulRunnable;
import com.sas.wadmin.jobeditor.diagram.DebugEvent;
import com.sas.wadmin.jobeditor.diagram.DebugEventListener;
import com.sas.wadmin.jobeditor.diagram.DiagramModel;
import com.sas.wadmin.jobeditor.diagram.DiagramPanel;
import com.sas.wadmin.jobeditor.diagram.ISASApplicationServerDiagramPanel;
import com.sas.wadmin.jobeditor.diagram.SaveDataObjectsRunnable;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.IDrillableAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IControlLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataTransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.wadmin.jobeditor.diagram.shapes.IWorkTableNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.ControlLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.StickyNoteNode;
import com.sas.wadmin.run.RunEvent;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.run.RunModelEvent;
import com.sas.wadmin.run.RunModelListener;
import com.sas.wadmin.validate.ValidateEvent;
import com.sas.wadmin.validate.ValidateModel;
import com.sas.wadmin.validate.ValidateModelEvent;
import com.sas.wadmin.validate.ValidateModelListener;
import com.sas.wadmin.visuals.common.CheckpointSetupPanel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsActionContext;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import com.sas.workspace.visuals.pfd.WsPFDPanel;
import com.sas.workspace.visuals.pfd.WsPFDPropertyTab;
import com.sas.workspace.visuals.pfd.WsPFDSelectionEvent;
import com.sas.workspace.visuals.pfd.WsPFDSelectionListener;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class DiagramTab
extends WsPFDPropertyTab
implements WsSelectionProvider,
DrillableComponent,
ISASApplicationServerDiagramPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(DiagramTab.class);
    public static final String CONTEXT = "DiagramTab";
    private static final String SHOW_DIAGRAM_TOOLBAR_KEY = "DiagramTab.ShowDiagramToolbar";
    private static final String ERROR_ON_NEWER_VERSION_ISSUE = "DiagramPanel.ErrorOnNewerVersionIssue";
    private static final String WARNING_ON_OLDER_VERSION_ISSUE = "DiagramPanel.WarningOnOlderVersionIssue";
    private static final String NOTE_COLOR_CHANGE = "fillColor";
    private static final String IS_COLLAPSED = "isCollapsed";
    private DesignTimeJobModel m_mdlJob;
    private JToolBar m_tools;
    private JToolBar m_barDiagram;
    private WsAbstractAction m_actProperties;
    private WsAbstractAction m_actDelete;
    private WsAbstractAction m_actSelectAll;
    private WsAbstractAction m_actConnections;
    private WsAbstractAction m_actReplace;
    private WsAbstractAction m_actRunFromSelected;
    private WsAbstractAction m_actRunSelected;
    private WsAbstractAction m_actRunToSelected;
    private WsAbstractToggleAction m_actCreateAsView;
    private WsAbstractAction m_actRegisterTable;
    private WsAbstractAction m_actJobPropagateToBeginning;
    private WsAbstractAction m_actJobPropagateToEnd;
    private WsAbstractAction m_actJobPropagateDefault;
    private WsAbstractAction m_actJobMap;
    private WsAbstractToggleAction m_actAutoPropagate;
    private WsAbstractToggleAction m_actAutoMap;
    private WsAbstractToggleAction m_actFromBeginningToEnd;
    private WsAbstractToggleAction m_actFromEndToBeginning;
    private WsAbstractToggleAction m_actCollectDiagnostics;
    private WsAbstractToggleAction m_actCollectRuntimeStatistics;
    private WsAbstractToggleAction m_actCollectTableStatistics;
    private WsAbstractToggleAction m_actDisableCheckpoints;
    private WsAbstractToggleAction m_actAssignAsRestartPoint;
    private WsAbstractAction m_actTransformationsMap;
    private WsAbstractAction m_actPropagateToTargetsFromSources;
    private WsAbstractAction m_actPropagateToTargetsFromBeginning;
    private WsAbstractAction m_actPropagateToTargetsFromEnd;
    private WsAbstractAction m_actPropagateToSourcesFromTargets;
    private WsAbstractAction m_actPropagateToSourcesFromBeginning;
    private WsAbstractAction m_actPropagateToSourcesFromEnd;
    private WsAbstractAction m_actPropagateFromTargetsToSources;
    private WsAbstractAction m_actPropagateFromTargetsToBeginning;
    private WsAbstractAction m_actPropagateFromTargetsToEnd;
    private WsAbstractAction m_actPropagateFromSourcesToTargets;
    private WsAbstractAction m_actPropagateFromSourcesToBeginning;
    private WsAbstractAction m_actPropagateFromSourcesToEnd;
    private WsDropMenuAction m_actSettings;
    private WsAbstractToggleAction m_actIncludeInPropagation;
    private WsAbstractToggleAction m_actIncludeInMapping;
    private WsAbstractToggleAction m_actExcludeFromRun;
    private WsAbstractAction m_actOpenDrillable;
    private WsAbstractAction m_actAddInputPort;
    private WsAbstractAction m_actDeleteInputPort;
    private WsAbstractAction m_actAddOutputPort;
    private WsAbstractAction m_actDeleteOutputPort;
    private WsAbstractAction m_actAddWorkTable;
    private WsAbstractToggleAction m_actLargeWorkTables;
    private WsAbstractAction m_actPopupAddStickyNote;
    private WsAbstractAction m_actAddStickyNote;
    private WsAbstractAction m_actCloseStickyNote;
    private WsAbstractAction m_actOpenStickyNote;
    private WsAbstractToggleAction m_actStickyNoteColorYellow;
    private WsAbstractToggleAction m_actStickyNoteColorBlue;
    private WsAbstractToggleAction m_actStickyNoteColorPink;
    private WsAbstractAction m_actAutoLayout;
    private WsAbstractToggleAction m_actLeftToRight;
    private WsAbstractToggleAction m_actTopToBottom;
    private WsAbstractToggleAction m_actBottomToTop;
    private WsAbstractToggleAction m_actZoomCustom;
    private WsAbstractToggleAction m_actZoom200;
    private WsAbstractToggleAction m_actZoom150;
    private WsAbstractToggleAction m_actZoom100;
    private WsAbstractToggleAction m_actZoom75;
    private WsAbstractToggleAction m_actZoom50;
    private WsAbstractToggleAction m_actZoom25;
    private WsAbstractToggleAction m_actZoom10;
    private WsAbstractToggleAction m_actZoomFitWidth;
    private WsAbstractToggleAction m_actZoomFitHeight;
    private WsAbstractToggleAction m_actZoomFitBoth;
    private WsAbstractToggleAction m_actShowGrid;
    private WsAbstractToggleAction m_actSnapToGrid;
    private WsAbstractToggleAction m_actGridStyleSolid;
    private WsAbstractToggleAction m_actGridStyleDot;
    private WsAbstractToggleAction m_actCollapse;
    private WsAbstractToggleAction m_actExpand;
    private WsAbstractToggleAction m_actControlOrder;
    private WsAppServer m_srvrSASApp;
    private IObject m_selectedObject;
    private IDiagramStickyNote m_selectedStickyNote;
    private PropertyChangeListener m_lsnrAppDefaults;
    private PFDModelListener m_lsnrDiagramModel;
    private PFDViewListener m_lsnrDiagram;
    private IModelListener m_lsnrModel;
    private RunModel m_mdlRun;
    private ValidateModel m_mdlValidate;
    private RunModelListener m_lsnrRun;
    private ValidateModelListener m_lsnrValidate;
    private MouseListener m_lsnrMouse;
    private List m_lDrillListeners;
    private List m_lDebugListeners;
    private List m_lReferences;
    private Object[] m_aSelectedObjects;
    private boolean m_bDeleting;

    public static boolean isUserPreferenceToErrorOnNewerVersionIssue() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(ERROR_ON_NEWER_VERSION_ISSUE, true);
    }

    public static void setUserPreferenceToErrorOnNewerVersionIssue(boolean bErrorOnVersionIssue) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(ERROR_ON_NEWER_VERSION_ISSUE, bErrorOnVersionIssue);
    }

    public static boolean isUserPreferenceToWarningOnOlderVersionIssue() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(WARNING_ON_OLDER_VERSION_ISSUE, true);
    }

    public static void setUserPreferenceToWarningOnOlderVersionIssue(boolean bWarningOnVersionIssue) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(WARNING_ON_OLDER_VERSION_ISSUE, bWarningOnVersionIssue);
    }

    public static boolean isUserPreferenceToShowDiagramToolBar() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_DIAGRAM_TOOLBAR_KEY, true);
    }

    public static void setUserPreferenceToShowDiagramToolBar(boolean bShowDiagramToolBar) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(SHOW_DIAGRAM_TOOLBAR_KEY, bShowDiagramToolBar);
    }

    public static boolean isAddSupportedFor(SimpleObject obj) {
        String sType = obj.getPublicType();
        return "Job".equals(sType) || "Table".equals(sType) || "ExternalFile".equals(sType) || "GeneratedTransform".equals(sType) || "Library".equals(sType) || "Document".equals(sType) || "MessageQueue".equals(sType);
    }

    public DiagramTab(String sJobID) {
        this(DesignTimeJobModel.createModelForExistingJob((String)sJobID));
    }

    public DiagramTab(DesignTimeJobModel mdlJob) {
        this.m_mdlJob = mdlJob;
        this.getDiagramPanel().setJobModel(mdlJob);
        this.m_lsnrAppDefaults = new AppDefaultsListener();
        Workspace.getWorkspace().getAppDefaultsFile().addPropertyChangeListener(this.m_lsnrAppDefaults);
        this.setName(bundle.getString("DiagramTab.Name.txt"));
        this.m_barDiagram = this.createDiagramToolBar();
        this.setDiagramToolBarVisible(DiagramTab.isUserPreferenceToShowDiagramToolBar());
        this.m_lDrillListeners = new ArrayList();
        this.m_lReferences = new ArrayList();
        this.m_aSelectedObjects = new Object[0];
        this.m_lDebugListeners = new ArrayList();
        this.m_lsnrDiagramModel = new DiagramModelListener();
        this.getPFDModel().addPFDModelListener(this.m_lsnrDiagramModel);
        this.m_lsnrDiagram = new DiagramListener();
        this.getPFDComponent().addPFDViewListener(this.m_lsnrDiagram);
        this.m_lsnrModel = new ModelListener();
        this.m_mdlJob.addModelListener(this.m_lsnrModel);
        this.m_lsnrRun = new RunJobModelListener();
        this.m_lsnrValidate = new ValidateJobModelListener();
        this.setHelpProduct("wdb");
        this.setHelpTopic("process_editor");
    }

    protected WsPFDPanel createPFDComponent() {
        DiagramPanel pfd = new DiagramPanel((DiagramModel)this.getPFDModel());
        pfd.setPopupMenuRequestListener(this.createDefaultPopupMenuRequestListener());
        pfd.getSelectionModel().addSelectionListener((WsPFDSelectionListener)new SelectionListener());
        pfd.addMouseListener(new DiagramMouseListener());
        return pfd;
    }

    protected WsPFDModel createPFDModel() {
        return new DiagramModel();
    }

    protected PFDScrollView createScrollComponent() {
        return new PFDScrollView((PFDView)this.getDiagramPanel());
    }

    public DiagramPanel getDiagramPanel() {
        return (DiagramPanel)this.getPFDComponent();
    }

    protected void createActions() {
        super.createActions();
        this.m_actProperties = new PropertiesAction();
        this.m_actDelete = new DeleteAction();
        this.m_actSelectAll = new SelectAllAction();
        this.m_actConnections = new ConnectionsAction();
        this.m_actReplace = new ReplaceAction();
        this.m_actRunFromSelected = new RunFromSelectedTransformation();
        this.m_actRunSelected = new RunSelectedTransformations();
        this.m_actRunToSelected = new RunToSelectedTransformation();
        this.m_actCreateAsView = new CreateAsViewAction();
        this.m_actRegisterTable = new RegisterTableAction();
        this.m_actJobPropagateToBeginning = new JobPropagateToBeginningAction();
        this.m_actJobPropagateToEnd = new JobPropagateToEndAction();
        this.m_actJobPropagateDefault = new JobPropagateDefaultAction();
        this.m_actJobMap = new JobMapAction();
        this.m_actAutoPropagate = new AutoPropagateAction();
        this.m_actAutoMap = new AutoMapAction();
        this.m_actFromBeginningToEnd = new FromBeginningToEndAction();
        this.m_actFromEndToBeginning = new FromEndToBeginningAction();
        this.m_actCollectDiagnostics = new CollectDiagnosticsAction();
        this.m_actCollectRuntimeStatistics = new CollectRuntimeStatisticsAction();
        this.m_actCollectTableStatistics = new CollectTableStatisticsAction();
        this.m_actDisableCheckpoints = new DisableCheckpointsAction();
        this.m_actSettings = new SettingsAction();
        this.m_actSettings.setDropMenu(this.createSettingsDropMenu());
        this.m_actAssignAsRestartPoint = new AssignAsRestartPointAction();
        this.m_actTransformationsMap = new TransformationsMapAction();
        this.m_actPropagateToTargetsFromSources = new PropagateToTargetsFromSourcesAction();
        this.m_actPropagateToTargetsFromBeginning = new PropagateToTargetsFromBeginningAction();
        this.m_actPropagateToTargetsFromEnd = new PropagateToTargetsFromEndAction();
        this.m_actPropagateToSourcesFromTargets = new PropagateToSourcesFromTargetsAction();
        this.m_actPropagateToSourcesFromBeginning = new PropagateToSourcesFromBeginningAction();
        this.m_actPropagateToSourcesFromEnd = new PropagateToSourcesFromEndAction();
        this.m_actPropagateFromTargetsToSources = new PropagateFromTargetsToSourcesAction();
        this.m_actPropagateFromTargetsToBeginning = new PropagateFromTargetsToBeginningAction();
        this.m_actPropagateFromTargetsToEnd = new PropagateFromTargetsToEndAction();
        this.m_actPropagateFromSourcesToTargets = new PropagateFromSourcesToTargetsAction();
        this.m_actPropagateFromSourcesToBeginning = new PropagateFromSourcesToBeginningAction();
        this.m_actPropagateFromSourcesToEnd = new PropagateFromSourcesToEndAction();
        this.m_actIncludeInPropagation = new IncludeInPropagationAction();
        this.m_actIncludeInMapping = new IncludeInMappingAction();
        this.m_actExcludeFromRun = new ExcludeFromRunAction();
        this.m_actAddInputPort = new AddInputPortAction();
        this.m_actDeleteInputPort = new DeleteInputPortAction();
        this.m_actAddOutputPort = new AddOutputPortAction();
        this.m_actDeleteOutputPort = new DeleteOutputPortAction();
        this.m_actAddWorkTable = new AddWorkTableAction();
        this.m_actLargeWorkTables = new LargeWorkTablesAction();
        this.m_actOpenDrillable = new OpenDrillableAction();
        this.m_actPopupAddStickyNote = new AddStickyNotePopupMenuAction();
        this.m_actAddStickyNote = new AddStickyNoteAction();
        this.m_actCloseStickyNote = new CloseStickyNoteAction();
        this.m_actOpenStickyNote = new OpenStickyNoteAction();
        this.m_actStickyNoteColorYellow = new StickyNoteColorYellowAction();
        this.m_actStickyNoteColorBlue = new StickyNoteColorBlueAction();
        this.m_actStickyNoteColorPink = new StickyNoteColorPinkAction();
        this.m_actAutoLayout = new AutoLayoutAction();
        this.m_actLeftToRight = new FlowDirectionLeftToRightAction();
        this.m_actTopToBottom = new FlowDirectionTopToBottomAction();
        this.m_actBottomToTop = new FlowDirectionBottomToTopAction();
        this.m_actZoomCustom = new ZoomCustomAction();
        this.m_actZoom200 = new Zoom200Action();
        this.m_actZoom150 = new Zoom150Action();
        this.m_actZoom100 = new Zoom100Action();
        this.m_actZoom75 = new Zoom75Action();
        this.m_actZoom50 = new Zoom50Action();
        this.m_actZoom25 = new Zoom25Action();
        this.m_actZoom10 = new Zoom10Action();
        this.m_actZoomFitWidth = new ZoomFitWidthAction();
        this.m_actZoomFitHeight = new ZoomFitHeightAction();
        this.m_actZoomFitBoth = new ZoomFitBothAction();
        this.m_actShowGrid = new ShowGridAction();
        this.m_actSnapToGrid = new SnapToGridAction();
        this.m_actGridStyleSolid = new GridStyleSolidAction();
        this.m_actGridStyleDot = new GridStyleDotAction();
        this.m_actCollapse = new CollapseAction();
        this.m_actExpand = new ExpandAction();
        this.m_actControlOrder = new ControlOrderAction();
        this.getDiagramPanel().setDeleteAction((Action)this.m_actDelete);
        this.getDiagramPanel().setDefaultAction((Action)this.m_actProperties);
    }

    protected JPopupMenu createPrimitivePopupMenu(PFDPrimitive prim) {
        if (prim instanceof IDiagramNode) {
            IDiagramNodeAdapter adapter = ((IDiagramNode)prim).getAdapter();
            return AppActionsManager.getInstance().createPopupMenuFor((WsActionContextInterface)new ActionContext(adapter));
        }
        if (prim instanceof StickyNoteNode) {
            return this.createStickyNotePopupMenu();
        }
        if (prim instanceof ControlLink) {
            return this.createControlLinkPopupMenu();
        }
        if (prim instanceof DataLink) {
            return this.createDataLinkPopupMenu();
        }
        if (prim instanceof PFDLink) {
            return this.createPFDLinkPopupMenu();
        }
        throw new UnsupportedOperationException("Unable to create popup menu for " + prim);
    }

    private JPopupMenu createStickyNotePopupMenu() {
        JPopupMenu mnuPopup = new JPopupMenu();
        mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)AppActionsManager.getInstance().getAction("Edit:Cut")));
        mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)AppActionsManager.getInstance().getAction("Common:Copy")));
        mnuPopup.addSeparator();
        mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDelete));
        return mnuPopup;
    }

    private JPopupMenu createControlLinkPopupMenu() {
        JPopupMenu mnuPopup = new JPopupMenu();
        return mnuPopup;
    }

    private JPopupMenu createPFDLinkPopupMenu() {
        JPopupMenu mnuPopup = new JPopupMenu();
        mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDelete));
        return mnuPopup;
    }

    private JPopupMenu createDataLinkPopupMenu() {
        JPopupMenu mnuPopup = new JPopupMenu();
        mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDelete));
        return mnuPopup;
    }

    protected JPopupMenu createPrimitivesPopupMenu(PFDPrimitive[] aPrimitives) {
        WsActionContext context = new WsActionContext(CONTEXT, (WsSelectionProvider)this);
        return AppActionsManager.getInstance().createPopupMenuFor((WsActionContextInterface)context);
    }

    protected JPopupMenu createCanvasPopupMenu() {
        this.m_aSelectedObjects = new Object[]{this.m_mdlJob.getJob()};
        this.fireSelectionChangedEvent();
        WsActionContext context = new WsActionContext(CONTEXT, (WsSelectionProvider)this);
        JPopupMenu menuPopup = AppActionsManager.getInstance().createPopupMenuFor((WsActionContextInterface)context);
        return menuPopup;
    }

    private JPopupMenu createSettingsDropMenu() {
        JPopupMenu mnuDrop = new JPopupMenu();
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actAutoPropagate));
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actAutoMap));
        mnuDrop.addSeparator();
        mnuDrop.add(WsUIUtilities.createRadioButtonMenuItem((WsAbstractToggleAction)this.m_actFromBeginningToEnd));
        mnuDrop.add(WsUIUtilities.createRadioButtonMenuItem((WsAbstractToggleAction)this.m_actFromEndToBeginning));
        mnuDrop.addSeparator();
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actDisableCheckpoints));
        return mnuDrop;
    }

    private JToolBar createDiagramToolBar() {
        JToolBar barDiagram = WsUIUtilities.createToolBar();
        barDiagram.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actAddStickyNote));
        barDiagram.addSeparator();
        barDiagram.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actJobPropagateDefault));
        barDiagram.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actJobMap));
        barDiagram.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)this.m_actSettings));
        barDiagram.addSeparator();
        barDiagram.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actProperties));
        return barDiagram;
    }

    public JToolBar getDiagramToolBar() {
        return this.m_barDiagram;
    }

    public void saveSettingsAndCleanUp() {
        Workspace.getWorkspace().getAppDefaultsFile().removePropertyChangeListener(this.m_lsnrAppDefaults);
        this.getPFDModel().removePFDModelListener(this.m_lsnrDiagramModel);
        this.getPFDModel().dispose();
        this.getPFDComponent().removePFDViewListener(this.m_lsnrDiagram);
        this.m_mdlJob.removeModelListener(this.m_lsnrModel);
        super.saveSettingsAndCleanUp();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actDelete.setActive(bActive);
        this.m_actSelectAll.setActive(bActive);
        this.m_actProperties.setActive(bActive);
        this.m_actConnections.setActive(bActive);
        this.m_actReplace.setActive(bActive);
        this.m_actCreateAsView.setActive(bActive);
        this.m_actRegisterTable.setActive(bActive);
        this.m_actJobPropagateToBeginning.setActive(bActive);
        this.m_actJobPropagateToEnd.setActive(bActive);
        this.m_actJobPropagateDefault.setActive(bActive);
        this.m_actJobMap.setActive(bActive);
        this.m_actAutoPropagate.setActive(bActive);
        this.m_actAutoMap.setActive(bActive);
        this.m_actFromBeginningToEnd.setActive(bActive);
        this.m_actFromEndToBeginning.setActive(bActive);
        this.m_actCollectDiagnostics.setActive(bActive);
        this.m_actCollectRuntimeStatistics.setActive(bActive);
        this.m_actCollectTableStatistics.setActive(bActive);
        this.m_actDisableCheckpoints.setActive(bActive);
        this.m_actAssignAsRestartPoint.setActive(bActive);
        this.m_actTransformationsMap.setActive(bActive);
        this.m_actRunFromSelected.setActive(bActive);
        this.m_actRunSelected.setActive(bActive);
        this.m_actRunToSelected.setActive(bActive);
        this.m_actPropagateToTargetsFromSources.setActive(bActive);
        this.m_actPropagateToTargetsFromBeginning.setActive(bActive);
        this.m_actPropagateToTargetsFromEnd.setActive(bActive);
        this.m_actPropagateToSourcesFromTargets.setActive(bActive);
        this.m_actPropagateToSourcesFromBeginning.setActive(bActive);
        this.m_actPropagateToSourcesFromEnd.setActive(bActive);
        this.m_actPropagateFromTargetsToSources.setActive(bActive);
        this.m_actPropagateFromTargetsToBeginning.setActive(bActive);
        this.m_actPropagateFromTargetsToEnd.setActive(bActive);
        this.m_actPropagateFromSourcesToTargets.setActive(bActive);
        this.m_actPropagateFromSourcesToBeginning.setActive(bActive);
        this.m_actPropagateFromSourcesToEnd.setActive(bActive);
        this.m_actIncludeInPropagation.setActive(bActive);
        this.m_actIncludeInMapping.setActive(bActive);
        this.m_actExcludeFromRun.setActive(bActive);
        this.m_actAddInputPort.setActive(bActive);
        this.m_actDeleteInputPort.setActive(bActive);
        this.m_actAddOutputPort.setActive(bActive);
        this.m_actDeleteOutputPort.setActive(bActive);
        this.m_actAddWorkTable.setActive(bActive);
        this.m_actLargeWorkTables.setActive(bActive);
        this.m_actOpenDrillable.setActive(bActive);
        this.m_actAddStickyNote.setActive(bActive);
        this.m_actPopupAddStickyNote.setActive(bActive);
        this.m_actCloseStickyNote.setActive(bActive);
        this.m_actOpenStickyNote.setActive(bActive);
        this.m_actStickyNoteColorYellow.setActive(bActive);
        this.m_actStickyNoteColorBlue.setActive(bActive);
        this.m_actStickyNoteColorPink.setActive(bActive);
        this.m_actAutoLayout.setActive(bActive);
        this.m_actLeftToRight.setActive(bActive);
        this.m_actTopToBottom.setActive(bActive);
        this.m_actBottomToTop.setActive(bActive);
        this.m_actZoomCustom.setActive(bActive);
        this.m_actZoom200.setActive(bActive);
        this.m_actZoom150.setActive(bActive);
        this.m_actZoom100.setActive(bActive);
        this.m_actZoom75.setActive(bActive);
        this.m_actZoom50.setActive(bActive);
        this.m_actZoom25.setActive(bActive);
        this.m_actZoom10.setActive(bActive);
        this.m_actZoomFitWidth.setActive(bActive);
        this.m_actZoomFitHeight.setActive(bActive);
        this.m_actZoomFitBoth.setActive(bActive);
        this.m_actShowGrid.setActive(bActive);
        this.m_actSnapToGrid.setActive(bActive);
        this.m_actGridStyleSolid.setActive(bActive);
        this.m_actGridStyleDot.setActive(bActive);
        this.m_actCollapse.setActive(bActive);
        this.m_actExpand.setActive(bActive);
        this.m_actControlOrder.setActive(bActive);
        AppFrameworkManager.getInstance().setSelectionProvider((WsSelectionProvider)(bActive ? this : null));
    }

    protected void updateActions() {
        IDiagramLink link;
        super.updateActions();
        boolean bEditable = this.isEditable();
        boolean bZeroObjects = this.m_aSelectedObjects.length == 0;
        boolean bOnePrimitive = this.m_aSelectedObjects.length == 1;
        boolean bOneObject = bOnePrimitive && this.m_aSelectedObjects[0] instanceof SimpleObject;
        boolean bSelectedDataObjects = !bZeroObjects;
        for (int iObject = 0; iObject < this.m_aSelectedObjects.length && bSelectedDataObjects; bSelectedDataObjects &= this.m_aSelectedObjects[iObject] instanceof IDataObject, ++iObject) {
        }
        boolean bSelectedTransforms = !bZeroObjects;
        boolean bSelectedDataTransforms = !bZeroObjects;
        for (int iObject = 0; iObject < this.m_aSelectedObjects.length && (bSelectedDataTransforms || bSelectedTransforms); bSelectedTransforms &= this.m_aSelectedObjects[iObject] instanceof ITransform, bSelectedDataTransforms &= this.m_aSelectedObjects[iObject] instanceof IDataTransform, ++iObject) {
        }
        int eRunState = this.getRunModel().getRunState();
        int eValidateState = this.getValidateModel().getValidateState();
        boolean bCheckpointOn = this.m_mdlJob.getJob().isCPRJobCodeNeeded();
        boolean bAllSelectedTransformsCodegenDisabled = true;
        boolean bAllSelectedTransformsCollectDiagnostics = true;
        if (bSelectedTransforms) {
            ITransform transform;
            for (int i = 0; i < this.m_aSelectedObjects.length && (bAllSelectedTransformsCodegenDisabled || bAllSelectedTransformsCollectDiagnostics); bAllSelectedTransformsCodegenDisabled &= !(transform = (ITransform)this.m_aSelectedObjects[i]).isCodeGenerationEnabled(), bAllSelectedTransformsCollectDiagnostics &= transform.isCollectingDiagnostics(), ++i) {
            }
        }
        boolean bSelectedDataTransform = bOneObject && bSelectedDataTransforms;
        boolean bSelectedTransform = bOneObject && bSelectedTransforms;
        boolean bAtLeastOneWorkTable = false;
        if (bSelectedDataTransform) {
            IDataObject[] targetTables = ((IDataTransform)this.m_aSelectedObjects[0]).getDataTargets();
            for (int iWorkTable = 0; iWorkTable < targetTables.length; ++iWorkTable) {
                if (!(targetTables[iWorkTable] instanceof IWorkTable)) continue;
                bAtLeastOneWorkTable = true;
                break;
            }
        }
        boolean bSelectedDataTransformWithWorkTables = bSelectedDataTransform && bAtLeastOneWorkTable;
        boolean bMainJob = bOneObject && this.m_aSelectedObjects[0] == this.m_mdlJob.getJob();
        String sType = bOneObject ? ((SimpleObject)this.m_aSelectedObjects[0]).getPublicType() : null;
        boolean bSelectedTable = bOneObject && "Table".equals(sType);
        boolean bSelectedWorkTable = bOneObject && "WorkTable".equals(sType);
        boolean bControlLinkSelected = bOnePrimitive && this.m_aSelectedObjects[0] instanceof IControlLink;
        boolean bOneStickyNoteSelected = bOnePrimitive && this.m_aSelectedObjects[0] instanceof IDiagramStickyNote;
        boolean bStickyNoteCollapsed = bOneStickyNoteSelected && ((IDiagramStickyNote)this.m_aSelectedObjects[0]).isCollapsed();
        PFDPrimitive[] aPrimitives = this.getDiagramPanel().getSelectionModel().getPrimitives();
        boolean bDataTransformCollapsed = bSelectedDataTransform && ((IDataTransformNode)aPrimitives[0]).isCollapsed();
        boolean bTransformWorkTableLink = false;
        if (bOnePrimitive && this.m_aSelectedObjects[0] instanceof IDiagramLink && (link = (IDiagramLink)this.m_aSelectedObjects[0]).getFromNode() instanceof IDataTransformNode && link.getToNode() instanceof IWorkTableNode) {
            bTransformWorkTableLink = true;
        }
        boolean bAllSourcesEditable = false;
        boolean bAllTargetsEditable = false;
        boolean bAtLeastOneSource = false;
        boolean bAtLeastOneTarget = false;
        if (bSelectedDataTransform) {
            IDataTransform xfm = (IDataTransform)this.m_aSelectedObjects[0];
            ITable[] aSources = xfm.getSourceTables();
            bAllSourcesEditable = bAtLeastOneSource = aSources.length > 0;
            for (int iSource = 0; iSource < aSources.length && bAllSourcesEditable; ++iSource) {
                bAllSourcesEditable = aSources[iSource].isEditable();
            }
            ITable[] aTargets = xfm.getTargetTables();
            bAllTargetsEditable = bAtLeastOneTarget = aTargets.length > 0;
            for (int iTarget = 0; iTarget < aTargets.length && bAllTargetsEditable; ++iTarget) {
                bAllTargetsEditable = aTargets[iTarget].isEditable();
            }
        }
        this.m_actDelete.setEnabled(this.m_aSelectedObjects.length > 0 && this.isEditable() && !bTransformWorkTableLink && !bControlLinkSelected && !bMainJob);
        this.m_actProperties.setEnabled(bOneObject || bZeroObjects);
        this.m_actConnections.setEnabled(bEditable && bOneObject && !bMainJob);
        this.m_actReplace.setEnabled(bEditable && (bSelectedTable || bSelectedWorkTable));
        this.m_actRunFromSelected.setEnabled((eRunState == 0 || eRunState == 2) && eValidateState != 1 && bSelectedTransform && !bCheckpointOn);
        this.m_actRunSelected.setEnabled((eRunState == 0 || eRunState == 2) && eValidateState != 1 && bSelectedTransforms && !bCheckpointOn);
        this.m_actRunToSelected.setEnabled((eRunState == 0 || eRunState == 2) && eValidateState != 1 && bSelectedTransform && !bCheckpointOn);
        this.m_actCreateAsView.setEnabled(bEditable);
        this.m_actRegisterTable.setEnabled(bEditable && bSelectedWorkTable);
        this.m_actJobPropagateToBeginning.setEnabled(bEditable);
        this.m_actJobPropagateToEnd.setEnabled(bEditable);
        this.m_actJobPropagateDefault.setEnabled(bEditable);
        this.m_actJobMap.setEnabled(bEditable);
        this.m_actAutoPropagate.setEnabled(bEditable);
        this.m_actAutoMap.setEnabled(bEditable);
        this.m_actFromBeginningToEnd.setEnabled(bEditable);
        this.m_actFromEndToBeginning.setEnabled(bEditable);
        this.m_actCollectDiagnostics.setEnabled(bEditable);
        this.m_actCollectRuntimeStatistics.setEnabled(bEditable);
        this.m_actCollectTableStatistics.setEnabled(bEditable && this.m_mdlJob.getJob().isCollectingStatistics());
        this.m_actDisableCheckpoints.setEnabled(bEditable);
        this.m_actAssignAsRestartPoint.setEnabled(bEditable && bSelectedTransform);
        this.m_actTransformationsMap.setEnabled(bEditable && bSelectedDataTransforms);
        this.m_actPropagateToTargetsFromSources.setEnabled(bEditable && bSelectedDataTransform && bAtLeastOneSource && bAllTargetsEditable);
        this.m_actPropagateToTargetsFromBeginning.setEnabled(bEditable && bSelectedDataTransform && bAllSourcesEditable && bAllTargetsEditable);
        this.m_actPropagateToTargetsFromEnd.setEnabled(bEditable && bSelectedDataTransform && bAllTargetsEditable);
        this.m_actPropagateToSourcesFromTargets.setEnabled(bEditable && bSelectedDataTransform && bAllSourcesEditable && bAtLeastOneTarget);
        this.m_actPropagateToSourcesFromBeginning.setEnabled(bEditable && bSelectedDataTransform && bAllSourcesEditable);
        this.m_actPropagateToSourcesFromEnd.setEnabled(bEditable && bSelectedDataTransform && bAllSourcesEditable && bAllTargetsEditable);
        this.m_actPropagateFromTargetsToSources.setEnabled(bEditable && bSelectedDataTransform && bAllSourcesEditable && bAtLeastOneTarget);
        this.m_actPropagateFromTargetsToBeginning.setEnabled(bEditable && bSelectedDataTransform && bAllSourcesEditable && bAtLeastOneTarget);
        this.m_actPropagateFromTargetsToEnd.setEnabled(bEditable && bSelectedDataTransform && bAtLeastOneTarget);
        this.m_actPropagateFromSourcesToTargets.setEnabled(bEditable && bSelectedDataTransform && bAtLeastOneSource && bAllTargetsEditable);
        this.m_actPropagateFromSourcesToBeginning.setEnabled(bEditable && bSelectedDataTransform && bAtLeastOneSource);
        this.m_actPropagateFromSourcesToEnd.setEnabled(bEditable && bSelectedDataTransform && bAtLeastOneSource && bAllTargetsEditable);
        this.m_actExcludeFromRun.setEnabled(bEditable && bSelectedTransforms);
        this.m_actIncludeInPropagation.setEnabled(bEditable && bSelectedDataTransform);
        this.m_actIncludeInMapping.setEnabled(bEditable && bSelectedDataTransform);
        this.m_actAddInputPort.setEnabled(bEditable && bSelectedDataTransform && this.getSelectedDataTransformation().isAddInputAvailable());
        this.m_actDeleteInputPort.setEnabled(bEditable && bSelectedDataTransform && this.getSelectedDataTransformation().isDeleteInputAvailable());
        this.m_actAddOutputPort.setEnabled(bEditable && bSelectedDataTransform && this.getSelectedDataTransformation().isAddOutputAvailable());
        this.m_actDeleteOutputPort.setEnabled(bEditable && bSelectedDataTransform && this.getSelectedDataTransformation().isDeleteOutputAvailable());
        this.m_actAddWorkTable.setEnabled(bEditable && bSelectedDataTransform && this.getSelectedDataTransformation().isAddWorkTableAvailable());
        this.m_actLargeWorkTables.setEnabled(bSelectedDataTransformWithWorkTables);
        this.m_actAddStickyNote.setEnabled(bEditable);
        this.m_actPopupAddStickyNote.setEnabled(bEditable);
        this.m_actCloseStickyNote.setEnabled(bOneStickyNoteSelected && bEditable && !bStickyNoteCollapsed);
        this.m_actOpenStickyNote.setEnabled(bOneStickyNoteSelected && bEditable && bStickyNoteCollapsed);
        this.m_actStickyNoteColorYellow.setEnabled(bOneStickyNoteSelected && bEditable);
        this.m_actStickyNoteColorBlue.setEnabled(bOneStickyNoteSelected && bEditable);
        this.m_actStickyNoteColorPink.setEnabled(bOneStickyNoteSelected && bEditable);
        this.m_actCreateAsView.setSelected((bSelectedTable || bSelectedWorkTable) && ((ITable)this.getSelectedObject()).isView());
        this.m_actCollectRuntimeStatistics.setSelected(this.m_mdlJob.getJob().isCollectingStatistics());
        this.m_actCollectTableStatistics.setSelected(this.m_mdlJob.getJob().isCollectingTableStatistics());
        this.m_actAutoMap.setSelected(this.m_mdlJob.getJob().isMappingAutomatically());
        this.m_actAutoPropagate.setSelected(this.m_mdlJob.getJob().isPropagatingAutomatically());
        this.m_actFromBeginningToEnd.setSelected(this.m_mdlJob.getJob().getAutomaticPropagationDirection() == 0);
        this.m_actFromEndToBeginning.setSelected(this.m_mdlJob.getJob().getAutomaticPropagationDirection() == 1);
        this.m_actDisableCheckpoints.setSelected(this.m_mdlJob.getJob().isDisableCheckpoints());
        this.m_actAssignAsRestartPoint.setSelected(bSelectedTransform && ((ITransform)this.getSelectedObject()).isCheckpointEnabled());
        boolean bCollectDiagnostics = bSelectedTransforms ? bAllSelectedTransformsCollectDiagnostics : this.m_mdlJob.getJob().isCollectingDiagnostics();
        this.m_actCollectDiagnostics.setSelected(bCollectDiagnostics);
        this.m_actExcludeFromRun.setSelected(bSelectedTransforms && bAllSelectedTransformsCodegenDisabled);
        this.m_actIncludeInPropagation.setSelected(bSelectedDataTransform && this.getSelectedDataTransformation().isIncludedInPropagation());
        this.m_actIncludeInMapping.setSelected(bSelectedDataTransform && this.getSelectedDataTransformation().isIncludedInMapping());
        this.m_actLargeWorkTables.setSelected(!bDataTransformCollapsed && bSelectedDataTransformWithWorkTables);
        this.m_actCollapse.setSelected(this.isCollapsed());
        this.m_actExpand.setSelected(!this.isCollapsed());
        this.m_actBottomToTop.setSelected(this.getFlowDirection().equals("Up"));
        this.m_actTopToBottom.setSelected(this.getFlowDirection().equals("Down"));
        this.m_actLeftToRight.setSelected(this.getFlowDirection().equals("Right"));
        if (bOneStickyNoteSelected) {
            this.setSelectedStickyNoteColor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        this.m_mdlJob.setModelEventsEnabled(false);
        boolean inLoad = this.getDiagramPanel().getDiagramModel().isInLoad();
        this.getDiagramPanel().getDiagramModel().setInLoad(true);
        boolean bModelEvents = true;
        try {
            String name;
            Iterator iterNames;
            LoadRunnable run = new LoadRunnable();
            OpRequestUI op = new OpRequestUI();
            op.setTitle(this.getName());
            op.setMessage(bundle.getString("DiagramTab.Loading.txt"));
            op.execute((Runnable)run);
            String sJobName = this.m_mdlJob.getJob().getName();
            this.setPrintJobTitle(sJobName);
            this.setGIFFileName(sJobName + ".png");
            if (!this.openJobVersionLessThanApplicationVersion()) {
                bModelEvents = false;
                boolean bl = false;
                return bl;
            }
            if (!this.openJobVersionGreaterThanApplicationVersion()) {
                bModelEvents = false;
                boolean bl = false;
                return bl;
            }
            List badTrans = this.m_mdlJob.getJob().getInvalidTransformationStepsList();
            List missingData = this.m_mdlJob.getJob().getMissingDataObject();
            List cleanedUpTransforms = this.m_mdlJob.getJob().getTransformNamesCleanedUp();
            StringBuffer names = new StringBuffer();
            if (!badTrans.isEmpty()) {
                iterNames = badTrans.iterator();
                while (iterNames.hasNext()) {
                    if (names != null && names.length() > 0) {
                        names.append(",\n");
                    } else {
                        names.append("\n");
                    }
                    name = (String)iterNames.next();
                    names.append(name);
                }
            }
            if (!missingData.isEmpty()) {
                iterNames = missingData.iterator();
                while (iterNames.hasNext()) {
                    if (names != null && names.length() > 0) {
                        names.append(",\n");
                    } else {
                        names.append("\n");
                    }
                    name = (String)iterNames.next();
                    names.append(name);
                }
            }
            if (!cleanedUpTransforms.isEmpty()) {
                iterNames = cleanedUpTransforms.iterator();
                while (iterNames.hasNext()) {
                    if (names != null && names.length() > 0) {
                        names.append(",\n");
                    } else {
                        names.append("\n");
                    }
                    name = (String)iterNames.next();
                    names.append(name);
                }
            }
            if (!(cleanedUpTransforms.isEmpty() && badTrans.isEmpty() || missingData.isEmpty())) {
                MessageUtil.displayMessage((String)bundle.formatString("DiagramTab.Warning.JobChanges.fmt", (Object)names));
            } else if (!missingData.isEmpty()) {
                MessageUtil.displayMessage((String)bundle.formatString("DiagramTab.Warning.DataObjects.fmt", (Object)names));
            } else if (!cleanedUpTransforms.isEmpty() || !badTrans.isEmpty()) {
                MessageUtil.displayMessage((String)bundle.formatString("DiagramTab.Warning.TransfRemoved.fmt", (Object)names));
            }
            this.updateActions();
            boolean bl = run.wasSuccessful();
            return bl;
        }
        finally {
            if (bModelEvents) {
                this.m_mdlJob.setModelEventsEnabled(true);
            }
            this.getDiagramPanel().getDiagramModel().setInLoad(inLoad);
            Workspace.getDefaultLogger().debug((Object)"COMPLETE!!");
        }
    }

    public boolean openJobVersionGreaterThanApplicationVersion() {
        boolean bGreater = true;
        if (!Workspace.getWorkspace().getCheckJobCompatibility()) {
            return true;
        }
        if (this.m_mdlJob.getJob() == null) {
            return true;
        }
        double jobVersion = this.m_mdlJob.getJob().getDISVersion();
        if (jobVersion == 0.0) {
            return true;
        }
        double applicationVersion = Workspace.getWorkspace().getApplicationVersionNumber();
        String appVersion = Double.toString(Workspace.getWorkspace().getApplicationVersionNumber());
        String string = appVersion = appVersion.equals("4.91") ? "4.910" : appVersion;
        if (jobVersion < applicationVersion) {
            bGreater = false;
            String appName = Workspace.getWorkspace().getApplicationName();
            appName = appName == null ? "" : appName.replaceAll(appVersion, "");
            if (DiagramTab.isUserPreferenceToWarningOnOlderVersionIssue()) {
                String sTitle = bundle.getString("DiagramTab.JobVersionWarningTitle.txt");
                int eAnswer = MessageUtil.displayMessage((String)bundle.formatString("DiagramTab.JobVersionVsApplicationVersion.txt", (Object)this.m_mdlJob.getJob().getName(), (Object)appName, (Object)Double.toString(this.m_mdlJob.getJob().getDISVersion()), (Object)appVersion), (String)sTitle, (int)2, (int)0);
                return eAnswer != 1;
            }
            return true;
        }
        return bGreater;
    }

    public boolean openJobVersionLessThanApplicationVersion() {
        boolean bLess = true;
        if (!Workspace.getWorkspace().getCheckJobCompatibility()) {
            return true;
        }
        if (this.m_mdlJob.getJob() == null) {
            return true;
        }
        double jobVersion = this.m_mdlJob.getJob().getDISVersion();
        if (jobVersion == 0.0) {
            return true;
        }
        double applicationVersion = Workspace.getWorkspace().getApplicationVersionNumber();
        String appVersion = Double.toString(Workspace.getWorkspace().getApplicationVersionNumber());
        String string = appVersion = appVersion.equals("4.91") ? "4.910" : appVersion;
        if (jobVersion > applicationVersion) {
            bLess = false;
            String appName = Workspace.getWorkspace().getApplicationName();
            appName = appName == null ? "" : appName.replaceAll(appVersion, "");
            if (DiagramTab.isUserPreferenceToErrorOnNewerVersionIssue()) {
                String sTitle = bundle.getString("DiagramTab.JobVersionErrorTitle.txt");
                MessageUtil.displayMessage((String)bundle.formatString("DiagramTab.JobVersionNewerThanApplicationVersionError.txt", (Object)this.m_mdlJob.getJob().getName(), (Object)appName, (Object)Double.toString(this.m_mdlJob.getJob().getDISVersion()), (Object)appVersion), (String)sTitle, (int)0, (int)-1);
                return false;
            }
            String sTitle = bundle.getString("DiagramTab.JobVersionWarningTitle.txt");
            int eAnswer = MessageUtil.displayMessage((String)bundle.formatString("DiagramTab.JobVersionVsApplicationVersion.txt", (Object)this.m_mdlJob.getJob().getName(), (Object)appName, (Object)Double.toString(this.m_mdlJob.getJob().getDISVersion()), (Object)appVersion), (String)sTitle, (int)2, (int)0);
            return eAnswer != 1;
        }
        return bLess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        this.m_mdlJob.setModelEventsEnabled(false);
        try {
            SaveRunnable run = new SaveRunnable();
            OpRequestUI op = new OpRequestUI();
            op.setTitle(this.m_mdlJob.getJob().getName());
            op.setMessage(bundle.getString("DiagramTab.Saving.txt"));
            op.execute((Runnable)run);
            boolean bl = run.wasSuccessful();
            return bl;
        }
        finally {
            this.m_mdlJob.setModelEventsEnabled(true);
        }
    }

    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.add(WsSelectionChangedListener.class, lsnr);
    }

    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.remove(WsSelectionChangedListener.class, lsnr);
    }

    public Object[] getSelectedObjects() {
        return this.m_aSelectedObjects;
    }

    private void selectionChanged() {
        PFDPrimitive[] aPrimitives = this.getDiagramPanel().getSelectionModel().getPrimitives();
        this.m_aSelectedObjects = new Object[aPrimitives.length];
        for (int iPrimitive = 0; iPrimitive < aPrimitives.length; ++iPrimitive) {
            this.m_aSelectedObjects[iPrimitive] = aPrimitives[iPrimitive] instanceof IDiagramNode ? ((IDiagramNode)aPrimitives[iPrimitive]).getObject() : aPrimitives[iPrimitive];
        }
        if (this.m_aSelectedObjects.length == 1 && this.m_aSelectedObjects[0] instanceof IObject) {
            this.setSelectedObject((IObject)this.m_aSelectedObjects[0]);
        } else if (this.m_aSelectedObjects.length == 1 && this.m_aSelectedObjects[0] instanceof IDiagramStickyNote) {
            this.setSelectedStickyNote((IDiagramStickyNote)this.m_aSelectedObjects[0]);
        } else if (this.m_aSelectedObjects.length == 0) {
            this.m_aSelectedObjects = new Object[]{this.m_mdlJob.getJob()};
        }
        this.fireSelectionChangedEvent();
        this.updateActions();
    }

    private void fireSelectionChangedEvent() {
        WsSelectionChangedListener[] aListeners = (WsSelectionChangedListener[])this.listenerList.getListeners(WsSelectionChangedListener.class);
        if (aListeners.length == 0) {
            return;
        }
        WsSelectionChangedEvent ev = new WsSelectionChangedEvent((WsSelectionProvider)this);
        for (int iListener = 0; iListener < aListeners.length; ++iListener) {
            aListeners[iListener].selectionChanged(ev);
        }
    }

    public void setRunModel(RunModel mdlRun) {
        if (this.m_mdlRun != null) {
            this.m_mdlRun.removeListener(this.m_lsnrRun);
        }
        this.m_mdlRun = mdlRun;
        if (this.m_mdlRun != null) {
            this.m_mdlRun.addListener(this.m_lsnrRun);
        }
        this.getDiagramPanel().setRunModel(mdlRun);
    }

    public RunModel getRunModel() {
        return this.m_mdlRun;
    }

    public void setValidateModel(ValidateModel mdlValidate) {
        if (this.m_mdlValidate != null) {
            this.m_mdlValidate.removeListener(this.m_lsnrValidate);
        }
        this.m_mdlValidate = mdlValidate;
        if (this.m_mdlValidate != null) {
            this.m_mdlValidate.addListener(this.m_lsnrValidate);
        }
        this.getDiagramPanel().setValidateModel(mdlValidate);
    }

    public ValidateModel getValidateModel() {
        return this.m_mdlValidate;
    }

    public void setSASAppServer(WsAppServer srvrSASApp) {
        this.m_srvrSASApp = srvrSASApp;
    }

    @Override
    public WsAppServer getSASAppServer() {
        return this.m_srvrSASApp;
    }

    public void setToolBar(JToolBar tools) {
        if (this.m_tools == tools) {
            return;
        }
        if (this.m_tools != null) {
            this.remove(this.m_tools);
        }
        this.m_tools = tools;
        if (this.m_tools != null) {
            this.add(this.m_tools, "North");
        }
    }

    @Override
    public JToolBar getToolBar() {
        return this.m_tools;
    }

    public void setToolBarVisible(boolean bVisible) {
        this.m_tools.setVisible(bVisible);
    }

    public boolean isToolBarVisible() {
        return this.m_tools.isVisible();
    }

    private void setDiagramToolBarVisible(boolean bVisible) {
        this.getDiagramPanel().getAction("ACTION_TOGGLE_TOOLBAR").putValue("pfdAbstractAction.selected", bVisible);
        this.getScrollComponent().revalidate();
    }

    public boolean isDiagramToolBarVisible() {
        Boolean bValue = (Boolean)this.getDiagramPanel().getAction("ACTION_TOGGLE_TOOLBAR").getValue("pfdAbstractAction.selected");
        return bValue == null ? false : bValue;
    }

    private String getFlowDirection() {
        return this.getDiagramPanel().getFlowDirection();
    }

    private void setFlowDirection(String sFlowDirection) {
        this.getDiagramPanel().setFlowDirection(sFlowDirection);
    }

    private void setSelectedStickyNote(IDiagramStickyNote note) {
        if (this.m_selectedStickyNote == note) {
            return;
        }
        this.m_selectedStickyNote = note;
    }

    private void setSelectedObject(IObject obj) {
        if (this.m_selectedObject == obj) {
            return;
        }
        this.m_selectedObject = obj;
    }

    private IObject getSelectedObject() {
        return this.m_selectedObject;
    }

    public boolean isDeleting() {
        return this.m_bDeleting;
    }

    public void delete() {
        this.m_bDeleting = true;
        try {
            this.getDiagramPanel().delete();
        }
        finally {
            this.m_bDeleting = false;
        }
    }

    private void closeStickyNote() {
        this.getDiagramPanel().closeStickyNote();
    }

    private void openStickyNote() {
        this.getDiagramPanel().openStickyNote();
    }

    private void registerTable() {
        this.getDiagramPanel().registerTable();
    }

    private void selectAll() {
        this.getDiagramPanel().selectAll();
    }

    public void selectObject(IObject obj) {
        this.getDiagramPanel().selectNodes(obj);
    }

    public void setModeOnTransformNodes(int eMode) {
        this.getDiagramPanel().setModeOnTransformNodes(eMode);
    }

    public IDiagramNode[] findNodes(IObject obj) {
        return this.getDiagramPanel().findNodes(obj);
    }

    public void showCheckpointSetupDialog() {
        CheckpointSetupPanel pnl = new CheckpointSetupPanel(this.m_mdlJob.getJob());
        String sTitle = bundle.getString("CheckpointSetupPanel.Title.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
        dlg.setResizable(true);
        dlg.setHelpProduct("wdb");
        dlg.setHelpTopic("checkpoint_setup_window");
        dlg.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPropertiesDialog(IComplexPersistableObject obj) {
        if (obj instanceof JobTransformModel) {
            AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), ((JobTransformModel)obj).getInnerJob());
        } else if (obj instanceof IJob) {
            AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), obj.getModel(), obj);
        } else {
            IDiagramNodeAdapter adapter = this.getDiagramPanel().getDiagramModel().getAdapter((IObject)obj);
            if (adapter == null) {
                return;
            }
            adapter.showPropertiesDialog((Window)Workspace.getWorkspace());
        }
        if (this.m_mdlJob.areAnyDataObjectsChanged()) {
            SaveDataObjectsRunnable run = new SaveDataObjectsRunnable(this.m_mdlJob);
            this.m_mdlJob.setModelEventsEnabled(false);
            try {
                OpRequestUI op = new OpRequestUI();
                op.setTitle(bundle.getString("DiagramTab.SavingChanges.txt"));
                op.setMessage(bundle.getString("DiagramTab.Saving.txt"));
                op.execute((Runnable)run);
            }
            finally {
                if (this.m_mdlJob.isUndoSupported()) {
                    this.m_mdlJob.getUndoManager().addEdit(new ModelUIUtilities.UnableToUndoUndoable((BaseModel)this.m_mdlJob));
                }
                this.m_mdlJob.setModelEventsEnabled(true);
            }
        }
    }

    private void addStickyNote() {
        StickyNoteNode note = new StickyNoteNode();
        note.setNoteStyleContext(DiagramPanel.getUserPreferenceForStickyNoteColor());
        Point pt = this.getSavedClickedPoint();
        this.getDiagramPanel().ViewToModel(pt);
        this.getDiagramPanel().addStickyNote(note, pt);
        note.expand();
    }

    @Override
    public WAPanel getPanel() {
        return this;
    }

    @Override
    public void addReference(Object referrer) {
        this.m_lReferences.add(referrer);
        Workspace.getDefaultLogger().debug((Object)("Reference added to " + this + ": " + referrer));
    }

    @Override
    public void removeReference(Object referrer) {
        if (!this.m_lReferences.remove(referrer)) {
            throw new IllegalStateException("Attempt to remove a reference that does not exist: " + referrer);
        }
        Workspace.getDefaultLogger().debug((Object)("Reference removed from " + this + ": " + referrer));
        if (this.m_lReferences.isEmpty()) {
            this.saveSettingsAndCleanUp();
        }
    }

    @Override
    public WsAbstractAction[] getSharedActions() {
        return new WsAbstractAction[0];
    }

    public void addDebugListener(DebugEventListener lsnr) {
        this.m_lDebugListeners.add(lsnr);
    }

    public void removeDebugListener(DebugEventListener lsnr) {
        this.m_lDebugListeners.remove(lsnr);
    }

    private void fireDebugEvent(String type) {
        if (this.m_lDebugListeners == null) {
            return;
        }
        DebugEvent ev = new DebugEvent(this, type);
        for (int iListener = 0; iListener < this.m_lDebugListeners.size(); ++iListener) {
            ((DebugEventListener)this.m_lDebugListeners.get(iListener)).debugActionTriggered(ev);
        }
    }

    @Override
    public void addDrillListener(DrillListener lsnr) {
        this.m_lDrillListeners.add(lsnr);
    }

    @Override
    public void removeDrillListener(DrillListener lsnr) {
        this.m_lDrillListeners.remove(lsnr);
    }

    private void fireDrillEvent(DrillableComponent cmpSource, DrillComponent cmpTarget) {
        DrillEvent ev = new DrillEvent(cmpSource, cmpTarget);
        for (int iListener = 0; iListener < this.m_lDrillListeners.size(); ++iListener) {
            DrillListener lsnr = (DrillListener)this.m_lDrillListeners.get(iListener);
            lsnr.drilled(ev);
        }
    }

    private boolean isContextForMainJob(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        return aObjects.length == 1 && aObjects[0] instanceof SimpleObject && aObjects[0] == this.m_mdlJob.getJob();
    }

    private boolean isContextForType(WsActionContextInterface context, String sType) {
        return this.isContextForTypes(context, new String[]{sType});
    }

    private boolean isContextForTypes(WsActionContextInterface context, String[] aTypes) {
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (!(aObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            String sType = ((SimpleObject)aObjects[iObject]).getPublicType();
            boolean bFound = false;
            for (int iType = 0; iType < aTypes.length && !bFound; ++iType) {
                bFound = aTypes[iType].equals(sType);
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private boolean isContextForTransformations(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] instanceof ITransform) continue;
            return false;
        }
        return true;
    }

    private boolean isContextForDataTransformations(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (!(aObjects[iObject] instanceof IDataTransform)) {
                return false;
            }
            if (!(aObjects[iObject] instanceof JobTransformModel)) continue;
            return false;
        }
        return true;
    }

    private boolean isContextForDataTransformation(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        return aObjects.length == 1 && aObjects[0] instanceof IDataTransform && !(aObjects[0] instanceof JobTransformModel);
    }

    private IDataTransform getSelectedDataTransformation() {
        return (IDataTransform)this.getSelectedObject();
    }

    private IDiagramStickyNote getSelectedStickyNote() {
        return this.m_selectedStickyNote;
    }

    private void setCollapse(boolean bVisible) {
        this.getDiagramPanel().setCollapse(bVisible);
    }

    private boolean isCollapsed() {
        return this.getDiagramPanel().isCollapsed();
    }

    private void setExpand(boolean bVisible) {
        this.getDiagramPanel().setCollapse(!bVisible);
    }

    private boolean isExpanded() {
        return !this.getDiagramPanel().isCollapsed();
    }

    private void setControlOrderVisible(boolean bVisible) {
        this.getDiagramPanel().setControlOrderVisible(bVisible);
    }

    private boolean isControlOrderVisible() {
        return this.getDiagramPanel().isControlOrderVisible();
    }

    private void setShowGrid(boolean bShowGrid) {
        this.getDiagramPanel().setShowGrid(bShowGrid);
    }

    private boolean isShowGrid() {
        return this.getDiagramPanel().isShowGrid();
    }

    public void setDropLocation(Point location) {
        this.getDiagramPanel().setDropLocation(location);
    }

    private void doAutoLayout() {
        this.getDiagramPanel().updateLayout();
    }

    private void setSelectedStickyNoteColor() {
        IDiagramStickyNote note = this.getSelectedStickyNote();
        if (note != null) {
            if (note.getNoteStyleContext().equals("NoteStyleYellow")) {
                this.m_actStickyNoteColorYellow.setSelected(true);
            } else if (note.getNoteStyleContext().equals("NoteStyleBlue")) {
                this.m_actStickyNoteColorBlue.setSelected(true);
            } else if (note.getNoteStyleContext().equals("NoteStylePink")) {
                this.m_actStickyNoteColorPink.setSelected(true);
            }
        }
    }

    public void setZoom(double iZoom) {
        if (iZoom == 2.0) {
            this.m_actZoom200.setSelected(true);
        } else if (iZoom == 1.5) {
            this.m_actZoom150.setSelected(true);
        } else if (iZoom == 1.0) {
            this.m_actZoom100.setSelected(true);
        } else if (iZoom == 0.75) {
            this.m_actZoom75.setSelected(true);
        } else if (iZoom == 0.5) {
            this.m_actZoom50.setSelected(true);
        } else if (iZoom == 0.25) {
            this.m_actZoom25.setSelected(true);
        } else if (iZoom == 0.1) {
            this.m_actZoom10.setSelected(true);
        } else {
            this.m_actZoom10.setSelected(false);
            this.m_actZoom25.setSelected(false);
            this.m_actZoom50.setSelected(false);
            this.m_actZoom100.setSelected(false);
            this.m_actZoom150.setSelected(false);
            this.m_actZoom200.setSelected(false);
            this.m_actZoom75.setSelected(false);
            this.m_actZoomCustom.setSelected(true);
        }
    }

    private void setZoom(String sZoom) {
        this.getDiagramPanel().setZoom(sZoom);
        if (sZoom.equals("FitBoth") || sZoom.equals("FitHeight") || sZoom.equals("FitWidth") || !this.getZoom().equals("2.0") && !this.getZoom().equals("1.5") && !this.getZoom().equals("1") && !this.getZoom().equals(".75") && !this.getZoom().equals(".5") && !this.getZoom().equals(".25") && !this.getZoom().equals(".1")) {
            this.m_actZoomCustom.setSelected(true);
        }
    }

    protected void installDefaults() {
    }

    private String getZoom() {
        return this.getDiagramPanel().getZoom();
    }

    public void setSnapToGrid(boolean bSnapToGrid) {
        this.getDiagramPanel().setSnapToGrid(bSnapToGrid);
    }

    public boolean isSnapToGrid() {
        return this.getDiagramPanel().isSnapToGrid();
    }

    private void setGridStyle(int iGridStyle) {
        this.getDiagramPanel().setGridStyle(iGridStyle);
    }

    private int getGridStyle() {
        return this.getDiagramPanel().getGridStyle();
    }

    private class AppDefaultsListener
    implements PropertyChangeListener {
        private AppDefaultsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (DiagramTab.SHOW_DIAGRAM_TOOLBAR_KEY.equals(ev.getPropertyName())) {
                DiagramTab.this.setDiagramToolBarVisible((Boolean)ev.getNewValue());
            }
        }
    }

    private class DiagramModelListener
    implements PFDModelListener {
        private DiagramModelListener() {
        }

        public void modelChanged(PFDModelEvent ev) {
            if (ev.getType() == 1001) {
                String sFlowDirection = null;
                DiagramTab.this.getDiagramPanel().setDoLayout(false);
                if (ev.getProperty().equals("Down")) {
                    DiagramTab.this.m_actTopToBottom.setSelected(true);
                    sFlowDirection = "Down";
                } else if (ev.getProperty().equals("Right")) {
                    DiagramTab.this.m_actLeftToRight.setSelected(true);
                    sFlowDirection = "Right";
                } else if (ev.getProperty().equals("Up")) {
                    DiagramTab.this.m_actBottomToTop.setSelected(true);
                    sFlowDirection = "Up";
                }
                DiagramTab.this.getDiagramPanel().setFlowDirection(sFlowDirection);
                DiagramTab.this.getDiagramPanel().setDoLayout(true);
            } else if (ev.getType() == 7) {
                if (ev.getProperty().equals(DiagramTab.NOTE_COLOR_CHANGE)) {
                    DiagramTab.this.setSelectedStickyNoteColor();
                } else if (ev.getProperty().equals(DiagramTab.IS_COLLAPSED) && (ev.getPrimitive() instanceof IDiagramStickyNote || ev.getPrimitive() instanceof IDataTransformNode)) {
                    DiagramTab.this.updateActions();
                }
            }
        }
    }

    private class DiagramListener
    implements PFDViewListener {
        private DiagramListener() {
        }

        public void viewChanged(PFDViewEvent ev) {
            switch (ev.getType()) {
                case 0: {
                    this.onTransformChangedAction(ev);
                    break;
                }
                case 7001: {
                    this.onCollapsedChangedAction(ev);
                    break;
                }
                case 3: {
                    this.onLayoutAction(ev);
                    break;
                }
                default: {
                    Workspace.getDefaultLogger().debug((Object)("Event type=" + ev.getType() + ", Event property = " + ev.getProperty()));
                }
            }
        }

        private void onLayoutAction(PFDViewEvent ev) {
            DiagramTab.this.updateActions();
        }

        private void onCollapsedChangedAction(PFDViewEvent ev) {
            if (ev.getProperty() == "true") {
                DiagramTab.this.setCollapse(true);
            } else {
                DiagramTab.this.setCollapse(false);
            }
            DiagramTab.this.updateActions();
        }

        private void onTransformChangedAction(PFDViewEvent ev) {
            DiagramTab.this.setZoom(DiagramTab.this.getPFDComponent().getScale());
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType == "ITransform:CheckpointEnabledChanged" && DiagramTab.this.getSelectedObject() instanceof ITransform && ((ITransform)DiagramTab.this.getSelectedObject()).isCheckpointEnabled() && !DiagramTab.this.m_mdlJob.isUndoing() && (DiagramTab.this.m_mdlJob.getJob().getAlternateTemporaryLibrary() == null || DiagramTab.this.m_mdlJob.getJob().getCheckpointStateLibrary() == null)) {
                DiagramTab.this.showCheckpointSetupDialog();
            }
            if (sType == "ModelController:UnknownChanges" || sType == "Table:ViewChanged" || sType == "IJob:CollectStatisticsChanged" || sType == "IJob:CollectTableStatisticsChanged" || sType == "IJob:CollectDiagnosticsChanged" || sType == "IJob:MapAutomaticallyChanged" || sType == "IJob:PropagateAutomaticallyChanged" || sType == "IJob:AutomaticPropagationDirectionChanged" || sType == "ITransform:CollectDiagnosticsChanged" || sType == "ITransform:CodeGenerationEnabledChanged" || sType == "MappingsContainer:IncludeInPropagationChanged" || sType == "MappingsContainer:IncludeInMappingsChanged" || sType == "DataTransform.InputAdded" || sType == "DataTransform.InputRemoved" || sType == "DataTransform.OutputAdded" || sType == "DataTransform.OutputRemoved" || sType == "DataTransform.DataTargetAdded" || sType == "DataTransform.DataTargetRemoved" || sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataSourceRemoved" || sType == "ITransform:CheckpointEnabledChanged") {
                DiagramTab.this.updateActions();
            }
        }
    }

    private class RunJobModelListener
    implements RunModelListener {
        private RunJobModelListener() {
        }

        @Override
        public void modelChanged(RunModelEvent ev) {
            String sType = ev.getType();
            if (sType == "RunStateChanged") {
                DiagramTab.this.updateActions();
            }
        }

        @Override
        public void runEventHappened(RunEvent ev) {
        }
    }

    private class ValidateJobModelListener
    implements ValidateModelListener {
        private ValidateJobModelListener() {
        }

        @Override
        public void modelChanged(ValidateModelEvent ev) {
            String sType = ev.getType();
            if (sType == "ValidateStateChanged") {
                DiagramTab.this.updateActions();
            }
        }

        @Override
        public void validateEventHappened(ValidateEvent ev) {
        }
    }

    private class SelectionListener
    implements WsPFDSelectionListener {
        private SelectionListener() {
        }

        public void selectionChanged(WsPFDSelectionEvent ev) {
            DiagramTab.this.selectionChanged();
        }
    }

    private class DiagramMouseListener
    extends MouseAdapter {
        private DiagramMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DiagramTab.this.setDropLocation(e.getPoint());
        }
    }

    private class PropertiesAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropertiesAction() {
            super(bundle, "DiagramTab.Action.Properties", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Properties"));
            this.setMenuSupportId("Edit:Properties");
        }

        public void actionPerformed(ActionEvent ev) {
            IJob obj = DiagramTab.this.m_aSelectedObjects.length == 0 ? DiagramTab.this.m_mdlJob.getJob() : (IComplexPersistableObject)DiagramTab.this.m_aSelectedObjects[0];
            DiagramTab.this.showPropertiesDialog((IComplexPersistableObject)obj);
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                if (aObjects[iObject] instanceof SimpleObject) continue;
                return false;
            }
            return true;
        }
    }

    private class DeleteAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public DeleteAction() {
            super(bundle, "DiagramTab.Action.Delete", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Delete"));
            this.setMenuSupportId("Common:Delete");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.delete();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            return !DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class SelectAllAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public SelectAllAction() {
            this.setMenuSupportId("Edit:SelectAll");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.selectAll();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return true;
        }
    }

    private class ConnectionsAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public ConnectionsAction() {
            this.setMenuSupportId("Edit:Connections");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.getDiagramPanel().showConnectionsDialog();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            if (DiagramTab.this.isContextForMainJob(context)) {
                return false;
            }
            Object[] aSelectedObjects = context.getSelectedObjects();
            for (int iObject = 0; iObject < aSelectedObjects.length; ++iObject) {
                if (aSelectedObjects[iObject] instanceof SimpleObject) continue;
                return false;
            }
            return true;
        }
    }

    private class ReplaceAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public ReplaceAction() {
            this.setMenuSupportId("Actions:Replace");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.getDiagramPanel().replaceTable();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length > 0 && aObjects[0] instanceof JobTransformModel) {
                return false;
            }
            return DiagramTab.this.isContextForTypes(context, new String[]{"Table", "WorkTable"});
        }
    }

    private class RunFromSelectedTransformation
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public RunFromSelectedTransformation() {
            this.setMenuSupportId("Context:RunFromSelectedTransformation");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForTransformations(context);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.fireDebugEvent("RunFromSelectedTransforms");
        }
    }

    private class RunSelectedTransformations
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public RunSelectedTransformations() {
            this.setMenuSupportId("Context:RunSelectedTransformations");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForTransformations(context);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.fireDebugEvent("RunSelectedTransforms");
        }
    }

    private class RunToSelectedTransformation
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public RunToSelectedTransformation() {
            this.setMenuSupportId("Context:RunToSelectedTransformation");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForTransformations(context);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.fireDebugEvent("RunToSelectedTransform");
        }
    }

    private class CreateAsViewAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public CreateAsViewAction() {
            this.setMenuSupportId("Context:CreateAsView");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.startCompoundUndoable();
            try {
                for (int iObject = 0; iObject < DiagramTab.this.m_aSelectedObjects.length; ++iObject) {
                    ITable table = (ITable)DiagramTab.this.m_aSelectedObjects[iObject];
                    table.setView(this.isSelected());
                }
            }
            finally {
                DiagramTab.this.m_mdlJob.endCompoundUndoable();
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForType(context, "WorkTable");
        }
    }

    private class RegisterTableAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public RegisterTableAction() {
            this.setMenuSupportId("Actions:RegisterTable");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForType(context, "WorkTable");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.registerTable();
        }
    }

    private class JobPropagateToBeginningAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public JobPropagateToBeginningAction() {
            this.setMenuSupportId("Actions:PropagateColumns:ForJob:ToBeginning");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromEndToBeginning();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class JobPropagateToEndAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public JobPropagateToEndAction() {
            this.setMenuSupportId("Actions:PropagateColumns:ForJob:ToEnd");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromBeginningToEnd();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class JobPropagateDefaultAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public JobPropagateDefaultAction() {
            super(bundle, "DiagramTab.Action.JobPropagateDefault", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:PropagateColumns"));
            this.setMenuSupportId("Toolbar:PropagateColumnsForJobDefault");
        }

        public void actionPerformed(ActionEvent ev) {
            if (DiagramTab.this.m_mdlJob.getJob().getAutomaticPropagationDirection() == 0) {
                DiagramTab.this.m_mdlJob.propagateFromBeginningToEnd();
            } else {
                DiagramTab.this.m_mdlJob.propagateFromEndToBeginning();
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class JobMapAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public JobMapAction() {
            super(bundle, "DiagramTab.Action.JobMap", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:MapColumns"));
            this.setMenuSupportId("Actions:MapColumns:ForJob");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.mapColumns();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class AutoPropagateAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public AutoPropagateAction() {
            super(bundle, "DiagramTab.Action.AutoPropagateJob", 256);
            this.setMenuSupportId("Context:Settings:AutomaticallyPropagateColumns");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.getJob().setPropagateAutomatically(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class AutoMapAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public AutoMapAction() {
            super(bundle, "DiagramTab.Action.AutoMapJob", 256);
            this.setMenuSupportId("Context:Settings:AutomaticallyMapColumns");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.getJob().setMapAutomatically(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class FromBeginningToEndAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public FromBeginningToEndAction() {
            super(bundle, "DiagramTab.Action.FromBeginningToEnd", 256);
            this.setMenuSupportId("Context:Settings:FromBeginningToEnd");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.getJob().setAutomaticPropagationDirection(0);
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class FromEndToBeginningAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public FromEndToBeginningAction() {
            super(bundle, "DiagramTab.Action.FromEndToBeginning", 256);
            this.setMenuSupportId("Context:Settings:FromEndToBeginning");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.getJob().setAutomaticPropagationDirection(1);
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class CollectDiagnosticsAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public CollectDiagnosticsAction() {
            this.setMenuSupportId("Context:CollectDiagnostics");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.startCompoundUndoable();
            try {
                boolean bCollectDiagnostics = this.isSelected();
                for (int i = 0; i < DiagramTab.this.m_aSelectedObjects.length; ++i) {
                    if (DiagramTab.this.m_aSelectedObjects[i] instanceof ITransform) {
                        ((ITransform)DiagramTab.this.m_aSelectedObjects[i]).setCollectDiagnostics(bCollectDiagnostics);
                        continue;
                    }
                    if (!(DiagramTab.this.m_aSelectedObjects[i] instanceof IJob)) continue;
                    ((IJob)DiagramTab.this.m_aSelectedObjects[i]).setCollectDiagnostics(bCollectDiagnostics);
                }
            }
            finally {
                DiagramTab.this.m_mdlJob.endCompoundUndoable();
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context) || DiagramTab.this.isContextForTransformations(context);
        }
    }

    private class CollectRuntimeStatisticsAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public CollectRuntimeStatisticsAction() {
            this.setMenuSupportId("Context:CollectRuntimeStatistics");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.getJob().setCollectStatistics(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class CollectTableStatisticsAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public CollectTableStatisticsAction() {
            this.setMenuSupportId("Context:CollectTableStatistics");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.getJob().setCollectTableStatistics(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class DisableCheckpointsAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public DisableCheckpointsAction() {
            super(bundle, "DiagramTab.Action.DisableCheckpoints", 256);
            this.setMenuSupportId("Context:Settings:DisableCheckpoints");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.getJob().setDisableCheckpoints(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class SettingsAction
    extends WsDropMenuAction {
        public SettingsAction() {
            super(bundle, "DiagramTab.Action.Settings", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("OptionsDropMenu"));
        }
    }

    private class AssignAsRestartPointAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public AssignAsRestartPointAction() {
            super(bundle, "DiagramTab.Action.AssignAsRestartPoint", 256);
            this.setMenuSupportId("Context:Assign as Restart-Point");
        }

        public void actionPerformed(ActionEvent ev) {
            ((ITransform)DiagramTab.this.getSelectedObject()).setCheckpointEnabled(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForTypes(context, new String[]{"TransformInstance"});
        }
    }

    private class TransformationsMapAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public TransformationsMapAction() {
            this.setMenuSupportId("Actions:MapColumns:ForTransformations");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformations(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            DiagramTab.this.m_mdlJob.startCompoundUndoable();
            try {
                for (int iObject = 0; iObject < DiagramTab.this.m_aSelectedObjects.length; ++iObject) {
                    IDataTransform transform = (IDataTransform)DiagramTab.this.m_aSelectedObjects[iObject];
                    if (!transform.isIncludedInMapping()) continue;
                    transform.mapColumns();
                }
            }
            finally {
                DiagramTab.this.m_mdlJob.endCompoundUndoable();
            }
        }
    }

    private class PropagateToTargetsFromSourcesAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateToTargetsFromSourcesAction() {
            this.setMenuSupportId("Actions:PropagateColumns:ToTargets:FromSources");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromSourcesToTargets((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateToTargetsFromBeginningAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateToTargetsFromBeginningAction() {
            this.setMenuSupportId("Actions:PropagateColumns:ToTargets:FromBeginning");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromBeginningToTargets((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateToTargetsFromEndAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateToTargetsFromEndAction() {
            this.setMenuSupportId("Actions:PropagateColumns:ToTargets:FromEnd");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromEndToTargets((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateToSourcesFromTargetsAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateToSourcesFromTargetsAction() {
            this.setMenuSupportId("Actions:PropagateColumns:ToSources:FromTargets");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromTargetsToSources((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateToSourcesFromBeginningAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateToSourcesFromBeginningAction() {
            this.setMenuSupportId("Actions:PropagateColumns:ToSources:FromBeginning");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromBeginningToSources((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateToSourcesFromEndAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateToSourcesFromEndAction() {
            this.setMenuSupportId("Actions:PropagateColumns:ToSources:FromEnd");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromEndToSources((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateFromTargetsToSourcesAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateFromTargetsToSourcesAction() {
            this.setMenuSupportId("Actions:PropagateColumns:FromTargets:ToSources");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromTargetsToSources((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateFromTargetsToBeginningAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateFromTargetsToBeginningAction() {
            this.setMenuSupportId("Actions:PropagateColumns:FromTargets:ToBeginning");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromTargetsToBeginning((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateFromTargetsToEndAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateFromTargetsToEndAction() {
            this.setMenuSupportId("Actions:PropagateColumns:FromTargets:ToEnd");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromTargetsToEnd((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateFromSourcesToTargetsAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateFromSourcesToTargetsAction() {
            this.setMenuSupportId("Actions:PropagateColumns:FromSources:ToTargets");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromSourcesToTargets((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateFromSourcesToBeginningAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateFromSourcesToBeginningAction() {
            this.setMenuSupportId("Actions:PropagateColumns:FromSources:ToBeginning");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromSourcesToBeginning((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class PropagateFromSourcesToEndAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropagateFromSourcesToEndAction() {
            this.setMenuSupportId("Actions:PropagateColumns:FromSources:ToEnd");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.propagateFromSourcesToEnd((IMappingsContainer)DiagramTab.this.getSelectedDataTransformation());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class IncludeInPropagationAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public IncludeInPropagationAction() {
            this.setMenuSupportId("Context:Settings:IncludeInPropagation");
        }

        public void actionPerformed(ActionEvent e) {
            DiagramTab.this.getSelectedDataTransformation().setIncludedInPropagation(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class IncludeInMappingAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public IncludeInMappingAction() {
            this.setMenuSupportId("Context:Settings:IncludeInMappings");
        }

        public void actionPerformed(ActionEvent e) {
            DiagramTab.this.getSelectedDataTransformation().setIncludedInMapping(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformation(context);
        }
    }

    private class ExcludeFromRunAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public ExcludeFromRunAction() {
            this.setMenuSupportId("Context:ExcludeFromRun");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForTypes(context, new String[]{"TransformInstance", "GeneratedTransform"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.m_mdlJob.startCompoundUndoable();
            try {
                boolean bCodegenEnabled = !this.isSelected();
                for (int i = 0; i < DiagramTab.this.m_aSelectedObjects.length; ++i) {
                    if (!(DiagramTab.this.m_aSelectedObjects[i] instanceof ITransform)) continue;
                    ((ITransform)DiagramTab.this.m_aSelectedObjects[i]).setCodeGenerationEnabled(bCodegenEnabled);
                }
            }
            finally {
                DiagramTab.this.m_mdlJob.endCompoundUndoable();
            }
        }
    }

    private class AddInputPortAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public AddInputPortAction() {
            this.setMenuSupportId("Actions:Ports:AddInputPort");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformations(context);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.getSelectedDataTransformation().addInput();
        }
    }

    private class DeleteInputPortAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public DeleteInputPortAction() {
            this.setMenuSupportId("Actions:Ports:DeleteInputPort");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformations(context);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.getSelectedDataTransformation().deleteInput();
        }
    }

    private class AddOutputPortAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public AddOutputPortAction() {
            this.setMenuSupportId("Actions:Ports:AddOutputPort");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformations(context);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.getSelectedDataTransformation().addOutput();
        }
    }

    private class DeleteOutputPortAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public DeleteOutputPortAction() {
            this.setMenuSupportId("Actions:Ports:DeleteOutputPort");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformations(context);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.getSelectedDataTransformation().deleteOutput();
        }
    }

    private class AddWorkTableAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public AddWorkTableAction() {
            this.setMenuSupportId("Actions:AddWorkTable");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformations(context);
        }

        public void actionPerformed(ActionEvent ev) {
            IWorkTable workTable = DiagramTab.this.getSelectedDataTransformation().addNewWorkTable();
            if (DiagramTab.this.m_mdlJob.getJob().isPropagatingAutomatically()) {
                if (DiagramTab.this.m_mdlJob.getJob().getAutomaticPropagationDirection() == 0) {
                    DiagramTab.this.m_mdlJob.propagateFromBeginningToEnd(DiagramTab.this.getSelectedDataTransformation(), (ITable)workTable);
                } else {
                    DiagramTab.this.m_mdlJob.propagateFromEndToBeginning(DiagramTab.this.getSelectedDataTransformation(), (ITable)workTable);
                }
            }
        }
    }

    private class LargeWorkTablesAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public LargeWorkTablesAction() {
            this.setMenuSupportId("Actions:ExpandWorkTables");
            this.setSelected(false);
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForDataTransformations(context);
        }

        public void actionPerformed(ActionEvent ev) {
            boolean bSelected = this.isSelected();
            PFDPrimitive[] aPrimitives = DiagramTab.this.getDiagramPanel().getSelectionModel().getPrimitives();
            for (int iPrimitive = 0; iPrimitive < aPrimitives.length; ++iPrimitive) {
                if (!(aPrimitives[iPrimitive] instanceof IDataTransformNode)) continue;
                ((IDataTransformNode)aPrimitives[iPrimitive]).setForceShowPorts(!((IDataTransformNode)aPrimitives[iPrimitive]).isForceShowPorts());
                ((IDataTransformNode)aPrimitives[iPrimitive]).setCollapsed(!((IDataTransformNode)aPrimitives[iPrimitive]).isCollapsed());
                bSelected = !((IDataTransformNode)aPrimitives[iPrimitive]).isCollapsed();
            }
            this.setSelected(bSelected);
        }
    }

    private class OpenDrillableAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public OpenDrillableAction() {
            this.setMenuSupportId("Context:Open");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            PFDPrimitive[] aPrimitives = DiagramTab.this.getDiagramPanel().getSelectionModel().getPrimitives();
            return aPrimitives.length == 1 && aPrimitives[0] instanceof IDiagramNode && ((IDiagramNode)aPrimitives[0]).getAdapter() instanceof IDrillableAdapter;
        }

        public void actionPerformed(ActionEvent ev) {
            IDiagramNodeAdapter adapter;
            PFDPrimitive[] aPrimitives = DiagramTab.this.getDiagramPanel().getSelectionModel().getPrimitives();
            if (aPrimitives.length == 1 && aPrimitives[0] instanceof IDiagramNode && (adapter = ((IDiagramNode)aPrimitives[0]).getAdapter()) instanceof IDrillableAdapter) {
                DiagramTab.this.fireDrillEvent(DiagramTab.this, ((IDrillableAdapter)((Object)adapter)).getDrillComponent(DiagramTab.this.getRunModel()));
            }
        }
    }

    private class AddStickyNotePopupMenuAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public AddStickyNotePopupMenuAction() {
            super(bundle, "DiagramTab.Action.AddStickyNote", 256);
            this.setMenuSupportId("Context:StickyNote:Add");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setSavedClickedPoint(DiagramTab.this.getPFDComponent().getClickedPoint());
            DiagramTab.this.addStickyNote();
            DiagramTab.this.setSavedClickedPoint(new Point());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class AddStickyNoteAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public AddStickyNoteAction() {
            super(bundle, "DiagramTab.Action.AddStickyNote", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:StickyNote:Add"));
            this.setMenuSupportId("Actions:StickyNote:Add");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setSavedClickedPoint(new Point());
            DiagramTab.this.addStickyNote();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return DiagramTab.this.isContextForMainJob(context);
        }
    }

    private class CloseStickyNoteAction
    extends WsAbstractAction {
        public CloseStickyNoteAction() {
            this.setMenuSupportId("Actions:StickyNote:Close");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.closeStickyNote();
        }
    }

    private class OpenStickyNoteAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public OpenStickyNoteAction() {
            this.setMenuSupportId("Actions:StickyNote:Open");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.openStickyNote();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length != 1) {
                return false;
            }
            return aObjects[0] instanceof IDiagramStickyNote;
        }
    }

    private class StickyNoteColorYellowAction
    extends WsAbstractToggleAction {
        public StickyNoteColorYellowAction() {
            this.setMenuSupportId("Actions:StickyNote:Yellow");
            this.setSelected(false);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.getSelectedStickyNote().setNoteStyleContext("NoteStyleYellow");
        }
    }

    private class StickyNoteColorBlueAction
    extends WsAbstractToggleAction {
        public StickyNoteColorBlueAction() {
            this.setMenuSupportId("Actions:StickyNote:Blue");
            this.setSelected(false);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.getSelectedStickyNote().setNoteStyleContext("NoteStyleBlue");
        }
    }

    private class StickyNoteColorPinkAction
    extends WsAbstractToggleAction {
        public StickyNoteColorPinkAction() {
            this.setMenuSupportId("Actions:StickyNote:Pink");
            this.setSelected(false);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.getSelectedStickyNote().setNoteStyleContext("NoteStylePink");
        }
    }

    private class AutoLayoutAction
    extends WsAbstractToggleAction {
        public AutoLayoutAction() {
            this.setMenuSupportId("View:Layout:DoLayout");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.doAutoLayout();
        }
    }

    private class FlowDirectionLeftToRightAction
    extends WsAbstractToggleAction {
        public FlowDirectionLeftToRightAction() {
            this.setMenuSupportId("View:Layout:LeftToRight");
            this.setSelected(DiagramTab.this.getFlowDirection().equals("Right"));
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setFlowDirection("Right");
        }
    }

    private class FlowDirectionTopToBottomAction
    extends WsAbstractToggleAction {
        public FlowDirectionTopToBottomAction() {
            this.setMenuSupportId("View:Layout:TopToBottom");
            this.setSelected(DiagramTab.this.getFlowDirection().equals("Down"));
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setFlowDirection("Down");
        }
    }

    private class FlowDirectionBottomToTopAction
    extends WsAbstractToggleAction {
        public FlowDirectionBottomToTopAction() {
            this.setMenuSupportId("View:Layout:BottomToTop");
            this.setSelected(DiagramTab.this.getFlowDirection().equals("Up"));
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setFlowDirection("Up");
        }
    }

    private class ZoomCustomAction
    extends WsAbstractToggleAction {
        public ZoomCustomAction() {
            this.setMenuSupportId("Hidden:Zoom:Custom");
            this.setSelected(!DiagramTab.this.getZoom().equals("2.0") && !DiagramTab.this.getZoom().equals("1.5") && !DiagramTab.this.getZoom().equals("1") && !DiagramTab.this.getZoom().equals(".75") && !DiagramTab.this.getZoom().equals(".5") && !DiagramTab.this.getZoom().equals(".25") && !DiagramTab.this.getZoom().equals(".1"));
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class Zoom200Action
    extends WsAbstractToggleAction {
        public Zoom200Action() {
            this.setMenuSupportId("View:Zoom:200%");
            this.setSelected(DiagramTab.this.getZoom().equals("2.0"));
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setZoom("2.0");
        }
    }

    private class Zoom150Action
    extends WsAbstractToggleAction {
        public Zoom150Action() {
            this.setMenuSupportId("View:Zoom:150%");
            this.setSelected(DiagramTab.this.getZoom().equals("1.5"));
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setZoom("1.5");
        }
    }

    private class Zoom100Action
    extends WsAbstractToggleAction {
        public Zoom100Action() {
            this.setMenuSupportId("View:Zoom:100%");
            this.setSelected(DiagramTab.this.getZoom().equals("1"));
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setZoom("1");
        }
    }

    private class Zoom75Action
    extends WsAbstractToggleAction {
        public Zoom75Action() {
            this.setMenuSupportId("View:Zoom:75%");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setZoom(".75");
            this.setSelected(DiagramTab.this.getZoom().equals(".75"));
        }
    }

    private class Zoom50Action
    extends WsAbstractToggleAction {
        public Zoom50Action() {
            this.setMenuSupportId("View:Zoom:50%");
            this.setSelected(DiagramTab.this.getZoom().equals(".5"));
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setZoom(".5");
        }
    }

    private class Zoom25Action
    extends WsAbstractToggleAction {
        public Zoom25Action() {
            this.setMenuSupportId("View:Zoom:25%");
            this.setSelected(DiagramTab.this.getZoom().equals(".25"));
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setZoom(".25");
        }
    }

    private class Zoom10Action
    extends WsAbstractToggleAction {
        public Zoom10Action() {
            this.setMenuSupportId("View:Zoom:10%");
            this.setSelected(DiagramTab.this.getZoom().equals(".1"));
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setZoom(".1");
        }
    }

    private class ZoomFitWidthAction
    extends WsAbstractToggleAction {
        public ZoomFitWidthAction() {
            this.setMenuSupportId("View:Zoom:FitWidth");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setZoom("FitWidth");
        }
    }

    private class ZoomFitHeightAction
    extends WsAbstractToggleAction {
        public ZoomFitHeightAction() {
            this.setMenuSupportId("View:Zoom:FitHeight");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setZoom("FitHeight");
        }
    }

    private class ZoomFitBothAction
    extends WsAbstractToggleAction {
        public ZoomFitBothAction() {
            this.setMenuSupportId("View:Zoom:FitBoth");
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setZoom("FitBoth");
        }
    }

    private class ShowGridAction
    extends WsAbstractToggleAction {
        public ShowGridAction() {
            this.setMenuSupportId("View:Grid:ShowGrid");
            this.setSelected(DiagramTab.this.isShowGrid());
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setShowGrid(this.isSelected());
        }
    }

    private class SnapToGridAction
    extends WsAbstractToggleAction {
        public SnapToGridAction() {
            this.setMenuSupportId("View:Grid:SnapToGrid");
            this.setSelected(DiagramTab.this.isSnapToGrid());
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setSnapToGrid(this.isSelected());
        }
    }

    private class GridStyleSolidAction
    extends WsAbstractToggleAction {
        public GridStyleSolidAction() {
            this.setMenuSupportId("View:Grid:Solid");
            this.setSelected(DiagramTab.this.getGridStyle() == 0);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setGridStyle(0);
        }
    }

    private class GridStyleDotAction
    extends WsAbstractToggleAction {
        public GridStyleDotAction() {
            this.setMenuSupportId("View:Grid:Dot");
            this.setSelected(DiagramTab.this.getGridStyle() == 1);
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setGridStyle(1);
        }
    }

    private class CollapseAction
    extends WsAbstractToggleAction {
        public CollapseAction() {
            this.setMenuSupportId("View:Collapse");
            this.setSelected(DiagramTab.this.isCollapsed());
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setCollapse(this.isSelected());
        }
    }

    private class ExpandAction
    extends WsAbstractToggleAction {
        public ExpandAction() {
            this.setMenuSupportId("View:Expand");
            this.setSelected(DiagramTab.this.isExpanded());
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setExpand(this.isSelected());
        }
    }

    private class ControlOrderAction
    extends WsAbstractToggleAction {
        public ControlOrderAction() {
            this.setMenuSupportId("View:ControlOrder");
            this.setSelected(DiagramTab.this.isControlOrderVisible());
        }

        public void actionPerformed(ActionEvent ev) {
            DiagramTab.this.setControlOrderVisible(this.isSelected());
        }
    }

    private class ActionContext
    implements WsActionContextInterface {
        private IDiagramNodeAdapter m_adapter;

        public ActionContext(IDiagramNodeAdapter adapter) {
            this.m_adapter = adapter;
        }

        public void addContextMenuItems(JPopupMenu mnuPopup) {
            this.m_adapter.addContextMenuItems(mnuPopup);
        }

        public Object[] getSelectedObjects() {
            return DiagramTab.this.getSelectedObjects();
        }

        public String getType() {
            return DiagramTab.CONTEXT;
        }
    }

    private class LoadRunnable
    extends AbstractWasSuccessfulRunnable {
        private LoadRunnable() {
        }

        @Override
        public void run() {
            this.setSuccessful(false);
            try {
                DiagramTab.this.m_mdlJob.loadFromOMR(Workspace.getMdFactory());
                this.setSuccessful(true);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ObjectFactoryException ex) {
                String sMessage = bundle.formatString("DiagramTab.Error.Loading.fmt", (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((String)sMessage, (int)0);
                Workspace.getDefaultLogger().error((Object)sMessage);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)new MdException((Throwable)ex), (String)"Reading");
                Workspace.getDefaultLogger().error((Object)ex.getLocalizedMessage());
            }
        }
    }

    private class SaveRunnable
    extends AbstractWasSuccessfulRunnable {
        private SaveRunnable() {
        }

        @Override
        public void run() {
            this.setSuccessful(false);
            try {
                DiagramTab.this.m_mdlJob.saveToOMR(Workspace.getMdFactory());
                DiagramTab.this.getDiagramPanel().save();
                DiagramTab.this.m_mdlJob.getUndoManager().discardAllEdits();
                this.setSuccessful(true);
                DiagramTab.this.setDataChanged(false);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)new MdException((Throwable)ex), (String)"Writing");
                Workspace.getDefaultLogger().error((Object)ex.getLocalizedMessage());
            }
        }
    }

    private class DirectionAction
    extends WsDropMenuAction {
        public DirectionAction() {
            super(bundle, "DiagramTab.Action.Direction", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("OptionsDropMenu"));
        }
    }
}

