/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlow;
import com.sas.etl.models.data.edmflow.IEDMFlow;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IDataObjectPlacements;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.IGeneratedTransformDefinition;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.IUIPlacement;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.job.transforms.GeneratedTransformModel;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.etl.models.job.transforms.businessrules.BusinessRuleTransformModel;
import com.sas.etl.models.job.transforms.dataloader.DataLoaderDirectiveTransformModel;
import com.sas.etl.models.job.transforms.dataloader.IDirective;
import com.sas.etl.models.job.transforms.edmflow.EDMFlowTransformModel;
import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.jobeditor.diagram.IPFDModel;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.copypaste.PasteItem;
import com.sas.wadmin.jobeditor.diagram.copypaste.PasteItemLocationComparator;
import com.sas.wadmin.jobeditor.diagram.copypaste.PasteItemsContainer;
import com.sas.wadmin.jobeditor.diagram.shapes.ICollapsibleShape;
import com.sas.wadmin.jobeditor.diagram.shapes.IControlLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IControlPort;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataTransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramPersistable;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.wadmin.jobeditor.diagram.shapes.IShape;
import com.sas.wadmin.jobeditor.diagram.shapes.ITransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IWorkTableNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.BaseLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.ControlLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.ControlPort;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramNodeFactory;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramParserException;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramUtil;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUndoManager;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DiagramModel
extends WsPFDModel
implements IPFDModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(DiagramModel.class);
    public static final int FLOW_DIRECTION_CHANGED = 1001;
    private static final String DIAGRAM_NODES = "DiagramNodes";
    private static final String DIAGRAM_LINKS = "DiagramLinks";
    private static final String FLOW_DIRECTION_RIGHT = "Right";
    private PropertyChangeListener m_appDefaultsListener;
    private DesignTimeJobModel m_mdlJob;
    private DiagramNodeFactory m_factoryNodes;
    private DiagramNodeAdapterFactory m_factoryAdapters;
    private HashMap m_mapNodes;
    private HashMap m_mapObjectShapes;
    private HashMap m_mapLinks;
    private Map<String, IDiagramStickyNote> m_mapStickyNotes;
    private List m_lNodes;
    private List m_lLinks;
    private List<IDiagramStickyNote> m_lStickyNotes;
    private String m_sDiagramXML;
    private boolean m_bFirstOpen;
    private boolean m_bCleanUpRequired;
    private HashMap m_mapDeletedStickyNotes;
    private HashMap m_mapDeletedNodes;
    private HashMap m_mapDeletedLinks;
    private Point m_nextLocation;
    private boolean m_bIncrementLocation;
    private Point m_dropPt;
    private IDiagramNode m_lastNodeAdded;
    private IModelListener m_lsnrJobModel;
    private ChangeListener m_lsnrUndo;
    private boolean m_bControlOrderVisible;
    private boolean m_bCollapse;
    private boolean m_bIgnoreEvents;
    private boolean m_bResetModeOnEdit;
    private boolean m_bIgnoreDeletedNodes;
    private int m_iInsertIteration = 0;
    private boolean m_inLoad = false;
    private boolean m_bNoLocation;

    public DiagramModel() {
        this(null);
    }

    public DiagramModel(DesignTimeJobModel mdlJob) {
        this(mdlJob, DiagramNodeFactory.getInstance(), DiagramNodeAdapterFactory.getInstance());
    }

    public DiagramModel(DesignTimeJobModel mdlJob, DiagramNodeFactory factoryNodes, DiagramNodeAdapterFactory factoryAdapters) {
        this.m_factoryAdapters = factoryAdapters;
        this.m_factoryNodes = factoryNodes;
        this.setFirstOpen(true);
        this.setIgnoreEvents(false);
        this.m_lNodes = new ArrayList();
        this.m_lLinks = new ArrayList();
        this.m_lStickyNotes = new ArrayList<IDiagramStickyNote>();
        this.m_mapNodes = new HashMap();
        this.m_mapLinks = new HashMap();
        this.m_mapStickyNotes = new HashMap<String, IDiagramStickyNote>();
        this.m_mapObjectShapes = new HashMap();
        this.m_mapDeletedNodes = new HashMap();
        this.m_mapDeletedLinks = new HashMap();
        this.m_mapDeletedStickyNotes = new HashMap();
        this.m_nextLocation = new Point();
        this.m_nextLocation.x = 0;
        this.m_nextLocation.y = 0;
        this.m_bIncrementLocation = true;
        this.m_lsnrJobModel = new JobModelListener();
        this.setJobModel(this.m_mdlJob);
        this.m_lsnrUndo = new UndoManagerListener();
        this.m_appDefaultsListener = new cPropertyChanged();
        Workspace.getWorkspace().getWorkspaceFile().addPropertyChangeListener(this.m_appDefaultsListener);
    }

    public void setInLoad(boolean inLoad) {
        this.m_inLoad = inLoad;
    }

    public boolean isInLoad() {
        return this.m_inLoad;
    }

    private List acquireNodes(IObject obj) {
        ArrayList<IDiagramNode> nodes = null;
        nodes = (ArrayList<IDiagramNode>)this.getNodes(obj);
        if (nodes == null || nodes.isEmpty()) {
            nodes = new ArrayList<IDiagramNode>();
            IDiagramNode node = this.addNode(obj);
            nodes.add(node);
        } else if (obj instanceof IDataObject && !(obj instanceof IWorkTable)) {
            IDiagramNode node = this.addNode(obj);
            nodes.add(node);
        }
        return nodes;
    }

    protected IDiagramStickyNote createStickyNote() {
        return null;
    }

    protected IDiagramNode addNode(IObject obj, IUIPlacement placement) {
        IDiagramNode node = null;
        ArrayList nodes = null;
        if (!this.getIgnoreDeletedNodes()) {
            nodes = (ArrayList)this.getDeletedNodes(obj);
        }
        if (nodes != null && !nodes.isEmpty()) {
            for (int iNode = 0; iNode < nodes.size(); ++iNode) {
                node = (IDiagramNode)nodes.get(iNode);
                if (obj instanceof IWorkTable || !(obj instanceof IDataObject)) continue;
                this.m_mdlJob.getJob().addUIPlacemnentToJob((IDataObject)obj, node.getUIPlacement());
                if (node.getId().equals(((IDataObject)obj).getChangedNodeId())) break;
            }
        }
        if (node == null) {
            IDiagramNodeAdapter adapter = this.m_factoryAdapters.createAdapter(obj);
            Point p = new Point();
            node = (IDiagramNode)this.m_factoryNodes.createNode(adapter);
            if (node instanceof IDataNode) {
                if (placement != null) {
                    ((IDataNode)node).setUIPlacement(placement);
                    node.setSpotLocation(1, new Point(node.getUIPlacement().getXPosition(), node.getUIPlacement().getYPosition()));
                } else if (node.getUIPlacement() == null) {
                    ((IDataNode)node).setUIPlacement((IDesignTimeModel)this.m_mdlJob);
                }
            }
            node.getSpotLocation(1, p);
            if (node instanceof ITransformNode) {
                if (placement == null && (node.getUIPlacement() == null || node.getUIPlacement().getXPosition() == -999)) {
                    node.setForceShowPorts(!this.m_bCollapse);
                    if (node instanceof ICollapsibleShape) {
                        ((ICollapsibleShape)((Object)node)).setCollapsed(this.m_bCollapse);
                    }
                }
                if (node.getNumInputPorts() > 1 && node.getInputPort(0) != null && node.getInputPort(0) instanceof IControlPort) {
                    node.getInputPort(0).setVisible(this.isControlOrderVisible());
                }
                if (node.getNumOutputPorts() > 1 && node.getOutputPort(0) != null && node.getOutputPort(0) instanceof IControlPort) {
                    node.getOutputPort(0).setVisible(this.isControlOrderVisible());
                }
            }
            if (!(obj instanceof IWorkTable || node.getUIPlacement() != null && node.getUIPlacement().getXPosition() != -999)) {
                if (this.m_dropPt != null) {
                    node.setLocation(this.m_dropPt.x, this.m_dropPt.y);
                    node.getSpotLocation(1, p);
                    node.getUIPlacement().setXPosition(p.x);
                    node.getUIPlacement().setYPosition(p.y);
                } else {
                    node.setLocation(this.m_nextLocation.x, this.m_nextLocation.y);
                    node.getSpotLocation(1, p);
                    node.getUIPlacement().setXPosition(p.x);
                    node.getUIPlacement().setYPosition(p.y);
                    if (this.m_bIncrementLocation) {
                        this.m_nextLocation.x += 20;
                        this.m_nextLocation.y += 20;
                    }
                }
            }
        }
        this.removeDeletedNode(obj, node);
        this.putNode(obj, node);
        this.m_lastNodeAdded = node;
        if (node instanceof IWorkTableNode) {
            return node;
        }
        this.addPrimitive((PFDPrimitive)((PFDAbstractNode)node));
        node.setSpotLocation(1, new Point(node.getUIPlacement().getXPosition(), node.getUIPlacement().getYPosition()));
        return node;
    }

    protected IDiagramNode addNode(IObject obj) {
        return this.addNode(obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dropSimpleObject(Point pt, SimpleObject simpleObj) {
        boolean bl;
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "DiagramModel:dropSimpleObject");
        try {
            Root mdObj = ObjectConverter.getInstance().convertToJOMAObject(store, simpleObj);
            bl = this.dropDataObject(pt, (CMetadata)mdObj);
        }
        catch (Throwable throwable) {
            try {
                store.dispose();
                throw throwable;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                return false;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return false;
            }
        }
        store.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropJobTransform(Point pt, SimpleObject job) {
        DesignTimeJobModel jobModel = this.getJobModel();
        this.m_dropPt = pt;
        if (jobModel != null) {
            jobModel.startCompoundUndoable();
            try {
                JobTransformModel transform = (JobTransformModel)jobModel.getObjectFactory().createNewTransform(JobTransformModel.getTransformTypeID(), jobModel.getJob().getID());
                OMRAdapter omr = new OMRAdapter((IModel)jobModel, Workspace.getMdFactory(), "drop inner job");
                try {
                    transform.attachInnerJob(job, omr);
                }
                finally {
                    omr.dispose();
                }
                this.getJobModel().getJob().getTransformsList().add(transform);
                this.getJobModel().getJob().getControlOrderedTransformsList().add(transform);
                transform.addDefaultSettings();
                boolean bl = true;
                return bl;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                boolean bl = false;
                return bl;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                boolean bl = false;
                return bl;
            }
            finally {
                this.m_dropPt = null;
                jobModel.endCompoundUndoable();
            }
        }
        return false;
    }

    public boolean pasteNodes(Point startLocation) {
        this.m_dropPt = startLocation;
        this.m_dropPt = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropBusinessRuleTransform(Point pt, CMetadata obj) {
        DesignTimeJobModel jobModel = this.getJobModel();
        this.m_dropPt = pt;
        if (jobModel != null) {
            IJob job = jobModel.getJob();
            jobModel.startCompoundUndoable();
            OMRAdapter load = null;
            try {
                load = new OMRAdapter((IModel)jobModel, Workspace.getMdFactory(), "load business rule");
                SimpleObject[] so = new SimpleObject[]{ObjectConverter.getInstance().convertToSimpleObject((PrimaryType)obj)};
                IBusinessRuleFlow flow = (IBusinessRuleFlow)load.acquireObject(ObjectConverter.getInstance().convertToJOMAObject(load.getOMRStore(), so[0]));
                BusinessRuleTransformModel transform = (BusinessRuleTransformModel)jobModel.getObjectFactory().createNewTransform(BusinessRuleTransformModel.getTransformTypeID(), job.getID());
                jobModel.getJob().getTransformsList().add(transform);
                transform.addDefaultSettings();
                transform.setBusinessRule(flow);
                boolean bl = true;
                return bl;
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                boolean bl = false;
                return bl;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                boolean bl = false;
                return bl;
            }
            finally {
                this.m_dropPt = null;
                jobModel.endCompoundUndoable();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropDirective(Point pt, CMetadata obj) {
        DesignTimeJobModel jobModel = this.getJobModel();
        this.m_dropPt = pt;
        if (jobModel != null) {
            IJob job = jobModel.getJob();
            jobModel.startCompoundUndoable();
            OMRAdapter load = null;
            try {
                load = new OMRAdapter((IModel)jobModel, Workspace.getMdFactory(), "load directive");
                SimpleObject[] so = new SimpleObject[]{ObjectConverter.getInstance().convertToSimpleObject((PrimaryType)obj)};
                IDirective flow = (IDirective)load.acquireObject(ObjectConverter.getInstance().convertToJOMAObject(load.getOMRStore(), so[0]));
                DataLoaderDirectiveTransformModel transform = (DataLoaderDirectiveTransformModel)jobModel.getObjectFactory().createNewTransform(DataLoaderDirectiveTransformModel.getTransformTypeID(), job.getID());
                jobModel.getJob().getTransformsList().add(transform);
                transform.addDefaultSettings();
                transform.setDirective(flow);
                transform.setName(flow.getName());
                boolean bl = true;
                return bl;
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                boolean bl = false;
                return bl;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                boolean bl = false;
                return bl;
            }
            finally {
                this.m_dropPt = null;
                jobModel.endCompoundUndoable();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropEDMFlowTransform(Point pt, CMetadata obj) {
        DesignTimeJobModel jobModel = this.getJobModel();
        this.m_dropPt = pt;
        if (jobModel != null) {
            IJob job = jobModel.getJob();
            jobModel.startCompoundUndoable();
            OMRAdapter load = null;
            try {
                load = new OMRAdapter((IModel)jobModel, Workspace.getMdFactory(), "load edm flow");
                SimpleObject[] so = new SimpleObject[]{ObjectConverter.getInstance().convertToSimpleObject((PrimaryType)obj)};
                IEDMFlow flow = (IEDMFlow)load.acquireObject(ObjectConverter.getInstance().convertToJOMAObject(load.getOMRStore(), so[0]));
                EDMFlowTransformModel transform = (EDMFlowTransformModel)jobModel.getObjectFactory().createNewTransform(EDMFlowTransformModel.getTransformTypeID(), job.getID());
                jobModel.getJob().getTransformsList().add(transform);
                transform.addDefaultSettings();
                transform.setEDMFlow(flow);
                boolean bl = true;
                return bl;
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                boolean bl = false;
                return bl;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                boolean bl = false;
                return bl;
            }
            finally {
                this.m_dropPt = null;
                jobModel.endCompoundUndoable();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean dropGeneratedTransform(Point pt, CMetadata obj) {
        DesignTimeJobModel jobModel = this.getJobModel();
        this.m_dropPt = pt;
        if (jobModel == null) return false;
        jobModel.startCompoundUndoable();
        try {
            IDataTransformNode node;
            IGeneratedTransformDefinition generatedDefinition = (IGeneratedTransformDefinition)jobModel.getObject(obj.getFQID());
            if (generatedDefinition == null) {
                generatedDefinition = jobModel.getObjectFactory().createGeneratedTransformDefinition(obj.getFQID());
                OMRAdapter omr = new OMRAdapter((IModel)jobModel, Workspace.getMdFactory(), "createGeneratedTransformDefinition");
                boolean undoSupport = jobModel.isUndoSupported();
                jobModel.setUndoSupported(false);
                try {
                    if (omr != null) {
                        omr.populateFor((IOMRPersistable)generatedDefinition);
                        generatedDefinition.loadFromOMR(omr);
                    }
                }
                catch (MdException me) {
                    this.m_dropPt = null;
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                    boolean bl = false;
                    return bl;
                }
                finally {
                    jobModel.setUndoSupported(undoSupport);
                    omr.dispose();
                }
            }
            GeneratedTransformModel transform = (GeneratedTransformModel)jobModel.getObjectFactory().createNewTransform("TransformationStep2", jobModel.getJob().getID());
            transform.setTransformDefinition(generatedDefinition);
            this.getJobModel().getJob().getTransformsList().add(transform);
            if (this.getNodes((IObject)transform) != null && (node = (IDataTransformNode)this.getNodes((IObject)transform).get(0)).getNumInputPorts() == 1 && node.getNumOutputPorts() == 1 && node.getInputPort(0) instanceof IControlPort && node.getOutputPort(0) instanceof IControlPort) {
                this.getJobModel().getJob().getControlOrderedTransformsList().add(transform);
            }
            transform.addDefaultSettings();
            jobModel.endCompoundUndoable();
            return true;
        }
        catch (RemoteException re) {
            jobModel.endCompoundUndoable();
            this.m_dropPt = null;
            return false;
        }
    }

    public void dispose() {
        Workspace.getWorkspace().getWorkspaceFile().removePropertyChangeListener(this.m_appDefaultsListener);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dropDataObject(Point pt, CMetadata obj) {
        block38: {
            DesignTimeJobModel jobModel = this.getJobModel();
            try {
                this.setIgnoreDeletedNodes(true);
                String strType = obj.getCMetadataType();
                String strPublicType = "";
                if (obj instanceof PrimaryType) {
                    strPublicType = ((PrimaryType)obj).getPublicType();
                }
                if (strType.equals("Prototype")) {
                    boolean bl = this.dropGeneratedTransform(pt, obj);
                    return bl;
                }
                if (strType.equals("Job")) {
                    boolean bl = this.dropJobTransform(pt, ObjectConverter.getInstance().convertToSimpleObject((PrimaryType)((Job)obj)));
                    return bl;
                }
                if (strType.equals("Transformation") && strPublicType.equals("BusinessRuleFlow")) {
                    boolean bl = this.dropBusinessRuleTransform(pt, obj);
                    return bl;
                }
                if (strType.equals("Transformation") && strPublicType.equals("DecisionLogic")) {
                    boolean bl = this.dropEDMFlowTransform(pt, obj);
                    return bl;
                }
                if (strType.equals("Transformation") && strPublicType.equals("Directive.DL")) {
                    boolean bl = this.dropDirective(pt, obj);
                    return bl;
                }
                List nodes = this.getObjectShapes(jobModel.getObject(obj.getId()), DIAGRAM_NODES);
                if (nodes != null && !nodes.isEmpty()) {
                    this.m_dropPt = pt;
                    IDiagramNode node = this.addNode(((IDiagramNode)nodes.get(0)).getObject());
                    if (node != null) {
                        this.getJobModel().undoableEditHappened((UndoableEdit)new AddDataObjectUndoable(node, pt));
                    }
                    boolean bl = true;
                    return bl;
                }
                this.m_dropPt = pt;
                if (jobModel == null) break block38;
                if (jobModel.getObject(obj.getFQID()) == null) {
                    String sPublicType = ((PrimaryType)obj).getPublicType();
                    IDataObject oData = this.m_mdlJob.getObjectFactory().createDataObjectForPublicType(sPublicType, obj.getFQID());
                    if (oData == null) {
                        try {
                            oData = ModelUIUtilities.createDataObject((IModel)this.m_mdlJob, (PrimaryType)obj);
                        }
                        catch (MdException e) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                            this.m_dropPt = null;
                            boolean bl = false;
                            this.setIgnoreDeletedNodes(false);
                            return bl;
                        }
                    }
                    this.m_bIgnoreEvents = true;
                    if (oData != null) {
                        try {
                            jobModel.loadFromOMR((IOMRPersistable)oData, Workspace.getMdFactory());
                        }
                        catch (MdException e) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                            this.m_dropPt = null;
                            boolean bl = false;
                            this.setIgnoreDeletedNodes(false);
                            return bl;
                        }
                        try {
                            jobModel.startCompoundUndoable();
                            this.m_bIgnoreEvents = false;
                            jobModel.getJob().getDataObjectsList().add(oData);
                        }
                        finally {
                            jobModel.endCompoundUndoable();
                        }
                    }
                } else if (!jobModel.getJob().getDataObjectsList().contains(jobModel.getObject(obj.getFQID()))) {
                    try {
                        jobModel.startCompoundUndoable();
                        jobModel.getJob().getDataObjectsList().add(jobModel.getObject(obj.getFQID()));
                        this.setLocation(this.m_lastNodeAdded, null, this.m_lastNodeAdded.getLocation());
                    }
                    finally {
                        jobModel.endCompoundUndoable();
                    }
                } else {
                    this.m_dropPt = null;
                    IDiagramNode node = this.addNode(jobModel.getObject(obj.getFQID()));
                    if (node != null) {
                        node.setLocation(pt.x, pt.y);
                        Point p = new Point();
                        node.getSpotLocation(1, p);
                        node.getUIPlacement().setXPosition(p.x);
                        node.getUIPlacement().setYPosition(p.y);
                        this.getJobModel().undoableEditHappened((UndoableEdit)new AddDataObjectUndoable(node, pt));
                    }
                }
                this.m_dropPt = null;
                boolean bl = true;
                return bl;
            }
            catch (RemoteException re) {
                this.m_dropPt = null;
                Workspace.handleRemoteException((RemoteException)re);
                boolean bl = false;
                return bl;
            }
            finally {
                this.setIgnoreDeletedNodes(false);
            }
        }
        this.m_dropPt = null;
        return false;
    }

    private List removeNodes(IObject obj) {
        ArrayList nodes = (ArrayList)this.getNodes(obj);
        if (nodes != null) {
            for (int iNode = 0; iNode < nodes.size(); ++iNode) {
                IDiagramNode node = (IDiagramNode)nodes.get(iNode);
                if (node != null && !(obj instanceof IWorkTable) && obj instanceof IDataObject && ((IDataObject)obj).getChangedNodeId() != null && !((IDataObject)obj).getChangedNodeId().equals(node.getId())) continue;
                this.removeNode(node.getId());
            }
        }
        return nodes;
    }

    private IDiagramLink removeLink(IObject fromObj, IObject toObj, int fromPortIndex, int toPortIndex) {
        IDiagramLink link = this.getLink(fromObj, toObj, fromPortIndex, toPortIndex);
        if (link == null) {
            return null;
        }
        this.removeLink(link);
        return link;
    }

    private IDiagramLink removeLink(IObject fromObj, IObject toObj) {
        return this.removeLink(fromObj, toObj, -1, -1);
    }

    protected void removeLink(IDiagramLink link) {
        IDiagramNode toNode;
        if (link == null) {
            return;
        }
        this.m_mapLinks.remove(link.getId());
        IDiagramNode fromNode = this.getNode(link.getFromNodeId());
        if (fromNode != null && this.containsInObjectShapes(fromNode.getObject())) {
            this.removeObjectShape(fromNode.getObject(), link);
        }
        if (fromNode != null) {
            this.putDeletedLink(fromNode, link);
        }
        if ((toNode = this.getNode(link.getToNodeId())) != null && this.containsInObjectShapes(toNode.getObject())) {
            this.removeObjectShape(toNode.getObject(), link);
        }
        if (toNode != null) {
            this.putDeletedLink(toNode, link);
        }
        link.setFromPort(null);
        link.setToPort(null);
        if (this.indexOfPrimitive((PFDPrimitive)((PFDLink)link)) == -1) {
            return;
        }
        this.removePrimitive((PFDPrimitive)((PFDLink)link));
        if (fromNode == null || toNode == null) {
            return;
        }
        if (fromNode.getObject() instanceof IWorkTable && toNode instanceof IDataTransformNode && this.getNode(((IWorkTableNode)fromNode).getTransformNodeId()) != null) {
            ((IDataTransformNode)this.getNode(((IWorkTableNode)fromNode).getTransformNodeId())).updateCollapsedLinks();
        }
        if (toNode.getObject() instanceof IWorkTable && fromNode instanceof IDataTransformNode) {
            ((IDataTransformNode)fromNode).updateCollapsedLinks();
        }
    }

    protected IDiagramNode removeNode(String id) {
        IDiagramNode node = this.getNode(id);
        if (node != null) {
            this.m_mapNodes.remove(id);
            this.removeObjectShape(node.getObject(), node);
            this.putDeletedNode(node.getObject(), node);
            if (node instanceof IWorkTableNode) {
                IDataTransformNode transNode = (IDataTransformNode)this.getNode(((IWorkTableNode)node).getTransformNodeId());
                if (transNode != null) {
                    transNode.removeWorkTable((PFDCompositeNode)node);
                    if (transNode.getNumWorkTables() == 0) {
                        transNode.setForceShowPorts(!this.m_bCollapse);
                        transNode.setCollapsed(this.m_bCollapse);
                    }
                }
            } else {
                if (node instanceof IDataNode) {
                    this.removeDataNodeUIFromJob((IDataNode)node);
                }
                this.removePrimitive((PFDPrimitive)((PFDAbstractNode)node));
            }
        }
        return node;
    }

    protected IDiagramStickyNote removeStickyNote(String id) {
        IDiagramStickyNote note = this.getStickyNote(id);
        if (note != null) {
            this.m_mapStickyNotes.remove(id);
            this.putDeletedStickyNote(note);
            this.removePrimitive((PFDPrimitive)note);
        }
        return note;
    }

    protected boolean dropTransform(Point pt, TransformInterface obj) {
        String sClass = obj.getTransformClass();
        this.m_dropPt = pt;
        DesignTimeJobModel jobModel = this.getJobModel();
        if (jobModel != null) {
            jobModel.startCompoundUndoable();
            ITransform transform = jobModel.getObjectFactory().createNewTransform(sClass, jobModel.getJob().getID());
            this.getJobModel().getJob().getTransformsList().add(transform);
            try {
                transform.addDefaultSettings();
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                return false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                return false;
            }
            if (this.getNodes((IObject)transform) != null) {
                ITransformNode node = (ITransformNode)this.getNodes((IObject)transform).get(0);
                if (node.isAutomaticAddToControlFlow()) {
                    this.getJobModel().getJob().getControlOrderedTransformsList().add(transform);
                }
                if (node.getNumInputPorts() > 1 && node.getInputPort(0) != null && node.getInputPort(0) instanceof IControlPort) {
                    node.getInputPort(0).setVisible(this.isControlOrderVisible());
                }
                if (node.getNumOutputPorts() > 1 && node.getOutputPort(0) != null && node.getOutputPort(0) instanceof IControlPort) {
                    node.getOutputPort(0).setVisible(this.isControlOrderVisible());
                }
            }
            jobModel.endCompoundUndoable();
            this.m_dropPt = null;
            return true;
        }
        this.m_dropPt = null;
        return false;
    }

    private PFDLink createLink(IObject objFrom, IObject objTo) {
        return this.createLink(objFrom, objTo, -1, -1);
    }

    private PFDLink createLink(IObject objFrom, IObject objTo, int fromPortIndex, int toPortIndex) {
        ArrayList lToNodes;
        ArrayList lFromNodes;
        IDiagramNode fromNode = null;
        IDiagramNode toNode = null;
        if (objFrom instanceof IDataObject && !(objFrom instanceof IWorkTable)) {
            fromNode = this.getNode(((IDataObject)objFrom).getChangedNodeId());
        }
        if (fromNode == null && (lFromNodes = (ArrayList)this.getNodes(objFrom)) != null && lFromNodes.size() > 0) {
            fromNode = (IDiagramNode)lFromNodes.get(0);
        }
        if (objTo instanceof IDataObject && !(objTo instanceof IWorkTable)) {
            toNode = this.getNode(((IDataObject)objTo).getChangedNodeId());
        }
        if (toNode == null && (lToNodes = (ArrayList)this.getNodes(objTo)) != null && lToNodes.size() > 0) {
            toNode = (IDiagramNode)lToNodes.get(0);
        }
        if (fromNode != null && toNode != null) {
            return this.createLink(fromNode, toNode, fromPortIndex, toPortIndex);
        }
        return null;
    }

    protected PFDLink createControlLinkFromExcecutionOrder(IDiagramNode nodeFrom, int portFrom, IDiagramNode nodeTo, int portTo) {
        if (nodeFrom == null || nodeTo == null) {
            return null;
        }
        PFDPort portOutputFrom = nodeFrom.getOutputPort(portTo);
        PFDPort portInputTo = nodeTo.getInputPort(portFrom);
        if (portOutputFrom == null || portInputTo == null) {
            return null;
        }
        ControlLink link = null;
        link = new ControlLink(portOutputFrom, portInputTo, false);
        if (nodeFrom.getNumOutputPorts() != 1 && nodeTo.getNumInputPorts() != 1) {
            link.setVisible(this.m_bControlOrderVisible);
            link.setLayoutAffected(false);
        }
        ((IDiagramLink)link).setFromNodePortIndex(nodeFrom.getOutputPortIndex(portOutputFrom));
        ((IDiagramLink)link).setToNodePortIndex(nodeTo.getInputPortIndex(portInputTo));
        this.addLink(link);
        if (nodeFrom.getObject() instanceof IWorkTable && nodeTo instanceof IDataTransformNode && this.getNode(((IWorkTableNode)nodeFrom).getTransformNodeId()) != null) {
            ((IDataTransformNode)this.getNode(((IWorkTableNode)nodeFrom).getTransformNodeId())).updateCollapsedLinks();
        }
        if (nodeTo.getObject() instanceof IWorkTable && nodeFrom instanceof IDataTransformNode) {
            link.setDraggable(false);
            link.setSelectable(false);
            ((IDataTransformNode)nodeFrom).updateCollapsedLinks();
        }
        return link;
    }

    protected PFDLink createLink(IDiagramNode nodeFrom, IDiagramNode nodeTo) {
        return this.createLink(nodeFrom, nodeTo, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PFDLink createLink(IDiagramNode nodeFrom, IDiagramNode nodeTo, int fromPortIndex, int toPortIndex) {
        PFDPort portOutputFrom = null;
        portOutputFrom = fromPortIndex == -1 ? nodeFrom.getOutputPort(nodeTo.getObject()) : nodeFrom.getOutputPort(fromPortIndex);
        PFDPort portInputTo = null;
        portInputTo = toPortIndex == -1 ? nodeTo.getInputPort(nodeFrom.getObject()) : nodeTo.getInputPort(toPortIndex);
        if (portOutputFrom == null || portInputTo == null) {
            return null;
        }
        if (portOutputFrom.getNumLinks() >= portOutputFrom.getMaxNumLinks()) {
            return null;
        }
        if (portInputTo.getNumLinks() >= portInputTo.getMaxNumLinks()) {
            return null;
        }
        BaseLink link = null;
        IDiagramLink oldLink = this.getDeletedLink(nodeFrom, nodeTo, nodeFrom.getOutputPortIndex(portOutputFrom), nodeTo.getInputPortIndex(portInputTo));
        if (oldLink != null) {
            oldLink.setLinkSupportedValidation(false);
            try {
                String sfromNode = oldLink.getFromNodeId();
                IDiagramNode fromNode = this.getNode(sfromNode);
                PFDPort fromPort = fromNode.getOutputPort(oldLink.getFromNodePortIndex());
                this.addLink((PFDLink)oldLink);
                oldLink.setFromPort(fromPort);
                IDiagramNode toNode = this.getNode(oldLink.getToNodeId());
                PFDPort toPort = toNode.getInputPort(oldLink.getToNodePortIndex());
                oldLink.setToPort(toPort);
                this.removeDeletedLink(fromNode, oldLink);
                this.removeDeletedLink(toNode, oldLink);
                if (fromNode.getObject() instanceof IWorkTable && toNode instanceof IDataTransformNode && this.getNode(((IWorkTableNode)fromNode).getTransformNodeId()) != null) {
                    ((IDataTransformNode)this.getNode(((IWorkTableNode)fromNode).getTransformNodeId())).updateCollapsedLinks();
                }
                if (toNode.getObject() instanceof IWorkTable && fromNode instanceof IDataTransformNode) {
                    ((IDataTransformNode)fromNode).updateCollapsedLinks();
                }
            }
            finally {
                oldLink.setLinkSupportedValidation(true);
            }
            return (PFDLink)oldLink;
        }
        if (portOutputFrom.isControl() && portInputTo.isControl()) {
            link = new ControlLink(portOutputFrom, portInputTo, false);
            if (((IDiagramNode)((ControlLink)link).getFromNode()).getNumInputPorts() != 1 || ((IDiagramNode)((ControlLink)link).getToNode()).getNumOutputPorts() == 1) {
                link.setVisible(this.m_bControlOrderVisible);
                link.setLayoutAffected(false);
            }
        } else {
            link = new DataLink(portOutputFrom, portInputTo, false);
        }
        if (((IDiagramLink)link).getToNodeId() == null || ((IDiagramLink)link).getFromNodeId() == null) {
            return null;
        }
        ((IDiagramLink)link).setFromNodePortIndex(nodeFrom.getOutputPortIndex(portOutputFrom));
        ((IDiagramLink)link).setToNodePortIndex(nodeTo.getInputPortIndex(portInputTo));
        this.addLink(link);
        if (nodeFrom.getObject() instanceof IWorkTable && nodeTo instanceof IDataTransformNode && this.getNode(((IWorkTableNode)nodeFrom).getTransformNodeId()) != null) {
            ((IDataTransformNode)this.getNode(((IWorkTableNode)nodeFrom).getTransformNodeId())).updateCollapsedLinks();
        }
        if (nodeTo.getObject() instanceof IWorkTable && nodeFrom instanceof IDataTransformNode) {
            link.setDraggable(false);
            link.setSelectable(false);
            ((IDataTransformNode)nodeFrom).updateCollapsedLinks();
        }
        return link;
    }

    public void createLinksNotExistingInXML() {
        ITransform[] aTransforms = this.m_mdlJob.getJob().getTransforms();
        for (int iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
            ITransform transform = aTransforms[iTransform];
            List lNodes = this.getNodes((IObject)transform);
            if (lNodes == null) continue;
            for (int iNode = 0; iNode < lNodes.size(); ++iNode) {
                IDiagramNode node = (IDiagramNode)lNodes.get(iNode);
                if (node instanceof ITransformNode && this.m_mdlJob.getJob().getControlOrderedTransformsList().indexOf(transform) != -1 && (node.getInputPort(0).getLink(0) == null || node.getOutputPort(0).getLink(0) == null)) {
                    this.addToExecutionOrder(this.m_mdlJob.getJob(), (IObject)transform);
                }
                if (!(transform instanceof IDataTransform)) continue;
                IDataTransform transformData = (IDataTransform)aTransforms[iTransform];
                IDataObject[] aSources = transformData.getDataSources();
                for (int iSource = 0; iSource < aSources.length; ++iSource) {
                    IDataObject source = aSources[iSource];
                    List lSourceNodes = this.getNodes((IObject)source);
                    IDiagramNode sourceNode = null;
                    if (lSourceNodes == null) {
                        sourceNode = this.addNode((IObject)source);
                    } else {
                        for (int iSourceNode = 0; iSourceNode < lSourceNodes.size(); ++iSourceNode) {
                            boolean bAlreadyFoundNode = false;
                            sourceNode = (IDiagramNode)lSourceNodes.get(iSourceNode);
                            if (lSourceNodes.size() == 1) break;
                            int[] portIndexes = ((IDataTransformNode)node).getInputPortIndexes((IObject)source);
                            for (int iIndex = 0; iIndex < portIndexes.length; ++iIndex) {
                                IDiagramLink link = this.getLink(sourceNode.getId(), node.getId(), -1, portIndexes[iIndex]);
                                if (link == null || portIndexes.length != 1) continue;
                                bAlreadyFoundNode = true;
                                break;
                            }
                            if (bAlreadyFoundNode) break;
                        }
                    }
                    int[] portIndexes = ((IDataTransformNode)node).getInputPortIndexes((IObject)source);
                    for (int iIndex = 0; iIndex < portIndexes.length; ++iIndex) {
                        IDiagramLink link = this.getLink(sourceNode.getId(), node.getId(), -1, portIndexes[iIndex]);
                        if (link != null) continue;
                        this.createLink(sourceNode, node, -1, portIndexes[iIndex]);
                    }
                }
                IDataObject[] aTargets = transformData.getDataTargets();
                for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                    IDataObject target = aTargets[iTarget];
                    List lTargetNodes = this.getNodes((IObject)target);
                    IDiagramNode targetNode = null;
                    if (lTargetNodes == null) {
                        targetNode = this.addNode((IObject)target);
                        continue;
                    }
                    PFDLink newLink = null;
                    block7: for (int iTargetNode = 0; iTargetNode < lTargetNodes.size(); ++iTargetNode) {
                        targetNode = (IDiagramNode)lTargetNodes.get(iTargetNode);
                        if (!(target instanceof IWorkTable) && !targetNode.getId().equals(target.getChangedNodeId()) && iTargetNode + 1 < lTargetNodes.size()) continue;
                        int[] portIndexes = ((IDataTransformNode)node).getOutputPortIndexes((IObject)target);
                        for (int iIndex = 0; iIndex < portIndexes.length; ++iIndex) {
                            IDiagramLink link = this.getLink(node.getId(), targetNode.getId(), portIndexes[iIndex], -1);
                            if (link == null && !(targetNode instanceof IWorkTableNode)) {
                                if (this.getLink(node.getObject(), targetNode.getObject()) != null) continue;
                                newLink = this.createLink(node, targetNode, portIndexes[iIndex], -1);
                                if (newLink != null) continue block7;
                                if (newLink == null && iTargetNode + 1 < lTargetNodes.size() || newLink != null || iTargetNode + 1 != lTargetNodes.size() || !this.isCleanUpRequired()) continue;
                                targetNode = this.addNode(targetNode.getObject());
                                newLink = this.createLink(node, targetNode, portIndexes[iIndex], -1);
                                continue;
                            }
                            if (link == null && (newLink = this.createLink(node, targetNode, portIndexes[iIndex], -1)) != null) continue block7;
                        }
                    }
                }
            }
        }
    }

    protected String createDiagramXML() {
        DesignTimeJobModel jobModel = this.getJobModel();
        if (jobModel != null) {
            ArrayList<Object> lShapes = new ArrayList<Object>();
            lShapes.addAll(this.m_mapLinks.values());
            lShapes.addAll(this.m_mapStickyNotes.values());
            return DiagramUtil.getXMLForObjects(lShapes, (IDesignTimeModel)jobModel);
        }
        return null;
    }

    protected boolean save() {
        String flowDirection = this.getFlowDirection();
        DesignTimeJobModel jobModel = this.getJobModel();
        if (jobModel != null) {
            jobModel.getJob().setUserProperty("FlowDirection", flowDirection);
            String sXML = this.createDiagramXML();
            if (sXML != null) {
                jobModel.getJob().setUserProperty("DiagramXML", sXML.toString());
                try {
                    jobModel.saveToOMR(Workspace.getMdFactory());
                    return true;
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Writing");
                    return false;
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                    return false;
                }
            }
        }
        return false;
    }

    private void refreshNodes(IObject obj) {
        this.refreshNodes(obj, null);
    }

    private void refreshNodes(IObject obj, ModelEvent ev) {
        ArrayList nodes = (ArrayList)this.getNodes(obj);
        if (nodes != null) {
            for (int iNode = 0; iNode < nodes.size(); ++iNode) {
                IDiagramNode node = (IDiagramNode)nodes.get(iNode);
                if (ev == null) {
                    node.refresh();
                    continue;
                }
                if (!(obj instanceof IDataTransform)) continue;
                ((IDataTransformNode)node).refresh(ev);
            }
        }
    }

    private void refreshAllNodes() {
        for (IDiagramNode node : this.m_mapNodes.values()) {
            node.refresh();
        }
    }

    private void clearDeletedLists() {
        this.m_mapDeletedNodes.clear();
        this.m_mapDeletedLinks.clear();
        this.m_mapDeletedStickyNotes.clear();
    }

    private void clearLists() {
        this.m_mapObjectShapes.clear();
        this.m_mapNodes.clear();
        this.m_mapLinks.clear();
    }

    private void refreshRemove() {
        for (int i = 0; i < this.getNumPrimitives(); ++i) {
            PFDPrimitive prim = this.getPrimitive(i);
            if (prim instanceof IDiagramStickyNote) continue;
            this.removePrimitive(prim);
        }
        this.clearKeyedNodes();
    }

    protected boolean refresh() {
        String flow;
        this.setIgnoreEvents(true);
        this.removeAllPrimitives();
        this.clearLists();
        this.setIgnoreEvents(false);
        DesignTimeJobModel jobModel = this.getJobModel();
        if (jobModel != null && (flow = jobModel.getJob().getUserProperty("FlowDirection")) != null && this.getDiagramXML() == null) {
            super.setFlowDirection(flow);
            this.fireModelChange(1001, flow, null);
        }
        boolean bLayout = this.addNodes();
        this.addLinks();
        this.updateStickyNotesFromXML();
        this.addStickyNotesFromXML();
        return bLayout;
    }

    protected List getNodes(IObject obj) {
        return (ArrayList)this.getObjectShapes(obj, DIAGRAM_NODES);
    }

    protected IDiagramNode getNode(String id) {
        return (IDiagramNode)this.m_mapNodes.get(id);
    }

    protected void putStickyNote(IDiagramStickyNote note) {
        this.m_mapStickyNotes.put(note.getId(), note);
    }

    protected void putNode(IObject obj, IDiagramNode node) {
        this.putObjectShape(obj, node);
        this.m_mapNodes.put(node.getId(), node);
    }

    protected void setIgnoreDeletedNodes(boolean bIgnoreDeletedNodes) {
        this.m_bIgnoreDeletedNodes = bIgnoreDeletedNodes;
    }

    protected boolean getIgnoreDeletedNodes() {
        return this.m_bIgnoreDeletedNodes;
    }

    protected void setFirstOpen(boolean bFirstOpen) {
        this.m_bFirstOpen = bFirstOpen;
    }

    protected boolean getFirstOpen() {
        return this.m_bFirstOpen;
    }

    public void setIgnoreEvents(boolean bIgnoreEvents) {
        this.m_bIgnoreEvents = bIgnoreEvents;
    }

    public boolean getIgnoreEvents() {
        return this.m_bIgnoreEvents;
    }

    private void setDiagramXML(String sDiagramXML) {
        this.m_sDiagramXML = sDiagramXML;
    }

    private String getDiagramXML() {
        return this.m_sDiagramXML;
    }

    protected List getDeletedNodes(IObject obj) {
        if (obj == null) {
            return null;
        }
        return (ArrayList)this.m_mapDeletedNodes.get(obj.getID());
    }

    protected IDiagramStickyNote getDeletedStickyNote(String sId) {
        if (sId == null) {
            return null;
        }
        return (IDiagramStickyNote)this.m_mapDeletedNodes.get(sId);
    }

    protected void removeDeletedNode(IObject obj, IDiagramNode node) {
        if (obj == null || node == null) {
            return;
        }
        ArrayList nodes = (ArrayList)this.m_mapDeletedNodes.get(obj.getID());
        if (nodes == null || nodes.indexOf(node) == -1) {
            return;
        }
        nodes.remove(nodes.indexOf(node));
        if (nodes.isEmpty()) {
            this.m_mapDeletedNodes.remove(obj.getID());
        } else {
            this.m_mapDeletedNodes.put(obj.getID(), nodes);
        }
    }

    protected void putDeletedNode(IObject obj, IDiagramNode node) {
        if (obj == null || node == null) {
            return;
        }
        ArrayList<IDiagramNode> deletedNodes = (ArrayList<IDiagramNode>)this.m_mapDeletedNodes.get(obj.getID());
        if (deletedNodes == null) {
            deletedNodes = new ArrayList<IDiagramNode>();
        } else {
            this.m_mapDeletedNodes.remove(obj.getID());
        }
        if (deletedNodes.indexOf(node) == -1) {
            deletedNodes.add(node);
        }
        this.m_mapDeletedNodes.put(obj.getID(), deletedNodes);
    }

    public boolean containsInDeletedNodes(String objId) {
        return this.m_mapDeletedNodes.containsKey(objId);
    }

    protected void putDeletedStickyNote(IDiagramStickyNote note) {
        if (note == null) {
            return;
        }
        if (!this.containsInDeletedStickyNotes(note.getId())) {
            this.m_mapDeletedStickyNotes.put(note.getId(), note);
        }
    }

    public boolean containsInDeletedStickyNotes(String Id) {
        return this.m_mapDeletedStickyNotes.containsKey(Id);
    }

    protected IDiagramNode getLastNodeAdded() {
        return this.m_lastNodeAdded;
    }

    protected List getObjectShapes(IObject obj, String type) {
        if (obj == null) {
            return null;
        }
        ArrayList shapes = (ArrayList)this.m_mapObjectShapes.get(obj);
        if (shapes != null) {
            ArrayList<IDiagramPersistable> nodes = new ArrayList<IDiagramPersistable>();
            ArrayList<IDiagramPersistable> links = new ArrayList<IDiagramPersistable>();
            if (shapes != null) {
                for (int iShape = 0; iShape < shapes.size(); ++iShape) {
                    IDiagramPersistable shape = (IDiagramPersistable)shapes.get(iShape);
                    if (shape instanceof IDiagramNode) {
                        nodes.add(shape);
                    }
                    if (!(shape instanceof IDiagramLink)) continue;
                    links.add(shape);
                }
            }
            if (type.equals(DIAGRAM_NODES)) {
                return nodes;
            }
            if (type.equals(DIAGRAM_LINKS)) {
                return links;
            }
            return (ArrayList)this.m_mapObjectShapes.values();
        }
        return null;
    }

    protected void removeObjectShape(IObject obj, IDiagramPersistable shape) {
        if (obj == null || shape == null) {
            return;
        }
        ArrayList shapes = (ArrayList)this.m_mapObjectShapes.get(obj);
        if (shapes == null || shapes.indexOf(shape) == -1) {
            return;
        }
        shapes.remove(shapes.indexOf(shape));
        if (shapes.isEmpty()) {
            this.m_mapObjectShapes.remove(obj);
        } else {
            this.m_mapObjectShapes.put(obj, shapes);
        }
    }

    protected void putObjectShape(IObject obj, IDiagramPersistable shape) {
        if (obj == null || shape == null) {
            return;
        }
        ArrayList<IDiagramPersistable> shapes = (ArrayList<IDiagramPersistable>)this.m_mapObjectShapes.get(obj);
        if (shapes == null) {
            shapes = new ArrayList<IDiagramPersistable>();
        } else {
            this.m_mapObjectShapes.remove(obj);
        }
        if (shapes.indexOf(shape) == -1) {
            shapes.add(shape);
        }
        this.m_mapObjectShapes.put(obj, shapes);
        if (obj instanceof JobTransformModel) {
            this.m_mapObjectShapes.put(((JobTransformModel)obj).getInnerJob(), shapes);
        }
    }

    public boolean containsInObjectShapes(IObject obj) {
        return this.m_mapObjectShapes.containsKey(obj);
    }

    protected IDiagramLink getDeletedLink(IDiagramNode fromNode, IDiagramNode toNode, int fromPortIndex, int toPortIndex) {
        ArrayList links = (ArrayList)this.m_mapDeletedLinks.get(fromNode.getId());
        if (links == null) {
            return null;
        }
        for (int iLink = 0; iLink < links.size(); ++iLink) {
            IDiagramLink link = (IDiagramLink)links.get(iLink);
            if (!link.getToNodeId().equals(toNode.getId())) continue;
            if (toPortIndex != -1 && fromPortIndex != -1) {
                if (link.getToNodePortIndex() != toPortIndex || fromPortIndex == -1 || link.getFromNodePortIndex() != fromPortIndex) continue;
                return link;
            }
            return link;
        }
        return null;
    }

    protected IDiagramLink getDeletedLink(IDiagramNode fromNode, IDiagramNode toNode) {
        return this.getDeletedLink(fromNode, toNode, -1, -1);
    }

    protected List getDeletedLinks(IDiagramNode node) {
        ArrayList links = (ArrayList)this.m_mapDeletedLinks.get(node.getId());
        return links;
    }

    protected void putDeletedLink(IDiagramNode node, IDiagramLink link) {
        if (node == null || link == null) {
            return;
        }
        ArrayList<IDiagramLink> links = (ArrayList<IDiagramLink>)this.m_mapDeletedLinks.get(node.getId());
        if (links == null) {
            links = new ArrayList<IDiagramLink>();
        } else {
            this.m_mapDeletedLinks.remove(node.getId());
        }
        if (links.indexOf(link) == -1) {
            links.add(link);
        }
        this.m_mapDeletedLinks.put(node.getId(), links);
    }

    public boolean containsInDeletedLinks(String nodeId) {
        return this.m_mapDeletedLinks.containsKey(nodeId);
    }

    protected void refreshExecutionOrder() {
        IJob job;
        List transforms;
        if (this.getJobModel() != null && this.getJobModel().getJob() != null && (transforms = (job = this.getJobModel().getJob()).getControlOrderedTransformsList()) != null) {
            for (int iTransform = 0; iTransform < transforms.size(); ++iTransform) {
                ITransform transform = (ITransform)transforms.get(iTransform);
                List nodes = this.getNodes((IObject)transform);
                IDiagramNode node = null;
                if (nodes != null) {
                    node = (IDiagramNode)nodes.get(0);
                }
                if (node == null) continue;
                node.setNodeOrderVisible(true);
                node.setNodeOrder(iTransform + 1);
            }
        }
    }

    protected void addToExecutionOrder(IJob job, IObject obj) {
        List transformNodesBefore;
        List transforms = job.getControlOrderedTransformsList();
        List transformNodes = this.getNodes(obj);
        IDiagramNode transformNode = null;
        if (transformNodes != null) {
            transformNode = (IDiagramNode)transformNodes.get(0);
        }
        int iTransformIndex = transforms.indexOf(obj);
        transformNode.setNodeOrderVisible(true);
        transformNode.setNodeOrder(iTransformIndex + 1);
        if (transforms.size() == 1) {
            return;
        }
        ITransform oTransformBefore = null;
        IDiagramPersistable transformNodeBefore = null;
        if (iTransformIndex > 0 && (transformNodesBefore = this.getNodes((IObject)(oTransformBefore = (ITransform)transforms.get(iTransformIndex - 1)))) != null) {
            transformNodeBefore = (IDiagramNode)transformNodesBefore.get(0);
        }
        IDiagramNode transformNodeAfter = null;
        if (transforms.size() > iTransformIndex + 1) {
            ITransform oTransformAfter = (ITransform)transforms.get(iTransformIndex + 1);
            List transformNodesAfter = this.getNodes((IObject)oTransformAfter);
            if (transformNodesAfter != null) {
                transformNodeAfter = (IDiagramNode)transformNodesAfter.get(0);
            }
            if (transformNodeBefore != null && transformNodeAfter != null) {
                this.removeLink(this.getLink(transformNodeBefore.getId(), transformNodeAfter.getId()));
            }
            if (this.getLink(transformNode.getId(), transformNodeAfter.getId()) == null) {
                this.createControlLinkFromExcecutionOrder(transformNode, 0, transformNodeAfter, 0);
            }
        }
        if (transformNodeBefore != null && this.getLink(transformNodeBefore.getId(), transformNode.getId()) == null) {
            this.createControlLinkFromExcecutionOrder((IDiagramNode)transformNodeBefore, 0, transformNode, 0);
        }
        this.refreshExecutionOrder();
    }

    public List getNodesAfter(IDiagramNode node) {
        Object nodeAfter = null;
        IDiagramLink afterLink = null;
        ArrayList<IDiagramNode> afterNodes = new ArrayList<IDiagramNode>();
        PFDPort outputPort = node.getOutputPort(0);
        Vector links = outputPort.getFromLinks();
        if (links != null && links.size() >= 1) {
            for (int iLink = 0; iLink < links.size(); ++iLink) {
                afterLink = (IDiagramLink)links.get(iLink);
                if (afterLink == null) continue;
                afterNodes.add((IDiagramNode)afterLink.getToNode());
            }
        }
        return afterNodes;
    }

    public List getNodesAfter(IObject obj) {
        List nodes = this.getNodes(obj);
        IDiagramNode node = null;
        if (nodes != null) {
            node = (IDiagramNode)nodes.get(0);
        }
        return this.getNodesAfter(node);
    }

    public List getNodesBefore(IDiagramNode node) {
        Object nodeBefore = null;
        IDiagramLink beforeLink = null;
        ArrayList<IDiagramNode> beforeNodes = new ArrayList<IDiagramNode>();
        PFDPort inputPort = node.getInputPort(0);
        Vector links = inputPort.getToLinks();
        if (links != null && links.size() >= 1) {
            for (int iLink = 0; iLink < links.size(); ++iLink) {
                beforeLink = (IDiagramLink)links.get(iLink);
                if (beforeLink == null) continue;
                beforeNodes.add((IDiagramNode)beforeLink.getFromNode());
            }
        }
        return beforeNodes;
    }

    public List getNodesBefore(IObject obj) {
        List nodes = this.getNodes(obj);
        IDiagramNode node = null;
        if (nodes != null) {
            node = (IDiagramNode)nodes.get(0);
        }
        return this.getNodesBefore(node);
    }

    protected void removeFromExecutionOrder(IJob job, IObject obj) {
        List transforms = job.getControlOrderedTransformsList();
        List transformNodes = this.getNodes(obj);
        IDiagramNode transformNode = null;
        if (transformNodes != null) {
            transformNode = (IDiagramNode)transformNodes.get(0);
        }
        transformNode.setNodeOrderVisible(false);
        transformNode.setNodeOrder(0);
        IDiagramNode transformNodeBefore = null;
        IDiagramLink beforeLink = null;
        PFDPort inputPort = transformNode.getInputPort(0);
        Vector links = inputPort.getToLinks();
        if (links != null && links.size() >= 1) {
            beforeLink = (IDiagramLink)links.get(0);
        }
        if (beforeLink != null) {
            transformNodeBefore = (IDiagramNode)beforeLink.getFromNode();
        }
        IDiagramNode transformNodeAfter = null;
        PFDPort outputPort = transformNode.getOutputPort(0);
        Vector afterLinks = outputPort.getFromLinks();
        IDiagramLink afterLink = null;
        if (afterLinks != null && afterLinks.size() >= 1) {
            afterLink = (IDiagramLink)afterLinks.get(0);
        }
        if (afterLink != null) {
            transformNodeAfter = (IDiagramNode)afterLink.getToNode();
        }
        if (beforeLink != null) {
            this.removeLink(beforeLink);
        }
        if (afterLink != null) {
            this.removeLink(afterLink);
        }
        if (transformNodeBefore != null && transformNodeAfter != null) {
            this.createControlLinkFromExcecutionOrder(transformNodeBefore, 0, transformNodeAfter, 0);
        }
        this.refreshExecutionOrder();
    }

    protected void removeDeletedLink(IDiagramNode node, IDiagramLink link) {
        if (node == null || link == null) {
            return;
        }
        ArrayList links = (ArrayList)this.m_mapDeletedLinks.get(node.getId());
        if (links == null || links.indexOf(link) == -1) {
            return;
        }
        links.remove(links.indexOf(link));
        if (links.isEmpty()) {
            this.m_mapDeletedLinks.remove(node.getId());
        } else {
            this.m_mapDeletedLinks.put(node.getId(), links);
        }
    }

    protected List getLinks(IObject obj) {
        return (ArrayList)this.getObjectShapes(obj, DIAGRAM_LINKS);
    }

    private IDiagramLink getLink(IObject fromObj, IObject toObj) {
        return this.getLink(fromObj, toObj, -1, -1);
    }

    private IDiagramLink getLink(IObject fromObj, IObject toObj, int fromPortIndex, int toPortIndex) {
        ArrayList fromLinks = (ArrayList)this.getLinks(fromObj);
        if (fromLinks != null) {
            for (int iFromLink = 0; iFromLink < fromLinks.size(); ++iFromLink) {
                IDiagramLink fromLink = (IDiagramLink)fromLinks.get(iFromLink);
                ArrayList toLinks = (ArrayList)this.getLinks(toObj);
                if (fromLink == null || toLinks == null) continue;
                for (int iToLink = 0; iToLink < toLinks.size(); ++iToLink) {
                    IDiagramLink toLink = (IDiagramLink)toLinks.get(iToLink);
                    IDiagramNode fromNode = this.getNode(fromLink.getFromNodeId());
                    IDiagramNode toNode = this.getNode(toLink.getToNodeId());
                    if (toLink == null || fromNode == null || !fromLink.getId().equals(toLink.getId()) || !fromNode.getObject().equals((Object)fromObj) || fromPortIndex != -1 && fromLink.getFromNodePortIndex() != fromPortIndex || toPortIndex != -1 && fromLink.getToNodePortIndex() != toPortIndex) continue;
                    return fromLink;
                }
            }
        }
        return null;
    }

    protected IDiagramStickyNote getStickyNote(String id) {
        return this.m_mapStickyNotes.get(id);
    }

    public IDiagramLink getLink(String fromId, String toId) {
        return this.getLink(fromId, toId, -1, -1);
    }

    public IDiagramLink getLink(String fromId, String toId, int fromPortIndex, int toPortIndex) {
        IDiagramNode node = this.getNode(fromId);
        ArrayList lLinks = (ArrayList)this.getLinks(node.getObject());
        for (int iLink = 0; iLink < lLinks.size(); ++iLink) {
            IDiagramLink link = (IDiagramLink)lLinks.get(iLink);
            if (!link.getFromNodeId().equals(fromId) || !link.getToNodeId().endsWith(toId) || fromPortIndex != -1 && link.getFromNodePortIndex() != fromPortIndex || toPortIndex != -1 && link.getToNodePortIndex() != toPortIndex) continue;
            return link;
        }
        return null;
    }

    protected IDiagramLink getLink(String id) {
        return (IDiagramLink)this.m_mapLinks.get(id);
    }

    protected void putLink(IDiagramLink link) {
        if (this.getLink(link.getId()) == null) {
            IDiagramNode nodeFrom = this.getNode(link.getFromNodeId());
            if (nodeFrom == null) {
                return;
            }
            this.putObjectShape(nodeFrom.getObject(), link);
            IDiagramNode nodeTo = this.getNode(link.getToNodeId());
            if (nodeTo == null) {
                return;
            }
            this.putObjectShape(nodeTo.getObject(), link);
            this.m_mapLinks.put(link.getId(), link);
        }
    }

    public void addLink(PFDLink link) {
        this.putLink((IDiagramLink)link);
        super.addLink(link);
    }

    public void addStickyNote(IDiagramStickyNote note) {
        this.addStickyNote(note, null);
    }

    protected void addStickyNote(IDiagramStickyNote note, Point p) {
        if (this.m_mapStickyNotes.containsKey(note.getId())) {
            return;
        }
        if (!this.m_inLoad) {
            this.getJobModel().undoableEditHappened((UndoableEdit)new AddStickyNoteUndoable(note));
        }
        this.putStickyNote(note);
        super.addPrimitive((PFDPrimitive)note);
        if (p != null) {
            note.setLocation(p.x, p.y);
        }
    }

    protected void removeStickyNote(IDiagramStickyNote note) {
        if (!this.m_mapStickyNotes.containsKey(note.getId())) {
            return;
        }
        if (!this.m_inLoad) {
            this.getJobModel().undoableEditHappened((UndoableEdit)new RemoveStickyNoteUndoable(note));
        }
        this.removeStickyNote(note.getId());
    }

    public DesignTimeJobModel getJobModel() {
        return this.m_mdlJob;
    }

    @Override
    public IModel getObjectModel() {
        return this.m_mdlJob;
    }

    public void setJobModel(DesignTimeJobModel mdlJob) {
        if (this.m_mdlJob != null) {
            this.m_mdlJob.removeModelListener(this.m_lsnrJobModel);
            ((WsUndoManager)this.m_mdlJob.getUndoManager()).removeChangeListener(this.m_lsnrUndo);
        }
        this.m_mdlJob = mdlJob;
        if (this.m_mdlJob != null) {
            this.refresh();
            this.m_mdlJob.addModelListener(this.m_lsnrJobModel);
            ((WsUndoManager)this.m_mdlJob.getUndoManager()).addChangeListener(this.m_lsnrUndo);
        }
    }

    protected boolean getResetModeOnEdit() {
        return this.m_bResetModeOnEdit;
    }

    protected void setResetModeOnEdit(boolean bResetMode) {
        if (this.m_bResetModeOnEdit == bResetMode) {
            return;
        }
        this.m_bResetModeOnEdit = bResetMode;
    }

    public void setCollapse(boolean bVisible) {
        if (this.m_bCollapse == bVisible) {
            return;
        }
        this.m_bCollapse = bVisible;
        for (int iPrimitive = 0; iPrimitive < this.getNumPrimitives(); ++iPrimitive) {
            PFDPrimitive prim = this.getPrimitive(iPrimitive);
            if (prim instanceof IDiagramNode) {
                ((IDiagramNode)prim).setForceShowPorts(!this.m_bCollapse);
            }
            if (!(prim instanceof ICollapsibleShape)) continue;
            ((ICollapsibleShape)prim).setCollapsed(this.m_bCollapse);
        }
    }

    public void setCleanUpRequired(boolean bCleanUpRequired) {
        this.m_bCleanUpRequired = bCleanUpRequired;
    }

    public boolean isCleanUpRequired() {
        return this.m_bCleanUpRequired;
    }

    public boolean isCollapsed() {
        return this.m_bCollapse;
    }

    public void setDropLocation(Point location) {
        this.m_dropPt = location;
        this.m_iInsertIteration = 0;
    }

    public void setLocation(IShape node, Point oldLocation, Point newLocation) {
        DesignTimeJobModel jobModel = this.getJobModel();
        if (jobModel != null) {
            jobModel.undoableEditHappened((UndoableEdit)new SetLocationUndoable(node, oldLocation, newLocation));
        }
        if (newLocation != null) {
            node.setSpotLocation(1, newLocation);
            if (node instanceof IDiagramNode) {
                Point p = new Point();
                node.getSpotLocation(1, p);
                ((IDiagramNode)node).getUIPlacement().setXPosition(p.x);
                ((IDiagramNode)node).getUIPlacement().setYPosition(p.y);
            }
        }
    }

    public void setLinkLocations(IDiagramLink link, Point[] aOldLocation, Point[] aNewLocation) {
        DesignTimeJobModel jobModel = this.getJobModel();
        if (jobModel != null) {
            jobModel.undoableEditHappened((UndoableEdit)new SetLinkLocationsUndoable(link, aOldLocation, aNewLocation));
        }
        if (aNewLocation == null) {
            return;
        }
        link.removeAllBreakPoints();
        for (int iLocation = 0; iLocation < aNewLocation.length; ++iLocation) {
            link.addBreakPoint(aNewLocation[iLocation]);
        }
    }

    public void setControlOrderVisible(boolean bVisible) {
        if (this.m_bControlOrderVisible == bVisible) {
            return;
        }
        this.m_bControlOrderVisible = bVisible;
        for (int iPrimitive = 0; iPrimitive < this.getNumPrimitives(); ++iPrimitive) {
            PFDPrimitive prim = this.getPrimitive(iPrimitive);
            if (prim instanceof IDataTransformNode) {
                PFDPort port;
                int iPort;
                IDataTransformNode node = (IDataTransformNode)prim;
                if (node.getInputPortGroup().getNumPorts() != 1 || !(node.getInputPort(0) instanceof IControlPort)) {
                    for (iPort = 0; iPort < node.getInputPortGroup().getNumPorts(); ++iPort) {
                        port = node.getInputPort(iPort);
                        if (!(port instanceof ControlPort)) continue;
                        port.setVisible(this.m_bControlOrderVisible);
                    }
                }
                if (node.getOutputPortGroup().getNumPorts() == 1 && node.getOutputPort(0) instanceof IControlPort) continue;
                for (iPort = 0; iPort < node.getOutputPortGroup().getNumPorts(); ++iPort) {
                    port = node.getOutputPort(iPort);
                    if (!(port instanceof ControlPort)) continue;
                    port.setVisible(this.m_bControlOrderVisible);
                }
                continue;
            }
            if (!(prim instanceof ControlLink) || ((IDiagramNode)((ControlLink)prim).getFromNode()).getNumOutputPorts() == 1 && ((IDiagramNode)((ControlLink)prim).getFromNode()).getOutputPort(0) instanceof IControlPort || ((IDiagramNode)((ControlLink)prim).getToNode()).getNumInputPorts() == 1 && ((IDiagramNode)((ControlLink)prim).getToNode()).getInputPort(0) instanceof IControlPort) continue;
            prim.setVisible(this.m_bControlOrderVisible);
            ((PFDLink)prim).setLayoutAffected(false);
        }
    }

    public boolean isControlOrderVisible() {
        return this.m_bControlOrderVisible;
    }

    private boolean addNodes() {
        this.addNodesFromXML();
        this.addDataNodesFromJob();
        this.createNodesNotExistingInXML();
        this.refreshExecutionOrder();
        return this.m_bNoLocation;
    }

    private boolean removeDataNodeUIFromJob(IDataNode node) {
        boolean bRemoved = false;
        Map placements = this.m_mdlJob.getJob().getDataObjectsPlacement();
        IDataObjectPlacements places = (IDataObjectPlacements)placements.get((IDataObject)node.getObject());
        if (places == null || places.getUIPlacements() == null) {
            return false;
        }
        for (int iNode = 0; iNode < places.getUIPlacements().size(); ++iNode) {
            IUIPlacement UIPlace = (IUIPlacement)places.getUIPlacements().get(iNode);
            if (!UIPlace.getNodeId().equals(node.getId())) continue;
            this.m_mdlJob.getJob().removeDataObjectUIPlacement((IDataObject)node.getObject(), UIPlace);
            bRemoved = true;
        }
        return bRemoved;
    }

    private boolean addDataNodesFromJob() {
        boolean bOneAdded = false;
        Map placements = this.m_mdlJob.getJob().getDataObjectsPlacement();
        for (Map.Entry entry : placements.entrySet()) {
            IDataObjectPlacements places = (IDataObjectPlacements)entry.getValue();
            if (places == null) {
                return bOneAdded;
            }
            for (int iNode = 0; iNode < places.getUIPlacements().size(); ++iNode) {
                IUIPlacement UIPlace = (IUIPlacement)places.getUIPlacements().get(iNode);
                IDiagramNode node = this.getNode(UIPlace.getNodeId());
                if (node != null) continue;
                this.addNode((IObject)entry.getKey(), UIPlace);
                bOneAdded = true;
            }
        }
        return bOneAdded;
    }

    private boolean addNodesFromXML() {
        IDiagramNode node;
        int iNode;
        String shapes = this.getDiagramXML();
        if (shapes == null) {
            shapes = this.m_mdlJob.getJob().getUserProperty("DiagramXML");
        }
        if (shapes == null && this.getFirstOpen()) {
            this.m_bNoLocation = true;
        }
        if (shapes != null) {
            this.m_bNoLocation = false;
            try {
                DiagramUtil.getObjectsFromXML(shapes, this.m_lLinks, this.m_lNodes, this.m_lStickyNotes, (IDesignTimeModel)this.getJobModel());
            }
            catch (SAXException se) {
                this.m_lLinks.clear();
                this.m_lNodes.clear();
                this.m_lStickyNotes.clear();
                MessageUtil.displayMessage((String)se.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
            catch (IOException ioe) {
                this.m_lLinks.clear();
                this.m_lNodes.clear();
                this.m_lStickyNotes.clear();
                MessageUtil.displayMessage((String)ioe.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
            catch (ParserConfigurationException pce) {
                this.m_lLinks.clear();
                this.m_lNodes.clear();
                this.m_lStickyNotes.clear();
                MessageUtil.displayMessage((String)pce.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
            catch (DiagramParserException dpe) {
                this.m_lLinks.clear();
                this.m_lNodes.clear();
                this.m_lStickyNotes.clear();
                MessageUtil.displayMessage((String)dpe.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
        }
        HashMap mapTempWorkTables = new HashMap();
        if (this.m_lNodes == null || this.m_lNodes.isEmpty()) {
            return false;
        }
        for (iNode = 0; iNode < this.m_lNodes.size(); ++iNode) {
            node = (IDiagramNode)this.m_lNodes.get(iNode);
            if (!node.isCleanUpRequired()) continue;
            this.setCleanUpRequired(true);
            return false;
        }
        for (iNode = 0; iNode < this.m_lNodes.size(); ++iNode) {
            node = (IDiagramNode)this.m_lNodes.get(iNode);
            if (node instanceof IDataTransformNode) {
                if (node.getNumInputPorts() > 1 && node.getInputPort(0) != null && node.getInputPort(0) instanceof IControlPort) {
                    node.getInputPort(0).setVisible(this.isControlOrderVisible());
                }
                if (node.getNumOutputPorts() > 1 && node.getOutputPort(0) != null && node.getOutputPort(0) instanceof IControlPort) {
                    node.getOutputPort(0).setVisible(this.isControlOrderVisible());
                }
            }
            if (node == null || node.getObject() == null) continue;
            this.putNode(node.getObject(), node);
            if (node instanceof IWorkTableNode) {
                ArrayList<IDiagramNode> workTables = (ArrayList<IDiagramNode>)mapTempWorkTables.get(((IWorkTableNode)node).getTransformNodeId());
                if (workTables == null) {
                    workTables = new ArrayList<IDiagramNode>();
                } else {
                    mapTempWorkTables.remove(((IWorkTableNode)node).getTransformNodeId());
                }
                if (workTables.indexOf(node) == -1) {
                    workTables.add(node);
                }
                mapTempWorkTables.put(((IWorkTableNode)node).getTransformNodeId(), workTables);
                continue;
            }
            this.addPrimitive((PFDPrimitive)((PFDAbstractNode)node));
        }
        for (iNode = 0; iNode < this.m_lNodes.size(); ++iNode) {
            if (!(this.m_lNodes.get(iNode) instanceof IDataTransformNode)) continue;
            node = (IDataTransformNode)this.m_lNodes.get(iNode);
            ArrayList tempWorkTables = (ArrayList)mapTempWorkTables.get(node.getId());
            if (tempWorkTables != null) {
                int iWorkTable;
                IWorkTableNode[] workTables = new IWorkTableNode[((IDataTransform)node.getObject()).getDataTargetsCount()];
                for (int iWorkTable2 = 0; iWorkTable2 < tempWorkTables.size(); ++iWorkTable2) {
                    IWorkTableNode workTable = (IWorkTableNode)tempWorkTables.get(iWorkTable2);
                    int iIndex = ((IDataTransform)node.getObject()).getTargetTableIndex((ITable)workTable.getObject());
                    workTables[iIndex] = workTable;
                }
                ArrayList<IWorkTableNode> aWorkTables = new ArrayList<IWorkTableNode>();
                for (iWorkTable = 0; iWorkTable < workTables.length; ++iWorkTable) {
                    if (workTables[iWorkTable] == null) continue;
                    aWorkTables.add(workTables[iWorkTable]);
                }
                for (iWorkTable = 0; iWorkTable < aWorkTables.size(); ++iWorkTable) {
                    node.addWorkTable(iWorkTable, (PFDCompositeNode)aWorkTables.get(iWorkTable));
                }
            }
            node.setSpotLocation(1, node.getUpperLeftPoint());
        }
        return true;
    }

    private boolean updateStickyNotesFromXML() {
        if (this.m_lStickyNotes == null || this.m_lStickyNotes.isEmpty()) {
            return false;
        }
        for (int iNote = 0; iNote < this.m_lStickyNotes.size(); ++iNote) {
            IDiagramStickyNote note = this.m_lStickyNotes.get(iNote);
            if (note == null) continue;
            if (this.m_mapStickyNotes.containsKey(note.getId()) && this.m_mapStickyNotes.get(note.getId()) != note) {
                this.m_mapStickyNotes.put(note.getId(), note);
            }
            this.addStickyNote(note);
        }
        for (Map.Entry<String, IDiagramStickyNote> e : this.m_mapStickyNotes.entrySet()) {
            if (this.m_lStickyNotes.contains(e.getValue())) continue;
            this.removeStickyNote(e.getValue());
        }
        return true;
    }

    private boolean addStickyNotesFromXML() {
        if (this.m_lStickyNotes == null || this.m_lStickyNotes.isEmpty()) {
            return false;
        }
        for (int iNote = 0; iNote < this.m_lStickyNotes.size(); ++iNote) {
            IDiagramStickyNote note = this.m_lStickyNotes.get(iNote);
            if (note == null) continue;
            this.addPrimitive((PFDPrimitive)note);
        }
        return true;
    }

    private boolean addLinksFromXML() {
        if (this.m_lLinks == null || this.m_lLinks.isEmpty()) {
            return false;
        }
        for (int iLink = 0; iLink < this.m_lLinks.size(); ++iLink) {
            int iIndex;
            int[] portIndexes;
            IDiagramLink link = (IDiagramLink)this.m_lLinks.get(iLink);
            if (link == null) continue;
            IDiagramNode nodeFrom = this.getNode(link.getFromNodeId());
            IDiagramNode nodeTo = this.getNode(link.getToNodeId());
            if (nodeFrom == null || nodeTo == null || nodeTo instanceof IDataTransformNode && !((IDataTransform)nodeTo.getObject()).getDataSourceList().contains(nodeFrom.getObject()) || nodeFrom instanceof IDataTransformNode && !((IDataTransform)nodeFrom.getObject()).getDataTargetList().contains(nodeTo.getObject())) continue;
            PFDPort portOutputFrom = null;
            PFDPort portInputTo = null;
            if (link.getFromNodePortIndex() < nodeFrom.getNumOutputPorts()) {
                portOutputFrom = nodeFrom.getOutputPort(link.getFromNodePortIndex());
            } else {
                if (!nodeFrom.getAdapter().isValidToConnectOutputOnRedraw(nodeTo.getObject())) continue;
                portIndexes = ((IDataTransformNode)nodeFrom).getOutputPortIndexes(nodeTo.getObject());
                for (iIndex = 0; iIndex < portIndexes.length; ++iIndex) {
                    portOutputFrom = nodeFrom.getOutputPort(portIndexes[iIndex]);
                    if (portOutputFrom == null) continue;
                    link.setFromNodePortIndex(portIndexes[iIndex]);
                }
            }
            if (portOutputFrom.getNumLinks() >= portOutputFrom.getMaxNumLinks()) continue;
            if (link.getToNodePortIndex() < nodeTo.getNumInputPorts()) {
                portInputTo = nodeTo.getInputPort(link.getToNodePortIndex());
            } else {
                if (!nodeTo.getAdapter().isValidToConnectInputOnRedraw(nodeFrom.getObject())) continue;
                portIndexes = ((IDataTransformNode)nodeTo).getInputPortIndexes(nodeFrom.getObject());
                for (iIndex = 0; iIndex < portIndexes.length; ++iIndex) {
                    portInputTo = nodeTo.getInputPort(portIndexes[iIndex]);
                    if (portInputTo == null) continue;
                    link.setToNodePortIndex(portIndexes[iIndex]);
                }
            }
            if (portInputTo != null && portInputTo.getNumLinks() >= portInputTo.getMaxNumLinks()) continue;
            link.setLinkSupportedValidation(false);
            ((PFDLink)link).setFromPort(portOutputFrom);
            ((PFDLink)link).setToPort(portInputTo);
            link.setLinkSupportedValidation(true);
            if (link instanceof IControlLink && nodeFrom.getNumInputPorts() != 1 && nodeTo.getNumOutputPorts() != 1) {
                ((PFDLink)link).setVisible(this.m_bControlOrderVisible);
                ((PFDLink)link).setLayoutAffected(false);
            }
            this.addLink((PFDLink)link);
            if (nodeFrom.getObject() instanceof IWorkTable && nodeTo instanceof IDataTransformNode && this.getNode(((IWorkTableNode)nodeFrom).getTransformNodeId()) != null) {
                ((IDataTransformNode)this.getNode(((IWorkTableNode)nodeFrom).getTransformNodeId())).updateCollapsedLinks();
            }
            if (!(nodeTo.getObject() instanceof IWorkTable) || !(nodeFrom instanceof IDataTransformNode)) continue;
            ((IDataTransformNode)nodeFrom).updateCollapsedLinks();
            ((PFDLink)link).setDraggable(false);
            ((PFDLink)link).setSelectable(false);
            ((IDataTransformNode)nodeFrom).updateCollapsedLinks();
        }
        return true;
    }

    private boolean createNodesNotExistingInXML() {
        boolean bOneAdded = true;
        ITransform[] aTransforms = this.m_mdlJob.getJob().getTransforms();
        if (aTransforms.length == 0) {
            bOneAdded = false;
        }
        for (int iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
            ITransform transform = aTransforms[iTransform];
            ArrayList nodes = (ArrayList)this.acquireNodes((IObject)transform);
            if (nodes == null || nodes.size() != 1 || !(nodes.get(0) instanceof IDataTransformNode)) continue;
            IDataTransform transformData = (IDataTransform)aTransforms[iTransform];
            IDataTransformNode transNode = (IDataTransformNode)nodes.get(0);
            transNode.refresh();
            IDataObject[] aSources = transformData.getDataSources();
            for (int iSource = 0; iSource < aSources.length; ++iSource) {
                IDiagramNode node;
                List sourceNodes = this.getNodes((IObject)aSources[iSource]);
                if (sourceNodes != null || aSources[iSource] instanceof IWorkTable || (node = this.addNode((IObject)aSources[iSource])) == null || this.m_mdlJob.getJob().getDataObjectsList().contains(aSources[iSource])) continue;
                boolean bSaveIgnore = this.m_bIgnoreEvents;
                this.m_bIgnoreEvents = true;
                this.m_mdlJob.getJob().getDataObjectsList().add(aSources[iSource]);
                this.m_bIgnoreEvents = bSaveIgnore;
            }
            this.updateTransformTargets(transNode, transformData);
        }
        IDataObject[] aDataObjects = this.m_mdlJob.getJob().getDataObjects();
        if (!bOneAdded && aDataObjects.length > 0) {
            bOneAdded = true;
        }
        for (int iDataObject = 0; iDataObject < aDataObjects.length; ++iDataObject) {
            IDataObject dataObject = aDataObjects[iDataObject];
            List nodes = this.getNodes((IObject)dataObject);
            if (nodes != null) continue;
            this.addNode((IObject)dataObject);
        }
        return bOneAdded;
    }

    private void updateTransformTargets(IDataTransformNode transNode, IDataTransform transformData) {
        if (transNode != null && transformData != null) {
            transNode.refresh();
            IDataObject[] aTargets = transformData.getDataTargets();
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                List targetNodes = this.getNodes((IObject)aTargets[iTarget]);
                if (targetNodes != null) continue;
                IDiagramNode node = this.addNode((IObject)aTargets[iTarget]);
                if (node != null && node instanceof IWorkTableNode) {
                    ((IWorkTableNode)node).setTransformNodeId(transNode.getId());
                    transNode.addWorkTable((PFDCompositeNode)node);
                    continue;
                }
                if (node == null || this.m_mdlJob.getJob().getDataObjectsList().contains(aTargets[iTarget])) continue;
                boolean bSaveIgnore = this.m_bIgnoreEvents;
                this.m_bIgnoreEvents = true;
                this.m_mdlJob.getJob().getDataObjectsList().add(aTargets[iTarget]);
                this.m_bIgnoreEvents = bSaveIgnore;
            }
        }
    }

    private void addLinks() {
        this.addLinksFromXML();
        this.createLinksNotExistingInXML();
    }

    public void setModeOnTransformNodes(int eMode) {
        ITransform[] aTransforms = this.m_mdlJob.getJob().getTransforms();
        for (int iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
            List lNodes = this.getNodes((IObject)aTransforms[iTransform]);
            if (lNodes == null || lNodes.isEmpty()) continue;
            ITransformNode node = (ITransformNode)lNodes.get(0);
            node.setMode(eMode);
            node.setRunStatus(0);
            node.setValidateStatus(0);
        }
    }

    public IDiagramNodeAdapter getAdapter(IObject obj) {
        List lNodes = this.getNodes(obj);
        if (lNodes != null && !lNodes.isEmpty()) {
            return ((IDiagramNode)lNodes.get(0)).getAdapter();
        }
        return null;
    }

    private class JobModelListener
    implements IModelListener {
        private JobModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (DiagramModel.this.m_bResetModeOnEdit) {
                DiagramModel.this.m_bResetModeOnEdit = false;
                DiagramModel.this.setModeOnTransformNodes(0);
            }
            if (!DiagramModel.this.m_bIgnoreEvents) {
                String sType = ev.getType();
                IObject obj = ev.getModelObject();
                Object data = ev.getData();
                Object addData = ev.getAdditionalData();
                if ("ModelController:UnknownChanges".equals(sType)) {
                    if (!DiagramModel.this.getFirstOpen()) {
                        DiagramModel.this.setDiagramXML(DiagramModel.this.createDiagramXML());
                    }
                    boolean bLayout = DiagramModel.this.refresh();
                    DiagramModel.this.setFirstOpen(false);
                    if (bLayout) {
                        DiagramModel.this.fireModelChange(1000, null, null);
                    }
                } else if ("ModelController:ItemsPasted".equals(sType)) {
                    if (DiagramModel.this.m_dropPt != null && ev.getData() instanceof PasteItemsContainer) {
                        IDiagramNode node;
                        IObject pastedItem;
                        PasteItemsContainer pasteContainer = (PasteItemsContainer)ev.getData();
                        List<PasteItem> lst = pasteContainer.getSortedPasteItems();
                        HashMap<PasteItem, IDiagramNode> pasteMap = new HashMap<PasteItem, IDiagramNode>(lst.size());
                        for (PasteItem item : lst) {
                            if (!(item.getObject() instanceof IDataObject)) continue;
                            if (!DiagramModel.this.getJobModel().getJob().getDataObjectsList().contains(item.getObject())) {
                                DiagramModel.this.getJobModel().getJob().getDataObjectsList().add(item.getObject());
                                continue;
                            }
                            pastedItem = (IObject)item.getObject();
                            node = DiagramModel.this.addNode(pastedItem);
                            if (node == null) continue;
                            ((IDataObject)pastedItem).setChangedNodeId(node.getId());
                        }
                        for (PasteItem item : lst) {
                            if (!(item.getObject() instanceof IDataObject)) {
                                pastedItem = (IObject)item.getObject();
                                node = DiagramModel.this.addNode(pastedItem);
                                if (node == null) continue;
                                pasteMap.put(item, node);
                                if (!(pastedItem instanceof IDataTransform) || !(node instanceof IDataTransformNode)) continue;
                                DiagramModel.this.updateTransformTargets((IDataTransformNode)node, (IDataTransform)pastedItem);
                                continue;
                            }
                            if (!(item.getObject() instanceof IDiagramStickyNote)) continue;
                            if (DiagramModel.this.m_iInsertIteration > 0) {
                                if (DiagramModel.this.isCollapsed()) {
                                    if (DiagramModel.this.getFlowDirection().equals(DiagramModel.FLOW_DIRECTION_RIGHT)) {
                                        ((DiagramModel)DiagramModel.this).m_dropPt.x += 175;
                                    } else {
                                        ((DiagramModel)DiagramModel.this).m_dropPt.y += 100;
                                    }
                                } else if (DiagramModel.this.getFlowDirection().equals(DiagramModel.FLOW_DIRECTION_RIGHT)) {
                                    ((DiagramModel)DiagramModel.this).m_dropPt.x += 345;
                                } else {
                                    ((DiagramModel)DiagramModel.this).m_dropPt.y += 195;
                                }
                            }
                            DiagramModel.this.m_iInsertIteration++;
                            item.getObject();
                            IDiagramStickyNote note = (IDiagramStickyNote)item.getObject();
                            DiagramModel.this.addStickyNote(note, DiagramModel.this.m_dropPt);
                        }
                        for (PasteItem item : pasteContainer.getPastedItems()) {
                            if (pasteMap.containsKey(item) || !(item.getObject() instanceof IObject)) continue;
                            List l = DiagramModel.this.getNodes((IObject)item.getObject());
                            for (int i = 0; i < l.size(); ++i) {
                                pasteMap.put(item, (IDiagramNode)l.get(i));
                            }
                        }
                        if (!pasteMap.isEmpty()) {
                            PasteItemLocationComparator pvc = new PasteItemLocationComparator(!DiagramModel.FLOW_DIRECTION_RIGHT.equals(DiagramModel.this.getFlowDirection()));
                            TreeSet<PasteItem> sortedPvc = new TreeSet<PasteItem>(pvc);
                            sortedPvc.addAll(pasteMap.keySet());
                            boolean isFirst = true;
                            for (PasteItem item : sortedPvc) {
                                IDiagramNode node2 = (IDiagramNode)pasteMap.get(item);
                                if (!isFirst) {
                                    if (DiagramModel.this.isCollapsed()) {
                                        if (DiagramModel.this.getFlowDirection().equals(DiagramModel.FLOW_DIRECTION_RIGHT)) {
                                            ((DiagramModel)DiagramModel.this).m_dropPt.x += 175;
                                        } else {
                                            ((DiagramModel)DiagramModel.this).m_dropPt.y += 100;
                                        }
                                    } else if (DiagramModel.this.getFlowDirection().equals(DiagramModel.FLOW_DIRECTION_RIGHT)) {
                                        ((DiagramModel)DiagramModel.this).m_dropPt.x += 345;
                                    } else {
                                        ((DiagramModel)DiagramModel.this).m_dropPt.y += 195;
                                    }
                                }
                                isFirst = false;
                                node2.setLocation(((DiagramModel)DiagramModel.this).m_dropPt.x, ((DiagramModel)DiagramModel.this).m_dropPt.y);
                                if (node2 instanceof IDataNode && node2.getUIPlacement() == null) {
                                    ((IDataNode)node2).setUIPlacement((IDesignTimeModel)DiagramModel.this.m_mdlJob);
                                }
                                Point p = new Point();
                                node2.getSpotLocation(1, p);
                                node2.getUIPlacement().setXPosition(p.x);
                                node2.getUIPlacement().setYPosition(p.y);
                                DiagramModel.this.getJobModel().undoableEditHappened((UndoableEdit)new AddDataObjectUndoable(node2, DiagramModel.this.m_dropPt));
                            }
                        }
                        DiagramModel.this.createLinksNotExistingInXML();
                    }
                } else if ("ModelController:ComplexOperationComplete".equals(sType)) {
                    ArrayList nodes = (ArrayList)DiagramModel.this.getNodes(obj);
                    if (nodes != null) {
                        for (int iNode = 0; iNode < nodes.size(); ++iNode) {
                            IDiagramNode node = (IDiagramNode)nodes.get(iNode);
                            if (!node.getAdapter().isLayoutRequired()) continue;
                            DiagramModel.this.fireModelChange(1000, null, null);
                            break;
                        }
                    }
                } else if (obj instanceof IJob && sType.equals("NotesContainer:PrivateNoteChanged")) {
                    DiagramModel.this.refreshNodes(obj);
                } else if (obj instanceof IDataObject || obj instanceof ITransform) {
                    IDiagramNode node = null;
                    if (sType.equals("DataTransform.DataTargetAdded")) {
                        IDataTransformNode transNode = null;
                        if (data instanceof IWorkTable) {
                            ArrayList transNodes = (ArrayList)DiagramModel.this.getNodes(obj);
                            node = DiagramModel.this.addNode((IObject)ev.getData());
                            if (node != null) {
                                if (transNodes != null && transNodes.size() > 0) {
                                    transNode = (IDataTransformNode)transNodes.get(0);
                                    ((IWorkTableNode)node).setTransformNodeId(transNode.getId());
                                    transNode.addWorkTable((PFDCompositeNode)node);
                                } else {
                                    DiagramModel.this.addPrimitive((PFDPrimitive)((PFDAbstractNode)node));
                                }
                            }
                        }
                        int fromPortIndex = -1;
                        if (addData instanceof Integer) {
                            fromPortIndex = (Integer)addData;
                        }
                        if (DiagramModel.this.getLink(obj, (IObject)data, fromPortIndex, -1) == null) {
                            DiagramModel.this.createLink(obj, (IObject)data, fromPortIndex, -1);
                        }
                        DiagramModel.this.refreshNodes((IObject)data);
                        if (transNode != null) {
                            transNode.updateCollapsedLinks();
                        }
                    } else if (sType.equals("DataTransform.DataSourceAdded")) {
                        int toPortIndex = -1;
                        if (addData instanceof Integer) {
                            toPortIndex = (Integer)addData;
                        }
                        if (DiagramModel.this.getLink((IObject)data, obj, -1, toPortIndex) == null) {
                            DiagramModel.this.createLink((IObject)data, obj, -1, toPortIndex);
                        }
                        DiagramModel.this.refreshNodes((IObject)data);
                    } else if (sType.equals("DataTransform.InputAdded") || sType.equals("DataTransform.InputRemoved") || sType.equals("DataTransform.OutputAdded") || sType.equals("DataTransform.OutputRemoved") || sType.equals("DataTransform.OutputUpdated") || sType.equals("DataTransform.InputUpdated")) {
                        DiagramModel.this.refreshNodes(obj, ev);
                    } else if ("DataTransform.DataSourceRemoved".equals(sType)) {
                        IDiagramLink link;
                        int toPortIndex = -1;
                        if (addData instanceof Integer) {
                            toPortIndex = (Integer)addData;
                        }
                        if ((link = DiagramModel.this.removeLink((IObject)data, obj, -1, toPortIndex)) != null) {
                            ((IDataObject)data).setChangedNodeId(link.getFromNodeId());
                        }
                    } else if ("DataTransform.DataTargetRemoved".equals(sType)) {
                        IDiagramLink link;
                        int fromPortIndex = -1;
                        if (addData instanceof Integer) {
                            fromPortIndex = (Integer)addData;
                        }
                        if ((link = DiagramModel.this.removeLink(obj, (IObject)data, fromPortIndex, -1)) != null) {
                            ((IDataObject)data).setChangedNodeId(link.getToNodeId());
                        }
                        if (data instanceof IWorkTable) {
                            if (DiagramModel.this.getNodes(obj) == null) {
                                return;
                            }
                            IWorkTable tbl = (IWorkTable)data;
                            IDataTransform[] consumers = tbl.getConsumerTransforms();
                            for (int iConsumer = 0; iConsumer < consumers.length; ++iConsumer) {
                                consumers[iConsumer].removeDataSource((IDataObject)tbl);
                            }
                            DiagramModel.this.removeNodes((IObject)((IWorkTable)data));
                        }
                    }
                    DiagramModel.this.refreshNodes(obj);
                } else if (obj == DiagramModel.this.m_mdlJob.getJob()) {
                    if (sType.equals("Job:TransformAdded") || sType.equals("Job:DataObjectAdded")) {
                        ArrayList nodes = (ArrayList)DiagramModel.this.acquireNodes((IObject)ev.getData());
                        if (nodes != null) {
                            for (int iNode = 0; iNode < nodes.size(); ++iNode) {
                                IDiagramNode node = (IDiagramNode)nodes.get(iNode);
                                if (node == null) continue;
                                node.refresh();
                            }
                        }
                    } else if ("DataTransform.DataTargetRemoved".equals(sType) || "DataTransform.DataSourceRemoved".equals(sType) || sType.equals("Job:TransformRemoved")) {
                        DiagramModel.this.removeNodes((IObject)data);
                    } else if (sType.equals("Job:DataObjectRemoved")) {
                        DiagramModel.this.removeNodes((IObject)data);
                    } else if (sType.equals("Job:TransformAddedToExecutionOrder")) {
                        DiagramModel.this.addToExecutionOrder((IJob)obj, (IObject)data);
                    } else if (sType.equals("Job:TransformRemovedFromExecutionOrder")) {
                        DiagramModel.this.removeFromExecutionOrder((IJob)obj, (IObject)data);
                    }
                }
            }
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            if (!DiagramModel.this.getJobModel().getUndoManager().canUndoOrRedo()) {
                DiagramModel.this.clearDeletedLists();
            }
        }
    }

    private class cPropertyChanged
    implements PropertyChangeListener {
        private cPropertyChanged() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("AppServer.Default".equals(evt.getPropertyName())) {
                if (DiagramModel.this.m_mdlJob != null && DiagramModel.this.m_mdlJob.getJob() != null) {
                    DiagramModel.this.m_mdlJob.getJob().setExecutionServer(ModelUIUtilities.acquireModelForDefaultSASAppServer((IModel)DiagramModel.this.m_mdlJob));
                }
                DiagramModel.this.refreshAllNodes();
            }
        }
    }

    private class AddDataObjectUndoable
    extends AbstractUndoableEdit {
        private IDiagramNode m_node;
        private Point m_location;

        public AddDataObjectUndoable(IDiagramNode node, Point location) {
            this.m_node = node;
            this.m_location = location;
        }

        @Override
        public void undo() {
            super.undo();
            DiagramModel.this.removeNode(this.m_node.getId());
        }

        @Override
        public void redo() {
            super.redo();
            DiagramModel.this.addPrimitive((PFDPrimitive)((PFDAbstractNode)this.m_node));
            if (this.m_node.getObject() instanceof IDataObject) {
                DiagramModel.this.getJobModel().getJob().addUIPlacemnentToJob((IDataObject)this.m_node.getObject(), this.m_node.getUIPlacement());
            }
            DiagramModel.this.putNode(this.m_node.getObject(), this.m_node);
        }
    }

    private class AddStickyNoteUndoable
    extends AbstractUndoableEdit {
        private IDiagramStickyNote m_stickyNote;

        public AddStickyNoteUndoable(IDiagramStickyNote stickyNote) {
            this.m_stickyNote = stickyNote;
        }

        @Override
        public void undo() {
            super.undo();
            DiagramModel.this.removeStickyNote(this.m_stickyNote);
        }

        @Override
        public void redo() {
            super.redo();
            DiagramModel.this.addStickyNote(this.m_stickyNote, this.m_stickyNote.getLocation());
        }
    }

    private class RemoveStickyNoteUndoable
    extends AbstractUndoableEdit {
        private IDiagramStickyNote m_stickyNote;

        public RemoveStickyNoteUndoable(IDiagramStickyNote stickyNote) {
            this.m_stickyNote = stickyNote;
        }

        @Override
        public void undo() {
            super.undo();
            DiagramModel.this.addStickyNote(this.m_stickyNote, this.m_stickyNote.getLocation());
        }

        @Override
        public void redo() {
            super.redo();
            DiagramModel.this.removeStickyNote(this.m_stickyNote);
        }
    }

    private class SetLocationUndoable
    extends AbstractUndoableEdit {
        private IShape m_node;
        private Point m_pOldLocation;
        private Point m_pNewLocation;

        public SetLocationUndoable(IShape node, Point pOldLocation, Point pNewLocation) {
            this.m_node = node;
            this.m_pOldLocation = pOldLocation;
            this.m_pNewLocation = pNewLocation;
        }

        @Override
        public void undo() {
            super.undo();
            DiagramModel.this.setLocation(this.m_node, this.m_pNewLocation, this.m_pOldLocation);
            if (this.m_node instanceof IDataNode) {
                ((IDataObject)((IDataNode)this.m_node).getObject()).setChangedNodeId(((IDataNode)this.m_node).getId());
            }
        }

        @Override
        public void redo() {
            super.redo();
            DiagramModel.this.setLocation(this.m_node, this.m_pOldLocation, this.m_pNewLocation);
        }
    }

    private class SetLinkLocationsUndoable
    extends AbstractUndoableEdit {
        private IDiagramLink m_link;
        private Point[] m_aOldLinkLocation;
        private Point[] m_aNewLinkLocation;

        public SetLinkLocationsUndoable(IDiagramLink link, Point[] aOldLinkLocation, Point[] aNewLinkLocation) {
            this.m_link = link;
            this.m_aOldLinkLocation = aOldLinkLocation;
            this.m_aNewLinkLocation = aNewLinkLocation;
        }

        @Override
        public void undo() {
            super.undo();
            DiagramModel.this.setLinkLocations(this.m_link, this.m_aNewLinkLocation, this.m_aOldLinkLocation);
        }

        @Override
        public void redo() {
            super.redo();
            DiagramModel.this.setLinkLocations(this.m_link, this.m_aOldLinkLocation, this.m_aNewLinkLocation);
        }
    }
}

