/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor;

import com.sas.etl.models.IObject;
import com.sas.wadmin.jobeditor.LogParser;
import com.sas.wadmin.run.IResults;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;

public class JobLogTab
extends WsLogPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(JobLogTab.class);
    private List m_lRunResults;

    public JobLogTab(int eType) {
        super(eType);
        if (eType == 1) {
            this.setName(bundle.getString("JobLogTab.Log.Name.txt"));
            this.setHelpProduct("texteditor");
            this.setHelpTopic("logspace");
        } else if (eType == 2) {
            this.setName(bundle.getString("JobLogTab.Output.Name.txt"));
            this.setHelpProduct("texteditor");
            this.setHelpTopic("outputspace");
        } else {
            throw new IllegalArgumentException("unknown type for JobLogTab");
        }
        this.m_lRunResults = new ArrayList();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.waum.updateWorkspaceUIComponents(bActive);
        this.m_actPrint.setActive(bActive);
        this.m_actPageSetup.setActive(bActive);
        this.m_actCopy.setActive(bActive);
        this.m_actSelectAll.setActive(bActive);
        this.m_actClear.setActive(bActive);
        this.m_actFindReplace.setActive(bActive);
    }

    public void appendResults(IResults results) {
        this.m_lRunResults.add(results);
        if (this.m_eType == 1) {
            this.appendText(results.getLog());
        } else if (this.m_eType == 2) {
            this.appendText(results.getOutput());
        }
        this.setDataChanged(true);
    }

    public void setSelectedModelObject(IObject object) {
        if (object == null) {
            return;
        }
        int endIndex = this.getText().length();
        if (endIndex == 0) {
            return;
        }
        for (int i = this.m_lRunResults.size() - 1; i >= 0; --i) {
            IResults results = (IResults)this.m_lRunResults.get(i);
            String[] contents = this.m_eType == 2 ? results.getOutput().getLineArray() : results.getLog().getLineArray();
            int segmentLength = 0;
            for (int j = 0; j < contents.length; ++j) {
                segmentLength += LogParser.getLengthInLogOf(contents[j]);
            }
            if (object.equals((Object)results.getModelObject())) {
                try {
                    this.m_txtEditor.scrollRectToVisible(this.m_txtEditor.modelToView(endIndex));
                    this.m_txtEditor.setCaretPosition(endIndex);
                    this.m_txtEditor.moveCaretPosition(endIndex - segmentLength);
                    return;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            if ((endIndex -= segmentLength) > 0) continue;
            return;
        }
    }
}

