/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDocument;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IMessageQueue;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IGeneratedTransformDefinition;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.other.INote;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.drill.DrillPanel;
import com.sas.wadmin.jobeditor.JobEditorPanel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardInternalFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractNewView;
import com.sas.workspace.WsBaseView;
import com.sas.workspace.WsLockManager;
import com.sas.workspace.models.SimpleObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class JobEditorView
extends WsAbstractNewView {
    private static final WAdminResource bundle = WAdminResource.getBundle(JobEditorView.class);
    private DesignTimeJobModel m_mdlJob;
    private IModelListener m_lsnrModel;
    private JobEditorPanel m_pnlJob;
    private DrillPanel m_pnlDrill;
    private List m_lLockedIDs = new ArrayList();

    public static WsBaseView createInstance(String sID, String sType, String sName) {
        return new JobEditorView(sID, sType, sName);
    }

    private JobEditorView(String sID, String sType, String sName) {
        super(sID, sType, sName);
    }

    protected String getFrameTitle() {
        String sTitle = this.m_pnlDrill.getBreadCrumbTrail();
        if (this.m_mdlJob.getJob().isUsingUserWrittenCode()) {
            sTitle = bundle.formatString("JobEditorView.UserWrittenTitle.fmt", (Object)sTitle);
        } else if (this.m_mdlJob.getJob().isCPRJobCodeNeeded(false)) {
            sTitle = bundle.formatString("JobEditorView.CheckpointEnabledTitle.fmt", (Object)sTitle);
        }
        return sTitle;
    }

    protected Icon getFrameIcon() {
        return AppIconFactory.getInstance().getIconForPublicType("Job");
    }

    protected String getDefaultsName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected WAStandardInternalFrame createFrame() {
        JobInternalFrame frm = new JobInternalFrame(this.getName());
        frm.setButtonsPanelVisible(false);
        return frm;
    }

    protected WAPanel createMainPanel() {
        this.m_mdlJob = DesignTimeJobModel.createModelForExistingJob((String)this.getID());
        this.m_mdlJob.getJob().setName(this.getName());
        if (this.m_mdlJob.getJob() != null) {
            this.m_mdlJob.getJob().setExecutionServer(ModelUIUtilities.acquireModelForDefaultSASAppServer((IModel)this.m_mdlJob));
        }
        this.m_mdlJob.setEditable(Workspace.isObjectEditable((SimpleObject)this.m_mdlJob.getJob()));
        this.m_lsnrModel = new ModelListener();
        this.m_mdlJob.addModelListener(this.m_lsnrModel);
        Workspace.getDefaultLogger().debug((Object)"create main panel start");
        this.m_pnlJob = new JobEditorPanel(this.m_mdlJob);
        this.m_pnlJob.setEditable(this.m_mdlJob.isEditable());
        this.m_pnlJob.setName(this.getName());
        Workspace.getDefaultLogger().debug((Object)"create main panel complete");
        this.m_pnlDrill = new DrillPanel();
        this.m_pnlDrill.setUndoManager(this.m_mdlJob.getUndoManager());
        this.m_pnlDrill.setFirstDrillableComponent(this.m_pnlJob);
        this.m_pnlDrill.setEditable(this.m_mdlJob.isEditable());
        this.m_pnlDrill.addPropertyChangeListener("BreadCrumbTrail", new BreadCrumbTrailListener());
        return this.m_pnlDrill;
    }

    public void dispose() {
        super.dispose();
        if (this.m_mdlJob != null) {
            this.clearLocks();
            if (this.m_lsnrModel != null) {
                this.m_mdlJob.removeModelListener(this.m_lsnrModel);
                this.m_lsnrModel = null;
            }
            this.m_mdlJob.dispose();
            this.m_mdlJob = null;
        }
    }

    private void lockAllObjects() {
        IObject[] aObjects = this.m_mdlJob.getAllObjects();
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            this.addLock(aObjects[iObject]);
        }
    }

    private void clearLocks() {
        while (!this.m_lLockedIDs.isEmpty()) {
            this.removeLock((String)this.m_lLockedIDs.get(0));
        }
    }

    private void addLock(IObject obj) {
        String sID = obj.getID();
        if (this.m_mdlJob.isNewObjectID(obj.getID())) {
            return;
        }
        if (obj instanceof IPhysicalTable || obj instanceof IExternalTable || obj instanceof IJob || obj instanceof ILibrary || obj instanceof INote || obj instanceof IDocument || obj instanceof IMessageQueue || obj instanceof IGeneratedTransformDefinition) {
            this.m_lLockedIDs.add(sID);
            WsLockManager.getInstance().addLock(sID);
        }
    }

    private void removeLock(String sID) {
        if (this.m_mdlJob.isNewObjectID(sID)) {
            return;
        }
        if (this.m_lLockedIDs.contains(sID)) {
            this.m_lLockedIDs.remove(sID);
            WsLockManager.getInstance().removeLock(sID);
        }
    }

    private class JobInternalFrame
    extends WAStandardInternalFrame {
        public JobInternalFrame(String sTitle) {
            super(sTitle);
        }

        protected boolean onCancel() {
            if (JobEditorView.this.m_pnlJob.getRunState() != 0) {
                MessageUtil.displayMessage((String)bundle.formatString("JobEditorView.CantCloseRunningJob.fmt", (Object)JobEditorView.this.m_mdlJob.getJob().getName()), (String)bundle.getString("JobEditorView.CantCloseRunningJob.title.txt"), (int)0);
                return false;
            }
            return super.onCancel();
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType == "ModelController:UnknownChanges") {
                JobEditorView.this.getFrame().setTitle(JobEditorView.this.getFrameTitle());
                JobEditorView.this.clearLocks();
                JobEditorView.this.lockAllObjects();
            } else if (sType == "IUserWrittenCode:activeChanged" && ev.getModelObject() == JobEditorView.this.m_mdlJob.getJob() || sType == "Object:NameChanged" && ev.getModelObject() == JobEditorView.this.m_mdlJob.getJob()) {
                JobEditorView.this.getFrame().setTitle(JobEditorView.this.getFrameTitle());
            } else if (sType == "BaseModel:EditableChanged") {
                JobEditorView.this.getFrame().setEditable(JobEditorView.this.m_mdlJob.isEditable());
            } else if (sType == "ModelController:ObjectAdded") {
                JobEditorView.this.addLock(ev.getModelObject());
            } else if (sType == "ModelController:ObjectRemoved") {
                JobEditorView.this.removeLock(ev.getModelObject().getID());
            } else if (sType == "IJob:DisableCheckpointsChanged" || sType == "ITransform:CheckpointEnabledChanged" || sType == "IJob:CheckpointStateLibraryChanged" || sType == "ITransform:CodeGenerationEnabledChanged") {
                JobEditorView.this.getFrame().setTitle(JobEditorView.this.getFrameTitle());
            }
        }
    }

    private class BreadCrumbTrailListener
    implements PropertyChangeListener {
        private BreadCrumbTrailListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            JobEditorView.this.getFrame().setTitle(JobEditorView.this.getFrameTitle());
        }
    }
}

