/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.efi2.ColumnDefinitionsPanel;
import com.sas.wadmin.efi2.EFIWizardFinishTab;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.UserWrittenExternalTablePanel;
import com.sas.wadmin.plugins.NewObjectInterface;
import com.sas.wadmin.visuals.SASImporter;
import com.sas.wadmin.visuals.WAGeneralWizardPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.rmi.RemoteException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NewUserWrittenExternalTableWizard
extends SASImporter
implements NewObjectInterface {
    private WAdminResource bundle = WAdminResource.getBundle(NewUserWrittenExternalTableWizard.class);
    private static final String UserWrittenPanel = "UserWrittenPanel";
    private static final String ColumnsPanel = "ColumnDefinitionsPanel";
    private static final String GeneralPanel = "GeneralPanel";
    private static final String FinishPanel = "FinishPanel";
    private SimpleObject m_folder = null;
    private boolean m_bInitialized = false;

    public NewUserWrittenExternalTableWizard() {
        this(null);
    }

    public NewUserWrittenExternalTableWizard(SimpleObject folder) {
        this.m_folder = folder;
    }

    @Override
    public boolean initializeWizard(WAWizardDialog dlgWizard, WATransitionWizardModel mdlWizard) {
        try {
            if (this.m_bInitialized) {
                return true;
            }
            MdObjectStore store = (MdObjectStore)dlgWizard.getWizardData("OBJECTSTORE");
            Tree defaultFolder = null;
            if (this.m_folder != null) {
                defaultFolder = (Tree)ObjectConverter.getInstance().convertToJOMAObject(store, this.m_folder);
            }
            if (defaultFolder == null) {
                try {
                    defaultFolder = WsMetadataUtil.getDefaultFolder((MdObjectStore)store);
                }
                catch (ServiceException e) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)e);
                }
            }
            ExternalTableDataModel mdlTable = new ExternalTableDataModel();
            dlgWizard.addWizardData("EFIDATAMODEL", (Object)mdlTable);
            mdlTable.setEFIType(3);
            ImageIcon image = this.bundle.getImageIcon("EFIImage.image.notrans");
            dlgWizard.setCanFinishEarly(false);
            WAGeneralWizardPanel generalWizardPanel = new WAGeneralWizardPanel(this.bundle.getString("NewDelimitedExternalTableWizard.GeneralPanel.Description.txt"), null, true);
            generalWizardPanel.setHelpProduct("wdb");
            generalWizardPanel.setHelpTopic("external_user_wiz");
            WAGeneralPanel generalPanel = generalWizardPanel.getGeneralPanel();
            generalPanel.enableNameValidation(true);
            String sName = WsMetadataNameUtil.getUniqueNameForType((String)"ExternalTable", (String)this.bundle.getString("NewEFIWizard.DefaultName.txt"));
            generalPanel.setNameField(sName);
            generalPanel.setOwningTree(defaultFolder);
            dlgWizard.addWizardData("GENERALPANEL", (Object)generalPanel);
            dlgWizard.addTab(this.bundle.getString("NewDelimitedExternalTableWizard.GeneralPanel.Title.txt"), GeneralPanel, (WAPropertyTab)generalWizardPanel, "wa_source_type.gif", (Icon)image, false);
            dlgWizard.addTab(this.bundle.getString("NewUserWrittenExternalTableWizard.UserWrittenPanel.Title.txt"), UserWrittenPanel, (WAPropertyTab)new UserWrittenExternalTablePanel(mdlTable), "wa_source_type.gif", (Icon)image, false);
            ColumnDefinitionsPanel columnDefinitionsPanel = new ColumnDefinitionsPanel(mdlTable, "USERWRITTEN");
            dlgWizard.addTabToCleanupOnCancel((WAPropertyTab)columnDefinitionsPanel);
            dlgWizard.addTab(this.bundle.getString("NewUserWrittenExternalTableWizard.ColumnDefintionsPanel.Title.txt"), ColumnsPanel, (WAPropertyTab)columnDefinitionsPanel, "wa_source_type.gif", (Icon)image, false);
            dlgWizard.addTab(this.bundle.getString("FinishTab.Title.txt"), FinishPanel, (WAPropertyTab)new EFIWizardFinishTab(), "wa_source_type.gif", (Icon)image, true);
            String[][] saTransitions = new String[][]{{GeneralPanel, "NEXT", UserWrittenPanel}, {UserWrittenPanel, "NEXT", ColumnsPanel}, {ColumnsPanel, "NEXT", FinishPanel}};
            mdlWizard.addTransitions(saTransitions);
            this.setTransitionsAdded(true);
            dlgWizard.setResizable(true);
            this.m_bInitialized = true;
            return true;
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return true;
        }
    }

    @Override
    public String getInitialTabName() {
        return UserWrittenPanel;
    }

    @Override
    public String getToolTip() {
        return null;
    }

    @Override
    public String getCategory() {
        return this.bundle.getString("NewUserWrittenExternalTableWizard.Category.txt");
    }

    @Override
    public void initPlugin() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getDescription() {
        return this.bundle.getString("NewUserWrittenExternalTableWizard.Description.txt");
    }

    @Override
    public Icon getIcon() {
        return WAdminResource.getTypeIcon((String)"ExternalTable", (boolean)true);
    }

    @Override
    public String getName() {
        return this.bundle.getString("NewUserWrittenExternalTableWizard.Name.txt");
    }
}

