/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.rio.MVAResultSet;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ImportColumnsFromHeader {
    private ExternalTableDataModel m_model;
    private int m_headerLine;

    public ImportColumnsFromHeader(ExternalTableDataModel model, int record) {
        this.m_model = model;
        this.m_headerLine = record;
    }

    public List getColumnNames() throws SQLException, WsAppServerFailException, WsAppServerCodeException {
        try {
            SASCodeGeneration sbSource = new SASCodeGeneration();
            sbSource.addSourceCode("data work.colsTable ;\n");
            int startRecordValue = this.m_model.getStartRecord();
            int numObsValue = this.m_model.getNumberObservations();
            boolean missoverSet = this.m_model.isMissover();
            String infileOptions = this.m_model.getInfileOptionsText();
            try {
                this.m_model.setStartRecord(this.m_headerLine);
                this.m_model.setNumberObservations(1);
                this.m_model.setInfileOptions(infileOptions);
                if (missoverSet) {
                    this.m_model.setMissover(false);
                }
                sbSource.addSourceCode(this.m_model.getInfileStatement());
                this.m_model.setStartRecord(startRecordValue);
                this.m_model.setNumberObservations(numObsValue);
                this.m_model.setInfileOptions(infileOptions);
                if (missoverSet) {
                    this.m_model.setMissover(true);
                }
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
            }
            int numColumns = 0;
            sbSource.addSourceCode("\n\n");
            if (this.m_model.isDelimited()) {
                sbSource.addSourceCode("length Name $32.; \n");
                sbSource.addSourceCode("input Name $ @@; \n");
                sbSource.addSourceCode("run;\n");
            } else {
                List cList = this.m_model.getColumns();
                if (!cList.isEmpty()) {
                    int i;
                    for (i = 0; i < cList.size(); ++i) {
                        if (i == 0) {
                            numColumns = 1;
                        }
                        ++numColumns;
                    }
                    for (i = 0; i < cList.size(); ++i) {
                        Column col = (Column)cList.get(i);
                        if (i == 0) {
                            sbSource.addSourceCode("input \n");
                        }
                        sbSource.indent();
                        sbSource.addSourceCode("@  ");
                        sbSource.addSourceCode(String.valueOf(col.getBeginPosition()));
                        int colLength = col.getEndPosition() - col.getBeginPosition() + 1;
                        sbSource.addSourceCode(" Name" + i + " $" + colLength + ". \n");
                        sbSource.unIndent();
                    }
                    sbSource.unIndent();
                    sbSource.addSourceCode(";\n run;\n");
                }
            }
            Workspace.getDefaultLogger().debug((Object)sbSource.getSource());
            WsAppServer appServer = this.m_model.getAppServer();
            if (appServer == null) {
                return new ArrayList();
            }
            appServer.submitSASCode(sbSource.getSource());
            String sqlStmt = "";
            sqlStmt = this.m_model.isDelimited() ? "Select Name from work.colsTable ;" : "Select * from work.colsTable ;";
            MVAResultSet fieldList = appServer.submitSQLStatement(sqlStmt);
            ArrayList<String> l_columnList = new ArrayList<String>(100);
            if (this.m_model.isDelimited()) {
                while (fieldList.next()) {
                    String colName = fieldList.getString(1).trim();
                    l_columnList.add(colName);
                }
            } else {
                while (fieldList.next()) {
                    for (int j = 1; j < numColumns; ++j) {
                        String colName = fieldList.getString(j).trim();
                        l_columnList.add(colName);
                    }
                }
            }
            try {
                fieldList.close();
            }
            catch (SQLException sqlE) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)sqlE);
            }
            return l_columnList;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return new ArrayList();
        }
    }
}

