/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.rio.MVAResultSet;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.ImportColumnsMessage;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.rmi.RemoteException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ImportColumnsFromEFF {
    private ExternalTableDataModel m_model;
    private String m_fullFileName;
    private MdObjectStore m_store;
    private static String m_delimiter;
    private static int m_fieldLength;
    private static String metaLib;
    private static String metaTable;
    private ArrayList m_alMessages;
    private static String READFLAG;
    private static WAdminResource bundle;

    public ImportColumnsFromEFF(ExternalTableDataModel model, String fullFileName, String delimiter, MdObjectStore store) {
        this.m_model = model;
        this.m_fullFileName = fullFileName;
        this.m_store = store;
        this.m_alMessages = new ArrayList();
        m_delimiter = delimiter;
        if (m_delimiter.length() == 0) {
            m_delimiter = " ";
        }
    }

    public List getColumns() throws SQLException, WsAppServerFailException, WsAppServerCodeException {
        int valueLRECL = m_fieldLength * 6;
        StringBuffer sbLibAndTable = new StringBuffer();
        sbLibAndTable.append(metaLib);
        sbLibAndTable.append(".");
        sbLibAndTable.append(metaTable);
        String metaLibDotTable = sbLibAndTable.toString();
        StringBuffer sbSource = new StringBuffer(300);
        sbSource.append("\ndata _null_;\n");
        sbSource.append("infile '");
        sbSource.append(this.m_fullFileName);
        sbSource.append("' delimiter= '");
        sbSource.append(m_delimiter);
        sbSource.append("' firstobs=1 DSD ; \n");
        sbSource.append("length firstChar $1.;\n");
        sbSource.append("input@1 firstChar; \n");
        sbSource.append("   if (compress(_infile_) NE '' && firstChar NE '#') then do;\n");
        sbSource.append("   call symput('firstobs', _N_);\n");
        sbSource.append("   stop;\n");
        sbSource.append("   end;\n");
        sbSource.append("run;\n");
        sbSource.append("\ndata work.etls_nms ;\n");
        sbSource.append("infile '");
        sbSource.append(this.m_fullFileName);
        sbSource.append("' delimiter= '");
        sbSource.append(m_delimiter);
        sbSource.append("' firstobs=&firstobs");
        sbSource.append(" obs=&firstobs ");
        sbSource.append(" DSD; \n");
        sbSource.append("length Name $");
        sbSource.append(String.valueOf(m_fieldLength));
        sbSource.append(".;  \n");
        sbSource.append("input Name $ @@; \n");
        sbSource.append("call symput ('col' || compress(put(_N_,4.)), Name); \n");
        sbSource.append("call symput('count', _N_); \n");
        sbSource.append("if _N_ = 1 then do; \n");
        sbSource.append("   ColObs1 = &firstobs+1; \n");
        sbSource.append("   call symput('ColObs1', ColObs1);\n");
        sbSource.append("end; \n\n");
        sbSource.append("run; \n\n");
        sbSource.append("%macro getCols;\n");
        sbSource.append("data ");
        sbSource.append(metaLibDotTable);
        sbSource.append("; \n");
        sbSource.append("infile '");
        sbSource.append(this.m_fullFileName);
        sbSource.append("' LRECL=");
        sbSource.append(valueLRECL);
        sbSource.append(" delimiter='");
        sbSource.append(m_delimiter);
        sbSource.append("' firstobs=&ColObs1");
        sbSource.append(" missover DSD end=endfile ; \n");
        sbSource.append("Length \n");
        sbSource.append("%do i = 1 %to &count; \n");
        sbSource.append("&&col&i $");
        sbSource.append(String.valueOf(m_fieldLength * 4) + ". \n");
        sbSource.append("%end; \n");
        sbSource.append("; \n");
        sbSource.append("do while (not endfile); \n");
        sbSource.append("input \n");
        sbSource.append("%do i = 1 %to &count; \n");
        sbSource.append("&&col&i $ \n");
        sbSource.append("%end; \n");
        sbSource.append("; \n");
        sbSource.append("  if (compress(_infile_) NE '' && substr(&col1,1,1) NE '#') then output;\n");
        sbSource.append("end;\n");
        sbSource.append("stop; \n");
        sbSource.append("run; \n");
        sbSource.append("%mend;\n");
        sbSource.append("%getCols; \n");
        sbSource.append(this.genTableDelete("work", "etls_nms"));
        WsAppServer appServer = this.m_model.getAppServer();
        if (appServer == null) {
            return new ArrayList();
        }
        Workspace.getDefaultLogger().debug((Object)sbSource.toString());
        appServer.close();
        appServer.submitSASCode(sbSource.toString());
        ArrayList alAttributeNames = (ArrayList)this.getColumnAttributeNames(metaLibDotTable);
        ArrayList alColumns = (ArrayList)this.getColumnMetadata(metaLibDotTable);
        ArrayList alColumnMetadataObjects = new ArrayList(alColumns.size());
        alColumnMetadataObjects = (ArrayList)this.createColumnMetadataObjects(alAttributeNames, alColumns);
        appServer.closeSQLConnection();
        appServer.submitSASCode(this.genTableDelete("work", metaTable));
        return alColumnMetadataObjects;
    }

    public String genTableDelete(String lib, String tableName) {
        StringBuffer sbDeleteSyntax = new StringBuffer(200);
        sbDeleteSyntax.append("proc datasets lib = ");
        sbDeleteSyntax.append(lib);
        sbDeleteSyntax.append(" nolist nowarn memtype = (data view);\n");
        sbDeleteSyntax.append("   delete ");
        sbDeleteSyntax.append(tableName);
        sbDeleteSyntax.append(";\n");
        sbDeleteSyntax.append("quit;\n\n");
        return sbDeleteSyntax.toString();
    }

    private List getColumnAttributeNames(String tabName) throws WsAppServerFailException {
        ResultSetMetaData m_metadata = null;
        int colCount = 0;
        String m_submitStmt = "select * from " + tabName;
        MVAResultSet rsltSet = this.m_model.getAppServer().submitSQLStatement(m_submitStmt);
        if (m_metadata == null) {
            try {
                m_metadata = rsltSet.getMetaData();
                colCount = m_metadata.getColumnCount();
            }
            catch (SQLException sqe) {
                MessageUtil.displayMessage((String)sqe.getLocalizedMessage(), (int)0);
            }
        }
        ArrayList<String> alColMetadata = new ArrayList<String>(colCount);
        for (int i = 0; i < colCount; ++i) {
            try {
                alColMetadata.add(m_metadata.getColumnName(i + 1));
                continue;
            }
            catch (SQLException sqe) {
                MessageUtil.displayMessage((String)sqe.getLocalizedMessage(), (int)0);
            }
        }
        return alColMetadata;
    }

    private List getColumnMetadata(String tabName) throws SQLException, WsAppServerFailException {
        ResultSetMetaData m_metadata = null;
        int colCount = 0;
        ArrayList alColumns = new ArrayList(50);
        String m_submitStmt = "select * from " + tabName;
        MVAResultSet rsltSet = this.m_model.getAppServer().submitSQLStatement(m_submitStmt);
        if (m_metadata == null) {
            m_metadata = rsltSet.getMetaData();
            colCount = m_metadata.getColumnCount();
        }
        while (rsltSet.next()) {
            ArrayList<String> alRow = new ArrayList<String>(colCount);
            for (int i = 1; i <= colCount; ++i) {
                String value = rsltSet.getString(i).trim();
                alRow.add(value);
            }
            alColumns.add(alRow);
        }
        try {
            rsltSet.close();
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return alColumns;
    }

    private List createColumnMetadataObjects(List alAttributeNames, List alColumns) {
        String space4 = "    ";
        String space = " ";
        ArrayList<Column> alColumnObjects = new ArrayList<Column>();
        try {
            for (int row = 0; row < alColumns.size(); ++row) {
                Column column = (Column)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, "Column" + String.valueOf(row + 1), "Column", this.m_model.getExternalTable().getRepositoryID());
                column.setIsNullable(1);
                boolean bReadColumnFlag = true;
                column.setPublicType("Column");
                column.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
                ArrayList columnValues = (ArrayList)alColumns.get(row);
                for (int attrPosn = 0; attrPosn < alAttributeNames.size(); ++attrPosn) {
                    String attribute = ((String)alAttributeNames.get(attrPosn)).trim();
                    String value = (String)columnValues.get(attrPosn);
                    try {
                        if (attribute.equalsIgnoreCase("BeginPosition")) {
                            if (value.length() <= 0) continue;
                            column.setBeginPosition(Integer.parseInt(value));
                            continue;
                        }
                        if (attribute.compareToIgnoreCase("ColumnLength") == 0) {
                            if (value.length() <= 0) continue;
                            column.setColumnLength(Integer.parseInt(value));
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("ColumnName")) {
                            if (value != null && value.length() > 32) {
                                value = value.substring(0, 32);
                            }
                            column.setColumnName(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("ColumnType")) {
                            column.setColumnType(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("Desc")) {
                            if (value != null && value.length() > m_fieldLength) {
                                value = value.substring(0, m_fieldLength);
                            }
                            column.setDesc(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("EndPosition")) {
                            if (value.length() <= 0) continue;
                            column.setEndPosition(Integer.parseInt(value));
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("IsDiscrete")) {
                            if (value.length() <= 0) continue;
                            column.setIsDiscrete(Integer.parseInt(value));
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("IsNullable")) {
                            if (value.length() <= 0) continue;
                            column.setIsNullable(Integer.parseInt(value));
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("Name")) {
                            column.setName(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("SASAttribute")) {
                            column.setSASAttribute(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("SASColumnLength")) {
                            if (value.length() <= 0) continue;
                            column.setSASColumnLength(Integer.parseInt(value));
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("SASColumnName")) {
                            if (value != null && value.length() > 32) {
                                value = value.substring(0, 32);
                            }
                            column.setSASColumnName(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("SASColumnType")) {
                            if (value.length() <= 0) continue;
                            column.setSASColumnType(value.substring(0, 1).toUpperCase());
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("SASExtendedColumnType")) {
                            column.setSASExtendedColumnType(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("SASExtendedLength")) {
                            column.setSASExtendedLength(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("SASFormat")) {
                            column.setSASFormat(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("SASInformat")) {
                            column.setSASInformat(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("SortOrder")) {
                            column.setSortOrder(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("SummaryRole")) {
                            column.setSummaryRole(value);
                            continue;
                        }
                        if (attribute.equalsIgnoreCase(READFLAG)) {
                            if (value.length() <= 0 || !this.m_model.isFixedWidth() || value.charAt(0) != 'n' && value.charAt(0) != 'N') continue;
                            bReadColumnFlag = false;
                            continue;
                        }
                        if (row != 0) continue;
                        this.m_alMessages.add(new ImportColumnsMessage(row + 1, attrPosn + 1, attribute, "", bundle.getString("ImportColumnsFromEFF.Error.InvalidAttribute.txt"), 2, false));
                        StringBuffer sbMsg = new StringBuffer(100);
                        sbMsg.append(bundle.getString("ImportColumnsFromEFF.Error.InvalidAttribute.txt"));
                        sbMsg.append(space4);
                        sbMsg.append(bundle.getString("ImportColumnsFromEFF.Row.txt"));
                        sbMsg.append(space + (row + 1));
                        sbMsg.append(space4);
                        sbMsg.append(bundle.getString("ImportColumnsFromEFF.Column.txt"));
                        sbMsg.append(space + (attrPosn + 1));
                        sbMsg.append(space4);
                        sbMsg.append(bundle.getString("ImportColumnsFromEFF.ColumnAttribute.txt"));
                        sbMsg.append(space);
                        sbMsg.append(attribute);
                        Workspace.getDefaultLogger().debug((Object)sbMsg.toString());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.m_alMessages.add(new ImportColumnsMessage(row + 1, attrPosn + 1, attribute, value, bundle.getString("ImportColumnsFromEFF.Error.IntegerValueExpected.txt"), 2, true));
                        StringBuffer sbMsg = new StringBuffer(100);
                        sbMsg.append(bundle.getString("ImportColumnsFromEFF.Error.IntegerValueExpected.txt"));
                        sbMsg.append(space4);
                        sbMsg.append(bundle.getString("ImportColumnsFromEFF.Row.txt"));
                        sbMsg.append(space + (row + 1));
                        sbMsg.append(space4);
                        sbMsg.append(bundle.getString("ImportColumnsFromEFF.Column.txt"));
                        sbMsg.append(space + (attrPosn + 1));
                        sbMsg.append(space4);
                        sbMsg.append(bundle.getString("ImportColumnsFromEFF.ColumnAttribute.txt"));
                        sbMsg.append(space);
                        sbMsg.append(attribute);
                        sbMsg.append(space4);
                        sbMsg.append(bundle.getString("ImportColumnsFromEFF.ColumnValue.txt"));
                        sbMsg.append(space);
                        sbMsg.append(value);
                        Workspace.getDefaultLogger().debug((Object)sbMsg.toString());
                    }
                }
                this.checkEndPosnGreaterThanBeginPosn(column, row + 1);
                this.updateSASColumnName(column);
                this.updateSASColumnLength(column);
                if (column.getSASColumnName().length() == 0 || !bReadColumnFlag) {
                    column.delete();
                    this.m_alMessages.add(new ImportColumnsMessage(row, 0, "SASColumnName", "", bundle.getString("ImportColumnsFromEFF.Error.NoName.txt"), 2, true));
                    continue;
                }
                alColumnObjects.add(column);
            }
            return alColumnObjects;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return alColumnObjects;
        }
    }

    private void checkEndPosnGreaterThanBeginPosn(Column column, int row) {
        try {
            if (column.getEndPosition() < column.getBeginPosition()) {
                int beginPosn = column.getBeginPosition();
                String sEndPosn = String.valueOf(column.getEndPosition());
                column.setEndPosition(beginPosn);
                String msgString = bundle.formatString("ImportColumnsFromEFF.Error.StartEndPosn.fmt.txt", (Object)sEndPosn, (Object)String.valueOf(beginPosn));
                this.m_alMessages.add(new ImportColumnsMessage(row, 0, "EndPosition", sEndPosn, msgString, 2, true));
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void updateSASColumnName(Column column) {
        try {
            if (column.getSASColumnName().length() == 0) {
                if (column.getColumnName().length() > 0) {
                    column.setSASColumnName(column.getColumnName());
                } else {
                    column.setSASColumnName(column.getName());
                }
            }
            if (column.getColumnName().length() == 0) {
                if (column.getSASColumnName().length() > 0) {
                    column.setColumnName(column.getSASColumnName());
                } else {
                    column.setColumnName(column.getName());
                }
            }
            if (column.getName().length() == 0) {
                if (column.getSASColumnName().length() > 0) {
                    column.setName(column.getSASColumnName());
                } else {
                    column.setName(column.getColumnName());
                }
            }
            if (column.getName().compareTo(column.getSASColumnName()) != 0) {
                column.setName(column.getSASColumnName());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void updateSASColumnLength(Column column) {
        try {
            if (column.getSASColumnLength() == 0 && column.getColumnLength() > 0) {
                column.setSASColumnLength(column.getColumnLength());
            }
            if (column.getColumnLength() == 0 && column.getSASColumnLength() > 0) {
                column.setColumnLength(column.getSASColumnLength());
            }
            if (column.getColumnType() == 1) {
                if (column.getSASColumnLength() == 0 && column.getEndPosition() > 0 && column.getBeginPosition() > 0) {
                    column.setSASColumnLength(column.getEndPosition() - column.getBeginPosition() + 1);
                }
            } else if (column.getColumnType() == 2) {
                if (column.getSASColumnLength() > 8) {
                    column.setSASColumnLength(8);
                } else if (column.getSASColumnLength() > 0 && column.getSASColumnLength() < 3) {
                    column.setSASColumnLength(3);
                }
            }
            if (column.getSASColumnLength() == 0) {
                column.setSASColumnLength(8);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setMessagesList(List messages) {
        this.m_alMessages = (ArrayList)messages;
    }

    public List getMessagesList() {
        return this.m_alMessages;
    }

    static {
        m_fieldLength = 200;
        metaLib = "work";
        metaTable = "etls_Mta";
        READFLAG = "READFLAG";
        bundle = WAdminResource.getBundle(ImportColumnsFromEFF.class);
    }
}

