/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.externalfile.IFixedWidthExternalFile;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.efi2.AdvancedExternalFileParametersPanel2;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.apache.commons.configuration.ConfigurationException;

public class FixedWidthExternalTablePanel2
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(FixedWidthExternalTablePanel2.class);
    public static final String ShowAutoResetConfirmProperty = "FixedWidthExternalTablePanel2.ShowAutoResetConfirmMessage";
    public static final String AutoResetProperty = "FixedWidthExternalTablePanel2.AutoResetLRECL";
    private IExternalTable m_mdlTable;
    private IFixedWidthExternalFile m_mdlFixedWidth;
    private boolean m_bSelectedNewFile;
    private JLabel m_lblDisabled;
    private JCheckBox m_ckbPadValuesWithBlanks;
    private JCheckBox m_ckbUnassignedAsMissing;
    private JLabel m_lblRecordLength;
    private WAIntTextField m_txtRecordLength;
    private WsAbstractAction m_actAdvanced;
    private JButton m_btnAdvanced;
    private ItemListener m_lsnrCheckbox;
    private IModelListener m_lsnrModel;

    public FixedWidthExternalTablePanel2(IExternalTable mdlTable) {
        this.m_mdlTable = mdlTable;
        this.m_mdlFixedWidth = (IFixedWidthExternalFile)mdlTable.getFile();
        this.m_bSelectedNewFile = false;
        this.setHelpProduct("wdb");
        this.setHelpTopic("fixed_width_parameters");
        this.initialize();
    }

    protected void initialize() {
        this.m_lblDisabled = new JLabel(bundle.getString("FixedWidthExternalTablePanel.Label.Disabled.txt"));
        this.m_lblDisabled.setFont(this.m_lblDisabled.getFont().deriveFont(1));
        this.m_lblDisabled.setVisible(false);
        this.m_lsnrCheckbox = new cCheckboxListener();
        this.m_ckbPadValuesWithBlanks = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"FixedWidthExternalTablePanel.Checkbox.PadValuesWithBlanks");
        this.m_ckbUnassignedAsMissing = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"FixedWidthExternalTablePanel.Checkbox.UnassignedAsMissing");
        this.m_ckbPadValuesWithBlanks.addItemListener(this.m_lsnrCheckbox);
        this.m_ckbUnassignedAsMissing.addItemListener(this.m_lsnrCheckbox);
        this.m_txtRecordLength = new WAIntTextField();
        this.m_txtRecordLength.setColumns(5);
        this.m_lblRecordLength = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtRecordLength, (WAdminResource)bundle, (String)"FixedWidthExternalTablePanel.Label.LogicalRecordLength");
        this.listenForDataChangesTo(this.m_ckbPadValuesWithBlanks);
        this.listenForDataChangesTo(this.m_ckbUnassignedAsMissing);
        this.listenForDataChangesTo((JTextComponent)this.m_txtRecordLength);
        this.m_lsnrModel = new ModelListener();
        this.m_mdlTable.getModel().addModelListener(this.m_lsnrModel);
        this.m_actAdvanced = new cAdvancedAction();
        this.m_btnAdvanced = new JButton((Action)this.m_actAdvanced);
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblDisabled, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_ckbPadValuesWithBlanks, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_ckbUnassignedAsMissing, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblRecordLength, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtRecordLength, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_btnAdvanced, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 14, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_ckbPadValuesWithBlanks.setSelected(this.m_mdlFixedWidth.isPadColumnValuesEnabled());
        this.m_ckbUnassignedAsMissing.setSelected(this.m_mdlFixedWidth.isTruncoverEnabled());
        if (this.m_mdlFixedWidth.getRecordLength() > 0 && !this.m_bSelectedNewFile) {
            this.m_txtRecordLength.setValue(this.m_mdlFixedWidth.getRecordLength());
        } else if (this.m_mdlFixedWidth.getServer() == null && this.doesFileExist()) {
            this.m_txtRecordLength.setValue(Math.min(Math.max(ExternalTableDataModel.getDefaultLogicalRecordLength(), this.getRecordLengthGuess()), ExternalTableDataModel.getMaximumLogicalRecordLength()));
        } else {
            boolean bResetValue = true;
            if (this.m_bSelectedNewFile) {
                bResetValue = this.getUserPreferenceAutoReset();
                if (this.getUserPreferenceToShowTheAutoResetMessage()) {
                    bResetValue = this.showResetLRECLConfirmMessage();
                }
            }
            if (bResetValue) {
                this.m_txtRecordLength.setValue(ExternalTableDataModel.getDefaultLogicalRecordLength());
            }
        }
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    private boolean showResetLRECLConfirmMessage() {
        String sMessage = bundle.getString("FixedWidthExternalTablePanel2.AutoResetLRECL.Msg.txt");
        String m_sRealTitle = bundle.getString("FixedWidthExternalTablePanel2.AutoResetLRECL.Title.txt");
        JCheckBox ckbDoNotShow = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"FixedWidthExternalTablePanel2.AutoResetLRECL.DoNotShow.CheckBox", (int)5);
        Object[] oaMessage = new Object[]{sMessage, " ", ckbDoNotShow};
        boolean bResetValue = 0 == JOptionPane.showConfirmDialog((Component)Workspace.getWorkspace(), oaMessage, m_sRealTitle, 0, 2);
        this.setUserPreferenceToShowTheAutoResetMessage(!ckbDoNotShow.isSelected());
        this.setUserPreferenceAutoReset(bResetValue);
        return bResetValue;
    }

    private boolean getUserPreferenceToShowTheAutoResetMessage() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(ShowAutoResetConfirmProperty, true);
    }

    private void setUserPreferenceToShowTheAutoResetMessage(boolean isShow) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(ShowAutoResetConfirmProperty, isShow);
    }

    private boolean getUserPreferenceAutoReset() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(AutoResetProperty, true);
    }

    private void setUserPreferenceAutoReset(boolean isAutoReset) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(AutoResetProperty, isAutoReset);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_mdlFixedWidth.setRecordLength(this.m_txtRecordLength.getValue());
        this.m_bSelectedNewFile = false;
        this.setDataChanged(false);
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlTable.getModel().removeModelListener(this.m_lsnrModel);
    }

    public boolean validateData() {
        if (this.m_txtRecordLength.getText().length() <= 0) {
            MessageUtil.displayMessage((String)bundle.getString("FixedWidthExternalTablePanel.Error.MissingRecordLength.txt"), (int)0);
            this.m_txtRecordLength.requestFocus();
            return false;
        }
        if (this.m_txtRecordLength.getValue() > ExternalTableDataModel.getMaximumLogicalRecordLength()) {
            MessageUtil.displayMessage((String)bundle.getString("FixedWidthExternalTablePanel.Error.InvalidRecordLength.txt"), (int)0);
            this.m_txtRecordLength.requestFocus();
            return false;
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    private void updateComponents() {
        boolean bEnabled = this.isEditable() && !this.m_mdlFixedWidth.getInfileOverrideFlag();
        this.m_ckbPadValuesWithBlanks.setEnabled(bEnabled);
        this.m_ckbUnassignedAsMissing.setEnabled(bEnabled);
        this.m_txtRecordLength.setEnabled(bEnabled);
        this.m_lblDisabled.setVisible(this.m_mdlFixedWidth.getInfileOverrideFlag());
    }

    private boolean doesFileExist() {
        try {
            WsAppServer appServer = WsAppServer.createAppServer((String)this.m_mdlFixedWidth.getServer().getID());
            if (appServer != null) {
                return appServer.doesFileExist(this.m_mdlTable.getAccessMethodFileName(this.m_mdlFixedWidth.getFileName()), this.m_mdlTable.getAccessMethodNickName(), this.m_mdlTable.getAccessMethodOptions("_temp"), this.m_mdlTable.getAccessMethodPreCode("_temp"));
            }
        }
        catch (BadServerDefinitionException ex) {
            return false;
        }
        catch (ConfigurationException ex) {
            return false;
        }
        catch (CodegenException ex) {
            return false;
        }
        catch (WsAppServerFailException ex) {
            return false;
        }
        catch (GenericError e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRecordLengthGuess() {
        try {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow().setCursor(Cursor.getPredefinedCursor(3));
            WsAppServer appServer = WsAppServer.createAppServer((String)this.m_mdlFixedWidth.getServer().getID());
            if (appServer == null) {
                int n = 0;
                return n;
            }
            String sEncoding = this.m_mdlTable.getInfileEncodingTextQuoted();
            String sOptions = !sEncoding.equals("") ? "encoding=" + sEncoding : "";
            String[] lines = appServer.readLinesFromFile(1, 100, this.m_mdlFixedWidth.getFileName(), sOptions);
            int iMax = 0;
            for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
                iMax = Math.max(iMax, lines[lineIndex].length());
            }
            int n = iMax;
            return n;
        }
        catch (GenericError e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        finally {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow().setCursor(Cursor.getDefaultCursor());
        }
        return 0;
    }

    private class cCheckboxListener
    implements ItemListener {
        private cCheckboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean bEnabled;
            JCheckBox ckb = (JCheckBox)e.getItemSelectable();
            boolean bl = bEnabled = ckb.isSelected() && FixedWidthExternalTablePanel2.this.isEditable();
            if (ckb == FixedWidthExternalTablePanel2.this.m_ckbPadValuesWithBlanks) {
                FixedWidthExternalTablePanel2.this.m_mdlFixedWidth.setPadColumnValuesEnabled(bEnabled);
            } else if (ckb == FixedWidthExternalTablePanel2.this.m_ckbUnassignedAsMissing) {
                FixedWidthExternalTablePanel2.this.m_mdlFixedWidth.setTruncoverEnabled(bEnabled);
            }
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String type = ev.getType();
            if (type.equals("ExternalTable:TruncoverChanged")) {
                FixedWidthExternalTablePanel2.this.m_ckbUnassignedAsMissing.setSelected(FixedWidthExternalTablePanel2.this.m_mdlFixedWidth.isTruncoverEnabled());
            } else if (type.equals("ExternalTable:PadColumnValuesChanged")) {
                FixedWidthExternalTablePanel2.this.m_ckbPadValuesWithBlanks.setSelected(FixedWidthExternalTablePanel2.this.m_mdlFixedWidth.isPadColumnValuesEnabled());
            } else if (type.equals("ExternalTable:RecordLengthChanged")) {
                FixedWidthExternalTablePanel2.this.m_txtRecordLength.setText("" + FixedWidthExternalTablePanel2.this.m_mdlFixedWidth.getRecordLength());
            } else if (type.equals("IFile:FileNameChanged")) {
                FixedWidthExternalTablePanel2.this.m_bSelectedNewFile = true;
            }
        }
    }

    private class cAdvancedAction
    extends WsAbstractAction {
        public cAdvancedAction() {
            super(bundle, "FixedWidthExternalTablePanel.Action.Advanced", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!FixedWidthExternalTablePanel2.this.validateData()) {
                return;
            }
            try {
                FixedWidthExternalTablePanel2.this.moveDataToStore();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                return;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            ModelUIUtilities.showDialog((IObject)FixedWidthExternalTablePanel2.this.m_mdlTable, bundle.getString("FixedWidthExternalTablePanel.AdvancedDialog.Title.txt"), new AdvancedExternalFileParametersPanel2(FixedWidthExternalTablePanel2.this.m_mdlTable));
            FixedWidthExternalTablePanel2.this.updateComponents();
        }
    }
}

