/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.efi2.AdvancedExternalFileParametersPanel;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.GuessingRowsModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class FixedWidthExternalTablePanel
extends WsDescriptionWizardTab {
    private static WAdminResource bundle = WAdminResource.getBundle(FixedWidthExternalTablePanel.class);
    private ExternalTableDataModel m_mdlTable;
    private JLabel m_lblDisabled;
    private JCheckBox m_ckbPadValuesWithBlanks;
    private JCheckBox m_ckbUnassignedAsMissing;
    private JLabel m_lblRecordLength;
    private WAIntTextField m_txtRecordLength;
    private WsAbstractAction m_actAdvanced;
    private JButton m_btnAdvanced;
    private boolean m_preserveView;

    public FixedWidthExternalTablePanel(ExternalTableDataModel mdlTable) {
        super(bundle.getString("FixedWidthExternalTablePanel.Description.txt"));
        this.m_mdlTable = mdlTable;
        this.m_preserveView = false;
        this.setHelpProduct("wdb");
        this.setHelpTopic("fixed_width_parameters");
        this.initialize();
    }

    protected void initialize() {
        this.m_lblDisabled = new JLabel(bundle.getString("FixedWidthExternalTablePanel.Label.Disabled.txt"));
        this.m_lblDisabled.setFont(this.m_lblDisabled.getFont().deriveFont(1));
        this.m_lblDisabled.setVisible(false);
        this.m_ckbPadValuesWithBlanks = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"FixedWidthExternalTablePanel.Checkbox.PadValuesWithBlanks");
        this.m_ckbUnassignedAsMissing = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"FixedWidthExternalTablePanel.Checkbox.UnassignedAsMissing");
        this.m_txtRecordLength = new WAIntTextField();
        this.m_txtRecordLength.setColumns(5);
        this.m_lblRecordLength = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtRecordLength, (WAdminResource)bundle, (String)"FixedWidthExternalTablePanel.Label.LogicalRecordLength");
        this.listenForDataChangesTo(this.m_ckbPadValuesWithBlanks);
        this.listenForDataChangesTo(this.m_ckbUnassignedAsMissing);
        this.listenForDataChangesTo((JTextComponent)this.m_txtRecordLength);
        this.m_actAdvanced = new cAdvancedAction();
        this.m_btnAdvanced = new JButton((Action)this.m_actAdvanced);
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblDisabled, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_ckbPadValuesWithBlanks, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_ckbUnassignedAsMissing, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblRecordLength, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtRecordLength, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_btnAdvanced, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 14, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void onNext() {
        try {
            this.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void onBack() {
        this.m_preserveView = true;
        this.m_mdlTable.setSelectedNewFile(false);
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlTable.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this.m_preserveView && !this.m_mdlTable.hasSelectedNewFile()) {
            return;
        }
        this.setListeningForChanges(false);
        this.m_ckbPadValuesWithBlanks.setSelected(this.m_mdlTable.isFixedPad());
        this.m_ckbUnassignedAsMissing.setSelected(this.m_mdlTable.isFixedTruncover());
        if (this.m_mdlTable.getLogicalRecordLength() > 0 && !this.m_mdlTable.hasSelectedNewFile()) {
            this.m_txtRecordLength.setValue(this.m_mdlTable.getLogicalRecordLength());
        } else if (this.m_mdlTable.fileExists()) {
            try {
                this.m_mdlTable.loadGuessingRows();
            }
            catch (GuessingRowsModel.StartValueTooLargeException startValueTooLargeException) {
                // empty catch block
            }
            this.m_txtRecordLength.setValue(Math.min(Math.max(ExternalTableDataModel.getDefaultLogicalRecordLength(), this.m_mdlTable.getMaximumGuessingRowLength()), ExternalTableDataModel.getMaximumLogicalRecordLength()));
        } else {
            this.m_txtRecordLength.setValue(ExternalTableDataModel.getDefaultLogicalRecordLength());
        }
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_preserveView = false;
        this.m_mdlTable.setFixedPad(this.m_ckbPadValuesWithBlanks.isSelected());
        this.m_mdlTable.setFixedTruncover(this.m_ckbUnassignedAsMissing.isSelected());
        this.m_mdlTable.setLogicalRecordLength(this.m_txtRecordLength.getValue());
        this.setDataChanged(false);
    }

    public boolean validateData() {
        if (this.m_txtRecordLength.getText().length() <= 0) {
            MessageUtil.displayMessage((String)bundle.getString("FixedWidthExternalTablePanel.Error.MissingRecordLength.txt"), (int)0);
            this.m_txtRecordLength.requestFocus();
            return false;
        }
        if (this.m_txtRecordLength.getValue() > ExternalTableDataModel.getMaximumLogicalRecordLength()) {
            MessageUtil.displayMessage((String)bundle.getString("FixedWidthExternalTablePanel.Error.InvalidRecordLength.txt"), (int)0);
            this.m_txtRecordLength.requestFocus();
            return false;
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    private void updateComponents() {
        boolean bEnabled = this.isEditable() && !this.m_mdlTable.isInfileOverriden();
        this.m_ckbPadValuesWithBlanks.setEnabled(bEnabled);
        this.m_ckbUnassignedAsMissing.setEnabled(bEnabled);
        this.m_txtRecordLength.setEnabled(bEnabled);
        this.m_lblDisabled.setVisible(this.m_mdlTable.isInfileOverriden());
    }

    private class cAdvancedAction
    extends WsAbstractAction {
        public cAdvancedAction() {
            super(bundle, "FixedWidthExternalTablePanel.Action.Advanced", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!FixedWidthExternalTablePanel.this.validateData()) {
                return;
            }
            try {
                FixedWidthExternalTablePanel.this.moveDataToStore();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                return;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("FixedWidthExternalTablePanel.AdvancedDialog.Title.txt"), true);
            dlg.setMainPanel((WAPanel)new AdvancedExternalFileParametersPanel(FixedWidthExternalTablePanel.this.m_mdlTable));
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                FixedWidthExternalTablePanel.this.updateComponents();
            }
        }
    }
}

