/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.wadmin.efi2.RecordTokenizerInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DelimitedRecordTokenizer
implements RecordTokenizerInterface {
    private static final String QUOTING_PATTERN = "[\"']";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";
    protected String m_record;
    protected int m_index = 0;
    protected StringBuffer m_field = new StringBuffer();
    protected ArrayList m_fields = new ArrayList();
    private String m_delimiters;
    private String m_delimiterPattern;
    private boolean m_skipConsecutiveDelimiters;
    private boolean m_stripQuotes;
    private HashMap m_quotePatterns;

    public DelimitedRecordTokenizer(String record, String delimiters, boolean skipConsecutiveDelimiters) {
        this(delimiters, skipConsecutiveDelimiters);
        this.m_record = record;
    }

    public DelimitedRecordTokenizer(String delimiters, boolean skipConsecutiveDelimiters) {
        this.m_delimiters = this.escapeString(delimiters);
        this.m_delimiterPattern = "[" + this.m_delimiters + "]";
        this.m_skipConsecutiveDelimiters = skipConsecutiveDelimiters;
        this.m_stripQuotes = !skipConsecutiveDelimiters;
        Pattern endDoubleQuote = Pattern.compile("\"(?:[" + this.m_delimiters + "]|$)");
        Pattern endSingleQuote = Pattern.compile("'(?:[" + this.m_delimiters + "]|$)");
        this.m_quotePatterns = new HashMap();
        this.m_quotePatterns.put(SINGLE_QUOTE, endSingleQuote);
        this.m_quotePatterns.put(DOUBLE_QUOTE, endDoubleQuote);
    }

    public void reset() {
        this.m_index = 0;
        this.m_field.setLength(0);
        this.m_fields.clear();
    }

    @Override
    public void setRecord(String record) {
        this.m_record = record;
        this.reset();
    }

    @Override
    public List splitRecord() {
        String character = this.beginLine();
        while (!this.endOfLine()) {
            String field;
            if (this.m_stripQuotes && this.isQuote(character) && (this.beginningOfLine() || this.isDelimiter(this.peekPreviousCharacter())) && (field = this.getQuotedField(character)) != null) {
                this.addField(field);
            } else if (this.isDelimiter(character)) {
                if (this.m_skipConsecutiveDelimiters) {
                    this.skipDelimiters();
                }
                this.addField();
            } else {
                this.m_field.append(character);
                if (this.lastCharacterOnLine()) {
                    this.addField();
                }
            }
            character = this.nextCharacter();
        }
        return this.m_fields;
    }

    private boolean isQuote(String character) {
        return character.matches(QUOTING_PATTERN);
    }

    private boolean isDelimiter(String character) {
        return character.matches(this.m_delimiterPattern);
    }

    private String getQuotedField(String quote) {
        int startPosition;
        Matcher matcher = ((Pattern)this.m_quotePatterns.get(quote)).matcher(this.m_record);
        if (matcher.find(startPosition = this.m_index + 1)) {
            this.m_index = matcher.end() - 1;
            return this.m_record.substring(startPosition, matcher.start());
        }
        return null;
    }

    private void skipDelimiters() {
        String character = this.getCharacter();
        while (character != null && this.isDelimiter(character)) {
            character = this.nextCharacter();
        }
        if (!this.endOfLine() && !this.beginningOfLine()) {
            this.previousCharacter();
        }
    }

    protected String escapeString(String string) {
        String result = string.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("\\^", "\\\\^");
        result = result.replaceAll("-", "\\\\-");
        result = result.replaceAll("\\[", "\\\\[");
        result = result.replaceAll("\\]", "\\\\]");
        return result;
    }

    protected String getCharacter() {
        if (this.m_index < this.m_record.length()) {
            return String.valueOf(this.m_record.charAt(this.m_index));
        }
        return null;
    }

    protected String nextCharacter() {
        if (this.m_index < this.m_record.length()) {
            ++this.m_index;
            return this.getCharacter();
        }
        return null;
    }

    protected String previousCharacter() {
        if (this.m_index > 0) {
            --this.m_index;
            return this.getCharacter();
        }
        return null;
    }

    protected String peekNextCharacter() {
        if (this.m_index < this.m_record.length() - 1) {
            return String.valueOf(this.m_record.charAt(this.m_index + 1));
        }
        return null;
    }

    protected String peekPreviousCharacter() {
        if (this.m_index > 0 && this.m_record.length() > 0) {
            return String.valueOf(this.m_record.charAt(this.m_index - 1));
        }
        return null;
    }

    protected boolean beginningOfLine() {
        return this.m_index == 0;
    }

    protected boolean lastCharacterOnLine() {
        return this.m_index == this.m_record.length() - 1;
    }

    protected boolean endOfLine() {
        return this.m_index >= this.m_record.length();
    }

    protected int getRecordLength() {
        return this.m_record.length();
    }

    protected String beginLine() {
        this.m_index = 0;
        this.m_field.setLength(0);
        return this.getCharacter();
    }

    protected void addField() {
        this.addField(this.m_field.toString());
    }

    protected void addField(String field) {
        this.m_fields.add(field);
        this.m_field.setLength(0);
    }
}

