/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.rio.MVAResultSet;
import com.sas.wadmin.efi2.COB2SASRunResultFileStructure;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;

public final class COBOL2SAS {
    private static WAdminResource bundle = WAdminResource.getBundle(COBOL2SAS.class);
    private WsAppServer m_wsAppServer;
    private String m_effDirectory;
    private String m_sasLogDirectory;
    private String m_cob2sasLocation;
    private String m_strOS;
    private String m_SASOptions;
    private String m_logFileName;
    private static String SASColumnSourceFile = "sourcefile";
    private static String SASColumnEFF_File = "filename";
    private static String SummaryOutputDataset = "work.etls_smy";

    public COBOL2SAS(WsAppServer appServer) {
        this.m_wsAppServer = appServer;
    }

    public void setEFFDirectory(String EFFDirectory) {
        this.m_effDirectory = COBOL2SAS.completeDirectory(EFFDirectory);
    }

    public void setSASLogDirectory(String sasLogDirectory) {
        this.m_sasLogDirectory = COBOL2SAS.completeDirectory(sasLogDirectory);
    }

    public void setSASOptions(String sasOptions) {
        this.m_SASOptions = sasOptions;
    }

    public void setCOB2SASLocation(String COB2SASLocation) {
        this.m_cob2sasLocation = COB2SASLocation;
    }

    public void setOperatingSystem(String strOS) {
        this.m_strOS = strOS;
    }

    public void setLogFileName(String logFileName) {
        StringBuffer fullPath = new StringBuffer();
        fullPath.append(this.m_sasLogDirectory);
        fullPath.append(logFileName);
        this.m_logFileName = fullPath.toString();
    }

    public String getLogFileName() {
        return this.m_logFileName;
    }

    public void submitCOB2SASCode(DefaultListModel lCopybookFiles) throws WsAppServerCodeException, WsAppServerFailException {
        StringBuffer sasCode = new StringBuffer();
        for (int files = 0; files < lCopybookFiles.size(); ++files) {
            String suggestedCSVFilename = this.getFileNameWithoutDotAndType((String)lCopybookFiles.get(files));
            if (files == 0) {
                this.setLogFileName(suggestedCSVFilename + ".log");
            }
            this.buildCOB2SASCode(sasCode, (String)lCopybookFiles.get(files), suggestedCSVFilename);
            this.cleanseCOB2SASResults(sasCode, (String)lCopybookFiles.get(files), suggestedCSVFilename);
            this.appendDatasets(sasCode);
        }
        this.submitSASCode(sasCode);
    }

    public String getFileNameWithoutDotAndType(String copybook) {
        String filenameWithoutType = copybook;
        String fileSeparator = COBOL2SAS.getFileSeparator(copybook);
        int beginFilenamePosition = -1;
        if (fileSeparator != "") {
            beginFilenamePosition = copybook.lastIndexOf(fileSeparator);
        }
        if (fileSeparator == ".") {
            String trimDotExtension = copybook.substring(0, beginFilenamePosition);
            beginFilenamePosition = trimDotExtension.lastIndexOf(fileSeparator);
        }
        int lastPeriodPosition = copybook.length();
        if (copybook.lastIndexOf(46) > 0) {
            lastPeriodPosition = copybook.lastIndexOf(46);
        }
        filenameWithoutType = lastPeriodPosition > 0 ? copybook.substring(beginFilenamePosition + 1, lastPeriodPosition) : copybook.substring(beginFilenamePosition + 1, copybook.length());
        return filenameWithoutType;
    }

    public static String completeDirectory(String directory) {
        int fileSeparatorPosition = -1;
        String fileSeparator = COBOL2SAS.getFileSeparator(directory);
        if (fileSeparator.length() == 0) {
            return directory;
        }
        fileSeparatorPosition = directory.lastIndexOf(fileSeparator);
        if (fileSeparatorPosition != directory.length() - 1) {
            StringBuffer newDirectory = new StringBuffer();
            newDirectory.append(directory);
            newDirectory.append(directory.substring(fileSeparatorPosition, fileSeparatorPosition + 1));
            directory = newDirectory.toString();
        }
        return directory;
    }

    public static String getFileSeparator(String path) {
        String fileSeparator = "";
        if (path.indexOf("\\") >= 0) {
            return "\\";
        }
        if (path.indexOf("/") >= 0) {
            return "/";
        }
        if (path.indexOf(".") >= 0) {
            return ".";
        }
        String msgString = bundle.formatString("COBOL2SAS.Error.FileSeparator.fmt.txt", (Object)path);
        MessageUtil.displayMessage((String)msgString, (int)2);
        return fileSeparator;
    }

    private void buildCOB2SASCode(StringBuffer sasCode, String copybook, String suggestedCSVFilename) {
        sasCode.append("\nfilename cob2sas '");
        sasCode.append(this.m_cob2sasLocation);
        sasCode.append("'; \n");
        sasCode.append("\n");
        sasCode.append("filename incobol '");
        sasCode.append(copybook);
        sasCode.append("';\n");
        int length = this.m_effDirectory.length();
        if (this.m_effDirectory.indexOf(".", length - 1) > 0) {
            this.m_effDirectory = this.m_effDirectory.substring(0, length - 1);
        }
        sasCode.append("filename outsas  '");
        sasCode.append(this.m_effDirectory);
        if (this.m_effDirectory.toLowerCase().indexOf("mvs:") >= 0) {
            sasCode.append("(");
            sasCode.append(suggestedCSVFilename);
            sasCode.append(")");
        } else {
            sasCode.append(suggestedCSVFilename);
            sasCode.append(".out");
        }
        sasCode.append("'  ; \n");
        sasCode.append("libname  perm '");
        try {
            sasCode.append(this.m_wsAppServer.getLibraryPath("work"));
        }
        catch (WsAppServerFailException wsfe) {
            MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
        }
        sasCode.append("'  ; \n");
        sasCode.append(this.m_SASOptions);
        sasCode.append(";\n");
        sasCode.append("%include cob2sas( ");
        sasCode.append(this.m_strOS);
        sasCode.append(" );\n");
        sasCode.append("run;\n\n");
    }

    private void cleanseCOB2SASResults(StringBuffer sasCode, String copybookFilename, String suggestedCSVFilename) {
        sasCode.append("data work.etls_mod; \n");
        sasCode.append("  attrib ");
        sasCode.append(SASColumnSourceFile);
        sasCode.append(" length=$80;\n");
        sasCode.append("  set perm.dictnry \n");
        sasCode.append("      ( rename=( newname=sascolumnname \n");
        sasCode.append("            infmt=sasinformat \n");
        sasCode.append("         atbyte=BeginPosition \n");
        sasCode.append("            bytes=sascolumnlength ) ); \n");
        sasCode.append("  drop level nst_dpth dataname usage picture ocr_base itm_disp ocr_val rdf_name; \n");
        sasCode.append("  if upcase(usage)='GROUP' then delete; \n");
        sasCode.append("  EndPosition = BeginPosition+SASColumnLength-1; \n");
        sasCode.append("  if trim( ");
        sasCode.append(SASColumnEFF_File);
        sasCode.append(" ) = '' then \n");
        sasCode.append("         ");
        sasCode.append(SASColumnEFF_File);
        sasCode.append(" = '");
        sasCode.append(suggestedCSVFilename);
        sasCode.append("' ; \n");
        sasCode.append("        ");
        sasCode.append(SASColumnEFF_File);
        sasCode.append("=translate( ");
        sasCode.append(SASColumnEFF_File);
        sasCode.append(",'_','-' ); \n");
        sasCode.append("SASColumnType='N';\n");
        sasCode.append("if substr( sasinformat,1,1 ) = '$' then sascolumntype='C';\n");
        sasCode.append("if SASColumnType='N' then sascolumnlength=8;\n");
        sasCode.append(SASColumnSourceFile);
        sasCode.append("  ='");
        sasCode.append(copybookFilename);
        sasCode.append("';\n");
        sasCode.append("run; \n\n");
    }

    private void appendDatasets(StringBuffer sasCode) {
        sasCode.append("proc append base=work.etls_all data=work.etls_mod; \n");
        sasCode.append("run; \n\n");
    }

    public void sortAndSummarize() throws WsAppServerCodeException, WsAppServerFailException {
        StringBuffer sasCode = new StringBuffer();
        sasCode.append("proc sort data=work.etls_all out=work.etls_srt; \n");
        sasCode.append("   by ");
        sasCode.append(SASColumnSourceFile);
        sasCode.append(" ");
        sasCode.append(SASColumnEFF_File);
        sasCode.append(" BeginPosition; \n");
        sasCode.append("run; \n\n");
        sasCode.append("\nproc summary data=work.etls_srt; \n");
        sasCode.append("by ");
        sasCode.append(SASColumnSourceFile);
        sasCode.append(" ");
        sasCode.append(SASColumnEFF_File);
        sasCode.append("; \n");
        sasCode.append("output out = ");
        sasCode.append(SummaryOutputDataset);
        sasCode.append("; \n");
        sasCode.append("run; \n\n");
        this.submitSASCode(sasCode);
    }

    public List getFilenamesFromSummaryDataset() throws SQLException, WsAppServerFailException {
        ArrayList<COB2SASRunResultFileStructure> lFileNames = new ArrayList<COB2SASRunResultFileStructure>(10);
        String m_submitStmt = "select * from " + SummaryOutputDataset;
        MVAResultSet rsltSet = this.m_wsAppServer.submitSQLStatement(m_submitStmt);
        while (rsltSet.next()) {
            String sourceFile = rsltSet.getString(SASColumnSourceFile).trim();
            String outputFile = rsltSet.getString(SASColumnEFF_File).trim();
            int columnCount = rsltSet.getInt("_freq_");
            StringBuffer fullPath = new StringBuffer();
            if (this.m_effDirectory.toLowerCase().compareTo("mvs:") >= 0) {
                fullPath.append(this.m_effDirectory);
                fullPath.append("(");
                if (outputFile.length() > 8) {
                    fullPath.append(outputFile.substring(0, 8));
                } else {
                    fullPath.append(outputFile);
                }
                fullPath.append(")");
            } else {
                fullPath.append(this.m_effDirectory);
                fullPath.append(outputFile);
                fullPath.append(".csv");
            }
            lFileNames.add(new COB2SASRunResultFileStructure(sourceFile, outputFile, fullPath.toString(), columnCount));
        }
        rsltSet.close();
        return lFileNames;
    }

    public void writeOutCSVFiles(List m_lFileNames) throws WsAppServerCodeException, WsAppServerFailException {
        StringBuffer sasCode = new StringBuffer();
        for (int i = 0; i < m_lFileNames.size(); ++i) {
            sasCode.append("data _null_; \n");
            sasCode.append("  %ds2csv ( data=work.etls_srt, runmode=b,  \n");
            sasCode.append("           csvfile='");
            sasCode.append(((COB2SASRunResultFileStructure)m_lFileNames.get(i)).getCSVFilePath());
            sasCode.append("',\n");
            sasCode.append("           var=sascolumnname  sascolumntype BeginPosition EndPosition sascolumnlength sasinformat, \n");
            sasCode.append("           where=( ");
            sasCode.append(SASColumnEFF_File);
            sasCode.append("='");
            sasCode.append(((COB2SASRunResultFileStructure)m_lFileNames.get(i)).getfileDescriptor());
            sasCode.append("' ) \n");
            sasCode.append("          ); \n");
            sasCode.append("run; \n");
        }
        this.submitSASCode(sasCode);
    }

    private void submitSASCode(StringBuffer sasCode) throws WsAppServerCodeException, WsAppServerFailException {
        SASCodeGeneration codeGeneration = new SASCodeGeneration();
        codeGeneration.addSourceCode(sasCode);
        this.m_wsAppServer.submitSASCode(codeGeneration.getSource());
    }
}

