/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.EFIDataModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AdvancedFileQuotingTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(AdvancedFileQuotingTab.class);
    private static final String DEFAULT = "DEFAULT";
    private static final String FTP = "FTP";
    private static final String URL = "URL";
    private JRadioButton m_rbnDefaultQuoting;
    private JRadioButton m_rbnDoubleQuoting;
    private JRadioButton m_rbnNoQuoting;
    private EFIDataModel m_mdlTable;
    private boolean m_editable;

    public AdvancedFileQuotingTab(EFIDataModel mdlTable) {
        this.m_mdlTable = mdlTable;
        this.setHelpProduct("wdb");
        this.setHelpTopic("advanced_quoting_tab");
        this.initialize();
    }

    protected void initialize() {
        this.m_rbnDefaultQuoting = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AdvancedFileQuotingTab.RadioButton.DefaultQuoting");
        this.m_rbnDoubleQuoting = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AdvancedFileQuotingTab.RadioButton.DoubleQuoting");
        this.m_rbnNoQuoting = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AdvancedFileQuotingTab.RadioButton.NoQuoting");
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.m_rbnDefaultQuoting);
        grp.add(this.m_rbnDoubleQuoting);
        grp.add(this.m_rbnNoQuoting);
        this.listenForDataChangesTo(this.m_rbnDefaultQuoting);
        this.listenForDataChangesTo(this.m_rbnDoubleQuoting);
        this.listenForDataChangesTo(this.m_rbnNoQuoting);
        this.setLayout(new GridBagLayout());
        this.add(this.m_rbnDefaultQuoting, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_rbnDoubleQuoting, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_rbnNoQuoting, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlTable.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_mdlTable.isNoQuotesEnabled()) {
            this.m_rbnNoQuoting.setSelected(true);
        } else if (this.m_mdlTable.isDoubleQuotesEnabled()) {
            this.m_rbnDoubleQuoting.setSelected(true);
        } else {
            this.m_rbnDefaultQuoting.setSelected(true);
        }
        if (this.m_editable) {
            if (this.m_mdlTable.isHttpAccessMethod()) {
                this.setupButtons(URL);
            } else if (this.m_mdlTable.isFtpAccessMethod()) {
                this.setupButtons(FTP);
            } else {
                this.setupButtons(DEFAULT);
            }
        }
        this.setListeningForChanges(true);
    }

    public void setupButtons(String accessMethod) {
        boolean ftp = false;
        boolean url = false;
        if (accessMethod.equals(FTP)) {
            ftp = true;
        } else if (accessMethod.equals(URL)) {
            url = true;
        }
        this.m_rbnDefaultQuoting.setEnabled(!url);
        if (ftp || url) {
            this.m_rbnNoQuoting.setEnabled(false);
        } else {
            this.m_rbnNoQuoting.setEnabled(true);
        }
        this.m_rbnDoubleQuoting.setEnabled(!url);
        if (url) {
            this.m_rbnDefaultQuoting.setSelected(true);
        }
        if (ftp && this.m_rbnNoQuoting.isSelected()) {
            this.m_rbnDefaultQuoting.setSelected(true);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_rbnDoubleQuoting.isSelected()) {
            this.m_mdlTable.setDoubleQuotesEnabled(true);
            this.m_mdlTable.setNoQuotesEnabled(false);
        } else if (this.m_rbnNoQuoting.isSelected()) {
            this.m_mdlTable.setNoQuotesEnabled(true);
            this.m_mdlTable.setDoubleQuotesEnabled(false);
        } else {
            this.m_mdlTable.setDoubleQuotesEnabled(false);
            this.m_mdlTable.setNoQuotesEnabled(false);
        }
        this.setDataChanged(false);
    }

    public boolean validateData() {
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_editable = bEditable;
        this.m_rbnDefaultQuoting.setEnabled(bEditable);
        this.m_rbnNoQuoting.setEnabled(bEditable);
        this.m_rbnDoubleQuoting.setEnabled(bEditable);
    }
}

