/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.drill;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.drill.DrillComponent;
import com.sas.wadmin.drill.DrillEvent;
import com.sas.wadmin.drill.DrillListener;
import com.sas.wadmin.drill.DrillableComponent;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.Stack;
import javax.swing.JToolBar;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;

public class DrillPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(DrillPanel.class);
    public static final String BREAD_CRUMB_TRAIL = "BreadCrumbTrail";
    private static final String BREAD_CRUMB_SEPARATOR = bundle.getString("DrillPanel.BreadCrumbSeparator.txt");
    private Stack m_stkDrillComponents = new Stack();
    private UndoManager m_mgrUndo;
    private JToolBar m_barMain;
    private JToolBar m_barCurrent;
    private WAPanel m_pnlCurrent;
    private WsAbstractAction m_actUp = new UpAction();
    private WsAbstractAction[] m_aSharedActions;
    private DrillListener m_lsnr;
    private boolean m_bActive;
    private boolean m_bUndoing;

    public DrillPanel() {
        this.m_barMain = WsUIUtilities.createToolBar();
        this.m_barMain.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actUp));
        this.m_barMain.addSeparator();
        this.setLayout(new BorderLayout());
        this.add(this.m_barMain, "North");
        this.m_lsnr = new DrillingListener();
    }

    public void setFirstDrillableComponent(DrillableComponent cmp) {
        this.push(cmp);
        cmp.getPanel().addPropertyChangeListener("DataChanged", (PropertyChangeListener)new DataChangedListener());
        this.m_aSharedActions = cmp.getSharedActions();
    }

    public DrillComponent getFirstDrillComponent() {
        return this.m_stkDrillComponents.isEmpty() ? null : (DrillComponent)this.m_stkDrillComponents.get(0);
    }

    public void setUndoManager(UndoManager mgrUndo) {
        this.m_mgrUndo = mgrUndo;
    }

    public UndoManager getUndoManager() {
        return this.m_mgrUndo;
    }

    public String getBreadCrumbTrail() {
        StringBuffer sbBreadCrumbTrail = new StringBuffer();
        for (int iComponent = 0; iComponent < this.m_stkDrillComponents.size(); ++iComponent) {
            DrillComponent cmp = (DrillComponent)this.m_stkDrillComponents.get(iComponent);
            sbBreadCrumbTrail.append(cmp.getName());
            sbBreadCrumbTrail.append(BREAD_CRUMB_SEPARATOR);
        }
        return sbBreadCrumbTrail.substring(0, sbBreadCrumbTrail.length() - BREAD_CRUMB_SEPARATOR.length());
    }

    private void push(DrillComponent cmp) {
        if (cmp instanceof DrillableComponent) {
            ((DrillableComponent)cmp).addDrillListener(this.m_lsnr);
        }
        if (this.m_mgrUndo != null && !this.m_bUndoing) {
            this.m_mgrUndo.addEdit(new PushUndoable(cmp));
        }
        this.m_stkDrillComponents.push(cmp);
        this.setCurrentDrillComponent(cmp);
        this.movePanelDataToView(cmp.getPanel());
        cmp.addReference((Object)this);
    }

    private void pop() {
        DrillComponent cmpCurrent = (DrillComponent)this.m_stkDrillComponents.peek();
        if (!this.m_bUndoing && !cmpCurrent.getPanel().validateData()) {
            return;
        }
        this.m_stkDrillComponents.pop();
        if (cmpCurrent instanceof DrillableComponent) {
            ((DrillableComponent)cmpCurrent).removeDrillListener(this.m_lsnr);
        }
        if (this.m_mgrUndo != null && !this.m_bUndoing) {
            this.m_mgrUndo.addEdit(new PopUndoable(cmpCurrent));
        }
        this.movePanelDataFromView(cmpCurrent.getPanel());
        cmpCurrent.removeReference((Object)this);
        this.setCurrentDrillComponent((DrillComponent)this.m_stkDrillComponents.peek());
    }

    private void setCurrentDrillComponent(DrillComponent cmp) {
        this.setCurrentPanel(cmp.getPanel());
        this.setCurrentToolBar(cmp.getToolBar());
        this.refreshBreadCrumbTrail();
        this.m_actUp.setEnabled(this.m_stkDrillComponents.size() != 1);
        this.revalidate();
        this.repaint();
    }

    private void setCurrentPanel(WAPanel pnl) {
        if (this.m_pnlCurrent != null) {
            this.m_pnlCurrent.updateWorkspaceUIComponents(false);
            this.remove((Component)this.m_pnlCurrent);
        }
        this.m_pnlCurrent = pnl;
        if (pnl != null) {
            this.add((Component)pnl, "Center");
            pnl.updateWorkspaceUIComponents(this.m_bActive);
        }
    }

    public WAPanel getCurrentPanel() {
        return this.m_pnlCurrent;
    }

    private void setCurrentToolBar(JToolBar bar) {
        if (this.m_barCurrent != null) {
            this.m_barMain.remove(this.m_barCurrent);
        }
        this.m_barCurrent = bar;
        if (this.m_barCurrent != null) {
            this.m_barCurrent.setBorder(null);
            this.m_barMain.add(this.m_barCurrent);
        }
    }

    public ClassLoader getHelpClassLoader() {
        return this.m_pnlCurrent.getHelpClassLoader();
    }

    public String getHelpProduct() {
        return this.m_pnlCurrent.getHelpProduct();
    }

    public String getHelpTopic() {
        return this.m_pnlCurrent.getHelpTopic();
    }

    private void refreshBreadCrumbTrail() {
        this.firePropertyChange(BREAD_CRUMB_TRAIL, null, this.getBreadCrumbTrail());
    }

    private void movePanelDataToView(WAPanel pnl) {
        try {
            pnl.moveDataToView();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
    }

    private void movePanelDataFromView(WAPanel pnl) {
        try {
            pnl.moveDataToStore();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
    }

    public boolean load() {
        return this.getFirstDrillComponent().getPanel().load();
    }

    public boolean save() {
        return this.getFirstDrillComponent().getPanel().save();
    }

    public Component getDefaultFocusComponent() {
        return this.m_pnlCurrent != null ? this.m_pnlCurrent.getDefaultFocusComponent() : null;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_bActive = bActive;
        if (this.m_pnlCurrent != null) {
            this.m_pnlCurrent.updateWorkspaceUIComponents(bActive);
        }
        for (int iAction = 0; iAction < this.m_aSharedActions.length; ++iAction) {
            this.m_aSharedActions[iAction].setActive(bActive);
        }
    }

    public boolean validateData() {
        return this.m_pnlCurrent.validateData();
    }

    public void saveSettingsAndCleanUp() {
        for (int iComponent = this.m_stkDrillComponents.size() - 1; iComponent >= 0; --iComponent) {
            DrillComponent cmp = (DrillComponent)this.m_stkDrillComponents.get(iComponent);
            cmp.getPanel().saveSettingsAndCleanUp();
        }
    }

    private class UpAction
    extends WsAbstractAction {
        public UpAction() {
            super(bundle, "DrillPanel.Action.Up", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("NavigateUp"));
        }

        public void actionPerformed(ActionEvent e) {
            DrillPanel.this.pop();
        }
    }

    private class DrillingListener
    implements DrillListener {
        private DrillingListener() {
        }

        @Override
        public void drilled(DrillEvent ev) {
            DrillPanel.this.push(ev.getDrillTarget());
        }
    }

    private class DataChangedListener
    implements PropertyChangeListener {
        private DataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            DrillPanel.this.setDataChanged((Boolean)ev.getNewValue());
        }
    }

    private class PushUndoable
    extends AbstractUndoableEdit {
        private DrillComponent m_cmp;

        public PushUndoable(DrillComponent cmp) {
            this.m_cmp = cmp;
            this.m_cmp.addReference(this);
        }

        @Override
        public void undo() {
            super.undo();
            DrillPanel.this.m_bUndoing = true;
            try {
                DrillPanel.this.pop();
            }
            finally {
                DrillPanel.this.m_bUndoing = false;
            }
        }

        @Override
        public void redo() {
            super.redo();
            DrillPanel.this.m_bUndoing = true;
            try {
                DrillPanel.this.push(this.m_cmp);
            }
            finally {
                DrillPanel.this.m_bUndoing = false;
            }
        }

        @Override
        public void die() {
            super.die();
            this.m_cmp.removeReference(this);
            this.m_cmp = null;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }
    }

    private class PopUndoable
    extends AbstractUndoableEdit {
        private DrillComponent m_cmp;

        public PopUndoable(DrillComponent cmp) {
            this.m_cmp = cmp;
            this.m_cmp.addReference(this);
        }

        @Override
        public void undo() {
            super.undo();
            DrillPanel.this.m_bUndoing = true;
            try {
                DrillPanel.this.push(this.m_cmp);
            }
            finally {
                DrillPanel.this.m_bUndoing = false;
            }
        }

        @Override
        public void redo() {
            super.redo();
            DrillPanel.this.m_bUndoing = true;
            try {
                DrillPanel.this.pop();
            }
            finally {
                DrillPanel.this.m_bUndoing = false;
            }
        }

        @Override
        public void die() {
            super.die();
            this.m_cmp.removeReference(this);
            this.m_cmp = null;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }
    }
}

