/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.editor.LogListHolder;
import com.sas.editor.LogListViewer;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsButtonsLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SASOutputDialog
extends WAStandardDialog {
    private WsAppServer m_WsAppServer;
    private LogListHolder m_output;
    private LogListViewer m_outputView = null;

    public SASOutputDialog(Dialog dlgOwner, String sTitle, boolean bModal) {
        super(dlgOwner, sTitle, bModal);
    }

    public SASOutputDialog(Frame dlgOwner, String sTitle, boolean bModal) {
        super(dlgOwner, sTitle, bModal);
    }

    public SASOutputDialog(Frame dlgOwner, String sTitle, boolean bModal, LogListHolder output) {
        super(dlgOwner, sTitle, bModal);
        this.m_output = output;
    }

    public SASOutputDialog(Dialog dlgOwner, String sTitle, boolean bModal, WsAppServer server) {
        super(dlgOwner, sTitle, bModal);
        this.m_WsAppServer = server;
    }

    public SASOutputDialog(Frame dlgOwner, String sTitle, boolean bModal, WsAppServer server) {
        super(dlgOwner, sTitle, bModal);
        this.m_WsAppServer = server;
    }

    protected void initialize() {
        super.initialize();
        LogListHolder outputData = null;
        if (this.m_output == null && this.m_WsAppServer != null) {
            try {
                outputData = this.m_WsAppServer.getOutput();
            }
            catch (WsAppServerFailException wsfe) {
                MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
            }
        } else {
            outputData = this.m_output;
        }
        this.m_outputView = new LogListViewer((Frame)Workspace.getWorkspace(), 2, outputData, Workspace.getWorkspace().getCodeEditorDefaults());
        this.m_outputView.getEditorPane().setCaretPosition(0);
        this.m_btnCancel.addActionListener((ActionListener)((Object)this));
        this.setResizable(true);
    }

    protected void updateButtonsPanel() {
        this.removeKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout((LayoutManager)new WsButtonsLayout());
        this.m_pnlButtons.add(this.m_btnCancel);
        ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnCancel);
        this.addKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
    }

    protected void layoutWidgets() {
        super.layoutWidgets();
        WAPanel centerPanel = new WAPanel();
        centerPanel.setLayout((LayoutManager)new BorderLayout());
        centerPanel.add((Component)this.m_outputView);
        centerPanel.setPreferredSize(new Dimension(600, 400));
        this.setMainPanel(centerPanel);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.populateStore();
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void populateStore() {
    }

    public void moveDataToView() {
    }

    public void moveDataToStore() {
    }

    public boolean validateData() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_btnCancel && this.onCancel()) {
            this.dispose();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.m_outputView != null) {
            this.m_outputView.cleanup();
        }
        this.m_outputView = null;
    }

    public void setWsAppServer(WsAppServer wsAppServer) {
        this.m_WsAppServer = wsAppServer;
    }
}

