/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.swing.visuals.CheckBoxTree;
import com.sas.swing.visuals.CheckBoxTreeCellRendererWrapper;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.changeanalysis.ComparisonResultsException;
import com.sas.wadmin.changeanalysis.ComparisonResultsModel;
import com.sas.wadmin.changeanalysis.DifferencesInterface;
import com.sas.wadmin.changeanalysis.DifferencesTreeModel;
import com.sas.wadmin.visuals.ImpactAnalysisOMAView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsColorChooserTool;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsDefaultTreeCellRenderer;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsTree;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsViewFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DifferencesPanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(DifferencesPanel.class);
    public static final String CHANGE_BACKGROUND_COLOR = "DifferencesPanel.ChangeBackgroundColor";
    private static final String DIFFERENCES_ONLY_KEY = "DifferencesPanel.DifferencesOnly";
    private static final String DELETE_MISSING_ITEMS_KEY = "DifferencesPanel.DeleteMissingItems";
    private DifferencesInterface m_mdlDifferences;
    private DifferencesTreeModel m_mdlTree;
    private CheckBoxTree m_treeImport;
    private JScrollPane m_scrImport;
    private WsTree m_treeTarget;
    private JScrollPane m_scrTarget;
    private JSplitPane m_spltMain;
    private JCheckBox m_ckbDifferencesOnly;
    private JCheckBox m_ckbDeleteMissingItems;
    private WsColorChooserTool m_btnColor;
    private WATextArea m_txtLastUpdated;
    private WsAbstractAction m_actDifferences;
    private WsAbstractAction m_actImpact;
    private WsAbstractAction m_actReverse;
    private WsAbstractAction m_actApply;
    private WsAbstractAction m_actDifferencesOnly;
    private WsAbstractAction m_actDeleteMissingItems;
    private boolean m_bDifferencesOnly;
    private boolean m_bDeleteMissingItems;
    private boolean m_bInApply;
    private Color m_clrChangeBackground;
    private PropertyChangeListener m_lsnrDefaultColor;

    public DifferencesPanel(DifferencesInterface model) {
        this.m_mdlDifferences = model;
        this.initialize();
    }

    protected void initialize() {
        this.initializeChangeColor();
        this.m_mdlTree = new DifferencesTreeModel();
        this.m_mdlTree.setStore(this.m_mdlDifferences.getStore());
        this.m_mdlTree.setListenForChanges(false);
        ArrayList<CMetadata> lRepositories = new ArrayList<CMetadata>();
        lRepositories.add(Workspace.getWorkspace().getCheckinRepository());
        this.m_mdlTree.setRepositories(lRepositories);
        this.m_treeImport = new CheckBoxTree((TreeModel)((Object)this.m_mdlTree));
        this.m_treeImport.setUI((TreeUI)new cModifiedTreeUI(0));
        this.m_treeImport.setCellRenderer((TreeCellRenderer)((Object)new cCheckBoxTreeCellRenderer((TreeCellRenderer)((Object)new cTreeCellRenderer()))));
        this.m_treeImport.setRootVisible(false);
        this.m_treeImport.setShowsRootHandles(true);
        this.m_treeImport.setShowSelectionIcon(false);
        this.m_treeImport.clearSelection();
        this.m_treeImport.getCheckedModel().setRowMapper(this.m_treeImport.getSelectionModel().getRowMapper());
        TreeSelectionModel mdlChecked = this.m_treeImport.getCheckedModel();
        this.m_treeImport.addTreeExpansionListener((TreeExpansionListener)new cExpansionListener(mdlChecked));
        mdlChecked.addTreeSelectionListener(new cAutoChecker(mdlChecked));
        this.m_treeTarget = new WsTree((DefaultTreeModel)((Object)this.m_mdlTree));
        this.m_treeTarget.setUI((TreeUI)new cModifiedTreeUI(1));
        this.m_treeTarget.setCellRenderer((TreeCellRenderer)((Object)new cTreeCellRenderer()));
        this.m_treeTarget.clearSelection();
        this.m_treeTarget.setShowsRootHandles(true);
        this.m_treeTarget.setRootVisible(false);
        this.m_treeImport.addTreeExpansionListener((TreeExpansionListener)new cExpansionListener(mdlChecked));
        this.m_treeTarget.setEditable(false);
        this.m_scrImport = new JScrollPane((Component)this.m_treeImport);
        this.m_scrImport.setPreferredSize(new Dimension(400, 200));
        this.m_scrTarget = new JScrollPane((Component)this.m_treeTarget);
        this.m_scrTarget.setPreferredSize(new Dimension(400, 200));
        new cScrollSynchronizer(this.m_scrImport.getVerticalScrollBar(), this.m_scrTarget.getVerticalScrollBar());
        new cExpansionSynchronizer((JTree)this.m_treeImport, (JTree)this.m_treeTarget);
        new cSelectionSynchronizer((JTree)this.m_treeImport, (JTree)this.m_treeTarget);
        this.m_treeImport.setSelectionRow(0);
        this.createActions();
        this.updateActions();
        cActionUpdater updater = new cActionUpdater();
        mdlChecked.addTreeSelectionListener(updater);
        this.m_treeImport.addTreeSelectionListener((TreeSelectionListener)updater);
        this.m_treeTarget.addTreeSelectionListener((TreeSelectionListener)updater);
        this.setDifferencesOnly(Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(DIFFERENCES_ONLY_KEY, true));
        this.setDeleteMissingItems(Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(DELETE_MISSING_ITEMS_KEY, false));
        this.m_ckbDifferencesOnly = new JCheckBox((Action)this.m_actDifferencesOnly);
        this.m_ckbDifferencesOnly.setSelected(this.isDifferencesOnly());
        this.m_ckbDeleteMissingItems = new JCheckBox((Action)this.m_actDeleteMissingItems);
        this.m_ckbDeleteMissingItems.setSelected(this.isDeleteMissingItems());
        CompoundBorder brdrTitle = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JLabel lblImport = WsUIUtilities.createLabelForComponent((JComponent)this.m_treeImport, (WAdminResource)bundle, (String)"DifferencesPanel.Label.Import");
        lblImport.setBorder(brdrTitle);
        JPanel pnlImport = new JPanel(new BorderLayout());
        pnlImport.add((Component)lblImport, "North");
        pnlImport.add((Component)this.m_scrImport, "Center");
        JLabel lblTarget = WsUIUtilities.createLabelForComponent((JComponent)this.m_treeTarget, (WAdminResource)bundle, (String)"DifferencesPanel.Label.Target");
        lblTarget.setBorder(brdrTitle);
        JPanel pnlTarget = new JPanel(new BorderLayout());
        pnlTarget.add((Component)lblTarget, "North");
        pnlTarget.add((Component)this.m_scrTarget, "Center");
        this.m_spltMain = new JSplitPane(1, pnlImport, pnlTarget);
        this.m_txtLastUpdated = new WATextArea();
        this.m_txtLastUpdated.setBehavior(1);
        this.m_txtLastUpdated.setAutosize(true);
        this.m_txtLastUpdated.setText(bundle.formatString("DifferencesPanel.LastUpdated.txt", (Object)""));
        this.setLayout(new GridBagLayout());
        this.add(this.createButtonsPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_txtLastUpdated, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_spltMain, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(8, 0, 0, 0), 0, 0));
        this.add(this.m_ckbDifferencesOnly, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_ckbDeleteMissingItems, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setHelpProduct("importca");
        this.setHelpTopic("differences_win");
    }

    protected JComponent createButtonsPanel() {
        JToolBar pnlButtons = new JToolBar();
        pnlButtons.setFloatable(false);
        pnlButtons.setRollover(true);
        this.m_btnColor = new WsColorChooserTool();
        this.m_btnColor.setSelectedColor(this.m_clrChangeBackground);
        this.m_btnColor.setToolTipText(bundle.getString("DifferencesPanel.ColorTool.tip"));
        this.m_btnColor.addPropertyChangeListener("selectedColor", (PropertyChangeListener)new cSelectedColorListener());
        pnlButtons.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actImpact));
        pnlButtons.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actReverse));
        pnlButtons.addSeparator();
        pnlButtons.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actApply));
        pnlButtons.addSeparator();
        pnlButtons.add((Component)this.m_btnColor);
        return pnlButtons;
    }

    private void initializeChangeColor() {
        int rgb = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(CHANGE_BACKGROUND_COLOR, 0);
        this.m_clrChangeBackground = rgb == 0 ? WsColorChooserTool.SILVER : new Color(rgb);
        this.m_lsnrDefaultColor = new cDefaultColorListener();
        Workspace.getWorkspace().getAppDefaultsFile().addPropertyChangeListener(this.m_lsnrDefaultColor);
    }

    protected void createActions() {
        this.m_actDifferences = new cDifferencesAction();
        this.m_actImpact = new cImpactAnalysisAction();
        this.m_actReverse = new cReverseImpactAnalysisAction();
        this.m_actApply = new cApplyAction();
        this.m_actDifferencesOnly = new cDifferencesOnlyAction();
        this.m_actDeleteMissingItems = new cDeleteMissingItemsAction();
    }

    protected void updateActions() {
        Object objLast;
        boolean bImpact = true;
        boolean bApply = false;
        TreePath[] aPaths = this.m_treeImport.getSelectionPaths();
        if (aPaths != null) {
            for (int iPath = 0; iPath < aPaths.length; ++iPath) {
                Object objLast2 = aPaths[iPath].getLastPathComponent();
                if (objLast2 instanceof DifferencesTreeModel.DataNode) {
                    DifferencesTreeModel.DataNode node = (DifferencesTreeModel.DataNode)objLast2;
                    String sType = node.getType();
                    if ((sType.equals("PhysicalTable") || sType.equals("Column")) && node.getLocation() != 0) continue;
                    bImpact = false;
                } else {
                    bImpact = false;
                }
                break;
            }
        } else {
            bImpact = false;
        }
        boolean bDeletesOnly = false;
        aPaths = this.m_treeImport.getCheckedModel().getSelectionPaths();
        if (aPaths != null && !this.isDeleteMissingItems()) {
            bDeletesOnly = true;
            for (int iPath = 0; iPath < aPaths.length; ++iPath) {
                DifferencesTreeModel.DataNode node;
                objLast = aPaths[iPath].getLastPathComponent();
                if (!(objLast instanceof DifferencesTreeModel.DataNode) || (node = (DifferencesTreeModel.DataNode)objLast).getLocation() == 1) continue;
                bDeletesOnly = false;
                break;
            }
        }
        if ((aPaths = this.m_treeImport.getCheckedModel().getSelectionPaths()) != null) {
            for (int iPath = 0; iPath < aPaths.length; ++iPath) {
                objLast = aPaths[iPath].getLastPathComponent();
                if (!(objLast instanceof DifferencesTreeModel.CheckableDataNode)) continue;
                bApply = true;
                break;
            }
        }
        this.m_actImpact.setEnabled(bImpact);
        this.m_actReverse.setEnabled(bImpact);
        this.m_actApply.setEnabled(bApply && !bDeletesOnly);
    }

    public void populateStore() throws MdException, RemoteException {
        ((ComparisonResultsModel)this.m_mdlDifferences).populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this.m_bInApply) {
            return;
        }
        try {
            ((ComparisonResultsModel)this.m_mdlDifferences).moveDataToModel();
            this.m_mdlTree.setDifferencesModel(this.m_mdlDifferences);
            this.m_mdlTree.moveDataToModel();
            this.m_txtLastUpdated.setText(bundle.formatString("DifferencesPanel.LastUpdated.txt", (Object)this.m_mdlDifferences.getLastComparisonUpdatedDate()));
        }
        catch (WsAppServerCodeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (ComparisonResultsException ex) {
            if (ex.getExceptionType() == 3) {
                String sTitle = bundle.getString("DifferencesPanel.DuplicateMessageTitle.txt");
                MessageUtil.displayListMessage((String)ex.getLocalizedMessage(), (List)((ComparisonResultsModel)this.m_mdlDifferences).getDuplicateMessageList(), (String)sTitle, (int)1, (int)-1);
            }
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        this.m_spltMain.setDividerLocation(0.5);
        this.m_treeImport.expandRow(0);
    }

    public void saveSettingsAndCleanUp() {
        Workspace.getWorkspace().getAppDefaultsFile().removePropertyChangeListener(this.m_lsnrDefaultColor);
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(DIFFERENCES_ONLY_KEY, this.m_ckbDifferencesOnly.isSelected());
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(DELETE_MISSING_ITEMS_KEY, this.m_ckbDeleteMissingItems.isSelected());
        this.m_mdlDifferences.dispose();
        this.m_mdlTree.dispose();
        super.saveSettingsAndCleanUp();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actDifferences.setActive(bActive);
        this.m_actImpact.setActive(bActive);
        this.m_actReverse.setActive(bActive);
        this.m_actApply.setActive(bActive);
    }

    public void setDifferencesOnly(boolean bDifferencesOnly) {
        if (this.m_bDifferencesOnly != bDifferencesOnly) {
            this.m_bDifferencesOnly = bDifferencesOnly;
            this.m_mdlTree.setDifferencesOnly(bDifferencesOnly);
        }
    }

    public boolean isDifferencesOnly() {
        return this.m_bDifferencesOnly;
    }

    public void setDeleteMissingItems(boolean bDeleteMissingItems) {
        if (this.m_bDeleteMissingItems != bDeleteMissingItems) {
            this.m_bDeleteMissingItems = bDeleteMissingItems;
            ((ComparisonResultsModel)this.m_mdlDifferences).setDeleteMissingItems(bDeleteMissingItems);
            this.updateActions();
            this.m_treeImport.repaint();
            this.m_treeTarget.repaint();
        }
    }

    public boolean isDeleteMissingItems() {
        return this.m_bDeleteMissingItems;
    }

    private void showImpactAnalysis(String sName, String sType, String sFQID, boolean bForward) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
            try {
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, sType, sFQID, null, null, "", 2056);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            Root mdo = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, sName, sType, sFQID);
            ImpactAnalysisOMAView view = this.findImpactAnalysisView(mdo, bForward);
            if (view != null) {
                store.dispose();
                WsViewFactory.showExistingView((WsOMAView)view);
                return;
            }
            view = sType.equals("PhysicalTable") ? new ImpactAnalysisOMAView((Classifier)((PhysicalTable)mdo), bForward) : new ImpactAnalysisOMAView((Column)mdo, bForward);
            WsViewFactory.attachViewToFrame((CMetadata)mdo, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame((CMetadata)mdo, ""));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private ImpactAnalysisOMAView findImpactAnalysisView(Root mdo, boolean bForward) {
        try {
            ArrayList lViews = mdo.getViewList();
            int nViews = lViews.size();
            for (int iView = 0; iView < nViews; ++iView) {
                ImpactAnalysisOMAView view;
                if (!lViews.get(iView).getClass().equals(ImpactAnalysisOMAView.class) || (view = (ImpactAnalysisOMAView)((Object)lViews.get(iView))).isForward() != bForward) continue;
                return view;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    private void removeObjects(List lFQIDs) {
        for (int iFQID = 0; iFQID < lFQIDs.size(); ++iFQID) {
            ArrayList lNodes = this.m_mdlTree.findNodes((String)lFQIDs.get(iFQID));
            for (int iNode = 0; iNode < lNodes.size(); ++iNode) {
                this.m_mdlTree.removeChild((WsTreeNode)lNodes.get(iNode));
            }
        }
        this.m_mdlTree.setDifferencesOnly(this.isDifferencesOnly());
    }

    private String[][] getCheckedObjects() {
        TreePath[] aPaths = this.m_treeImport.getCheckedModel().getSelectionPaths();
        if (aPaths == null) {
            return new String[0][3];
        }
        int nObjects = 0;
        for (int iPath = 0; iPath < aPaths.length; ++iPath) {
            WsTreeNode node = (WsTreeNode)aPaths[iPath].getLastPathComponent();
            if (!(node instanceof DifferencesTreeModel.DataNode)) continue;
            ++nObjects;
        }
        int iObject = 0;
        String[][] saObjects = new String[nObjects][3];
        for (int iPath = 0; iPath < aPaths.length; ++iPath) {
            WsTreeNode node = (WsTreeNode)aPaths[iPath].getLastPathComponent();
            if (!(node instanceof DifferencesTreeModel.DataNode)) continue;
            DifferencesTreeModel.DataNode nodeData = (DifferencesTreeModel.DataNode)node;
            saObjects[iObject][0] = nodeData.getFQID();
            saObjects[iObject][1] = nodeData.getType();
            saObjects[iObject][2] = DifferencesTreeModel.convertLocation(nodeData.getLocation());
            ++iObject;
        }
        return saObjects;
    }

    private Color getBackgroundColorForNode(JTree tree, WsTreeNode node) {
        DifferencesTreeModel.BaseNode node2;
        if (node instanceof DifferencesTreeModel.BaseNode && ((node2 = (DifferencesTreeModel.BaseNode)node).getLocation() != 2 || node2.hasChanged())) {
            return this.m_clrChangeBackground;
        }
        return null;
    }

    protected class cModifiedTreeUI
    extends BasicTreeUI {
        private int m_eLocation;

        public cModifiedTreeUI(int eLocation) {
            this.m_eLocation = eLocation;
        }

        public int getLocation() {
            return this.m_eLocation;
        }

        @Override
        public void update(Graphics g, JComponent c) {
            this.paintBackground(g, c);
            this.paint(g, c);
        }

        public void paintBackground(Graphics g, JComponent c) {
            if (c.isOpaque()) {
                TreePath initialPath;
                Enumeration<TreePath> paintingEnumerator;
                Rectangle rPaint = g.getClipBounds();
                g.setColor(c.getBackground());
                g.fillRect(rPaint.x, rPaint.y, rPaint.width, rPaint.height);
                Insets insets = this.tree.getInsets();
                if (insets == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                if ((paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath = this.getClosestPathForLocation(this.tree, 0, rPaint.y))) != null) {
                    TreePath path;
                    int yBottom = rPaint.y + rPaint.height;
                    Rectangle rNode = new Rectangle();
                    while (paintingEnumerator.hasMoreElements() && (path = paintingEnumerator.nextElement()) != null) {
                        Color clrBack = DifferencesPanel.this.getBackgroundColorForNode(this.tree, (WsTreeNode)path.getLastPathComponent());
                        if (clrBack != null) {
                            this.treeState.getBounds(path, rNode);
                            g.setColor(clrBack);
                            g.fillRect(rPaint.x, rNode.y + insets.top, rPaint.width, rNode.height);
                        }
                        if (insets.top + rNode.y + rNode.height < yBottom) continue;
                        break;
                    }
                }
            }
        }

        @Override
        protected void paintRow(Graphics g, Rectangle rClip, Insets insets, Rectangle rBounds, TreePath path, int iRow, boolean bExpanded, boolean bHasBeenExpanded, boolean bLeaf) {
            if (this.isPathVisible(path)) {
                super.paintRow(g, rClip, insets, rBounds, path, iRow, bExpanded, bHasBeenExpanded, bLeaf);
            }
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics g, Rectangle rClip, Insets insets, TreePath path) {
            if (this.isPathVisible(path)) {
                super.paintVerticalPartOfLeg(g, rClip, insets, path);
            }
        }

        @Override
        protected void paintHorizontalPartOfLeg(Graphics g, Rectangle rClip, Insets insets, Rectangle rBounds, TreePath path, int iRow, boolean bExpanded, boolean bHasBeenExpanded, boolean bLeaf) {
            if (this.isPathVisible(path)) {
                super.paintHorizontalPartOfLeg(g, rClip, insets, rBounds, path, iRow, bExpanded, bHasBeenExpanded, bLeaf);
            }
        }

        @Override
        protected boolean shouldPaintExpandControl(TreePath path, int iRow, boolean bExpanded, boolean bHasBeenExpanded, boolean bLeaf) {
            return this.isPathVisible(path) && super.shouldPaintExpandControl(path, iRow, bExpanded, bHasBeenExpanded, bLeaf);
        }

        protected boolean isPathVisible(TreePath path) {
            for (int iPart = path.getPathCount() - 1; iPart >= 0; --iPart) {
                Object part = path.getPathComponent(iPart);
                if (!(part instanceof DifferencesTreeModel.BaseNode)) continue;
                DifferencesTreeModel.BaseNode node = (DifferencesTreeModel.BaseNode)part;
                int eLocation = node.getLocation();
                int eTreeLocation = this.getLocation();
                if (eLocation == 2 || eLocation == eTreeLocation) {
                    return true;
                }
                if (eTreeLocation == 0) {
                    WsTreeNode nodeParent = (WsTreeNode)node.getParent();
                    return !(nodeParent instanceof DifferencesTreeModel.BaseNode) || ((DifferencesTreeModel.BaseNode)nodeParent).getLocation() == 2;
                }
                return false;
            }
            return true;
        }

        protected boolean isPathADelete(TreePath path) {
            Object last = path.getLastPathComponent();
            return this.getLocation() == 0 && last instanceof DifferencesTreeModel.CheckableDataNode && ((DifferencesTreeModel.CheckableDataNode)last).getLocation() == 1;
        }
    }

    protected class cCheckBoxTreeCellRenderer
    extends CheckBoxTreeCellRendererWrapper {
        public cCheckBoxTreeCellRenderer(TreeCellRenderer rdr) {
            super(rdr);
            AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 2, 0, 5, true, true, true);
            layout.setIgnoreSizeOfNonVisibleComponents(true);
            this.setLayout((LayoutManager)layout);
        }

        public JCheckBox createDefaultCheckBox() {
            JCheckBox ckb = super.createDefaultCheckBox();
            ckb.setBorderPaintedFlat(true);
            return ckb;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
            Component cmp = super.getTreeCellRendererComponent(tree, node, bSelected, bExpanded, bLeaf, iRow, bHasFocus);
            this.getCheckBox().setVisible(this.isCheckBoxVisible(node));
            Color clrBack = DifferencesPanel.this.getBackgroundColorForNode(tree, (WsTreeNode)node);
            if (clrBack != null) {
                this.getCheckBox().setBackground(clrBack);
            }
            return cmp;
        }

        private boolean isCheckBoxVisible(Object node) {
            return node instanceof DifferencesTreeModel.CheckableNode && ((DifferencesTreeModel.CheckableNode)node).isCheckable();
        }
    }

    protected class cTreeCellRenderer
    extends WsDefaultTreeCellRenderer {
        private final Icon m_iconBlank = DifferencesPanel.access$100().getImageIcon("DifferencesPanel.SourceTree.Blank.image");
        private final Icon m_iconNew = DifferencesPanel.access$100().getImageIcon("DifferencesPanel.SourceTree.New.image");
        private final Icon m_iconDelete = DifferencesPanel.access$100().getImageIcon("DifferencesPanel.SourceTree.Delete.image");
        private final Icon m_iconChanged = DifferencesPanel.access$100().getImageIcon("DifferencesPanel.SourceTree.Changed.image");

        protected cTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
            this.setBackgroundNonSelectionColor(DifferencesPanel.this.getBackgroundColorForNode(tree, (WsTreeNode)node));
            JLabel lbl = (JLabel)super.getTreeCellRendererComponent(tree, node, bSelected, bExpanded, bLeaf, iRow, bHasFocus);
            if (node instanceof DifferencesTreeModel.BaseNode) {
                int eTreeLocation = ((cModifiedTreeUI)tree.getUI()).getLocation();
                DifferencesTreeModel.BaseNode node2 = (DifferencesTreeModel.BaseNode)node;
                if (node instanceof DifferencesTreeModel.cColumnNode) {
                    lbl.setText(node2.getUserObject().toString());
                } else if (node instanceof DifferencesTreeModel.CheckableDataNode) {
                    lbl.setText(node2.getUserObject().toString());
                } else {
                    lbl.setText(node2.getName(eTreeLocation));
                }
                lbl.setIcon(this.getIcon(node2, eTreeLocation, bExpanded));
            }
            return lbl;
        }

        private Icon getIcon(DifferencesTreeModel.BaseNode node, int eTreeLocation, boolean bExpanded) {
            Icon iconBase = node.getIcon(eTreeLocation);
            if (iconBase == null) {
                iconBase = node.getIcon(bExpanded);
            }
            if (eTreeLocation == 1) {
                return iconBase;
            }
            Icon iconDelta = this.getDeltaIcon(node, bExpanded);
            if (iconDelta == null) {
                return iconBase;
            }
            if (iconBase == null) {
                return iconDelta;
            }
            WsCompoundIcon icon = new WsCompoundIcon();
            icon.addIcon(iconDelta);
            icon.addIcon(iconBase);
            return icon;
        }

        private Icon getDeltaIcon(DifferencesTreeModel.BaseNode node, boolean bExpanded) {
            int eLocation = node.getLocation();
            if (eLocation == 1) {
                if (DifferencesPanel.this.isDeleteMissingItems()) {
                    return this.m_iconDelete;
                }
                return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.m_iconDelete).getImage()));
            }
            if (eLocation == 0) {
                if (node instanceof DifferencesTreeModel.DataNode) {
                    return this.m_iconNew;
                }
                return this.m_iconBlank;
            }
            if (node.hasChanged()) {
                return this.m_iconChanged;
            }
            return this.m_iconBlank;
        }
    }

    private static class cExpansionListener
    implements TreeExpansionListener {
        private TreeSelectionModel m_mdl;

        public cExpansionListener(TreeSelectionModel mdl) {
            this.m_mdl = mdl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            WsTreeNode nodeCurrent = (WsTreeNode)e.getPath().getLastPathComponent();
            nodeCurrent.setIsExpanded(true);
            if (nodeCurrent.hasExpanded()) {
                return;
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            try {
                nodeCurrent.expand();
                if (this.m_mdl.isPathSelected(new TreePath(nodeCurrent.getPath()))) {
                    for (int iChild = 0; iChild < nodeCurrent.getChildCount(); ++iChild) {
                        WsTreeNode nodeChild = (WsTreeNode)nodeCurrent.getChildAt(iChild);
                        if (!(nodeChild instanceof DifferencesTreeModel.CheckableNode) || !((DifferencesTreeModel.CheckableNode)nodeChild).isCheckable()) continue;
                        this.m_mdl.addSelectionPath(new TreePath(nodeChild.getPath()));
                    }
                }
            }
            finally {
                Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            WsTreeNode nodeCurrent = (WsTreeNode)e.getPath().getLastPathComponent();
            nodeCurrent.setIsExpanded(false);
        }
    }

    protected static class cAutoChecker
    implements TreeSelectionListener {
        private TreeSelectionModel m_mdl;

        public cAutoChecker(TreeSelectionModel mdl) {
            this.m_mdl = mdl;
        }

        @Override
        public void valueChanged(TreeSelectionEvent ev) {
            TreePath[] aPaths = ev.getPaths();
            for (int iPath = 0; iPath < aPaths.length; ++iPath) {
                WsTreeNode node = (WsTreeNode)aPaths[iPath].getLastPathComponent();
                if (!(node instanceof DifferencesTreeModel.CheckableNode) || !((DifferencesTreeModel.CheckableNode)node).hasCheckableChildren()) continue;
                for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
                    WsTreeNode nodeChild = (WsTreeNode)node.getChildAt(iChild);
                    if (!(nodeChild instanceof DifferencesTreeModel.CheckableNode) || !((DifferencesTreeModel.CheckableNode)nodeChild).isCheckable()) continue;
                    if (ev.isAddedPath(iPath)) {
                        this.m_mdl.addSelectionPath(new TreePath(nodeChild.getPath()));
                        continue;
                    }
                    this.m_mdl.removeSelectionPath(new TreePath(nodeChild.getPath()));
                }
            }
        }
    }

    protected static class cScrollSynchronizer
    implements AdjustmentListener {
        private JScrollBar m_sbrOne;
        private JScrollBar m_sbrTwo;
        private boolean m_bEnabled;
        private boolean m_bIgnore;

        public cScrollSynchronizer() {
            this.setEnabled(true);
        }

        public cScrollSynchronizer(JScrollBar sbrOne, JScrollBar sbrTwo) {
            this.attach(sbrOne, sbrTwo);
            this.setEnabled(true);
        }

        public void attach(JScrollBar sbrOne, JScrollBar sbrTwo) {
            if (this.m_sbrOne != null || this.m_sbrTwo != null) {
                this.detach();
            }
            this.m_sbrOne = sbrOne;
            this.m_sbrTwo = sbrTwo;
            this.m_sbrOne.addAdjustmentListener(this);
            this.m_sbrTwo.addAdjustmentListener(this);
        }

        public void detach() {
            this.m_sbrOne.removeAdjustmentListener(this);
            this.m_sbrTwo.removeAdjustmentListener(this);
            this.m_sbrOne = null;
            this.m_sbrTwo = null;
        }

        public void setEnabled(boolean bEnabled) {
            this.m_bEnabled = bEnabled;
        }

        public boolean isEnabled() {
            return this.m_bEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adjustmentValueChanged(AdjustmentEvent ev) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_bIgnore) {
                return;
            }
            try {
                this.m_bIgnore = true;
                int minMax = Math.min(this.m_sbrOne.getMaximum() - this.m_sbrOne.getModel().getExtent(), this.m_sbrTwo.getMaximum() - this.m_sbrTwo.getModel().getExtent());
                int value = Math.min(ev.getValue(), minMax);
                this.m_sbrOne.setValue(value);
                this.m_sbrTwo.setValue(value);
            }
            finally {
                this.m_bIgnore = false;
            }
        }
    }

    protected static class cExpansionSynchronizer
    implements TreeExpansionListener {
        private JTree m_treeOne;
        private JTree m_treeTwo;
        private boolean m_bEnabled;
        private boolean m_bIgnore;

        public cExpansionSynchronizer() {
            this.setEnabled(true);
        }

        public cExpansionSynchronizer(JTree treeOne, JTree treeTwo) {
            this.attach(treeOne, treeTwo);
            this.setEnabled(true);
        }

        public void attach(JTree treeOne, JTree treeTwo) {
            if (this.m_treeOne != null || this.m_treeTwo != null) {
                this.detach();
            }
            this.m_treeOne = treeOne;
            this.m_treeTwo = treeTwo;
            this.m_treeOne.addTreeExpansionListener(this);
            this.m_treeTwo.addTreeExpansionListener(this);
        }

        public void detach() {
            this.m_treeOne.removeTreeExpansionListener(this);
            this.m_treeTwo.removeTreeExpansionListener(this);
            this.m_treeOne = null;
            this.m_treeTwo = null;
        }

        public void setEnabled(boolean bEnabled) {
            this.m_bEnabled = bEnabled;
        }

        public boolean isEnabled() {
            return this.m_bEnabled;
        }

        @Override
        public void treeExpanded(TreeExpansionEvent ev) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_bIgnore) {
                return;
            }
            try {
                this.m_bIgnore = true;
                if (ev.getSource() == this.m_treeOne) {
                    this.m_treeTwo.expandPath(ev.getPath());
                    this.m_treeTwo.getParent().validate();
                } else {
                    this.m_treeOne.expandPath(ev.getPath());
                    this.m_treeOne.getParent().validate();
                }
            }
            finally {
                this.m_bIgnore = false;
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent ev) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_bIgnore) {
                return;
            }
            try {
                this.m_bIgnore = true;
                if (ev.getSource() == this.m_treeOne) {
                    this.m_treeTwo.collapsePath(ev.getPath());
                } else {
                    this.m_treeOne.collapsePath(ev.getPath());
                }
            }
            finally {
                this.m_bIgnore = false;
            }
        }
    }

    protected static class cSelectionSynchronizer
    implements TreeSelectionListener {
        private JTree m_treeOne;
        private JTree m_treeTwo;
        private boolean m_bEnabled;
        private boolean m_bIgnore;

        public cSelectionSynchronizer() {
            this.setEnabled(true);
        }

        public cSelectionSynchronizer(JTree treeOne, JTree treeTwo) {
            this.attach(treeOne, treeTwo);
            this.setEnabled(true);
        }

        public void attach(JTree treeOne, JTree treeTwo) {
            if (this.m_treeOne != null || this.m_treeTwo != null) {
                this.detach();
            }
            this.m_treeOne = treeOne;
            this.m_treeTwo = treeTwo;
            this.m_treeOne.addTreeSelectionListener(this);
            this.m_treeTwo.addTreeSelectionListener(this);
        }

        public void detach() {
            this.m_treeOne.removeTreeSelectionListener(this);
            this.m_treeTwo.removeTreeSelectionListener(this);
            this.m_treeOne = null;
            this.m_treeTwo = null;
        }

        public void setEnabled(boolean bEnabled) {
            this.m_bEnabled = bEnabled;
        }

        public boolean isEnabled() {
            return this.m_bEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent ev) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_bIgnore) {
                return;
            }
            try {
                this.m_bIgnore = true;
                JTree treeTarget = ev.getSource() == this.m_treeOne ? this.m_treeTwo : this.m_treeOne;
                TreePath[] aPaths = ev.getPaths();
                for (int iPath = 0; iPath < aPaths.length; ++iPath) {
                    if (ev.isAddedPath(iPath)) {
                        treeTarget.addSelectionPath(aPaths[iPath]);
                        continue;
                    }
                    treeTarget.removeSelectionPath(aPaths[iPath]);
                }
            }
            finally {
                this.m_bIgnore = false;
            }
        }
    }

    protected class cActionUpdater
    implements TreeSelectionListener {
        protected cActionUpdater() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent ev) {
            DifferencesPanel.this.updateActions();
        }
    }

    protected class cSelectedColorListener
    implements PropertyChangeListener {
        protected cSelectedColorListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            DifferencesPanel.this.m_clrChangeBackground = (Color)e.getNewValue();
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(DifferencesPanel.CHANGE_BACKGROUND_COLOR, DifferencesPanel.this.m_clrChangeBackground.getRGB());
        }
    }

    protected class cDefaultColorListener
    implements PropertyChangeListener {
        protected cDefaultColorListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!ev.getPropertyName().equals(DifferencesPanel.CHANGE_BACKGROUND_COLOR)) {
                return;
            }
            DifferencesPanel.this.m_clrChangeBackground = new Color(Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(DifferencesPanel.CHANGE_BACKGROUND_COLOR, DifferencesPanel.this.m_clrChangeBackground.getRGB()));
            DifferencesPanel.this.m_btnColor.setSelectedColor(DifferencesPanel.this.m_clrChangeBackground);
            DifferencesPanel.this.repaint();
        }
    }

    protected class cDifferencesAction
    extends WsAbstractAction {
        public cDifferencesAction() {
            this.setMenuSupportId("differencesmenu");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    protected class cImpactAnalysisAction
    extends WsAbstractAction {
        public cImpactAnalysisAction() {
            super(bundle, "DifferencesPanel.Action.ImpactAnalysis", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ImpactAnalysis"));
            this.setMenuSupportId("impactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] aPaths = DifferencesPanel.this.m_treeTarget.getSelectionPaths();
            for (int iPath = 0; iPath < aPaths.length; ++iPath) {
                DifferencesTreeModel.DataNode node = (DifferencesTreeModel.DataNode)aPaths[iPath].getLastPathComponent();
                DifferencesPanel.this.showImpactAnalysis(node.getName(), node.getType(), node.getFQID(), true);
            }
        }
    }

    protected class cReverseImpactAnalysisAction
    extends WsAbstractAction {
        public cReverseImpactAnalysisAction() {
            super(bundle, "DifferencesPanel.Action.ReverseImpactAnalysis", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ReverseImpactAnalysis"));
            this.setMenuSupportId("reverseimpactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] aPaths = DifferencesPanel.this.m_treeTarget.getSelectionPaths();
            for (int iPath = 0; iPath < aPaths.length; ++iPath) {
                DifferencesTreeModel.DataNode node = (DifferencesTreeModel.DataNode)aPaths[iPath].getLastPathComponent();
                DifferencesPanel.this.showImpactAnalysis(node.getName(), node.getType(), node.getFQID(), false);
            }
        }
    }

    protected class cApplyAction
    extends WsAbstractAction {
        public cApplyAction() {
            super(bundle, "DifferencesPanel.Action.Apply", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Apply"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            String[][] saCheckedObjects = DifferencesPanel.this.getCheckedObjects();
            try {
                DifferencesPanel.this.m_bInApply = true;
                List lFQIDs = ((ComparisonResultsModel)DifferencesPanel.this.m_mdlDifferences).apply(saCheckedObjects);
                if (lFQIDs != null) {
                    DifferencesPanel.this.removeObjects(lFQIDs);
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (ComparisonResultsException cre) {
                MessageUtil.displayMessage((String)cre.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerCodeException ce) {
                ((ComparisonResultsModel)DifferencesPanel.this.m_mdlDifferences).showSASLogDialog(ce.getLocalizedMessage(), 0);
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)se);
            }
            finally {
                DifferencesPanel.this.m_bInApply = false;
            }
        }
    }

    protected class cDifferencesOnlyAction
    extends WsAbstractAction {
        public cDifferencesOnlyAction() {
            super(bundle, "DifferencesPanel.Action.DifferencesOnly", 0);
        }

        public void actionPerformed(ActionEvent e) {
            DifferencesPanel.this.setDifferencesOnly(DifferencesPanel.this.m_ckbDifferencesOnly.isSelected());
        }
    }

    protected class cDeleteMissingItemsAction
    extends WsAbstractAction {
        public cDeleteMissingItemsAction() {
            super(bundle, "DifferencesPanel.Action.DeleteMissingItems", 0);
        }

        public void actionPerformed(ActionEvent e) {
            DifferencesPanel.this.setDeleteMissingItems(DifferencesPanel.this.m_ckbDeleteMissingItems.isSelected());
        }
    }

    protected class cRefreshAction
    extends WsAbstractAction {
        public cRefreshAction() {
            super(bundle, "DifferencesPanel.Action.Refresh", 2);
            this.setMenuSupportId("refresh");
        }

        public void actionPerformed(ActionEvent e) {
            MessageUtil.displayMessage((String)"Refresh");
        }
    }

    protected class cRecompareAction
    extends WsAbstractAction {
        public cRecompareAction() {
            super(bundle, "DifferencesPanel.Action.Recompare", 2);
            this.setMenuSupportId("diffrecompare");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ((ComparisonResultsModel)DifferencesPanel.this.m_mdlDifferences).reCompare();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (ComparisonResultsException cre) {
                MessageUtil.displayMessage((String)cre.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerCodeException ce) {
                ((ComparisonResultsModel)DifferencesPanel.this.m_mdlDifferences).showSASLogDialog(ce.getLocalizedMessage(), 0);
            }
            finally {
                ((ComparisonResultsModel)DifferencesPanel.this.m_mdlDifferences).getAppServer().closeSASCodeSession();
                ((ComparisonResultsModel)DifferencesPanel.this.m_mdlDifferences).getAppServer().close();
            }
        }
    }

    protected class cRemoveAction
    extends WsAbstractAction {
        public cRemoveAction() {
            super(bundle, "DifferencesPanel.Action.Remove", 2);
            this.setMenuSupportId("diffremove");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ((ComparisonResultsModel)DifferencesPanel.this.m_mdlDifferences).remove(DifferencesPanel.this.getCheckedObjects());
            }
            catch (WsAppServerCodeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ComparisonResultsException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }
}

