/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.changeanalysis.ComparisonResultsException;
import com.sas.wadmin.changeanalysis.ComparisonResultsModel;
import com.sas.wadmin.changeanalysis.ComparisonResultsTableModel;
import com.sas.wadmin.changeanalysis.ComparisonResultsTreeModel;
import com.sas.wadmin.changeanalysis.DifferencesView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.changemanagement.CMEvent;
import com.sas.workspace.changemanagement.CMEventListener;
import com.sas.workspace.changemanagement.CMListenerManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ComparisonResultsPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ComparisonResultsPanel.class);
    private static String SETTINGS_PREFIX = "ComparisonResultsTable";
    private WsTable m_tblResults;
    private JScrollPane m_scrResults;
    private ComparisonResultsTableModel m_mdlResults;
    private JToolBar m_barTools;
    private WsAbstractAction m_actViewDifferences;
    private WsAbstractAction m_actRecompare;
    private WsAbstractAction m_actApply;
    private WsAbstractAction m_actViewActivity;
    private WsAbstractAction m_actDelete;
    private WsAbstractAction m_actRefresh;
    private WsDropMenuAction m_actSettings;
    private WsAbstractToggleAction m_actCompareOnlyChangesImported;
    private WsAbstractToggleAction m_actIgnoreCase;
    private WsAbstractToggleAction m_actOverwriteExistingData;
    private CMEventListener m_CMEventListener;

    public ComparisonResultsPanel() {
        this.initialize();
    }

    protected void initialize() {
        this.createActions();
        this.createTable();
        this.createToolBar();
        this.layoutComponents();
        this.m_CMEventListener = new cCMEventListener();
        CMListenerManager.getInstance().addChangeListener(this.m_CMEventListener);
        this.setHelpProduct("wdb");
        this.setHelpTopic("comparisontree");
    }

    private void createTable() {
        this.m_mdlResults = new ComparisonResultsTableModel();
        this.m_tblResults = new WsTable((WsAbstractTableModel)this.m_mdlResults);
        this.m_scrResults = new JScrollPane((Component)this.m_tblResults);
        this.m_tblResults.setEditable(false);
        this.m_tblResults.setAutoResizeMode(4);
        this.m_tblResults.setColumnHeaderVisible(true);
        this.m_tblResults.setColumnHidingEnabled(false);
        this.m_tblResults.setColumnHoldingEnabled(false);
        this.m_tblResults.setDeleteKeyAction((Action)this.m_actDelete);
        this.m_tblResults.setOriginPopupMenuEnabled(false);
        this.m_tblResults.setTablePopupMenuEnabled(false);
        this.m_tblResults.setRowHeaderVisible(true);
        this.m_tblResults.setRowHeaderPopupMenuEnabled(false);
        this.m_tblResults.setRowHoldingEnabled(false);
        this.m_tblResults.setRowsReorderable(false);
        this.m_tblResults.setSortingEnabled(true);
        this.m_tblResults.restoreSettings(SETTINGS_PREFIX);
        this.m_tblResults.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.m_tblResults.setDefaultAction((Action)this.m_actViewDifferences);
    }

    private void createActions() {
        this.m_actViewDifferences = new cViewDifferencesAction();
        this.m_actRecompare = new cRecompareAction();
        this.m_actApply = new cApplyAction();
        this.m_actViewActivity = new cViewActivityAction();
        this.m_actDelete = new DeleteAction();
        this.m_actRefresh = new RefreshAction();
        this.m_actSettings = new SettingsAction();
        this.m_actCompareOnlyChangesImported = new CompareOnlyChangesImportedAction();
        this.m_actIgnoreCase = new IgnoreCaseAction();
        this.m_actOverwriteExistingData = new OverwriteExistingDataAction();
        this.m_actSettings.setDropMenu(this.createSettingsDropMenu());
    }

    private void createToolBar() {
        this.m_barTools = WsUIUtilities.createToolBar();
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actViewDifferences));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRecompare));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actApply));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actViewActivity));
        this.m_barTools.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)this.m_actSettings));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actDelete));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRefresh));
    }

    private JPopupMenu createSettingsDropMenu() {
        JPopupMenu mnuDrop = new JPopupMenu();
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actCompareOnlyChangesImported));
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actIgnoreCase));
        mnuDrop.addSeparator();
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actOverwriteExistingData));
        return mnuDrop;
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.m_barTools, "North");
        this.add(this.m_scrResults, "Center");
    }

    public void moveDataToView() throws RemoteException, MdException {
        this.m_mdlResults.moveDataToModel();
        this.updateActions();
    }

    public boolean load() {
        return true;
    }

    public boolean save() {
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_tblResults.saveSettings(SETTINGS_PREFIX);
        CMListenerManager.getInstance().removeChangeListener(this.m_CMEventListener);
        try {
            this.m_mdlResults.dispose();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public boolean canClose() {
        return this.saveMetadata();
    }

    private boolean saveMetadata() {
        try {
            if (this.m_mdlResults.getStore() != null) {
                this.m_mdlResults.getStore().updatedMetadataAll();
            }
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Writing");
            return false;
        }
    }

    private ComparisonResultsModel getSelectedResultsModel() {
        int[] aRows = this.m_tblResults.getSelectedRowsFromSelectedCells();
        if (aRows == null || aRows.length == 0) {
            return null;
        }
        int iRow = this.m_tblResults.convertRowIndexToModel(aRows[0]);
        return (ComparisonResultsModel)this.m_mdlResults.getValueAt(iRow, 5);
    }

    private ComparisonResultsModel[] getAllSelectedResultsModels() {
        int[] aRows = this.m_tblResults.getSelectedRowsFromSelectedCells();
        if (aRows == null || aRows.length == 0) {
            return null;
        }
        this.m_tblResults.convertRowIndexesToModel(aRows);
        ComparisonResultsModel[] aModels = new ComparisonResultsModel[aRows.length];
        for (int iModel = 0; iModel < aRows.length; ++iModel) {
            aModels[iModel] = (ComparisonResultsModel)this.m_mdlResults.getValueAt(aRows[iModel], 5);
        }
        return aModels;
    }

    private void setOptionsToModel(ComparisonResultsModel mdlComparisonResults) {
        mdlComparisonResults.setOption("DeltaOnly", this.m_actCompareOnlyChangesImported.isSelected() ? "YES" : "NO");
        mdlComparisonResults.setOption("IgnoreCase", this.m_actIgnoreCase.isSelected() ? "YES" : "NO");
        mdlComparisonResults.setOption("RecompareOverwrite", this.m_actOverwriteExistingData.isSelected() ? "YES" : "NO");
    }

    private void updateActions() {
        int[] aRows = this.m_tblResults.getSelectedRowsFromSelectedCells();
        boolean bOneSelected = aRows.length == 1;
        boolean bAtLeastOneSelected = aRows.length > 0;
        this.m_actApply.setEnabled(bOneSelected);
        this.m_actRecompare.setEnabled(bOneSelected);
        this.m_actViewActivity.setEnabled(bOneSelected);
        this.m_actViewDifferences.setEnabled(bOneSelected);
        this.m_actDelete.setEnabled(bAtLeastOneSelected);
        this.m_actRefresh.setEnabled(true);
        this.m_actCompareOnlyChangesImported.setEnabled(bOneSelected);
        this.m_actIgnoreCase.setEnabled(bOneSelected);
        this.m_actOverwriteExistingData.setEnabled(bOneSelected);
        if (bOneSelected) {
            ComparisonResultsModel mdl = this.getSelectedResultsModel();
            this.m_actCompareOnlyChangesImported.setSelected(mdl.isDeltaOnly());
            this.m_actIgnoreCase.setSelected(mdl.isIgnoreCaseSensitive());
            this.m_actOverwriteExistingData.setSelected(mdl.isRecompareOverwriteData());
        } else {
            this.m_actCompareOnlyChangesImported.setSelected(false);
            this.m_actIgnoreCase.setSelected(false);
            this.m_actOverwriteExistingData.setSelected(false);
        }
    }

    private void handleViewDifferencesAction() {
        Tree mdo;
        if (this.getSelectedResultsModel() != null && (mdo = this.getSelectedResultsModel().getTree()) != null) {
            WsViewFactory.showView((CMetadata)mdo, DifferencesView.class);
        }
    }

    private void handleViewActivityAction() {
        ComparisonResultsModel mdl = this.getSelectedResultsModel();
        mdl.viewActivityLog();
    }

    private void handleApplyAction() {
        ComparisonResultsModel mdl = this.getSelectedResultsModel();
        try {
            mdl.apply();
        }
        catch (WsAppServerCodeException e) {
            mdl.showSASLogDialog(e.getLocalizedMessage(), 0);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (ComparisonResultsException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    private void handleRecompareAction() {
        ComparisonResultsModel mdl = this.getSelectedResultsModel();
        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("ComparisonResultsTreeModel.Recomparison.ProgressIndicator.Message.txt"), bundle.getString("ComparisonResultsTreeModel.Recomparison.ProgressIndicator.Title.txt"));
        request.setDelayBeforeProgressCancelDialog(500);
        request.setProgressShownOnStatusBar(false);
        ComparisonResultsTreeModel.RecomparisonRunnable recomparisonRunnable = new ComparisonResultsTreeModel.RecomparisonRunnable(mdl);
        request.execute((Runnable)recomparisonRunnable);
        if (!recomparisonRunnable.loginCanceled()) {
            if (recomparisonRunnable.showSASLogWithErrors()) {
                mdl.showSASLogDialog(recomparisonRunnable.getErrorMessage(), 0);
            } else if (recomparisonRunnable.wasSuccessful()) {
                mdl.showSASLogDialog();
            }
        }
    }

    private void doDelete() {
        ComparisonResultsModel[] aModels = this.getAllSelectedResultsModels();
        int eAnswer = MessageUtil.displayMessage((String)bundle.getString("ComparisonResultsPanel.ConfirmDelete.Message.txt"), (String)bundle.getString("ComparisonResultsPanel.ConfirmDelete.Title.txt"), (int)1, (int)0);
        if (eAnswer == 0) {
            this.deleteImpl(aModels);
            this.deleteSelectedRows();
        }
    }

    private void doRefresh() {
        try {
            this.m_mdlResults.moveDataToModel();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
    }

    private void handleSettingsChange() {
        if (this.m_tblResults.getSelectedRowsFromSelectedCells().length != 1) {
            return;
        }
        ComparisonResultsModel mdl = this.getSelectedResultsModel();
        try {
            this.setOptionsToModel(mdl);
            mdl.addAllOptionsToTree();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteImpl(ComparisonResultsModel[] aModels) {
        for (int iModel = 0; iModel < aModels.length; ++iModel) {
            ComparisonResultsModel mdl = aModels[iModel];
            try {
                mdl.delete();
                continue;
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                continue;
            }
            catch (ComparisonResultsException e) {
                if (e.getExceptionType() != 2) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                    continue;
                }
                int choice = MessageUtil.displayMessage((String)bundle.formatString("ComparisonResultsTreeModel.DeleteError.txt", (Object)e.getLocalizedMessage()), (int)0, (int)0);
                if (choice != 0) continue;
                try {
                    mdl.deleteComparisonResultTreeObjects();
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                continue;
            }
            catch (WsAppServerCodeException e) {
                mdl.showSASLogDialog(e.getLocalizedMessage(), 0);
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                continue;
            }
            finally {
                mdl.dispose();
            }
        }
    }

    private void deleteSelectedRows() {
        int[] aRows = this.m_tblResults.getSelectedRowsFromSelectedCells();
        if (aRows == null || aRows.length == 0) {
            return;
        }
        this.m_tblResults.convertRowIndexesToModel(aRows);
        for (int i = 0; i < aRows.length; ++i) {
            this.m_mdlResults.deleteRow(aRows[i]);
        }
    }

    private class cCMEventListener
    implements CMEventListener {
        private cCMEventListener() {
        }

        public void CMObjectsUpdated(CMEvent ev) {
        }

        public void CMObjectsDeleted(CMEvent ev) {
            if (ev.getCMAction().equals("CLEARPROJECT")) {
                ComparisonResultsPanel.this.doRefresh();
            }
        }

        public void CMObjectsCreated(CMEvent ev) {
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            ComparisonResultsPanel.this.updateActions();
        }
    }

    private class cViewDifferencesAction
    extends WsAbstractAction {
        public cViewDifferencesAction() {
            super(bundle, "ComparisonResultsPanel.Action.ViewDifferences", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ViewDifferences"));
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent ev) {
            ComparisonResultsPanel.this.handleViewDifferencesAction();
        }
    }

    private class cRecompareAction
    extends WsAbstractAction {
        public cRecompareAction() {
            super(bundle, "ComparisonResultsPanel.Action.Recompare", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Recompare"));
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent ev) {
            ComparisonResultsPanel.this.handleRecompareAction();
        }
    }

    private class cApplyAction
    extends WsAbstractAction {
        public cApplyAction() {
            super(bundle, "ComparisonResultsPanel.Action.Apply", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Apply"));
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent ev) {
            ComparisonResultsPanel.this.handleApplyAction();
        }
    }

    private class cViewActivityAction
    extends WsAbstractAction {
        public cViewActivityAction() {
            super(bundle, "ComparisonResultsPanel.Action.ViewActivity", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("CheckOuts:History"));
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent ev) {
            ComparisonResultsPanel.this.handleViewActivityAction();
        }
    }

    private class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "ComparisonResultsPanel.Action.Delete", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Delete"));
        }

        public void actionPerformed(ActionEvent ev) {
            ComparisonResultsPanel.this.doDelete();
        }
    }

    private class RefreshAction
    extends WsAbstractAction {
        public RefreshAction() {
            super(bundle, "ComparisonResultsPanel.Action.Refresh", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Refresh"));
        }

        public void actionPerformed(ActionEvent ev) {
            ComparisonResultsPanel.this.doRefresh();
        }
    }

    private class SettingsAction
    extends WsDropMenuAction {
        public SettingsAction() {
            super(bundle, "ComparisonResultsPanel.Action.Settings", 256);
        }
    }

    private class CompareOnlyChangesImportedAction
    extends WsAbstractToggleAction {
        public CompareOnlyChangesImportedAction() {
            super(bundle, "ComparisonResultsPanel.Action.CompareOnlyChangesImported", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            ComparisonResultsPanel.this.handleSettingsChange();
        }
    }

    private class IgnoreCaseAction
    extends WsAbstractToggleAction {
        public IgnoreCaseAction() {
            super(bundle, "ComparisonResultsPanel.Action.IgnoreCase", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            ComparisonResultsPanel.this.handleSettingsChange();
        }
    }

    private class OverwriteExistingDataAction
    extends WsAbstractToggleAction {
        public OverwriteExistingDataAction() {
            super(bundle, "ComparisonResultsPanel.Action.OverwriteExistingData", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            ComparisonResultsPanel.this.handleSettingsChange();
        }
    }
}

