/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.changeanalysis.ComparisonResultsException;
import com.sas.wadmin.changeanalysis.ComparisonResultsModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ComparisonResultsOptionsPanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ComparisonResultsOptionsPanel.class);
    private JCheckBox m_ckbCompareDeltaOnly;
    private JCheckBox m_ckbIgnoreCase;
    private JCheckBox m_ckbOverwriteExisting;
    private JCheckBox m_ckbUseCustomDictionary;
    private JCheckBox m_ckbAutoAddToCustomDictionary;
    private JLabel m_lblFormatFile;
    private WAComboBox m_cmbFormatFile;
    private JButton m_btnBrowse;
    private JLabel m_lblDelimiter;
    private WATextField m_txtDelimiter;
    private WsAbstractAction m_actBrowse;
    private ComparisonResultsModel m_mdlComparisonResults;
    private File m_oCustomDictionaryFile;
    private boolean m_showCustom;
    private static final String FORMAT_FILES_KEY = "ComparisonResultsOptions.CustomFormatFiles";
    private static final int FORMAT_FILES_MAX = 8;

    public ComparisonResultsOptionsPanel(ComparisonResultsModel model) {
        this(model, false);
    }

    public ComparisonResultsOptionsPanel(ComparisonResultsModel model, boolean showCustom) {
        this.m_mdlComparisonResults = model;
        this.m_showCustom = showCustom;
        this.setHelpProduct("importca");
        this.setHelpTopic("ca_options_win");
        this.initialize();
    }

    protected void initialize() {
        this.m_ckbCompareDeltaOnly = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ComparisonResultsOptionsPanel.Label.CompareDelta");
        this.m_ckbCompareDeltaOnly.setSelected(true);
        this.m_ckbIgnoreCase = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ComparisonResultsOptionsPanel.Label.IgnoreCase");
        this.m_ckbIgnoreCase.setSelected(true);
        this.m_ckbOverwriteExisting = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ComparisonResultsOptionsPanel.Label.Overwrite");
        JPanel pnlGeneral = new JPanel();
        pnlGeneral.setLayout(new BorderLayout());
        pnlGeneral.add((Component)this.m_ckbCompareDeltaOnly, "North");
        pnlGeneral.add((Component)this.m_ckbIgnoreCase, "South");
        pnlGeneral.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ComparisonResultsOptionsPanel.Label.General.txt")));
        JPanel pnlRecompare = new JPanel();
        pnlRecompare.setLayout(new BorderLayout());
        pnlRecompare.add((Component)this.m_ckbOverwriteExisting, "North");
        pnlRecompare.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ComparisonResultsOptionsPanel.Label.Recompare.txt")));
        this.setLayout(new BorderLayout());
        this.add(pnlGeneral, "North");
        this.add(pnlRecompare, "Center");
        if (this.m_showCustom) {
            this.m_cmbFormatFile = new WAComboBox();
            this.m_cmbFormatFile.setEditable(true);
            this.m_cmbFormatFile.setEnabled(false);
            this.m_lblFormatFile = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbFormatFile, (WAdminResource)bundle, (String)"ComparisonResultsOptionsPanel.Label.EFF");
            this.m_txtDelimiter = new WATextField();
            this.m_txtDelimiter.setColumns(1);
            this.m_txtDelimiter.setMaxCharacters(1);
            this.m_txtDelimiter.setEditable(true);
            this.m_lblDelimiter = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtDelimiter, (WAdminResource)bundle, (String)"ComparisonResultsOptionsPanel.Label.Delimiter");
            this.m_ckbUseCustomDictionary = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ComparisonResultsOptionsPanel.Label.UseCustomDic");
            this.m_ckbAutoAddToCustomDictionary = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ComparisonResultsOptionsPanel.Label.AutoAdd");
            this.m_actBrowse = new cBrowseAction();
            this.m_btnBrowse = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actBrowse);
            cItemListener itmListener = new cItemListener();
            this.m_ckbUseCustomDictionary.addItemListener(itmListener);
            JPanel pnlCustom = new JPanel();
            pnlCustom.setLayout(new GridBagLayout());
            pnlCustom.add((Component)this.m_ckbUseCustomDictionary, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            pnlCustom.add((Component)this.m_lblDelimiter, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 5), 0, 0));
            pnlCustom.add((Component)this.m_lblFormatFile, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 24, 0, 0), 0, 0));
            pnlCustom.add((Component)this.m_cmbFormatFile, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            pnlCustom.add((Component)this.m_btnBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            pnlCustom.add((Component)this.m_txtDelimiter, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            pnlCustom.add((Component)this.m_ckbAutoAddToCustomDictionary, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
            pnlCustom.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ComparisonResultsOptionsPanel.Label.CustomDic.txt")));
            this.add(pnlCustom, "South");
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (!this.m_mdlComparisonResults.isWizard()) {
            this.m_mdlComparisonResults.populateStore();
        }
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        try {
            if (!this.m_mdlComparisonResults.isWizard()) {
                this.m_mdlComparisonResults.moveDataToModel();
            }
            this.m_ckbCompareDeltaOnly.setSelected(this.m_mdlComparisonResults.isDeltaOnly());
            this.m_ckbIgnoreCase.setSelected(this.m_mdlComparisonResults.isIgnoreCaseSensitive());
            this.m_ckbOverwriteExisting.setSelected(this.m_mdlComparisonResults.isRecompareOverwriteData());
            if (this.m_showCustom) {
                this.m_cmbFormatFile.loadItems(FORMAT_FILES_KEY, 8);
                this.m_ckbUseCustomDictionary.setSelected(this.m_mdlComparisonResults.useCustomDictionary());
                this.m_ckbAutoAddToCustomDictionary.setSelected(this.m_mdlComparisonResults.isAutoAddToCustom());
                this.m_oCustomDictionaryFile = this.m_mdlComparisonResults.getCustomFile();
                if (this.m_oCustomDictionaryFile == null) {
                    this.m_cmbFormatFile.setSelectedIndex(0);
                } else {
                    this.m_cmbFormatFile.setSelectedItem((Object)this.m_oCustomDictionaryFile.getFileName());
                }
                this.m_txtDelimiter.setText(this.m_mdlComparisonResults.getCustomExternalFormatFileDelimiter());
                if (this.m_txtDelimiter.getText().trim().length() == 0) {
                    this.m_txtDelimiter.setText(",");
                }
            }
        }
        catch (ComparisonResultsException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_mdlComparisonResults.setOption("DeltaOnly", this.m_ckbCompareDeltaOnly.isSelected() ? "YES" : "NO");
        this.m_mdlComparisonResults.setOption("IgnoreCase", this.m_ckbIgnoreCase.isSelected() ? "YES" : "NO");
        this.m_mdlComparisonResults.setOption("RecompareOverwrite", this.m_ckbOverwriteExisting.isSelected() ? "YES" : "NO");
        if (this.m_showCustom) {
            if (this.m_ckbUseCustomDictionary.isSelected()) {
                this.m_cmbFormatFile.saveItems(FORMAT_FILES_KEY, 8);
                this.m_mdlComparisonResults.setOption("UseCustomDictionary", this.m_ckbUseCustomDictionary.isSelected() ? "YES" : "NO");
                this.m_mdlComparisonResults.setOption("AutoAddToCustom", this.m_ckbAutoAddToCustomDictionary.isSelected() ? "YES" : "NO");
                this.m_mdlComparisonResults.setCustomExternalFormatFile((String)this.m_cmbFormatFile.getSelectedItem(), this.m_txtDelimiter.getText());
                if (!this.m_mdlComparisonResults.isWizard()) {
                    if (this.m_oCustomDictionaryFile != null) {
                        this.m_oCustomDictionaryFile.setFileName((String)this.m_cmbFormatFile.getSelectedItem());
                        this.m_mdlComparisonResults.setCustomExternalFormatFileDelimiter(this.m_oCustomDictionaryFile, this.m_txtDelimiter.getText());
                    } else {
                        this.m_mdlComparisonResults.createCustomFileAndAddToTree();
                    }
                }
            } else if (this.m_oCustomDictionaryFile != null && !this.m_mdlComparisonResults.isWizard()) {
                this.m_mdlComparisonResults.removeCustomFileFromStore();
            }
        }
        if (!this.m_mdlComparisonResults.isWizard()) {
            this.m_mdlComparisonResults.addAllOptionsToTree();
        }
        this.setDataChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateData() {
        if (this.m_showCustom && this.m_ckbUseCustomDictionary.isSelected()) {
            String sFileName = (String)this.m_cmbFormatFile.getSelectedItem();
            if (sFileName == null || sFileName.length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ComparisonResultsOptionsPanel.Error.NoFormatFileSpecified.txt"), (int)0);
                this.m_cmbFormatFile.requestFocus();
                return false;
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer appServer = this.m_mdlComparisonResults.getAppServer();
                if (appServer == null) {
                    boolean bl = false;
                    return bl;
                }
                appServer.doesFileExist(sFileName);
            }
            catch (WsAppServerFailException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                boolean bl = false;
                return bl;
            }
            catch (GenericError e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                this.m_cmbFormatFile.requestFocus();
                boolean bl = false;
                return bl;
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_ckbCompareDeltaOnly.setEnabled(bEditable);
        this.m_ckbIgnoreCase.setEnabled(bEditable);
        this.m_ckbOverwriteExisting.setEnabled(bEditable);
        if (this.m_showCustom) {
            this.m_ckbUseCustomDictionary.setEnabled(bEditable);
            boolean isSelected = this.m_ckbUseCustomDictionary.isSelected();
            this.m_lblFormatFile.setEnabled(bEditable && isSelected);
            this.m_cmbFormatFile.setEnabled(bEditable && isSelected);
            this.m_actBrowse.setEnabled(bEditable && isSelected);
            this.m_txtDelimiter.setEnabled(bEditable && isSelected);
            this.m_lblDelimiter.setEnabled(bEditable && isSelected);
            this.m_ckbAutoAddToCustomDictionary.setEnabled(bEditable && isSelected);
        }
    }

    private class cBrowseAction
    extends WsAbstractAction {
        public cBrowseAction() {
            super(bundle, "ComparisonResultsOptionsPanel.Action.Browse", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                String filename;
                ComparisonResultsOptionsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer appServer = ComparisonResultsOptionsPanel.this.m_mdlComparisonResults.getAppServer();
                if (appServer == null) {
                    return;
                }
                LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                mapFileTypes.put(bundle.getString("ComparisonResultsOptionsPanel.DelimitedFileTypes.txt"), "CSV");
                mapFileTypes.put(bundle.getString("ComparisonResultsOptionsPanel.AllFileTypes.txt"), "*");
                if (appServer.getOperatingSystem().equalsIgnoreCase("OS")) {
                    MessageUtil.displayMessage((String)bundle.getString("ComparisonResultsOptionsPanel.Error.UnableToBrowse.txt"), (int)0);
                    return;
                }
                String sName = (String)ComparisonResultsOptionsPanel.this.m_cmbFormatFile.getSelectedItem();
                if (sName == null) {
                    sName = "";
                }
                if ((filename = appServer.promptForFilename(bundle.getString("ComparisonResultsOptionsPanel.RemoteFileSelector.Title.txt"), sName, mapFileTypes)) != null) {
                    ComparisonResultsOptionsPanel.this.m_cmbFormatFile.setSelectedItem((Object)filename);
                }
            }
            catch (WsAppServerFailException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            finally {
                ComparisonResultsOptionsPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class cItemListener
    implements ItemListener {
        private cItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JCheckBox ckBox = (JCheckBox)e.getSource();
            boolean bSelected = ckBox.isSelected();
            ComparisonResultsOptionsPanel.this.m_lblFormatFile.setEnabled(bSelected);
            ComparisonResultsOptionsPanel.this.m_cmbFormatFile.setEnabled(bSelected);
            ComparisonResultsOptionsPanel.this.m_actBrowse.setEnabled(bSelected);
            ComparisonResultsOptionsPanel.this.m_txtDelimiter.setEnabled(bSelected);
            ComparisonResultsOptionsPanel.this.m_lblDelimiter.setEnabled(bSelected);
            ComparisonResultsOptionsPanel.this.m_ckbAutoAddToCustomDictionary.setEnabled(bSelected);
        }
    }
}

