/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.actions.AbstractSelectionToggleAction;
import com.sas.wadmin.pfd.PFDUtil;
import com.sas.wadmin.transforms.sql.editor.JoinDiagramTab;
import com.sas.wadmin.transforms.sql.editor.NavigatorTree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.text.MessageFormat;

public class UseAsWebStreamAction
extends AbstractSelectionToggleAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(UseAsWebStreamAction.class);

    public UseAsWebStreamAction() {
        super(bundle, "AppActionsManager.Action.ContextUseAsWebStream", 256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (!Workspace.isObjectEditable((SimpleObject)((SimpleObject)aSelectedObjects[0]))) {
            if (Workspace.getWorkspace().isChangeManagementOn()) {
                Object[] sName = new String[]{((SimpleObject)aSelectedObjects[0]).getName()};
                String sMessage = MessageFormat.format(bundle.getString("UseAsWebStreamAction.Checkout.Error.txt"), sName);
                MessageUtil.displayMessage((String)sMessage, (int)0);
            } else {
                Object[] sName = new String[]{((SimpleObject)aSelectedObjects[0]).getName()};
                String sMessage = MessageFormat.format(bundle.getString("UseAsWebStreamAction.NotEditable.Error.txt"), sName);
                MessageUtil.displayMessage((String)sMessage, (int)0);
            }
            return;
        }
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "UseAsWebStreamAction:actionPerformed");
            try {
                String sTemplate = "<TEMPLATES><PhysicalTable><Extensions/></PhysicalTable></TEMPLATES>";
                DataTable tableNode = (DataTable)ObjectConverter.getInstance().convertToJOMAObject(store, (SimpleObject)aSelectedObjects[0], sTemplate);
                if (PFDUtil.isWebServiceStream(tableNode)) {
                    PFDUtil.manageWebServiceStream(false, tableNode, bundle);
                } else {
                    PFDUtil.manageWebServiceStream(true, tableNode, bundle);
                }
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    @Override
    protected boolean isEnabledForSelection(Object[] aSelectedObjects) {
        return aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof SimpleObject && "Table".equals(((SimpleObject)aSelectedObjects[0]).getPublicType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isSelectedForSelection(Object[] aSelectedObjects) {
        block7: {
            if (this.isEnabledForSelection(aSelectedObjects)) {
                boolean bl;
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "UseAsWebStreamAction:isSelectedForSelection");
                try {
                    String sTemplate = "<TEMPLATES><PhysicalTable><Extensions/></PhysicalTable></TEMPLATES>";
                    DataTable tableNode = (DataTable)ObjectConverter.getInstance().convertToJOMAObject(store, (SimpleObject)aSelectedObjects[0], sTemplate);
                    bl = PFDUtil.isWebServiceStream(tableNode);
                }
                catch (Throwable throwable) {
                    try {
                        store.dispose();
                        throw throwable;
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                        break block7;
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Writing");
                    }
                }
                store.dispose();
                return bl;
            }
        }
        return false;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if (context instanceof JoinDiagramTab.DiagramContext || context instanceof NavigatorTree.TreeContext) {
            return false;
        }
        return this.isEnabledForSelection(context.getSelectedObjects());
    }
}

