/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.editor.LogListHolder;
import com.sas.editor.LogListViewer;
import com.sas.etl.models.data.impl.BaseLibrary;
import com.sas.etl.models.data.impl.BaseWorkTable;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.wadmin.jobeditor.diagram.ISASApplicationServerDiagramPanel;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.PhysicalTableUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

public class UpdateMetadataAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(UpdateMetadataAction.class);
    private LogListViewer m_lSASLog;
    private int m_totalTables;
    private Map m_tablesModified;
    private WsAppServer m_defaultAppserver;
    private boolean m_termAppServer = true;
    private MdObjectStore m_store;

    public UpdateMetadataAction() {
        super(bundle, "AppActionsManager.Action.ActionsUpdateMetadata", 257);
    }

    protected void createDefaultAppServer() {
        this.m_defaultAppserver = WsAppServer.createDefaultAppServer((boolean)true);
        this.m_termAppServer = true;
    }

    protected void initialize() throws RemoteException {
        this.m_tablesModified = new HashMap();
        this.m_totalTables = 0;
        WsSelectionProvider provider = this.getSelectionProvider();
        if (provider instanceof ISASApplicationServerDiagramPanel) {
            this.m_defaultAppserver = ((ISASApplicationServerDiagramPanel)provider).getSASAppServer();
        }
        if (this.m_defaultAppserver == null) {
            this.createDefaultAppServer();
        } else {
            this.m_termAppServer = false;
        }
        this.m_store = Workspace.getMdFactory().createObjectStore(null, "UpdateMetadataAction: store");
        String[] strArray = new String[1];
        Integer[] intArray = new Integer[1];
        strArray[0] = "";
        intArray[0] = new Integer(5);
        this.m_lSASLog = new LogListViewer(5, new LogListHolder(strArray, intArray), Workspace.getWorkspace().getCodeEditorDefaults());
        this.m_lSASLog.setDefaults(Workspace.getWorkspace().getCodeEditorDefaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        try {
            int failedTables;
            BaseLibrary workLib = null;
            for (int iObject = 0; iObject < aSelectedObjects.length; ++iObject) {
                SimpleObject obj = (SimpleObject)aSelectedObjects[iObject];
                if (obj.getMetadataType().equalsIgnoreCase("WorkTable") && obj.getID().indexOf("$") > -1) {
                    MessageUtil.displayMessage((String)bundle.getString("UpdateMetadataAction.JobMustBeSaved.Message.txt"));
                    return;
                }
                if (!(obj instanceof BaseWorkTable)) continue;
                BaseWorkTable wt = (BaseWorkTable)obj;
                workLib = (BaseLibrary)wt.getLibraryForUseInJob();
            }
            this.initialize();
            if (this.m_defaultAppserver == null) {
                return;
            }
            Root workLibrary = null;
            if (workLib != null) {
                workLibrary = ObjectConverter.getInstance().convertToJOMAObject(this.m_store, (SimpleObject)workLib);
            }
            Root[] tables = ObjectConverter.getInstance().convertToJOMAObjects(this.m_store, aObjects);
            this.m_totalTables = tables.length;
            int showMessage = 0;
            ParametersModel parmModel = new ParametersModel();
            boolean bUpdateStatus = PhysicalTableUtil.updateTableMetadata((ParametersInterface)parmModel, (Map)this.m_tablesModified, (LogListViewer)this.m_lSASLog, (WsAppServer)this.m_defaultAppserver, (CMetadata[])tables, (CMetadata)workLibrary);
            if (bUpdateStatus && (showMessage = (failedTables = this.m_totalTables - this.m_tablesModified.size()) > 0 ? MessageUtil.displayMessage((String)bundle.formatString("UpdateMetadataAction.UpdateTableSummary.fmt.txt", (Object)new Integer(this.m_totalTables - failedTables), (Object)new Integer(this.m_totalTables), (Object)new Integer(failedTables)), (String)bundle.getString("UpdateMetadataAction.Resync.Title.txt"), (int)0, (int)0) : MessageUtil.displayMessage((String)bundle.formatString("UpdateMetadataAction.UpdateTableSummary.fmt.txt", (Object)new Integer(this.m_totalTables - failedTables), (Object)new Integer(this.m_totalTables), (Object)new Integer(failedTables)), (String)bundle.getString("UpdateMetadataAction.Resync.Title.txt"), (int)1, (int)0)) == 0) {
                SASLogDialog logDlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("UpdateMetadataAction.Resync.ShowLog.title.txt"), true, this.m_lSASLog);
                logDlg.setResizable(true);
                logDlg.show();
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        finally {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        if (this.m_tablesModified != null) {
            this.m_tablesModified.clear();
            this.m_tablesModified = null;
        }
        try {
            if (this.m_store != null) {
                this.m_store.dispose();
                this.m_store = null;
            }
            if (this.m_defaultAppserver != null && this.m_termAppServer) {
                this.m_defaultAppserver.close();
                this.m_defaultAppserver.dispose();
                this.m_defaultAppserver = null;
            }
            if (this.m_lSASLog != null) {
                this.m_lSASLog.cleanup();
                this.m_lSASLog = null;
            }
            this.m_totalTables = 0;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aSelectedObjects.length; ++iObject) {
            if (!(aSelectedObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            SimpleObject obj = (SimpleObject)aSelectedObjects[iObject];
            if (!"Table".equals(obj.getPublicType()) && !obj.getMetadataType().equalsIgnoreCase("WorkTable")) {
                return false;
            }
            if (Workspace.isObjectEditable((SimpleObject)obj)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        Object[] aSelectedObjects = context.getSelectedObjects();
        if (aSelectedObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aSelectedObjects.length; ++iObject) {
            if (!(aSelectedObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            SimpleObject obj = (SimpleObject)aSelectedObjects[iObject];
            if ("Table".equals(obj.getPublicType()) || obj.getMetadataType().equalsIgnoreCase("WorkTable")) continue;
            return false;
        }
        return true;
    }
}

