/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.ChangeManagementUtil;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;

class UndoCheckOutAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(UndoCheckOutAction.class);

    public UndoCheckOutAction() {
        super(bundle, "AppActionsManager.Action.CheckOutsUndoCheckOut", 0);
        this.setIcon(AppIconFactory.getInstance().getIconForAction("CheckOuts:UndoCheckOut"));
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        ChangeManagementUtil.undoCheckOut(aObjects);
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aSelectedObjects.length; ++iObject) {
            if (!(aSelectedObjects[iObject] instanceof SimpleBrowseObject)) {
                return false;
            }
            SimpleBrowseObject simpleObject = (SimpleBrowseObject)aSelectedObjects[iObject];
            if (ChangeManagementUtil.isUndoCheckOutAllowed(simpleObject)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if (!"CheckoutsTree".equals(context.getType())) {
            return false;
        }
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] instanceof SimpleObject && ((SimpleObject)aObjects[iObject]).isPublicObject()) continue;
            return false;
        }
        return true;
    }
}

