/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.wadmin.app.AppDialogFactory;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import javax.swing.JFrame;

class RegisterTablesAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(RegisterTablesAction.class);

    public RegisterTablesAction() {
        super(bundle, "AppActionsManager.Action.FileRegisterTables", 257);
        this.setIcon(AppIconFactory.getInstance().getIconForAction("File:RegisterTables"));
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        SimpleObject folder = null;
        SimpleObject library = null;
        if (aSelectedObjects != null && aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof SimpleObject) {
            SimpleObject object = (SimpleObject)aSelectedObjects[0];
            String sType = object.getPublicType();
            if ("Folder".equals(sType)) {
                folder = object;
            } else if ("Library".equals(sType)) {
                library = object;
            }
        }
        AppDialogFactory.getInstance().showRegisterTablesDialog((JFrame)Workspace.getWorkspace(), library, folder);
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        return true;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if ("TransformationsTree".equals(context.getType()) || "DiagramTab".equals(context.getType())) {
            return false;
        }
        Object[] aObjects = context.getSelectedObjects();
        if ("InventoryTree".equals(context.getType())) {
            try {
                if (aObjects.length == 1 && aObjects[0] instanceof TypeDescriptorInterface && "Table".equals(((TypeDescriptorInterface)aObjects[0]).getTypeName())) {
                    return true;
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return false;
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
                return false;
            }
        }
        if (aObjects.length == 0 && ("FoldersTree".equals(context.getType()) || "CheckoutsTree".equals(context.getType()))) {
            return true;
        }
        return aObjects.length == 1 && aObjects[0] instanceof SimpleObject && ("Folder".equals(((SimpleObject)aObjects[0]).getPublicType()) || "Library".equals(((SimpleObject)aObjects[0]).getPublicType()));
    }

    @Override
    protected boolean isEnabledWhenNoSelectionProvider() {
        return true;
    }
}

