/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.metadata.promotion.visuals.CopyListListener;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.TransportUtil;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.wadmin.jobeditor.diagram.DiagramPanel;
import com.sas.wadmin.jobeditor.diagram.DiagramTab;
import com.sas.wadmin.jobeditor.diagram.copypaste.PFDCopyPaste;
import com.sas.wadmin.jobeditor.diagram.copypaste.PFDCopyPasteSerializer;
import com.sas.wadmin.jobeditor.diagram.copypaste.PFDObjectSelection;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.tree.TransformationsTree;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

class JobPasteAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(JobPasteAction.class);

    public JobPasteAction() {
        super(bundle, "AppActionsManager.Action.EditPaste", 0);
        this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Paste"));
        CopyPasteUtil.addCopyListListener((CopyListListener)new CopyListListener(){

            public void copyListChanged() {
                WsSelectionProvider selectionProvider;
                WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
                if (actionsMgr != null && (selectionProvider = actionsMgr.getSelectionProvider()) != null) {
                    Object[] aSelectedObjects = selectionProvider.getSelectedObjects();
                    JobPasteAction.this.setEnabled(JobPasteAction.this.isSelectionValid(aSelectedObjects));
                    return;
                }
                JobPasteAction.this.setEnabled(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        WsSelectionProvider provider = this.getSelectionProvider();
        if (!(provider instanceof DiagramTab)) {
            this.actionPerformedForPaste(aSelectedObjects);
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        DiagramTab diagram = (DiagramTab)provider;
        DiagramPanel panel = diagram.getDiagramPanel();
        DesignTimeJobModel model = panel.getJobModel();
        try {
            Transferable t = clipboard.getContents(null);
            PFDCopyPasteSerializer s = (PFDCopyPasteSerializer)t.getTransferData(PFDCopyPaste.PFDFlavor);
            PFDObjectSelection cp = new PFDObjectSelection(s);
            cp.pasteObjects(panel.getDiagramModel(), (IModel)model, Workspace.getMdFactory(), model.getJob(), true);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
            Workspace.handleServiceException((ServiceException)e);
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (IOException e) {
            ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (SAXException e) {
            ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (ParserConfigurationException e) {
            ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (ClassNotFoundException e) {
            ModelLogger.getDefaultLogger().error((Object)"ClassNotFoundException", (Throwable)e);
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (UnsupportedFlavorException e) {
            ModelLogger.getDefaultLogger().error((Object)"UnsupportedFlavorException", (Throwable)e);
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        WsSelectionProvider provider = this.getSelectionProvider();
        if (!(provider instanceof DiagramTab)) {
            return this.isSelectionValidForPaste(aSelectedObjects);
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        return contents != null && contents.isDataFlavorSupported(PFDCopyPaste.PFDFlavor);
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        WsSelectionProvider provider = this.getSelectionProvider();
        if (!(provider instanceof DiagramTab)) {
            return this.isValidForContextForPaste(context);
        }
        return "DiagramTab".equals(context.getType()) && context.getSelectedObjects()[0] instanceof IJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionPerformedForPaste(Object[] aSelectedObjects) {
        if (this.getSelectionProvider() instanceof TransformationsTree) {
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "PasteAction:actionPerformed");
                try {
                    Tree tree = WsMetadataUtil.getDefaultFolder((MdObjectStore)store);
                    if (tree != null) {
                        SimpleObjectImpl folder = new SimpleObjectImpl(tree.getName(), tree.getFQID(), tree.getCMetadataType(), tree.getPublicType());
                        String sCategory = aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof String ? (String)aSelectedObjects[0] : "";
                        TransportUtil.doPaste((SimpleObject)folder, sCategory);
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                catch (ServiceException se) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)se);
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        } else if (aSelectedObjects.length == 0) {
            TransportUtil.doPaste();
        } else {
            TransportUtil.doPaste((SimpleObject)aSelectedObjects[0]);
        }
    }

    protected boolean isSelectionValidForPaste(Object[] aSelectedObjects) {
        if (!CopyPasteUtil.isPasteAllowed()) {
            return false;
        }
        if (aSelectedObjects.length == 0) {
            return true;
        }
        if (aSelectedObjects.length == 1) {
            Object obj = aSelectedObjects[0];
            if (obj instanceof SimpleObject && "Folder".equals(((SimpleObject)aSelectedObjects[0]).getPublicType())) {
                return true;
            }
            if (obj instanceof String) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidForContextForPaste(WsActionContextInterface context) {
        if ("InventoryTree".equals(context.getType())) {
            return false;
        }
        if ("DiagramTab".equals(context.getType())) {
            return false;
        }
        Object[] aObjects = context.getSelectedObjects();
        if ("TransformationsTree".equals(context.getType()) && aObjects.length == 1 && aObjects[0] instanceof String) {
            return true;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] instanceof SimpleObject && "Folder".equals(((SimpleObject)aObjects[iObject]).getPublicType())) continue;
            return false;
        }
        return true;
    }
}

