/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.AppDialogFactory;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.tree.TransformationsTree;
import java.rmi.RemoteException;

class ImportSASPackageAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(ImportSASPackageAction.class);

    public ImportSASPackageAction() {
        super(bundle, "AppActionsManager.Action.FileImportSASPackage", 0);
        this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Import"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (WsViewFactory.anyViewsExist()) {
            String sTitle = bundle.getString("ImportSASPackageAction.Title.txt");
            String sMessage = bundle.formatString("ImportSASPackageAction.Message.fmt", (Object)Workspace.getWorkspace().getApplicationName());
            MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)2);
            return;
        }
        if (this.getSelectionProvider() instanceof TransformationsTree) {
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ImportSASPackageAction:actionPerformed");
                try {
                    Tree tree = WsMetadataUtil.getDefaultFolder((MdObjectStore)store);
                    if (tree != null) {
                        SimpleObjectImpl folder = new SimpleObjectImpl(tree.getName(), tree.getFQID(), tree.getCMetadataType(), tree.getPublicType());
                        String sCategory = aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof String ? (String)aSelectedObjects[0] : "";
                        AppDialogFactory.getInstance().showImportSASPackageDialog((SimpleObject)folder, sCategory);
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                catch (ServiceException se) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)se);
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        } else if (aSelectedObjects.length == 0) {
            AppDialogFactory.getInstance().showImportSASPackageDialog();
        } else {
            AppDialogFactory.getInstance().showImportSASPackageDialog((SimpleObject)aSelectedObjects[0]);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length == 0) {
            return true;
        }
        if (aSelectedObjects.length == 1) {
            Object obj = aSelectedObjects[0];
            if (obj instanceof SimpleObject && "Folder".equals(((SimpleObject)aSelectedObjects[0]).getPublicType())) {
                return true;
            }
            if (obj instanceof String) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if ("InventoryTree".equals(context.getType())) {
            return false;
        }
        if ("DiagramTab".equals(context.getType())) {
            return false;
        }
        Object[] aObjects = context.getSelectedObjects();
        if ("TransformationsTree".equals(context.getType()) && aObjects.length == 1 && aObjects[0] instanceof String) {
            return true;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] instanceof SimpleObject && "Folder".equals(((SimpleObject)aObjects[iObject]).getPublicType())) continue;
            return false;
        }
        return true;
    }
}

