/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.etl.models.job.transforms.GeneratedTransformModel;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.wadmin.app.AppFrameworkManager;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.ContainedByFolderFilter;

class FindInFoldersAction
extends AbstractSelectionAction
implements WsAbstractApplicationActionsManager.ContextualAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(FindInFoldersAction.class);

    public FindInFoldersAction() {
        super(bundle, "AppActionsManager.Action.EditFindInFolders", 0);
        this.setIcon(AppIconFactory.getInstance().getIconForAction("Edit:FindIn:Folders"));
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        SimpleObject obj = (SimpleObject)aSelectedObjects[0];
        if (obj instanceof GeneratedTransformModel) {
            AppFrameworkManager.getInstance().findInFolders((SimpleObject)((GeneratedTransformModel)obj).getTransformDefinition(), true);
        } else if (obj instanceof JobTransformModel) {
            AppFrameworkManager.getInstance().findInFolders(((JobTransformModel)obj).getInnerJob(), true);
        } else {
            AppFrameworkManager.getInstance().findInFolders(obj, true);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        return aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof SimpleObject && (!"TransformInstance".equals(((SimpleObject)aSelectedObjects[0]).getPublicType()) || aSelectedObjects[0] instanceof GeneratedTransformModel || aSelectedObjects[0] instanceof JobTransformModel);
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if ("FoldersTree".equals(context.getType()) || "CheckoutsTree".equals(context.getType())) {
            return false;
        }
        Object[] aSelectedObjects = context.getSelectedObjects();
        return aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof SimpleObject && (((SimpleObject)aSelectedObjects[0]).isPublicObject() && ContainedByFolderFilter.accept((String)((SimpleObject)aSelectedObjects[0]).getPublicType()) || aSelectedObjects[0] instanceof GeneratedTransformModel || aSelectedObjects[0] instanceof JobTransformModel);
    }
}

