/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.etl.models.data.IWorkTable;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.AppViewFactory;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;

class AnalysisAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(AnalysisAction.class);

    public AnalysisAction() {
        super(bundle, "AppActionsManager.Action.ActionsAnalyze", 256);
        this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Analyze"));
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        AppViewFactory.getInstance().showAnalysisView((SimpleObject)aSelectedObjects[0]);
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length != 1 || !(aSelectedObjects[0] instanceof SimpleObject)) {
            return false;
        }
        if (aSelectedObjects[0] instanceof IWorkTable && ((IWorkTable)aSelectedObjects[0]).getID().indexOf(36) != -1) {
            return false;
        }
        return AppViewFactory.getInstance().isAnalysisViewSupported((SimpleObject)aSelectedObjects[0]);
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] instanceof SimpleObject && AppViewFactory.getInstance().isAnalysisViewSupported((SimpleObject)aObjects[iObject])) continue;
            return false;
        }
        return true;
    }
}

