/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app;

import com.sas.etl.models.job.transforms.GeneratedTransformModel;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.services.information.ServerInterface;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.wadmin.visuals.TransformationType;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractIconFactory;
import java.net.URL;
import javax.swing.Icon;

public class AppIconFactory
extends WsAbstractIconFactory {
    private static final WAdminResource bundle = WAdminResource.getBundle(AppIconFactory.class);
    public static final String REGISTER_TABLES_ACTION = "File:RegisterTables";
    public static final String NEW_FOLDER_ACTION = "File:New:Folder";
    public static final String NEW_DOCUMENT_ACTION = "File:New:Document";
    public static final String NEW_EXTERNAL_FILE_ACTION = "File:New:ExternalFile";
    public static final String NEW_TRANSFORMATION_ACTION = "File:New:Transformation";
    public static final String NEW_JOB_ACTION = "File:New:Job";
    public static final String NEW_LIBRARY_ACTION = "File:New:Library";
    public static final String NEW_NOTE_ACTION = "File:New:Note";
    public static final String NEW_STORED_PROCESS_ACTION = "File:New:StoredProcess";
    public static final String NEW_TABLE_ACTION = "File:New:Table";
    public static final String NEW_CODE_ACTION = "File:New:Code";
    public static final String FIND_IN_FOLDERS_ACTION = "Edit:FindIn:Folders";
    public static final String CHECK_OUT_ACTION = "CheckOuts:CheckOut";
    public static final String CHECK_IN_ACTION = "CheckOuts:CheckIn";
    public static final String UNDO_CHECK_OUT_ACTION = "CheckOuts:UndoCheckOut";
    public static final String HISTORY_ACTION = "CheckOuts:History";
    public static final String ASSIGN_RESTARTPOINT_ACTION = "Context:Assign as Restart-Point";
    public static final String GENERATE_CODE_ACTION = "Actions:GenerateCode";
    public static final String MAP_COLUMNS_ACTION = "Actions:MapColumns";
    public static final String PROPAGATE_COLUMNS_ACTION = "Actions:PropagateColumns";
    public static final String PROPAGATE_SOURCES_TO_TARGETS_ACTION = "Actions:PropagateColumns:FromSources:ToTargets";
    public static final String PROPAGATE_TARGETS_TO_SOURCES_ACTION = "Actions:PropagateColumns:FromTargets:ToSources";
    public static final String NEW_STICKY_NOTE_ACTION = "Actions:StickyNote:Add";
    public static final String YELLOW_STICKY_NOTE_ACTION = "Actions:StickyNote:Yellow";
    public static final String BLUE_STICKY_NOTE_ACTION = "Actions:StickyNote:Blue";
    public static final String PINK_STICKY_NOTE_ACTION = "Actions:StickyNote:Pink";
    public static final String DEBUG_ACTION = "Debug:Debug";
    public static final String RUN_TO_SELECTED_TRANSFORMATION_ACTION = "Debug:RunToSelectedTransformation";
    public static final String RUN_FROM_TRANSFORMATION_ACTION = "Debug:RunFromSelectedTransformation";
    public static final String RUN_SELECTED_TRANSFORMATIONS_ACTION = "Debug:RunSelectedTransformations";
    public static final String CONTINUE_ACTION = "Debug:Continue";
    public static final String STEP_ACTION = "Debug:Step";
    public static final String SEARCH_ACTION = "Tools:Search";
    public static final String REPORTS_ACTION = "Tools:Reports";
    public static final String COMPARISON_RESULTS_ACTION = "Tools:ComparisonResults";
    public static final String CASCADE_ACTION = "Common:Cascade";
    public static final String ARRANGE_ALL_ACTION = "Common:Arrange";
    public static final String TABLE_VIEW_ACTION = "TableView";
    public static final String DETAILS_VIEW_ACTION = "DetailsView";
    public static final String GRAPH_VIEW_ACTION = "GraphView";
    public static final String DETAILS_PANEL_ACTION = "DetailsPanel";
    public static final String MAP_SELECTED_COLUMNS_ACTION = "MapSelectedColumns";
    public static final String EXPRESSION_ACTION = "Expression";
    public static final String EXPAND_LEFT_PANEL_ACTION = "ExpandLeftPanel";
    public static final String EXPAND_RIGHT_PANEL_ACTION = "ExpandRightPanel";
    public static final String SHOW_BOTH_PANELS_ACTION = "ShowBothPanels";
    public static final String VIEW_DIFFERENCES_ACTION = "ViewDifferences";
    public static final String RECOMPARE_ACTION = "Recompare";
    public static final String APPLY_ACTION = "Apply";
    public static final String CA_IMPACT_ACTION = "ImpactAnalysis";
    public static final String CA_REVERSE_IMPACT_ACTION = "ReverseImpactAnalysis";
    public static final String NAVIGATE_UP_ACTION = "NavigateUp";
    public static final String OPTIONS_ACTION = "Options";
    public static final String CLEAR_ALL_ACTION = "ClearAll";
    public static final String PRINT_TO_FILE_ACTION = "PrintToFile";
    public static final String APPEND_ACTION = "Append";
    public static final String VALIDATE_ACTION = "Validate";
    public static final String AUTO_JOIN_ACTION = "AutoJoin";
    public static final String RUN_REPORT_ACTION = "RunReport";
    public static final String CHECK_DATABASE_ACTION = "CheckDatabase";
    public static final String PROPAGATE_COLUMNS_DROP_MENU_ACTION = "PropagateColumnsDropMenu";
    public static final String EXPRESSION_DROP_MENU_ACTION = "ExpressionDropMenu";
    public static final String DELETE_DROP_MENU_ACTION = "DeleteDropMenu";
    public static final String NEW_KEY_DROP_MENU_ACTION = "NewKeyDropMenu";
    public static final String WORK_TABLE_TYPE = "Type:WorkTable";

    public static AppIconFactory getAppInstance() {
        return (AppIconFactory)AppIconFactory.getInstance();
    }

    public AppIconFactory() {
    }

    public AppIconFactory(ServerInterface server) {
        super(server);
    }

    protected void registerIconsForPrivateTypes() {
        super.registerIconsForPrivateTypes();
        this.addIconForPrivateType(WORK_TABLE_TYPE, 16, bundle.getIcon("AppIconFactory.PrivateType.WorkTable.16.image"));
        this.addIconForPrivateType(WORK_TABLE_TYPE, 24, bundle.getIcon("AppIconFactory.PrivateType.WorkTable.24.image"));
    }

    protected void registerIconsForActions() {
        super.registerIconsForActions();
        this.addIconForAction(REGISTER_TABLES_ACTION, bundle.getIcon("AppIconFactory.Action.RegisterTables.image"));
        this.addIconForAction(NEW_FOLDER_ACTION, bundle.getIcon("AppIconFactory.Action.NewFolder.image"));
        this.addIconForAction(NEW_DOCUMENT_ACTION, bundle.getIcon("AppIconFactory.Action.NewDocument.image"));
        this.addIconForAction(NEW_EXTERNAL_FILE_ACTION, bundle.getIcon("AppIconFactory.Action.NewExternalFile.image"));
        this.addIconForAction(NEW_TRANSFORMATION_ACTION, bundle.getIcon("AppIconFactory.Action.NewTransformation.image"));
        this.addIconForAction(NEW_JOB_ACTION, bundle.getIcon("AppIconFactory.Action.NewJob.image"));
        this.addIconForAction(NEW_LIBRARY_ACTION, bundle.getIcon("AppIconFactory.Action.NewLibrary.image"));
        this.addIconForAction(NEW_NOTE_ACTION, bundle.getIcon("AppIconFactory.Action.NewNote.image"));
        this.addIconForAction(NEW_STORED_PROCESS_ACTION, bundle.getIcon("AppIconFactory.Action.NewStoredProcess.image"));
        this.addIconForAction(NEW_TABLE_ACTION, bundle.getIcon("AppIconFactory.Action.NewTable.image"));
        this.addIconForAction(NEW_CODE_ACTION, bundle.getIcon("AppIconFactory.Action.NewCode.image"));
        this.addIconForAction(FIND_IN_FOLDERS_ACTION, bundle.getIcon("AppIconFactory.Action.FindInFolders.image"));
        this.addIconForAction(CHECK_OUT_ACTION, bundle.getIcon("AppIconFactory.Action.CheckOut.image"));
        this.addIconForAction(CHECK_IN_ACTION, bundle.getIcon("AppIconFactory.Action.CheckIn.image"));
        this.addIconForAction(UNDO_CHECK_OUT_ACTION, bundle.getIcon("AppIconFactory.Action.UndoCheckOut.image"));
        this.addIconForAction(HISTORY_ACTION, bundle.getIcon("AppIconFactory.Action.History.image"));
        this.addIconForAction(GENERATE_CODE_ACTION, bundle.getIcon("AppIconFactory.Action.GenerateCode.image"));
        this.addIconForAction(CHECK_DATABASE_ACTION, bundle.getIcon("AppIconFactory.Action.CheckDatabase.image"));
        this.addIconForAction(MAP_COLUMNS_ACTION, bundle.getIcon("AppIconFactory.Action.MapColumns.image"));
        this.addIconForAction(PROPAGATE_COLUMNS_ACTION, bundle.getIcon("AppIconFactory.Action.PropagateColumns.image"));
        this.addIconForAction(PROPAGATE_SOURCES_TO_TARGETS_ACTION, bundle.getIcon("AppIconFactory.Action.PropagateSourcesToTargets.image"));
        this.addIconForAction(PROPAGATE_TARGETS_TO_SOURCES_ACTION, bundle.getIcon("AppIconFactory.Action.PropagateTargetsToSources.image"));
        this.addIconForAction(NEW_STICKY_NOTE_ACTION, bundle.getIcon("AppIconFactory.Action.NewStickyNote.image"));
        this.addIconForAction(YELLOW_STICKY_NOTE_ACTION, bundle.getIcon("AppIconFactory.Action.YellowStickyNote.image"));
        this.addIconForAction(BLUE_STICKY_NOTE_ACTION, bundle.getIcon("AppIconFactory.Action.BlueStickyNote.image"));
        this.addIconForAction(PINK_STICKY_NOTE_ACTION, bundle.getIcon("AppIconFactory.Action.PinkStickyNote.image"));
        this.addIconForAction(DEBUG_ACTION, bundle.getIcon("AppIconFactory.Action.Debug.image"));
        this.addIconForAction(RUN_TO_SELECTED_TRANSFORMATION_ACTION, bundle.getIcon("AppIconFactory.Action.RunToTransformation.image"));
        this.addIconForAction(RUN_FROM_TRANSFORMATION_ACTION, bundle.getIcon("AppIconFactory.Action.RunFromTransformation.image"));
        this.addIconForAction(RUN_SELECTED_TRANSFORMATIONS_ACTION, bundle.getIcon("AppIconFactory.Action.RunSelectedTransformations.image"));
        this.addIconForAction(STEP_ACTION, bundle.getIcon("AppIconFactory.Action.Step.image"));
        this.addIconForAction(CONTINUE_ACTION, bundle.getIcon("AppIconFactory.Action.Continue.image"));
        this.addIconForAction(SEARCH_ACTION, bundle.getIcon("AppIconFactory.Action.Search.image"));
        this.addIconForAction(REPORTS_ACTION, bundle.getIcon("AppIconFactory.Action.Reports.image"));
        this.addIconForAction(COMPARISON_RESULTS_ACTION, bundle.getIcon("AppIconFactory.Action.ComparisonResults.image"));
        this.addIconForAction(CASCADE_ACTION, bundle.getIcon("AppIconFactory.Action.Cascade.image"));
        this.addIconForAction(ARRANGE_ALL_ACTION, bundle.getIcon("AppIconFactory.Action.ArrangeAll.image"));
        this.addIconForAction(ASSIGN_RESTARTPOINT_ACTION, bundle.getIcon("AppIconFactory.Action.AssignRestartPoint.image"));
        this.addIconForAction(TABLE_VIEW_ACTION, bundle.getIcon("AppIconFactory.Action.TableView.image"));
        this.addIconForAction(DETAILS_VIEW_ACTION, bundle.getIcon("AppIconFactory.Action.DetailsView.image"));
        this.addIconForAction(GRAPH_VIEW_ACTION, bundle.getIcon("AppIconFactory.Action.GraphView.image"));
        this.addIconForAction(DETAILS_PANEL_ACTION, bundle.getIcon("AppIconFactory.Action.DetailsPanel.image"));
        this.addIconForAction(MAP_SELECTED_COLUMNS_ACTION, bundle.getIcon("AppIconFactory.Action.MapSelectedColumns.image"));
        this.addIconForAction(EXPRESSION_ACTION, bundle.getIcon("AppIconFactory.Action.Expression.image"));
        this.addIconForAction(EXPAND_LEFT_PANEL_ACTION, bundle.getIcon("AppIconFactory.Action.ExpandLeftPanel.image"));
        this.addIconForAction(EXPAND_RIGHT_PANEL_ACTION, bundle.getIcon("AppIconFactory.Action.ExpandRightPanel.image"));
        this.addIconForAction(SHOW_BOTH_PANELS_ACTION, bundle.getIcon("AppIconFactory.Action.ShowBothPanels.image"));
        this.addIconForAction(VIEW_DIFFERENCES_ACTION, bundle.getIcon("AppIconFactory.Action.ViewDifferences.image"));
        this.addIconForAction(RECOMPARE_ACTION, bundle.getIcon("AppIconFactory.Action.Recompare.image"));
        this.addIconForAction(APPLY_ACTION, bundle.getIcon("AppIconFactory.Action.Apply.image"));
        this.addIconForAction(CA_IMPACT_ACTION, bundle.getIcon("AppIconFactory.Action.ImpactAnalysis.image"));
        this.addIconForAction(CA_REVERSE_IMPACT_ACTION, bundle.getIcon("AppIconFactory.Action.ReverseImpactAnalysis.image"));
        this.addIconForAction(NAVIGATE_UP_ACTION, bundle.getIcon("AppIconFactory.Action.NavigateUp.image"));
        this.addIconForAction(OPTIONS_ACTION, bundle.getIcon("AppIconFactory.Action.Options.image"));
        this.addIconForAction(CLEAR_ALL_ACTION, bundle.getIcon("AppIconFactory.Action.ClearAll.image"));
        this.addIconForAction(PRINT_TO_FILE_ACTION, bundle.getIcon("AppIconFactory.Action.PrintToFile.image"));
        this.addIconForAction(APPEND_ACTION, bundle.getIcon("AppIconFactory.Action.Append.image"));
        this.addIconForAction(VALIDATE_ACTION, bundle.getIcon("AppIconFactory.Action.Validate.image"));
        this.addIconForAction(AUTO_JOIN_ACTION, bundle.getIcon("AppIconFactory.Action.AutoJoin.image"));
        this.addIconForAction(RUN_REPORT_ACTION, bundle.getIcon("AppIconFactory.Action.RunReport.image"));
        this.addIconForAction(PROPAGATE_COLUMNS_DROP_MENU_ACTION, bundle.getIcon("AppIconFactory.Action.PropagateColumnsDropMenu.image"));
        this.addIconForAction(EXPRESSION_DROP_MENU_ACTION, bundle.getIcon("AppIconFactory.Action.ExpressionDropMenu.image"));
        this.addIconForAction(DELETE_DROP_MENU_ACTION, bundle.getIcon("AppIconFactory.Action.DeleteDropMenu.image"));
        this.addIconForAction(NEW_KEY_DROP_MENU_ACTION, bundle.getIcon("AppIconFactory.Action.NewKeyDropMenu.image"));
    }

    public Icon getIconForTransformation(String sTransformationTypeID) {
        return this.getIconForTransformation(sTransformationTypeID, 16);
    }

    public Icon getIconForTransformation(String sTransformationTypeID, int eSize) {
        if (eSize != 16 && eSize != 24) {
            throw new IllegalArgumentException("Size must be SIZE_16 or SIZE_24");
        }
        if (GeneratedTransformModel.getTransformTypeID().equals(sTransformationTypeID)) {
            return this.getIconForPublicType("GeneratedTransform", eSize);
        }
        if (JobTransformModel.getTransformTypeID().equals(sTransformationTypeID)) {
            return this.getIconForPublicType("Job", eSize);
        }
        TransformationType type = TransformManager.getInstance().getTransformationType(sTransformationTypeID);
        return type == null ? null : type.getIcon(eSize);
    }

    public URL getIconURLForTransformation(String sTransformationType) {
        return this.getIconURLForTransformation(sTransformationType, 16);
    }

    public URL getIconURLForTransformation(String sTransformationType, int eSize) {
        if (eSize != 16 && eSize != 24) {
            throw new IllegalArgumentException("Size must be SIZE_16 or SIZE_24");
        }
        TransformationType type = TransformManager.getInstance().getTransformationType(sTransformationType);
        return type == null ? null : type.getIconURL(eSize);
    }
}

