/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app;

import com.sas.wadmin.app.actions.AppActionsManager;
import com.sas.wadmin.run.RuntimeStatusPanel;
import com.sas.wadmin.visuals.WAdminTreeObject;
import com.sas.wadmin.visuals.properties.PropertiesAdapter;
import com.sas.wadmin.visuals.properties.PropertiesTable;
import com.sas.wadmin.visuals.properties.WAQuickPropertiesPane;
import com.sas.workspace.SplitManager;
import com.sas.workspace.WATitledPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WorkspaceTreeObject;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractApplicationFrameworkManager;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsMessagesPropertyTab;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsStatusBarUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.tree.CheckoutsTree;
import com.sas.workspace.visuals.tree.FoldersTree;
import com.sas.workspace.visuals.tree.InventoryTree;
import com.sas.workspace.visuals.tree.TransformationsTree;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class AppFrameworkManager
extends WsAbstractApplicationFrameworkManager {
    private static WAdminResource bundle = WAdminResource.getBundle(AppFrameworkManager.class);
    public static final String FOLDERS = "Folders";
    public static final String INVENTORY = "Inventory";
    public static final String CHECKOUTS = "Checkouts";
    public static final String TRANSFORMATIONS = "Transformations";
    public static final String QUICK_PROPERTIES = "QuickProperties";
    public static final String RUNTIME_MANAGER = "RuntimeManager";
    public static final String ACTIONS_HISTORY = "ActionsHistory";
    private Workspace m_workspace;
    private WorkspaceFile m_appDefaultsFile;
    private SplitManager m_splitManager;
    private JComponent m_treeComponent;
    private PropertiesAdapter m_adpQuickProperties;
    private PropertiesTable m_tblQuickProperties;
    private JScrollPane m_spnQuickProperties;
    private WATitledPane m_tpnQuickProperties;
    private JTabbedPane m_pnlInformationTabs;
    private JComponent m_tabRuntimeManager;
    private JComponent m_tabActionsHistory;
    private boolean m_bQuickPropertiesVisible;
    private boolean m_bInformationTabsVisible;
    private boolean m_bRuntimeManagerVisible;
    private boolean m_bActionsHistoryVisible;
    private boolean m_bApplicationComponentsVisible;

    public AppFrameworkManager() {
        this.initialize();
    }

    private void initialize() {
        this.m_tblQuickProperties = new PropertiesTable();
        this.m_tblQuickProperties.restoreSettings("QuickPropertiesTable");
        this.m_adpQuickProperties = new PropertiesAdapter(this.m_tblQuickProperties, false);
        this.m_spnQuickProperties = new JScrollPane((Component)((Object)this.m_tblQuickProperties));
        this.m_tpnQuickProperties = new WAQuickPropertiesPane();
        this.m_tpnQuickProperties.setContents((Component)this.m_spnQuickProperties);
        this.m_tpnQuickProperties.setPreferredSize(new Dimension(0, 0));
        this.m_pnlInformationTabs = new JTabbedPane();
        this.m_tabRuntimeManager = new RuntimeStatusPanel();
        this.m_tabActionsHistory = WsMessagesPropertyTab.getInstance();
        this.m_workspace = Workspace.getWorkspace();
        this.m_appDefaultsFile = this.m_workspace.getAppDefaultsFile();
    }

    public void findInFolders(SimpleObject obj) {
        this.findInFolders(new SimpleObject[]{obj}, false);
    }

    public void findInFolders(SimpleObject obj, boolean bFolderTreeVisible) {
        this.findInFolders(new SimpleObject[]{obj}, true);
    }

    public void findInFolders(SimpleObject[] aObjects) {
        this.findInFolders(aObjects, false);
    }

    public void findInFolders(SimpleObject[] aObjects, boolean bFolderTreeVisible) {
        WAdminTreeObject to = (WAdminTreeObject)Workspace.getWorkspace().getTreeObject();
        if (bFolderTreeVisible) {
            to.setVisible("FoldersTree", true);
        }
        to.getFoldersTree().selectObjects(aObjects);
    }

    public void findInTransformations(SimpleObject[] aObjects) {
        WAdminTreeObject to = (WAdminTreeObject)Workspace.getWorkspace().getTreeObject();
        to.setVisible("TransformationsTree", true);
        to.getTransformationsTree().selectObjects(aObjects);
    }

    public void saveLayout() {
        if (!this.m_bApplicationComponentsVisible) {
            return;
        }
        this.m_bApplicationComponentsVisible = false;
        if (!this.m_appDefaultsFile.isOpen()) {
            String strFileName = this.m_appDefaultsFile.getFileName();
            if (strFileName == null) {
                strFileName = Workspace.getDataIntegrationStudioWorkspaceFilePath();
            }
            this.m_appDefaultsFile.openExisting(strFileName);
        }
        WorkspaceTreeObject treeObject = this.m_workspace.getTreeObject();
        Component treeComponent = null;
        if (treeObject != null) {
            treeObject.saveState();
            treeComponent = treeObject.getTreeComponent();
        }
        this.m_appDefaultsFile.setPropertyBoolean("AppFrameworkManager.QuickPropertiesVisible", this.m_bQuickPropertiesVisible);
        this.m_appDefaultsFile.setPropertyBoolean("AppFrameworkManager.RuntimeManagerVisible", this.m_bRuntimeManagerVisible);
        this.m_appDefaultsFile.setPropertyBoolean("AppFrameworkManager.ActionsHistoryVisible", this.m_bActionsHistoryVisible);
        if (treeComponent != null) {
            this.m_appDefaultsFile.setPropertyInt("AppFrameworkManager.TreesWidth", treeComponent.getWidth());
            if (this.m_bQuickPropertiesVisible) {
                this.m_appDefaultsFile.setPropertyInt("AppFrameworkManager.TreesHeight", treeComponent.getHeight());
            }
        }
        if (this.m_bInformationTabsVisible) {
            this.m_appDefaultsFile.setPropertyInt("AppFrameworkManager.InformationTabsHeight", this.m_pnlInformationTabs.getHeight());
        }
        this.m_appDefaultsFile.saveExisting();
        this.m_bQuickPropertiesVisible = false;
        this.m_bInformationTabsVisible = false;
        this.m_bRuntimeManagerVisible = false;
        this.m_bActionsHistoryVisible = false;
        this.m_pnlInformationTabs.removeAll();
    }

    public void restoreLayout() {
        this.m_splitManager = this.m_workspace.getSplitManager();
        this.m_treeComponent = (JComponent)this.m_workspace.getTreeObject().getTreeComponent();
        if (this.m_splitManager == null || !this.m_splitManager.isEmpty()) {
            return;
        }
        WsStatusBarUtilities.addAppserverPanel();
        WsStatusBarUtilities.addUserPanel();
        WsStatusBarUtilities.addServerPanel();
        boolean bQuickPropertiesVisible = this.m_appDefaultsFile.getPropertyBoolean("AppFrameworkManager.QuickPropertiesVisible", true);
        boolean bRuntimeManagerVisible = this.m_appDefaultsFile.getPropertyBoolean("AppFrameworkManager.RuntimeManagerVisible", true);
        boolean bActionsHistoryVisible = this.m_appDefaultsFile.getPropertyBoolean("AppFrameworkManager.ActionsHistoryVisible", true);
        int iTreesWidth = this.m_appDefaultsFile.getPropertyInt("AppFrameworkManager.TreesWidth", 200);
        try {
            this.m_splitManager.add((JComponent)this.m_workspace.getCustomDesktop());
            this.m_splitManager.add(1, this.m_treeComponent, (JComponent)this.m_workspace.getCustomDesktop(), iTreesWidth, 0.0);
            this.setQuickPropertiesVisible(bQuickPropertiesVisible);
            this.m_workspace.validate();
            this.setRuntimeManagerVisible(bRuntimeManagerVisible);
            this.setActionsHistoryVisible(bActionsHistoryVisible);
        }
        catch (SplitManager.IllegalOrientationException e) {
            e.printStackTrace();
        }
        catch (SplitManager.IllegalAdditionException e) {
            e.printStackTrace();
        }
        catch (SplitManager.IllegalDirectionException e) {
            e.printStackTrace();
        }
        catch (SplitManager.ManagerNotEmptyException e) {
            e.printStackTrace();
        }
        catch (SplitManager.ComponentNotFoundException e) {
            e.printStackTrace();
        }
        String newTitle = this.m_workspace.getTitle() + " - " + this.m_workspace.getWorkspaceFile().getPropertyString("Name");
        this.m_workspace.setTitle(newTitle);
        this.m_bApplicationComponentsVisible = true;
    }

    public void setVisible(String sKey, boolean bVisible) {
        block9: {
            try {
                if (QUICK_PROPERTIES.equals(sKey)) {
                    this.setQuickPropertiesVisible(bVisible);
                    break block9;
                }
                if (RUNTIME_MANAGER.equals(sKey)) {
                    this.setRuntimeManagerVisible(bVisible);
                    break block9;
                }
                if (ACTIONS_HISTORY.equals(sKey)) {
                    this.setActionsHistoryVisible(bVisible);
                    break block9;
                }
                throw new IllegalArgumentException("the component " + sKey + " is not in the framework, or its visibility cannot be modified");
            }
            catch (SplitManager.IllegalOrientationException e) {
                e.printStackTrace();
            }
            catch (SplitManager.IllegalAdditionException e) {
                e.printStackTrace();
            }
            catch (SplitManager.IllegalDirectionException e) {
                e.printStackTrace();
            }
            catch (SplitManager.ManagerNotEmptyException e) {
                e.printStackTrace();
            }
            catch (SplitManager.ComponentNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public FoldersTree getFoldersTree() {
        return (FoldersTree)this.getComponent(FOLDERS);
    }

    public InventoryTree getInventoryTree() {
        return (InventoryTree)this.getComponent(INVENTORY);
    }

    public TransformationsTree getTransformationsTree() {
        return (TransformationsTree)this.getComponent(TRANSFORMATIONS);
    }

    public CheckoutsTree getCheckoutsTree() {
        return (CheckoutsTree)this.getComponent(CHECKOUTS);
    }

    public JComponent getComponent(String sKey) {
        WAdminTreeObject treeObject = (WAdminTreeObject)this.m_workspace.getTreeObject();
        if (FOLDERS.equals(sKey)) {
            return treeObject.getFoldersTree();
        }
        if (INVENTORY.equals(sKey)) {
            return treeObject.getInventoryTree();
        }
        if (CHECKOUTS.equals(sKey)) {
            return treeObject.getCheckoutsTree();
        }
        if (TRANSFORMATIONS.equals(sKey)) {
            return treeObject.getTransformationsTree();
        }
        if (QUICK_PROPERTIES.equals(sKey)) {
            return this.m_tpnQuickProperties;
        }
        if (RUNTIME_MANAGER.equals(sKey)) {
            return this.m_tabRuntimeManager;
        }
        if (ACTIONS_HISTORY.equals(sKey)) {
            return this.m_tabActionsHistory;
        }
        throw new IllegalArgumentException("the component " + sKey + " is not in the framework");
    }

    public void setSelectedComponent(String sKey) {
        WAdminTreeObject treeObject = (WAdminTreeObject)this.m_workspace.getTreeObject();
        if (FOLDERS.equals(sKey)) {
            treeObject.setVisible("FoldersTree", true);
        } else if (INVENTORY.equals(sKey)) {
            treeObject.setVisible("InventoryTree", true);
        } else if (CHECKOUTS.equals(sKey)) {
            treeObject.setVisible("CheckoutsTree", true);
        } else if (TRANSFORMATIONS.equals(sKey)) {
            treeObject.setVisible("TransformationsTree", true);
        } else if (QUICK_PROPERTIES.equals(sKey)) {
            this.m_tblQuickProperties.requestFocus();
        } else if (RUNTIME_MANAGER.equals(sKey)) {
            this.m_pnlInformationTabs.setSelectedComponent(this.m_tabRuntimeManager);
        } else if (ACTIONS_HISTORY.equals(sKey)) {
            this.m_pnlInformationTabs.setSelectedComponent(this.m_tabActionsHistory);
        } else {
            throw new IllegalArgumentException("the component " + sKey + " is not in the framework, or it cannot be selected");
        }
    }

    public void setSelectionProvider(WsSelectionProvider provider) {
        WsAbstractApplicationActionsManager.getInstance().setSelectionProvider(provider);
        if (this.m_bQuickPropertiesVisible) {
            this.m_adpQuickProperties.setSelectionProvider(provider);
        }
    }

    private void setQuickPropertiesVisible(boolean bVisible) throws SplitManager.IllegalOrientationException, SplitManager.IllegalAdditionException, SplitManager.IllegalDirectionException, SplitManager.ManagerNotEmptyException, SplitManager.ComponentNotFoundException {
        if (this.m_bQuickPropertiesVisible == bVisible) {
            return;
        }
        this.m_bQuickPropertiesVisible = bVisible;
        if (this.m_bQuickPropertiesVisible) {
            this.m_adpQuickProperties.setSelectionProvider(WsAbstractApplicationActionsManager.getInstance().getSelectionProvider());
            int iTreesHeight = this.m_appDefaultsFile.getPropertyInt("AppFrameworkManager.TreesHeight", 350);
            this.m_splitManager.add(0, this.m_treeComponent, (JComponent)this.m_tpnQuickProperties, iTreesHeight, 1.0);
        } else {
            this.m_adpQuickProperties.setSelectionProvider(null);
            this.m_splitManager.remove((JComponent)this.m_tpnQuickProperties);
        }
    }

    private void setRuntimeManagerVisible(boolean bVisible) throws SplitManager.IllegalOrientationException, SplitManager.IllegalAdditionException, SplitManager.IllegalDirectionException, SplitManager.ManagerNotEmptyException, SplitManager.ComponentNotFoundException {
        if (this.m_bRuntimeManagerVisible == bVisible) {
            if (bVisible) {
                this.m_pnlInformationTabs.setSelectedComponent(this.m_tabRuntimeManager);
            }
            return;
        }
        this.m_bRuntimeManagerVisible = bVisible;
        WsAbstractToggleAction act = (WsAbstractToggleAction)AppActionsManager.getInstance().getAction("View:RuntimeManager");
        act.setSelected(bVisible);
        if (this.m_bRuntimeManagerVisible) {
            this.m_pnlInformationTabs.insertTab(bundle.getString("AppFrameworkManager.RuntimeManager.txt"), null, this.m_tabRuntimeManager, null, 0);
            this.m_pnlInformationTabs.setSelectedComponent(this.m_tabRuntimeManager);
            if (this.m_pnlInformationTabs.getTabCount() == 1) {
                this.setInformationTabsVisible(true);
            }
        } else {
            if (this.m_pnlInformationTabs.getTabCount() == 1) {
                this.setInformationTabsVisible(false);
            }
            this.m_pnlInformationTabs.remove(this.m_tabRuntimeManager);
        }
    }

    private void setActionsHistoryVisible(boolean bVisible) throws SplitManager.IllegalOrientationException, SplitManager.IllegalAdditionException, SplitManager.IllegalDirectionException, SplitManager.ManagerNotEmptyException, SplitManager.ComponentNotFoundException {
        if (this.m_bActionsHistoryVisible == bVisible) {
            return;
        }
        this.m_bActionsHistoryVisible = bVisible;
        if (this.m_bActionsHistoryVisible) {
            this.m_pnlInformationTabs.addTab(bundle.getString("AppFrameworkManager.ActionsHistory.txt"), this.m_tabActionsHistory);
            this.m_pnlInformationTabs.setSelectedComponent(this.m_tabActionsHistory);
            if (this.m_pnlInformationTabs.getTabCount() == 1) {
                this.setInformationTabsVisible(true);
            }
        } else {
            if (this.m_pnlInformationTabs.getTabCount() == 1) {
                this.setInformationTabsVisible(false);
            }
            this.m_pnlInformationTabs.remove(this.m_tabActionsHistory);
        }
    }

    private void setInformationTabsVisible(boolean bVisible) throws SplitManager.IllegalOrientationException, SplitManager.IllegalAdditionException, SplitManager.IllegalDirectionException, SplitManager.ManagerNotEmptyException, SplitManager.ComponentNotFoundException {
        if (this.m_bInformationTabsVisible == bVisible) {
            return;
        }
        this.m_bInformationTabsVisible = bVisible;
        if (this.m_bInformationTabsVisible) {
            int cyInformation = this.m_appDefaultsFile.getPropertyInt("AppFrameworkManager.InformationTabsHeight", 150);
            int cyDesktop = this.m_workspace.getCustomDesktop().getHeight();
            int cyDivider = (Integer)UIManager.get("SplitPane.dividerSize");
            int yDivider = Math.min(Math.max(300, cyDesktop - cyDivider - cyInformation), cyDesktop - 30);
            this.m_splitManager.add(0, (JComponent)this.m_workspace.getCustomDesktop(), (JComponent)this.m_pnlInformationTabs, yDivider, 1.0);
        } else {
            this.m_appDefaultsFile.setPropertyInt("AppFrameworkManager.InformationTabsHeight", this.m_pnlInformationTabs.getHeight());
            this.m_splitManager.remove((JComponent)this.m_pnlInformationTabs);
        }
    }
}

