/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app;

import com.sas.wadmin.app.AppDesktop;
import com.sas.workspace.CustomDesktopUI;
import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class AppDesktopUI
extends CustomDesktopUI {
    private static final WAdminResource bundle = WAdminResource.getBundle(AppDesktopUI.class);

    public static ComponentUI createUI(JComponent h) {
        return new AppDesktopUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        AppDesktop desk = (AppDesktop)((Object)this.desktop);
        desk.setFirstFadeColor(new Color(255, 255, 255));
        desk.setSecondFadeColor(new Color(242, 249, 255));
        desk.setBackground(new Color(242, 249, 255));
        desk.setIcon(bundle.getIcon("AppDesktopUI.CornerIcon.image"));
    }

    public void paint(Graphics g, JComponent cmp) {
        AppDesktop desk = (AppDesktop)((Object)cmp);
        Dimension dim = desk.getSize();
        Color clrFirst = desk.getFirstFadeColor();
        Color clrSecond = desk.getSecondFadeColor();
        if (clrFirst != null && clrSecond != null) {
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, desk.getFirstFadeColor(), dim.width, dim.height, desk.getSecondFadeColor());
            Graphics2D g2 = (Graphics2D)g;
            Paint oldPaint = g2.getPaint();
            g2.setPaint(gradient);
            g2.fillRect(0, 0, dim.width, dim.height);
            g2.setPaint(oldPaint);
        }
        Icon icon = desk.getIcon();
        int xIcon = dim.width - icon.getIconWidth();
        int yIcon = dim.height - icon.getIconHeight();
        icon.paintIcon((Component)((Object)desk), g, xIcon, yIcon);
    }
}

