/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.analysis;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.analysis.ColumnImpactAnalysisTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardInternalFrame;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractNewOMAView;
import com.sas.workspace.WsBaseView;
import com.sas.workspace.WsColumnMetadataUtil;
import java.awt.Dimension;
import java.rmi.RemoteException;
import javax.swing.Icon;

public class ColumnAnalysisView
extends WsAbstractNewOMAView {
    private static final WAdminResource bundle = WAdminResource.getBundle(ColumnAnalysisView.class);
    private String m_sTableName;

    public static WsBaseView createInstance(String sID, String sType, String sName) {
        return new ColumnAnalysisView(sID, sType, sName);
    }

    private ColumnAnalysisView(String sID, String sType, String sName) {
        super(sID, sType, sName);
    }

    protected WAStandardInternalFrame createFrame() {
        WAStandardInternalFrame frm = new WAStandardInternalFrame(this.getFrameTitle());
        frm.setOKButtonVisible(false);
        frm.setCancelButtonVisible(false);
        frm.setApplyButtonVisible(false);
        frm.setCloseButtonVisible(true);
        return frm;
    }

    protected void createMetadataObject(String sID, String sType, String sName) {
        super.createMetadataObject(sID, sType, sName);
        try {
            Column mdoColumn = (Column)this.getObject();
            DataTable tbl = mdoColumn.getTable();
            this.m_sTableName = tbl.getName();
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected WAPanel createMainPanel() {
        WATabbedPanel tabs = new WATabbedPanel();
        tabs.setPreferredSize(new Dimension(400, 400));
        tabs.addTab((WAPropertyTab)new ColumnImpactAnalysisTab((Column)this.getObject(), 1));
        tabs.addTab((WAPropertyTab)new ColumnImpactAnalysisTab((Column)this.getObject(), 2));
        return tabs;
    }

    protected String getDefaultsName() {
        return "ColumnAnalysis";
    }

    protected Icon getFrameIcon() {
        return WsColumnMetadataUtil.getColumnTypeIcon((Column)((Column)this.getObject()));
    }

    protected void refreshData() {
        super.refreshData();
        try {
            DataTable tbl = ((Column)this.getObject()).getTable();
            this.m_sTableName = tbl.getName();
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected String getFrameTitle() {
        return bundle.formatString("ColumnAnalysisView.Title.fmt", (Object)this.m_sTableName, (Object)this.getName());
    }
}

