/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DataTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;

public class ValidationUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(ValidationUtil.class);
    public static final String EMAILREPORT = "EmailReport";
    public static final String SAVEREPORT = "SaveReport";
    public static final String SAVETABLE = "SaveTable";
    public static final String NOREPORT = "NoReport";
    public static final String ERROR_TABLE_OPTION = "ErrorTable";
    public static final String WORK_ERROR_TABLE = "work.etls_Errors";
    public static final String WORK_EXCEPTIONS_TABLE = "work.etls_Exceptions";
    public static final String WORK_DUPS_TABLE = "work.etls_Dups";
    public static final String WORK_SOURCE_TABLE = "work.etls_Source";
    public static final String WORK_FMT_TABLE = "work.etls_fmtData";

    private ValidationUtil() {
    }

    public static void genAbortJobMacro(CodegenRequest cgReq, boolean abort) {
        if (abort) {
            cgReq.addCommentLine(bundle.getString("ValidationUtil.AbortJob.comment.txt")).addSourceCode("%macro abortJob; \n\n").indent().addSourceCode("%if (&m_abort eq 1) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%makeReport; \n\n").addSourceCode(CodegenRequest.makeAbortJobCode("8000")).unIndent().addSourceCode("%end;\n\n").unIndent().addSourceCode("%mend abortJob; \n\n");
        }
    }

    public static void genAbortJob(CodegenRequest cgReq, boolean abort) {
        if (abort) {
            cgReq.addCommentLine(bundle.getString("ValidationUtil.AbortJob.comment.txt")).addSourceCode("%if (&m_abort eq 1) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%makeReport; \n\n").genPercentPutStatement(bundle.getString("ValidationUtil.Abort.comment.sasmacro.notrans"), "ERROR:").genAbortJob("8000").unIndent().addSourceCode("%end;\n\n");
        }
    }

    public static void setupErrorTable(CodegenRequest cgReq, String errorDSName, boolean move) {
        if (errorDSName.length() == 0) {
            return;
        }
        if (move && errorDSName.indexOf("&") >= 0) {
            cgReq.addCommentLine(bundle.getString("ValidationUtil.ETLSource.comment.txt")).addSourceCode("data _null_;\n").indent();
            if (errorDSName.toUpperCase().indexOf("&DATETIME") >= 0) {
                cgReq.addSourceCode("call symput(\"DATETIME\", translate(put(&runTime, datetime13.), \"_\", \":\")); \n");
            } else if (errorDSName.toUpperCase().indexOf("&DATE") >= 0) {
                cgReq.addSourceCode("call symput(\"DATE\", put(datepart(&runTime), date7.)); \n");
            } else if (errorDSName.toUpperCase().indexOf("&TIME") >= 0) {
                cgReq.addSourceCode("call symput(\"TIME\", translate(put(timepart(&runTime), time5.), \"_\", \":\")); \n");
            }
            cgReq.unIndent().addSourceCode("run; \n\n");
        }
    }

    public static void genExceptionHandling(CodegenRequest cgReq, String targetDSName, String tempErrorTable, boolean move, boolean abort) {
        if (move) {
            cgReq.addCommentLine(bundle.getString("ValidationUtil.MoveToError.comment.txt")).addSourceCode("if (i_move) then \n").indent().addSourceCode("output " + tempErrorTable + ";\n").unIndent().addCommentLine(bundle.getString("ValidationUtil.MoveToOutput.comment.txt")).addSourceCode("else \n").indent().addSourceCode("output " + targetDSName + ";\n\n").unIndent();
        } else {
            cgReq.addSourceCode("output " + targetDSName + ";\n\n");
        }
        cgReq.addSourceCode("if eof then \n").addSourceCode("do; \n").indent().addCommentLine(bundle.getString("ValidationUtil.CreateFlags.comment.txt")).addSourceCode("call symput(\"m_excp\", put(i_excp, 1.));\n");
        if (abort) {
            cgReq.addSourceCode("call symput(\"m_abort\", put(i_abort, 1.));\n");
        }
        cgReq.unIndent().addSourceCode("end; \n");
    }

    public static void genMakeReportMacro(CodegenRequest cgReq, ClassifierMap classifierMap, DataTableCG sourceTableCG) throws MdException, RemoteException {
        if (!ValidationUtil.needExceptionTable(classifierMap)) {
            return;
        }
        TransformationStep step = (TransformationStep)classifierMap.getSteps(false).get(0);
        AssociationList triggeredEvents = step.getTriggeredEvents();
        cgReq.addCommentLine(bundle.getString("ValidationUtil.MakeReport.comment.txt")).addSourceCode("%macro makeReport; \n\n").indent();
        cgReq.addSourceCode("%if (&m_excp eq 1) %then \n").addSourceCode("%do; \n").indent();
        if (triggeredEvents.isEmpty()) {
            ValidationUtil.genProcPrint(cgReq, sourceTableCG, step);
        }
        for (int i = 0; i < triggeredEvents.size(); ++i) {
            PropertySet truePS;
            Event event = (Event)triggeredEvents.get(i);
            if (event.getPropertySets().isEmpty() || (truePS = CodeConditionOptionsUtil.getActionsPropertySet(event, true)) == null) continue;
            AssociationList trueProperties = truePS.getSetProperties();
            for (int j = 0; j < trueProperties.size(); ++j) {
                Property action = (Property)trueProperties.get(j);
                String reportType = action.getDefaultValue();
                if (reportType.equals(EMAILREPORT) || reportType.equals(SAVEREPORT) || reportType.equals(SAVETABLE)) {
                    StringBuffer optionString = new StringBuffer("");
                    AssociationList optionList = action.getProperties();
                    for (int k = 0; k < optionList.size(); ++k) {
                        Property optionProp = (Property)optionList.get(k);
                        optionString.append(optionProp.getDefaultValue());
                        if (k == optionList.size() - 1) continue;
                        optionString.append(", ");
                    }
                    if (reportType.equals(EMAILREPORT) || reportType.equals(SAVEREPORT)) {
                        if (reportType.equals(EMAILREPORT)) {
                            cgReq.addCommentLine(bundle.getString("ValidationUtil.EmailReport.comment.txt")).addSourceCode("filename report email \"" + optionString.toString() + "\" subject= \"" + bundle.getString("ValidationUtil.EmailSubject.txt") + "\"; \n\n");
                        } else {
                            cgReq.addCommentLine(bundle.getString("ValidationUtil.SaveReport.comment.txt")).addSourceCode("filename report \"" + optionString.toString() + "\"; \n\n");
                        }
                        cgReq.addSourceCode("proc printto print = report new; \n").addSourceCode("run; \n\n");
                        ValidationUtil.genProcPrint(cgReq, sourceTableCG, step);
                        cgReq.addSourceCode("proc printto; \n").addSourceCode("run; \n\n").addSourceCode("filename report; \n\n");
                        continue;
                    }
                    if (!reportType.equals(SAVETABLE)) continue;
                    String dateFormat = cgReq.isJobDateFormatNLS((AbstractTransformation)step) ? "nldatm." : "datetime.";
                    cgReq.addCommentLine(bundle.getString("ValidationUtil.SaveTable.comment.txt")).addSourceCode("data work.etls_Exceptions; \n").indent().addSourceCode("attrib x_datetime format = ").addSourceCode(dateFormat).addSourceCode(" label = \"" + bundle.getString("ValidationUtil.DateTimeLabel.txt") + "\"; \n").addSourceCode("x_datetime = datetime(); \n").addSourceCode("set work.etls_Exceptions; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("proc append base = " + optionString.toString() + "\n").addSourceCode("            data = work.etls_Exceptions force; \n").addSourceCode("run; \n");
                    continue;
                }
                cgReq.addSourceCode("\n").addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(action, (AbstractTransformation)step));
            }
        }
        cgReq.unIndent().addSourceCode("%end; \n\n").unIndent().addSourceCode("%mend makeReport; \n\n");
    }

    public static void genProcPrint(CodegenRequest cgReq, DataTableCG sourceTableCG, TransformationStep step) throws MdException, RemoteException {
        String dateFormat = cgReq.isJobDateFormatNLS((AbstractTransformation)step) ? "nldatmap." : "datetime.";
        cgReq.addSourceCode("options nodate; \n\n").addSourceCode("proc sort data = work.etls_Exceptions; \n").indent().addSourceCode("by x_row; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("proc print data = work.etls_Exceptions noobs label; \n").indent().addSourceCode("title1 \"").addSourceCode(bundle.getString("ValidationUtil.GenProcPrint.title.txt") + " " + sourceTableCG.getDataLocation(cgReq, false, false) + "\"; \n").addSourceCode("title2 \"%sysfunc(datetime(),").addSourceCode(dateFormat).addSourceCode(")\"; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("options date; \n\n");
    }

    public static void genUpdateErrorTable(CodegenRequest cgReq, String tempErrorTable, String errorDSName, String indent) {
        ValidationUtil.genUpdateErrorTable(cgReq, tempErrorTable, errorDSName);
    }

    public static void genUpdateErrorTable(CodegenRequest cgReq, String tempErrorTable, String errorDSName) {
        if (errorDSName.length() == 0) {
            return;
        }
        String justTempErrorTable = tempErrorTable;
        if (tempErrorTable.indexOf("(") > 0) {
            justTempErrorTable = tempErrorTable.substring(0, tempErrorTable.indexOf("(") - 1);
        }
        cgReq.addCommentLine(bundle.getString("ValidationUtil.AddRunTime.comment.txt")).addSourceCode("data " + justTempErrorTable + "; \n").indent().addSourceCode("set " + justTempErrorTable + "; \n").addSourceCode("format ETL_Error_JobRunTime datetime16.; \n").addSourceCode("ETL_Error_JobRunTime = &runTime; \n").unIndent().addSourceCode("run; \n\n").addCommentLine(bundle.getString("ValidationUtil.UpdateErrors.comment.txt")).addSourceCode("proc append base = " + errorDSName + "\n").addSourceCode("            data = " + tempErrorTable + " force; \n").addSourceCode("run; \n\n");
    }

    public static void genAutoExtract(CodegenRequest cgReq, ClassifierMap classifierMap, String targetDSName) throws MdException, RemoteException {
        boolean autoExtract = AutoExtract.columnMapping(classifierMap, cgReq, targetDSName, "");
        if (autoExtract) {
            cgReq.addSourceCode("data " + targetDSName + "; \n").indent().addSourceCode("set work.mapped; \n").unIndent().addSourceCode("run; \n\n").genTableDelete("work.mapped", "VIEW");
        }
    }

    public static void genAutoExtract(CodegenRequest cgReq, ClassifierMap classifierMap, String targetDSName, List ignoreColumns) throws MdException, RemoteException {
        ValidationUtil.genAutoExtract(cgReq, classifierMap, targetDSName, ignoreColumns, true);
    }

    public static boolean genAutoExtract(CodegenRequest cgReq, ClassifierMap classifierMap, DataTable sourceTable, DataTable targetTable, String targetDSName, List ignoreColumns, boolean derived, boolean lookup) throws MdException, RemoteException {
        boolean autoExtract = AutoExtract.columnMapping(classifierMap, cgReq, derived, "work.mapped", targetDSName, "", sourceTable, targetTable, true, false, ignoreColumns, AutoExtract.TARGET_COLUMNS, AutoExtract.EXTRA_COLUMNS, AutoExtract.WHERE_CLAUSE, false, true, false, true);
        if (autoExtract) {
            cgReq.addSourceCode("data " + targetDSName + "; \n").indent().addSourceCode("set work.mapped; \n").unIndent().addSourceCode("run; \n\n").genTableDelete("work.mapped", "VIEW");
        }
        return autoExtract;
    }

    public static void genAutoExtract(CodegenRequest cgReq, ClassifierMap classifierMap, String targetDSName, List ignoreColumns, boolean derived) throws MdException, RemoteException {
        boolean autoExtract = AutoExtract.columnMapping(classifierMap, cgReq, derived, targetDSName, "", ignoreColumns);
        if (autoExtract) {
            cgReq.addSourceCode("data " + targetDSName + "; \n").indent().addSourceCode("set work.mapped; \n").unIndent().addSourceCode("run; \n\n").genTableDelete("work.mapped", "VIEW");
        }
    }

    public static void genRunTime(CodegenRequest cgReq) {
        cgReq.addCommentLine(bundle.getString("ValidationUtil.MakeRunTime.comment.txt")).genGetDateTime("runTime", "");
    }

    public static boolean needExceptionTable(ClassifierMap classifierMap) throws MdException, RemoteException {
        TransformationStep step = (TransformationStep)classifierMap.getSteps(false).get(0);
        AssociationList triggeredEvents = step.getTriggeredEvents();
        if (triggeredEvents == null || triggeredEvents.size() <= 0) {
            return true;
        }
        for (int i = 0; i < triggeredEvents.size(); ++i) {
            PropertySet truePS;
            Event event = (Event)triggeredEvents.get(i);
            if (event.getPropertySets().size() <= 0 || (truePS = CodeConditionOptionsUtil.getActionsPropertySet(event, true)) == null) continue;
            AssociationList trueProperties = truePS.getSetProperties();
            for (int j = 0; j < trueProperties.size(); ++j) {
                Property action = (Property)trueProperties.get(j);
                String reportType = action.getDefaultValue();
                if (!reportType.equals(NOREPORT)) continue;
                return false;
            }
        }
        return true;
    }
}

