/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.ServerSupport;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class UpdateTableMetadata {
    private static WAdminResource bundle = WAdminResource.getBundle(UpdateTableMetadata.class);
    private MdObjectStore m_store;
    private boolean m_localStore = false;
    private List m_tables;

    public UpdateTableMetadata(List tables, MdObjectStore store) {
        this.m_store = store;
        this.setUpdateTableList(tables);
    }

    public void setUpdateTableList(List tables) {
        this.m_tables = new ArrayList();
        try {
            int size = tables.size();
            for (int i = 0; i < size; ++i) {
                CMetadata t = (CMetadata)tables.get(i);
                if (!t.getCMetadataType().equals("PhysicalTable") && !t.getCMetadataType().equals("WorkTable")) continue;
                this.m_tables.add(t);
            }
        }
        catch (RemoteException exc) {
            Workspace.handleRemoteException((RemoteException)exc);
        }
    }

    public StringBuffer getUpdateTableMetadataCode() {
        if (this.m_tables == null || this.m_tables.isEmpty()) {
            return null;
        }
        SASCodeGeneration code = null;
        try {
            SASLibrary library = null;
            PhysicalTable table = null;
            if (this.m_store == null) {
                this.m_store = Workspace.getMdFactory().createObjectStore();
                this.m_localStore = true;
            }
            code = new SASCodeGeneration();
            int size = this.m_tables.size();
            for (int i = 0; i < size; ++i) {
                table = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, (CMetadata)this.m_tables.get(i));
                library = this.getLibrary((DataTable)table);
                if (library == null) {
                    code.addCommentLine(bundle.getString("UpdateTableMetadata.LibraryError.Message.txt"));
                }
                try {
                    this.getFormatLine(code, table);
                    StringBuffer sb = this.updateMetadata(library, table, "");
                    code.addSourceCode(sb);
                    continue;
                }
                catch (MdException mdException) {
                    MessageUtil.displayDetailsMessage((String)bundle.getString("UpdateTableMetadata.MetadataError.Message.txt"), (String)bundle.getString("UpdateTableMetadata.MetadataError.Title.txt"), (int)1, (String)mdException.getLocalizedMessage());
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.cleanUp();
        return code.getSourceBuffer();
    }

    private StringBuffer updateMetadata(SASLibrary library, PhysicalTable table, String metaCode) throws MdException, RemoteException {
        StringBuffer sascode = new StringBuffer();
        boolean isRemote = this.isRemoteLibrary(library);
        ServerContext iServerContext = null;
        if (isRemote) {
            iServerContext = (ServerContext)library.getDeployedComponents().elementAt(0);
            ServerSupport iSupport = new ServerSupport(iServerContext);
            sascode.append(iSupport.access());
            sascode.append(iSupport.startSubmit());
            sascode.append(iSupport.doReturnCodeSetup());
            sascode.append(LibraryUtil.accessPath((SASLibrary)library, (ServerContext)iServerContext));
            sascode.append(metaCode);
            sascode.append(this.getMetaLibCode(library, table).toString());
            sascode.append(iSupport.endSubmit());
        } else {
            sascode.append(this.getMetaLibCode(library, table));
        }
        return sascode;
    }

    private SASLibrary getLibrary(DataTable table) {
        SASLibrary lib = null;
        try {
            RelationalSchema tableContainer;
            if (table.getTablePackages().size() == 0) {
                lib = null;
            }
            if ((tableContainer = table.getTablePackage()) instanceof DatabaseSchema) {
                if (((DatabaseSchema)tableContainer).getUsedByPackages().size() == 0) {
                    lib = null;
                }
                lib = (SASLibrary)((DatabaseSchema)tableContainer).getUsedByPackages().elementAt(0);
            } else {
                lib = (SASLibrary)tableContainer;
            }
        }
        catch (MdException mdException) {
            lib = null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return lib;
    }

    private boolean isRemoteLibrary(SASLibrary iLib) {
        boolean remoteToAppServer = false;
        ArrayList<ServerContext> lIOMServers = new ArrayList<ServerContext>();
        try {
            AssociationList lServers = iLib.getDeployedComponents();
            if (lServers.size() == 0) {
                return remoteToAppServer;
            }
            for (int i = 0; i < lServers.size(); ++i) {
                if (!(lServers.get(i) instanceof ServerContext)) {
                    remoteToAppServer = false;
                    return remoteToAppServer;
                }
                ServerContext iSCx = (ServerContext)lServers.get(i);
                AssociationList lLogicals = iSCx.getUsingComponents();
                for (int j = 0; j < lLogicals.size(); ++j) {
                    LogicalServer iLs = (LogicalServer)lLogicals.get(j);
                    if (iLs.getClassIdentifier().compareTo("440196D4-90F0-11D0-9F41-00A024BB830C") != 0) continue;
                    lIOMServers.add(iSCx);
                }
            }
        }
        catch (MdException e) {
            remoteToAppServer = false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (lIOMServers.size() == 0) {
            remoteToAppServer = true;
        }
        return remoteToAppServer;
    }

    private StringBuffer getMetaLibCode(SASLibrary library, PhysicalTable pTable) {
        try {
            StringBuffer code = new StringBuffer();
            StringBuffer buffer = null;
            String repid = library.getFQID();
            String libid = library.getFQID();
            libid = pTable.getCMetadataType().equals("WorkTable") ? "" : libid.substring(libid.indexOf(".") + 1);
            repid = repid.substring(0, repid.indexOf("."));
            ParametersModel parmModel = new ParametersModel((Root)pTable);
            try {
                buffer = parmModel.getParameterMacroCode();
            }
            catch (MdException e) {
                buffer = null;
            }
            if (buffer != null) {
                code.append(buffer);
            }
            code.append("\n");
            code.append("proc metalib;\n");
            code.append("\n");
            code.append("   omr (libid=\"");
            code.append(libid);
            code.append("\"\n");
            code.append("      repid=\"");
            code.append(repid);
            code.append("\");\n");
            code.append("   report(type = summary);\n");
            code.append("   update_rule = (noadd);\n");
            code.append("\n");
            code.append("   select (");
            code.append(pTable.getFQID());
            code.append(");\n");
            code.append("\n");
            code.append("run;\n");
            return code;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    private void getFormatLine(SASCodeGeneration sasCodeGeneration, PhysicalTable table) throws RemoteException {
        String tableId = table.getFQID();
        String divider = sasCodeGeneration.repeat("=", 74);
        sasCodeGeneration.addSourceCode("\n");
        sasCodeGeneration.addSourceCode("/*").addSourceCode(divider).addSourceCode("* \n");
        String reposId = tableId.substring(0, tableId.indexOf("."));
        sasCodeGeneration.addSourceCode(sasCodeGeneration.getCommentLine(bundle.formatString("UpdateTableMetadata.WT_PT.Fmt.txt", (Object)table.getCMetadataType())));
        sasCodeGeneration.addSourceCode(sasCodeGeneration.getCommentLine(bundle.formatString("UpdateTableMetadata.ReposId.Fmt.txt", (Object)reposId)));
        sasCodeGeneration.addSourceCode(sasCodeGeneration.getCommentLine(bundle.formatString("UpdateTableMetadata.TableName.Fmt.txt", (Object)table.getName())));
        sasCodeGeneration.addSourceCode(" *").addSourceCode(divider).addSourceCode("*/ \n");
    }

    private void cleanUp() {
        try {
            if (this.m_store != null && this.m_localStore) {
                this.m_store.dispose();
                this.m_store = null;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }
}

