/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SasMiningResults {
    private static WAdminResource bundle = WAdminResource.getBundle(SasMiningResults.class);
    private static final String SYSTEM_OPTIONS = "SystemOptions";
    private static final String GEN_MODEL_KEY = "Generated ModelKey Column";
    private static final String GEN_DATE_TIME = "Generated DateTime Column";
    private static final String GEN_DATE = "Generated Date Column";
    private static final String KEY_CODE = "Key";

    private SasMiningResults() {
    }

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap oClassifierMap) throws MdException, RemoteException {
        cgReq.checkSourceAndTarget(oClassifierMap);
        cgReq.checkTargetsForExternalTable(oClassifierMap);
        cgReq.checkSourcesForExternalTable(oClassifierMap);
        boolean bNoMiningResult = true;
        TextStore tsSourceCode = null;
        Extension oModelKeyExtension = null;
        DataTable oRequiredInputsTable = null;
        AssociationList lRequiredInputsColumns = new ArrayList();
        AssociationList alSourceSpecifications = oClassifierMap.getSourceSpecifications();
        int nMiningResults = alSourceSpecifications.size();
        for (int iMiningResult = 0; iMiningResult < nMiningResults; ++iMiningResult) {
            Root oRoot = (Root)alSourceSpecifications.get(iMiningResult);
            if (!(oRoot instanceof MiningResult)) continue;
            MiningResult oMiningResult = (MiningResult)oRoot;
            if (!oMiningResult.getSourceCodes().isEmpty()) {
                tsSourceCode = (TextStore)oMiningResult.getSourceCodes().get(0);
            }
            AssociationList alRequiredInputs = oMiningResult.getTransformationSources();
            bNoMiningResult = false;
            if (!alRequiredInputs.isEmpty()) {
                AssociationList alColumns;
                AssociationList alFMs = oClassifierMap.getFeatureMaps();
                oRequiredInputsTable = (DataTable)alRequiredInputs.get(0);
                lRequiredInputsColumns = alColumns = oRequiredInputsTable.getColumns();
                int nColumns = alColumns.size();
                for (int iColumns = 0; iColumns < nColumns; ++iColumns) {
                    Column oColumn = (Column)alColumns.get(iColumns);
                    FeatureMap oFM = SasMiningResults.findFeatureMapForColumn(alFMs, oColumn);
                    if (oFM != null) continue;
                    throw new CodegenException(bundle.getString("SasMiningResults.NoFMsforRequiredInput.msg.txt"));
                }
            } else {
                throw new CodegenException(bundle.getString("SasMiningResults.NoRequiredInputs.msg.txt"));
            }
            AssociationList alExtensions = oMiningResult.getExtensions();
            for (int iExtension = 0; iExtension < alExtensions.size(); ++iExtension) {
                Extension oExtension = (Extension)alExtensions.get(iExtension);
                if (!oExtension.getName().equals(KEY_CODE)) continue;
                oModelKeyExtension = oExtension;
            }
        }
        if (bNoMiningResult) {
            throw new CodegenException(bundle.getString("SasMiningResults.NoMiningModel.msg.txt"));
        }
        DataTable oSource = (DataTable)oClassifierMap.getClassifierSources().get(0);
        DataTableCG oSourceCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)oSource);
        String sSourceDsOptions = oSourceCG.getSourceTableOptions(true);
        DataTable oTarget = (DataTable)oClassifierMap.getClassifierTargets().get(0);
        PhysicalTableCG oTargetCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)oTarget);
        String sTargetDsname = oTargetCG.getDataLocation(cgReq);
        String sTargetDsOptions = oTargetCG.getTargetTableOptions(false);
        ArrayList<Column> lSourceColumns = new ArrayList<Column>();
        AssociationList alSourceColumns = oSource.getColumns();
        AssociationList alTargetColumns = oTarget.getColumns();
        int nSourceColumns = alSourceColumns.size();
        for (int iSourceColumns = 0; iSourceColumns < nSourceColumns; ++iSourceColumns) {
            Column oRequiredColumn;
            Column oColumn = (Column)alSourceColumns.get(iSourceColumns);
            Column oTargetColumn = SasMiningResults.findColumnInList((List)alTargetColumns, oColumn);
            if (oTargetColumn == null || (oRequiredColumn = SasMiningResults.findColumnInList((List)lRequiredInputsColumns, oColumn)) != null) continue;
            lSourceColumns.add(oTargetColumn);
        }
        cgReq.genAdditionalSystemOptions((AbstractTransformation)oClassifierMap, SYSTEM_OPTIONS);
        cgReq.genTableDelete(oTarget);
        AutoExtract.columnMapping(oClassifierMap, cgReq, sSourceDsOptions, oRequiredInputsTable.getName(), (List)lRequiredInputsColumns, lSourceColumns);
        AssociationList colList = oTarget.getColumns();
        String keepColumns = cgReq.makeColumnList((List)colList, "                ");
        StringBuffer extraColumnsList = new StringBuffer();
        for (int i = 0; i < colList.size(); ++i) {
            Column col = (Column)colList.get(i);
            ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
            String colName = colCG.getColumnName(cgReq);
            String colDesc = col.getDesc();
            if (colDesc.equals(GEN_MODEL_KEY)) {
                extraColumnsList.append(colName).append(" = \"").append(oModelKeyExtension.getValue()).append("\";\n");
                continue;
            }
            if (colDesc.equals(GEN_DATE_TIME)) {
                extraColumnsList.append(colName).append(" = ").append("datetime();\n");
                continue;
            }
            if (!colDesc.equals(GEN_DATE)) continue;
            extraColumnsList.append(colName).append(" = ").append("date();\n");
        }
        cgReq.addSourceCode("data ").addSourceCode(sTargetDsname).addSourceCode("\n").addSourceCode("        (keep = ").addSourceCode(keepColumns);
        if (sTargetDsOptions.length() > 0) {
            cgReq.addSourceCode("\n").addSourceCode("         ").addSourceCode(sTargetDsOptions);
        }
        cgReq.addSourceCode(") \n");
        TransformationStep step = (TransformationStep)oClassifierMap.getSteps(false).get(0);
        if (oTargetCG.isView(step, cgReq)) {
            cgReq.addSourceCode("    / view = ").addSourceCode(sTargetDsname);
        }
        cgReq.addSourceCode("; \n\n").indent();
        cgReq.addSourceCode("set &SYSLAST");
        if (sSourceDsOptions.length() > 0) {
            cgReq.addSourceCode(" ").addSourceCode(sSourceDsOptions);
        }
        cgReq.addSourceCode("; \n\n");
        cgReq.addSourceCode(extraColumnsList.toString()).addSourceCode("\n");
        if (tsSourceCode == null) {
            throw new CodegenException(bundle.getString("SasMiningResults.NoMiningModelCode.msg.txt"));
        }
        cgReq.addSourceCode(tsSourceCode.getStoredText());
        cgReq.unIndent().addSourceCode("\n").addSourceCode("run; \n");
        cgReq.genRCSetCall("&syserr");
    }

    public static FeatureMap findFeatureMapForColumn(AssociationList alFMs, Column oColumn) throws MdException, RemoteException {
        int nFMs = alFMs.size();
        for (int iFM = 0; iFM < nFMs; ++iFM) {
            AssociationList alFeatureTargets;
            FeatureMap oFM = (FeatureMap)alFMs.get(iFM);
            if (oFM.getIsUserDefined() != 0 || !(alFeatureTargets = oFM.getFeatureTargets()).contains((Object)oColumn)) continue;
            return oFM;
        }
        return null;
    }

    public static Column findColumnInList(List lColumns, Column oColumn) throws MdException, RemoteException {
        int nColumns = lColumns.size();
        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
            Column oRequiredColumn = (Column)lColumns.get(iColumn);
            if (!oColumn.getSASColumnName().equals(oRequiredColumn.getSASColumnName()) || !oColumn.getSASColumnType().equals(oRequiredColumn.getSASColumnType()) || oColumn.getSASColumnLength() != oRequiredColumn.getSASColumnLength()) continue;
            return oRequiredColumn;
        }
        return null;
    }
}

