/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.codegen.DBMSSTORE;
import com.sas.codegen.IndexCG;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.UniqueKey;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SAS
extends DBMSSTORE {
    private static WAdminResource bundle = WAdminResource.getBundle(SAS.class);
    private static final String CI_MODEL_TABLE = "work.etls_CITemplate";
    private static final String COMMANDS_WORK_TABLE = "etls_commands";
    private static final String COMPARE_WORK_TABLE1 = "etls_compare1";
    private static final String COMPARE_WORK_TABLE2 = "etls_compare2";
    private static final String CI_FILTER_PRELOAD = "when in ('PRE1','PRE2')";
    private static final String CI_FILTER_POSTLOAD = "when in ('POST1','POST2')";
    private static final String IC_CREATE_COMMAND = "ic create";
    private static final String PREEXISTING_CONTRAINTS_MVAR = "etls_preExistingConstraints";
    protected static final String SAS_OPTION_TEMPLATE = "/com/sas/wadmin/visuals/res/Options_SASTable_Template.xml";

    public SAS() {
        this.m_passthru = false;
        this.setConstraintTypesDroppable("PUNF");
        this.setNotNullIsConstraint(true);
    }

    @Override
    public void genModIndexStatement(CodegenRequest cgReq, String tableName, Index modifyIndex, boolean unique) throws MdException, RemoteException {
        IndexCG indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)modifyIndex);
        cgReq.addSourceCode("modify ").addSourceCode(tableName).addSourceCode(this.getDSOptions(true)).addSourceCode("\n").indent().addSourceCode("key = ").addSourceCode(indexCG.getIndexName(cgReq, false));
        if (unique) {
            cgReq.addSourceCode(" / unique");
        }
        cgReq.addSourceCode(";\n\n").unIndent();
    }

    @Override
    public List getOptionModels() throws RemoteException, ServiceException, ServerConnectionException, MdException, IOException, SAXException, ParserConfigurationException {
        ArrayList models = new ArrayList();
        return models;
    }

    @Override
    public void createIndexes2(CodegenRequest cgReq, List indexList) throws MdException, RemoteException {
        this.createIndexes2(cgReq, indexList, "");
    }

    public void createIndexes2(CodegenRequest cgReq, List indexList, String altTableName) throws MdException, RemoteException {
        if (!indexList.isEmpty()) {
            cgReq.addSectionComment(bundle.getString("DBMSSTORE.CreateIndex.msg.notrans"));
            cgReq.genPercentPutStatement(bundle.getString("DBMSSTORE.CreateIndex.note.sasmacro.notrans"));
            String tabname = "";
            tabname = altTableName.length() > 0 ? altTableName : this.getDataLocation(cgReq, false, true);
            String libname = SAS.getLibref(tabname);
            String tableName = SAS.getTableName(tabname);
            cgReq.addSourceCode("proc datasets lib = " + libname + " nolist; \n").indent().addSourceCode("modify " + tableName + "; \n").indent();
            for (int i = 0; i < indexList.size(); ++i) {
                Index index = (Index)indexList.get(i);
                this.createSingleIndex(cgReq, index);
            }
            cgReq.unIndent().unIndent().addSourceCode("quit; \n\n").genRCSetCall("&syserr");
        }
    }

    public void createSingleIndex(CodegenRequest cgReq, Index index) throws MdException, RemoteException {
        String indexName = this.getIndexName(cgReq, index);
        AssociationList lColumns = index.getColumns();
        if (lColumns.size() == 1) {
            Column col = (Column)lColumns.elementAt(0);
            String colname = this.getIndexColumnName(cgReq, col);
            if (!colname.equals(indexName)) {
                cgReq.throwException(bundle.formatString("DBMSSTORE.IndexNoMatch.msg.txt", (Object)indexName, (Object)colname));
                return;
            }
            cgReq.addSourceCode("index create " + indexName);
        } else if (lColumns.size() > 0) {
            cgReq.addSourceCode("index create " + indexName + " = ");
            String indexColumns = cgReq.makeColumnList((List)lColumns, "                ");
            cgReq.addSourceCode("(" + indexColumns + ")");
        } else {
            cgReq.throwException(bundle.getString("DBMSSTORE.NoColumnsOnIndex.msg.txt"));
            return;
        }
        StringBuffer opts = new StringBuffer("");
        if (index.getIsUnique() != 0) {
            opts.append(" unique");
        }
        if (index.getIsNoMiss() != 0) {
            opts.append(" nomiss");
        }
        if (opts.length() > 1) {
            cgReq.addSourceCode("\n").indent().addSourceCode("/" + opts.toString()).unIndent();
        }
        cgReq.addSourceCode(";\n");
    }

    @Override
    public void dropSingleIndex(CodegenRequest cgReq) throws MdException, RemoteException {
        boolean quoting;
        String table_opts = this.getIndexTableOptions();
        if (table_opts.length() > 0) {
            table_opts = "(" + table_opts.trim() + ")";
        }
        if (quoting = cgReq.getQuoting()) {
            cgReq.addSourceCode("drop index \"%trim(%bquote(&etls_indexName))\"n on %bquote(&etls_indexTable)");
        } else {
            cgReq.addSourceCode("drop index &etls_indexName on &etls_indexTable");
        }
        cgReq.addSourceCode(" " + table_opts + "\n");
    }

    @Override
    public void queryIndexes(CodegenRequest cgReq) throws MdException, RemoteException {
        String tabname = this.getDataLocation(cgReq, false, false);
        String outlib = SAS.getLibref(tabname).toUpperCase();
        String outmem = SAS.getTableName(tabname).toUpperCase();
        cgReq.indent().addSourceCode("from \n").addSourceCode("( \n").indent().addSourceCode("select distinct indxname as idxname, \n").addSourceCode("       \"" + tabname + "\" as tabname \n").indent().addSourceCode("from dictionary.indexes \n").indent().addSourceCode("where upcase(libname) eq \"" + outlib + "\" and upcase(memname) eq \"" + outmem + "\" \n").unIndent().unIndent().unIndent().addSourceCode("); \n").unIndent();
    }

    @Override
    public boolean syncCISetup(CodegenRequest cgReq, Index indexToKeep) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        ArrayList indexList = new ArrayList(this.getIndexesToCreate());
        AssociationList foreignKeysList = this.m_table.getForeignKeys();
        AssociationList uniqueKeysList = this.m_table.getUniqueKeys();
        List notNullColumnsList = this.getNotNullCols();
        if (indexList.size() < 0 && foreignKeysList.size() < 0 && notNullColumnsList.size() < 0 && uniqueKeysList.size() < 0) {
            return false;
        }
        cgReq.addSourceCode("/* Prepare table to use as model for indexing */ \n").addSourceCode("data work.etls_CITemplate; \n").indent().addSourceCode("set &etls_lastTable; \n").addSourceCode("stop; \n").unIndent().addSourceCode("run; \n");
        this.createIndexes2(cgReq, indexList, CI_MODEL_TABLE);
        if (!notNullColumnsList.isEmpty() || !uniqueKeysList.isEmpty()) {
            String tabname = CI_MODEL_TABLE;
            this.genCreateConstraints(cgReq, tabname, notNullColumnsList, (List)uniqueKeysList, new ArrayList());
        }
        this.genCIContentsMacro(cgReq, true);
        cgReq.addSourceCode("%etls_CIContents(table=" + tableName + ", workTableOut=" + COMPARE_WORK_TABLE1 + ");\n").addSourceCode("%etls_CIContents(table=work.etls_CITemplate, workTableOut=etls_compare2);\n\n");
        this.syncCIFKeys(cgReq, COMPARE_WORK_TABLE2, (List)foreignKeysList);
        this.genSyncCICmdsMacro(cgReq, indexToKeep, tableName, CI_MODEL_TABLE);
        cgReq.addSourceCode("%etls_syncCICmds(physTable=etls_compare1,mdlTable=etls_compare2,workTableOut=etls_commands);\n\n");
        cgReq.genTableDelete("etls_compare1 etls_compare2");
        return true;
    }

    private void genCIContentsMacro(CodegenRequest cgReq, boolean addRecreate) {
        cgReq.addSourceCode("%macro etls_CIContents(table=,workTableOut=);\n").indent().addSourceCode("%put NOTE: Building table listing Constraints and Indexes for: &table;\n").addSourceCode("proc datasets lib=work nolist; delete &workTableOut; quit;\n").addSourceCode("proc contents data=&table noprint out2=&workTableOut; run;\n");
        cgReq.addSourceCode("data &workTableOut;\n").indent().addSourceCode("length name $60 type $20 icown idxUnique idxNoMiss $3 recreate $600;\n").addSourceCode("set &workTableOut;\n").addSourceCode("if ICOwn ne 'YES';\n");
        if (addRecreate) {
            cgReq.addSourceCode("length recreate2 $600;").addSourceCode("retain match 0;\n").addSourceCode("drop match;\n").addSourceCode("IF _N_ = 1 THEN MATCH = PRXPARSE(\"s/\\/ Updatecentiles=[1-9]+|Updatecentiles=[1-9]+//\");\n").addSourceCode("CALL PRXCHANGE(match,-1,recreate,recreate2);\n");
        }
        cgReq.unIndent().addSourceCode("run;\n").genRCSetCall("&syserr").unIndent().addSourceCode("%mend etls_CIContents;\n");
    }

    @Override
    public void replaceTableCIPreLoad(CodegenRequest cgReq) throws MdException, RemoteException {
        boolean reapplyOldConstraints = this.m_TLM.getReapplyCInReplaceDS();
        boolean constraintEnabled = this.m_TLM.isConstraintEnabled();
        if (constraintEnabled || reapplyOldConstraints) {
            String tableName = this.getDataLocation(cgReq);
            if (reapplyOldConstraints) {
                cgReq.addSourceCode("%let etls_preExistingConstraints=0; \n\n");
            }
            cgReq.addSourceCode("%if &etls_tableExist %then \n").addSourceCode("%do; /* table exists */\n").indent();
            cgReq.genTableDelete("etls_commands etls_commands_C etls_commands_F");
            this.genCIContentsMacro(cgReq, false);
            cgReq.addSourceCode("\n").addSourceCode("%etls_CIContents(table=" + tableName + ", workTableOut=" + COMMANDS_WORK_TABLE + ");\n\n");
            cgReq.addSourceCode("data ");
            if (constraintEnabled) {
                cgReq.addSourceCode("etls_commands_F ");
            }
            if (reapplyOldConstraints) {
                cgReq.addSourceCode("etls_commands_C");
            }
            cgReq.addSourceCode("; \n").indent().addSourceCode("set etls_commands; \n");
            if (reapplyOldConstraints) {
                cgReq.addCommentLine(bundle.getString("DBMSSTORE.CommandsForReapplyingConstraints.msg.notrans")).addSourceCode("if upcase(type) ne 'INDEX' then \n").addSourceCode("do; \n").indent().addSourceCode("command=recreate;\n").addSourceCode("output etls_commands_C; \n").addSourceCode("call symput('etls_preExistingConstraints','1'); \n").unIndent().addSourceCode("end; \n");
            }
            if (constraintEnabled) {
                cgReq.addCommentLine(bundle.getString("DBMSSTORE.CommandsForDeletingFKeys.msg.notrans")).addSourceCode("if upcase(type)=\"FOREIGN KEY\" then \n").addSourceCode("do; \n").indent().addSourceCode("command='ic delete '||trim(name)||';';\n").addSourceCode("output etls_commands_F; \n").unIndent().addSourceCode("end; \n");
            }
            cgReq.unIndent().addSourceCode("run; \n\n");
            if (constraintEnabled) {
                cgReq.genPercentPutStatement(bundle.getString("DBMSSTORE.DeleteFKeys.note.sasmacro.notrans"));
                this.executeProcDatasetsCmds(cgReq, "etls_commands_F", "", "");
                cgReq.genTableDelete("etls_commands etls_commands_F");
            }
            cgReq.unIndent().addSourceCode("%end; /* table exists */ \n\n");
        }
    }

    @Override
    public void dropCI(CodegenRequest cgReq, boolean dropC, boolean dropI, Index indexToKeep) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq);
        this.genCIContentsMacro(cgReq, false);
        cgReq.addSourceCode("%etls_CIContents(table=" + tableName + ", workTableOut=" + COMMANDS_WORK_TABLE + ");\n\n");
        cgReq.addSourceCode("data etls_commands; \n").indent().addSourceCode("retain dropC " + (dropC ? 1 : 0) + " dropI " + (dropI ? 1 : 0) + "; /* user choices */ \n").addSourceCode("set etls_commands; \n").addSourceCode("if upcase(type)='INDEX' then command='index delete '||trim(name)||';';\n").addSourceCode("else command='ic delete '||trim(name)||';';\n").addSourceCode("if dropC and upcase(type) ne 'INDEX' then output;\n").addSourceCode("else if dropI and upcase(type) eq 'INDEX'");
        if (indexToKeep != null) {
            cgReq.addSourceCode(" and name ne \"" + indexToKeep + "\"");
        }
        cgReq.addSourceCode(" then output;\n").unIndent().addSourceCode("run; \n\n");
        this.executeProcDatasetsCmds(cgReq, COMMANDS_WORK_TABLE, "", "");
        cgReq.genTableDelete(COMMANDS_WORK_TABLE);
    }

    private void executeProcDatasetsCmds(CodegenRequest cgReq, String commandFile, String filter, String tableName) throws MdException, RemoteException {
        if (tableName.equals("")) {
            tableName = this.getDataLocation(cgReq);
        }
        cgReq.addSourceCode("data _null_;\n").indent().addSourceCode("set " + commandFile);
        if (!filter.equals("")) {
            cgReq.addSourceCode("(where=(" + filter + "))");
        }
        cgReq.addSourceCode(" end=eof;\n").addSourceCode("if _n_=1 then \n").indent().addSourceCode("call execute('proc datasets nolist lib=" + SAS.getLibref(tableName) + ";modify " + SAS.getTableName(tableName) + ";');\n").unIndent().addSourceCode("call execute(command);\n").addSourceCode("if eof then call execute('; quit;');\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
    }

    @Override
    public void syncCIPreLoad(CodegenRequest cgReq) throws MdException, RemoteException {
        this.executeProcDatasetsCmds(cgReq, COMMANDS_WORK_TABLE, CI_FILTER_PRELOAD, "");
    }

    @Override
    public void syncCIPostLoad(CodegenRequest cgReq, Index indexToKeep) throws MdException, RemoteException {
        this.executeProcDatasetsCmds(cgReq, COMMANDS_WORK_TABLE, CI_FILTER_POSTLOAD, "");
    }

    public void genSyncCICmdsMacro(CodegenRequest cgReq, Index keepIndex, String targetTable, String modelTable) throws MdException, RemoteException {
        String CISelected = this.m_TLM.getCIActionsSelected(",", true);
        cgReq.addSourceCode("%macro etls_CIDelete(when);\n").indent().addSourceCode("do;\n").indent().addSourceCode("command=typeCmd||' delete '||trim(name)||';';\n").addSourceCode("when=\"&when\";\n").addSourceCode("output;\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("%mend;\n").addSourceCode("%macro etls_CICreate(when);\n").indent().addSourceCode("do;\n").indent().addSourceCode("command=recreate;\n").addSourceCode("when=\"&when\";\n").addSourceCode("output;\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("%mend;\n");
        cgReq.addSourceCode("%macro etls_syncCICmds(physTable=,mdlTable=,workTableOut=);\n\n").indent().addSourceCode("%let CISelected=" + CISelected + ";  /* constrainst before/after, misc indexes before/after */ \n\n").addSourceCode("proc sort data=&physTable; by recreate2 name type; run;\n").addSourceCode("proc sort data=&mdlTable; by recreate2 name type; run;\n\n").addSourceCode("data &workTableOut;\n").indent().addSourceCode("merge &physTable(in=inExisting keep=recreate2 type name recreate IdxUnique IdxNoMiss rename=(IdxUnique=IUOld IdxNoMiss=IMOld name=nameOld))\n").addSourceCode("      &mdlTable(in=inToBe keep=recreate2 type name recreate IdxUnique IdxNoMiss name);\n").addSourceCode("by recreate2;\n").addSourceCode("array CISelections(2,2) $8 _temporary_ (&CISelected);\n").addSourceCode("keep command when typeCmd type selPtr isConstraining;\n").addSourceCode("length command $1000 when $6 typeCmd $5;\n").addSourceCode("type=upcase(type);\n");
        cgReq.addSourceCode("if type='INDEX' then typeCmd='index';\n").addSourceCode("else typeCmd='ic';\n").addSourceCode("if not inToBe then\n").addSourceCode("do;\n").indent().addSourceCode("IdxUnique=IUOld;\n").addSourceCode("IdxNoMiss=IMOld;\n").addSourceCode("name=nameOld;\n").unIndent().addSourceCode("end;\n").addSourceCode("if type='INDEX' then isConstraining=0;\n").addSourceCode("else isConstraining=1;\n").addSourceCode("if isConstraining then selPtr=1;\n").addSourceCode("else selPtr=2;\n").addSourceCode("/* Identify matches */\n").addSourceCode("if inExisting and inToBe and \n").addSourceCode("   ((type ne 'INDEX') or (type='INDEX' and nameOld eq name)) then\n").addSourceCode("do;\n").indent().addSourceCode("if CISelections(selPtr,1) in ('OFF') then %etls_CIDelete(PRE1)\n").addSourceCode("else /* on,asis */ %etls_CICreate(SKIP);\n").addSourceCode("if CISelections(selPtr,2) in ('OFF') and not (CISelections(selPtr,1) in ('OFF')) then %etls_CIDelete(POST1)\n").addSourceCode("else if CISelections(selPtr,2) in ('ON') and CISelections(selPtr,1)='OFF' then %etls_CICreate(POST2)\n").addSourceCode("else /* asis */ %etls_CICreate(SKIP);\n").addSourceCode("return;\n").unIndent().addSourceCode("end;\n").addSourceCode("/* For those that didn't match... clean out any no longer defined... */\n").addSourceCode("/* unless user doesn't want anything changed.                        */\n").addSourceCode("if inExisting then\n").addSourceCode("do;\n").indent().addSourceCode("if CISelections(selPtr,1) in('ASIS') and CISelections(selPtr,2) in('ASIS') then %etls_CICreate(SKIP)\n").addSourceCode("do; \n").indent().addSourceCode("if CISelections(1,1)='ASIS' and CISelections(2,1)='ASIS' then %etls_CIDelete(POST1) \n").addSourceCode("else %etls_CIDelete(PRE1) \n").unIndent().addSourceCode("end; \n").unIndent().addSourceCode("end;\n").addSourceCode("/* Add any not yet defined (or name changed)... */\n").addSourceCode("if inToBe then\n").addSourceCode("do;\n").indent().addSourceCode("if CISelections(selPtr,1) in('ON') then %etls_CICreate(PRE2)\n").addSourceCode("else /* off,asis */ %etls_CICreate(SKIP)\n").addSourceCode("if CISelections(selPtr,2) in('ON') and not (CISelections(selPtr,1) in('ON')) then %etls_CICreate(POST2)\n").addSourceCode("else if CISelections(selPtr,2) in ('OFF') and CISelections(selPtr,1) in ('ON') then %etls_CIDelete(POST2)\n").addSourceCode("else /* asis */ %etls_CICreate(SKIP)\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr").addSourceCode("proc sort data=&workTableOut nodupkey; by when isconstraining command; run;\n").unIndent().addSourceCode("%mend etls_syncCICmds;\n");
    }

    protected String getIndexTableOptions() {
        return "";
    }

    @Override
    public String getIndexColumnName(CodegenRequest cgReq, Column column) throws MdException, RemoteException {
        ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)column);
        String colname = colCG.getColumnName(cgReq);
        if (colname == null || colname.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoColumnName.msg.txt"));
        }
        return colname;
    }

    @Override
    public String getIndexName(CodegenRequest cgReq, Index index) throws MdException, RemoteException {
        IndexCG indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)index);
        String indexName = indexCG.getIndexName(cgReq);
        if (indexName == null || indexName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.IndexNameUndefined.msg.txt"));
        }
        return indexName;
    }

    @Override
    public void genGetNumRows(CodegenRequest cgReq, String tableName, String macroVariable) {
        cgReq.genGetNumRows(tableName, macroVariable, true);
    }

    @Override
    public StringBuffer getConnect(CodegenRequest cgReq) {
        return null;
    }

    @Override
    public boolean getPassThroughSupport() {
        return false;
    }

    @Override
    public void genBeginSelectAllFromConnect(CodegenRequest cgReq) {
    }

    @Override
    public void genEndSelectAllFromConnect(CodegenRequest cgReq) {
    }

    @Override
    public void genDisconnect(CodegenRequest cgReq) {
    }

    @Override
    public void genExecuteBegin(CodegenRequest cgReq, String prefix) {
    }

    @Override
    public void genExecuteEnd(CodegenRequest cgReq, String prefix) {
        cgReq.addSourceCode(prefix + "; \n");
    }

    @Override
    public void truncate(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.Truncate.msg.notrans"));
        cgReq.genPercentPutStatement(bundle.getString("DBMSSTORE.Truncate.note.sasmacro.notrans"));
        String fullTableName = this.getDataLocation(cgReq);
        String tableName = SAS.getTableName(fullTableName);
        String libRef = SAS.getLibref(fullTableName);
        String constraintTableName = "work.etls_constraints";
        String warningMessage = bundle.getString("DBMSSTORE.Truncate.Warning.msg.notrans");
        List warnList = cgReq.splitString(warningMessage, 78, false);
        StringBuffer warningBuffer = new StringBuffer();
        for (int i = 0; i < warnList.size(); ++i) {
            warningBuffer.append("\n    \" ").append((String)warnList.get(i)).append("\"");
        }
        warningMessage = warningBuffer.toString();
        cgReq.addCommentLine(bundle.getString("DBMSSTORE.Truncate.Contents.msg.notrans")).addSourceCode("proc contents data = " + fullTableName + "\n").addSourceCode("              out2 = " + constraintTableName + " \n").addSourceCode("              noprint; \n").addSourceCode("run;\n\n");
        cgReq.addCommentLine(bundle.getString("DBMSSTORE.Truncate.GetNumConstraints.msg.notrans"));
        cgReq.genGetNumRows(constraintTableName, "etls_hasRows", false, "1");
        cgReq.addSourceCode("%let ").addSourceCode("etls_numICOwned").addSourceCode(" = 0;\n");
        cgReq.addSourceCode("%let etls_primaryKey = NO; \n\n").addSourceCode("%if &etls_hasRows %then  \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DBMSSTORE.Truncate.HaveConstraints.msg.notrans")).addSourceCode("\n").indent().addCommentLine(bundle.getString("DBMSSTORE.Truncate.CountICOwn.msg.notrans")).addSourceCode("proc sql noprint;\n").indent().addSourceCode("select count(*) into :etls_numICOwned \n").indent().addSourceCode(" from ").addSourceCode(constraintTableName).addSourceCode(" where ICOwn = 'YES';\n").unIndent().unIndent().addSourceCode("quit;\n\n").addCommentLine(bundle.getString("DBMSSTORE.Truncate.FindConstraints.msg.notrans")).addSourceCode("data " + constraintTableName + "; \n").indent().addSourceCode("set " + constraintTableName + "; \n").addSourceCode("type = upcase(type); \n").addSourceCode("if (type eq \"REFERENTIAL\") then \n").addSourceCode("do; \n").indent().addSourceCode("call symput(\"etls_primaryKey\", \"YES\"); \n").addSourceCode("stop; \n").unIndent().addSourceCode("end; \n\n").addCommentLine(bundle.getString("DBMSSTORE.Truncate.ConstraintIndex.msg.notrans")).addSourceCode("if (type eq \"INDEX\" and ICOwn eq \"YES\") then \n").indent().addSourceCode("delete; \n").unIndent().unIndent().addSourceCode("run; \n\n").unIndent().addSourceCode("%end; ").addCommentLine(bundle.getString("DBMSSTORE.Truncate.HaveConstraints.msg.notrans")).addSourceCode("\n").addSourceCode("%if (&etls_primaryKey eq YES) %then \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DBMSSTORE.Truncate.HavePrimaryKey.msg.notrans")).addSourceCode("\n").indent().addSourceCode("data _null_; \n").indent().addSourceCode("put \"WARNING:\"" + warningMessage + "; \n").unIndent().addSourceCode("run; \n\n").addCommentLine(bundle.getString("DBMSSTORE.Truncate.LogicallyDeleteRecords.msg.notrans")).addSourceCode("proc sql; \n").indent().addSourceCode("delete * from " + fullTableName + "; \n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc").unIndent().addSourceCode("%end; ").addCommentLine(bundle.getString("DBMSSTORE.Truncate.HavePrimaryKey.msg.notrans")).addSourceCode("\n").addSourceCode("%else \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DBMSSTORE.Truncate.DoeNotHavePrimaryKey.msg.notrans")).addSourceCode("\n").indent().addSourceCode("%if (&etls_numICOwned gt 0) %then \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DBMSSTORE.Truncate.HaveConstraints.msg.notrans")).addSourceCode("\n").indent().addCommentLine(bundle.getString("DBMSSTORE.Truncate.DeleteConstraints.msg.notrans")).addSourceCode("proc datasets lib = " + libRef + " nolist; \n").indent().addSourceCode("modify " + tableName + "; \n").indent().addSourceCode("ic delete _all_; \n").unIndent().unIndent().addSourceCode("quit; \n\n").unIndent().addSourceCode("%end; ").addCommentLine(bundle.getString("DBMSSTORE.Truncate.HaveConstraints.msg.notrans")).addSourceCode("\n").addCommentLine(bundle.getString("DBMSSTORE.Truncate.PhysicallyDeleteRecords.msg.notrans")).addSourceCode("data " + fullTableName + "; \n").indent().addSourceCode("set " + fullTableName + "; \n").addSourceCode("stop; \n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr").addSourceCode("%if &etls_hasRows %then \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DBMSSTORE.Truncate.HaveConstraints.msg.notrans")).addSourceCode("\n").indent().addCommentLine(bundle.getString("DBMSSTORE.Truncate.RecreateConstraints.msg.notrans")).addSourceCode("data _null_; \n\n").indent().addSourceCode("set " + constraintTableName + " end=eof; \n\n").addSourceCode("if _n_ eq 1 then \n").addSourceCode("do; \n\n").indent().addSourceCode("call execute(\"proc datasets lib = " + libRef + " nolist;\"); \n").addSourceCode("call execute('   modify " + tableName + ";'); \n").unIndent().addSourceCode("end; \n\n").addSourceCode("call execute(\"      \" || recreate); \n\n").addSourceCode("if eof then \n").indent().addSourceCode("call execute(\"quit;\"); \n\n").unIndent().unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr").unIndent().addSourceCode("%end; ").addCommentLine(bundle.getString("DBMSSTORE.Truncate.HaveConstraints.msg.notrans")).addSourceCode("\n").unIndent().addSourceCode("%end; ").addCommentLine(bundle.getString("DBMSSTORE.Truncate.DoeNotHavePrimaryKey.msg.notrans")).addSourceCode("\n").genTableDelete(constraintTableName);
    }

    @Override
    public String getDataTableLabel() {
        String vdesc = null;
        try {
            vdesc = this.m_table.getName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        if (vdesc == null || vdesc.trim().length() == 0) {
            vdesc = "";
        }
        return vdesc;
    }

    @Override
    public boolean genRereadExposure(CodegenRequest cgReq) throws MdException, RemoteException {
        return false;
    }

    @Override
    public void genLibname(CodegenRequest cgReq, boolean resetLibname) throws MdException, RemoteException {
    }

    @Override
    public String getDBNULL(CodegenRequest cgReq) throws MdException, RemoteException {
        return "";
    }

    @Override
    public void createConstraints(CodegenRequest cgReq) throws MdException, RemoteException {
        AssociationList foreignKeys = this.m_table.getForeignKeys();
        AssociationList uniqueKeys = this.m_table.getUniqueKeys();
        List notNullColumns = this.getNotNullCols();
        if (this.m_TLM != null && this.m_TLM.getReapplyCInReplaceDS() && this.m_TLM.getLoadStyleValue().equalsIgnoreCase("Replace") && this.m_TLM.getReplaceType().equalsIgnoreCase("EntireTable")) {
            cgReq.genPercentPutStatement(bundle.getString("DBMSSTORE.ReapplyConstraints.note.sasmacro.notrans")).addSourceCode("%if &etls_preExistingConstraints %then \n").addSourceCode("%do; \n").indent().addCommentLine(bundle.getString("DBMSSTORE.ReapplyConstraints.msg.notrans"));
            this.executeProcDatasetsCmds(cgReq, "etls_commands_C", "", "");
            cgReq.genTableDelete("etls_commands_C").unIndent().addSourceCode("%end; \n\n");
        } else if (!(notNullColumns.isEmpty() && foreignKeys.isEmpty() && uniqueKeys.isEmpty())) {
            String tabname = this.getDataLocation(cgReq, false, true);
            this.genCreateConstraints(cgReq, tabname, notNullColumns, (List)uniqueKeys, (List)foreignKeys);
        }
    }

    public void genCreateConstraints(CodegenRequest cgReq, String tabname, List notNullColumns, List uniqueKeys, List foreignKeys) throws MdException, RemoteException {
        UniqueKey key;
        int i;
        ForeignKey key2;
        int i2;
        String libname = SAS.getLibref(tabname);
        String tableName = SAS.getTableName(tabname);
        int foreignKeysSize = foreignKeys.size();
        for (i2 = 0; i2 < foreignKeysSize; ++i2) {
            key2 = (ForeignKey)foreignKeys.get(i2);
            DataTable table = key2.getPartnerUniqueKey().getTable();
            PhysicalTableCG primKeyTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
            primKeyTableCG.accessPath(cgReq);
        }
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.CreateConstraint.msg.notrans"));
        cgReq.genPercentPutStatement(bundle.getString("DBMSSTORE.CreateConstraint.note.sasmacro.notrans"));
        cgReq.addSourceCode("proc datasets library=").addSourceCode(libname).addSourceCode(" nolist;\n");
        cgReq.indent().addSourceCode("modify ").addSourceCode(tableName).addSourceCode(";\n").indent();
        for (i2 = 0; i2 < notNullColumns.size(); ++i2) {
            Column col = (Column)notNullColumns.get(i2);
            ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
            cgReq.addSourceCode("ic create ").addSourceCode("not null (").addSourceCode(colCG.getColumnName(cgReq)).addSourceCode(");\n");
        }
        for (i2 = 0; i2 < foreignKeysSize; ++i2) {
            key2 = (ForeignKey)foreignKeys.get(i2);
            cgReq.addSourceCode(this.createSingleFKey(cgReq, key2, IC_CREATE_COMMAND)).addSourceCode("\n");
        }
        int uniqueSize = uniqueKeys.size();
        ArrayList<UniqueKey> uniqKeys = new ArrayList<UniqueKey>();
        for (i = 0; i < uniqueSize; ++i) {
            key = (UniqueKey)uniqueKeys.get(i);
            if (key.getIsPrimary() == 0) {
                uniqKeys.add(0, key);
                continue;
            }
            uniqKeys.add(key);
        }
        for (i = 0; i < uniqueSize; ++i) {
            key = (UniqueKey)uniqKeys.get(i);
            cgReq.addSourceCode("ic create ");
            Index keyIndex = this.getIndexUsedInUniqueKey(key);
            if (keyIndex != null) {
                cgReq.addSourceCode(this.getIndexName(cgReq, keyIndex) + " = ");
            }
            if (key.getIsPrimary() == 0) {
                cgReq.addSourceCode("unique ");
            } else {
                cgReq.addSourceCode("primary key ");
            }
            String colList = cgReq.makeColumnList((List)key.getKeyedColumns(), cgReq.getCurrentIndent() + "   ");
            cgReq.addSourceCode("(").addSourceCode(colList).addSourceCode(");\n");
        }
        cgReq.unIndent().unIndent();
        cgReq.addSourceCode("quit;\n\n");
        cgReq.genRCSetCall("&syserr");
    }

    @Override
    public String createSingleFKey(CodegenRequest cgReq, ForeignKey key, String addCommand) throws MdException, RemoteException {
        StringBuffer code = new StringBuffer("");
        PhysicalTableCG primKeyTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)key.getPartnerUniqueKey().getTable());
        String primKeyTableName = primKeyTableCG.getDataLocation(cgReq, false, true);
        String colList = cgReq.makeColumnList((List)key.getKeyedColumns(), cgReq.getCurrentIndent() + "   ");
        code.append(addCommand + " ").append("Foreign Key (").append(colList).append(") references ").append(primKeyTableName.toUpperCase()).append(" on update Restrict on delete Restrict").append(";");
        return code.toString();
    }

    private void syncCIFKeys(CodegenRequest cgReq, String commandTable, List foreignKeys) throws MdException, RemoteException {
        ForeignKey key;
        int i;
        int foreignKeysSize = foreignKeys.size();
        for (i = 0; i < foreignKeysSize; ++i) {
            key = (ForeignKey)foreignKeys.get(i);
            PhysicalTableCG primKeyTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)key.getPartnerUniqueKey().getTable());
            primKeyTableCG.accessPath(cgReq);
        }
        cgReq.addSourceCode("data " + commandTable + "; \n").indent().addSourceCode("type = \"foreign key\";\n");
        for (i = 0; i < foreignKeysSize; ++i) {
            key = (ForeignKey)foreignKeys.get(i);
            cgReq.addSourceCode("recreate =\"").addSourceCode(this.createSingleFKey(cgReq, key, IC_CREATE_COMMAND).replaceAll("\"", "\"\"")).addSourceCode("\"; \nrecreate2=recreate;\noutput;\n");
        }
        cgReq.addSourceCode("modify " + commandTable + "; \n");
        cgReq.addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n");
    }

    @Override
    public void dropConstraints(CodegenRequest cgReq) throws MdException, RemoteException {
        AssociationList foreignKeys = this.m_table.getForeignKeys();
        AssociationList uniqueKeys = this.m_table.getUniqueKeys();
        List notNullColumns = this.getNotNullCols();
        if (!(notNullColumns.isEmpty() && foreignKeys.isEmpty() && uniqueKeys.isEmpty())) {
            String tabname = this.getDataLocation(cgReq, false, true);
            String libname = SAS.getLibref(tabname);
            String tableName = SAS.getTableName(tabname);
            cgReq.addSectionComment(bundle.getString("DBMSSTORE.DropConstraint.msg.notrans"));
            cgReq.genPercentPutStatement(bundle.getString("DBMSSTORE.DropConstraint.note.sasmacro.notrans"));
            cgReq.addSourceCode("proc datasets library=").addSourceCode(libname).addSourceCode(" nolist;\n");
            cgReq.indent().addSourceCode("modify ").addSourceCode(tableName).addSourceCode(";\n").indent();
            cgReq.addSourceCode("ic delete _all_;\n");
            cgReq.unIndent().unIndent();
            cgReq.addSourceCode("quit;\n\n");
            cgReq.genRCSetCall("&syserr");
        }
    }

    @Override
    public void genDeleteAll(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.addSourceCode("delete * from " + tableName + " \n");
    }

    @Override
    public void genDeleteAll2(CodegenRequest cgReq) throws MdException, RemoteException {
        this.genDeleteAll(cgReq);
    }

    @Override
    public boolean getTruncateSupport() throws MdException, RemoteException {
        return false;
    }
}

