/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GeneratedTransform {
    private static final WAdminResource bundle = WAdminResource.getBundle(GeneratedTransform.class);
    public static final String OPTIONS_ROLE = "MACROOPTIONS";
    private static final String OUTPUT = "OUTPUT";
    private static final String INPUT = "INPUT";
    public static final String SQL = "SQL";
    private static final String INPUT_MACRO_PREFIX = "_INPUT";
    private static final String OUTPUT_MACRO_PREFIX = "_OUTPUT";

    private GeneratedTransform() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap, StringBuffer sourceCodeBuffer) throws MdException, RemoteException {
        HashMap<String, AssociationProperty> outputMap = new HashMap<String, AssociationProperty>();
        HashMap<String, AssociationProperty> inputMap = new HashMap<String, AssociationProperty>();
        boolean needQuotes = false;
        String vvnOption = "";
        cgReq.checkSourcesForExternalTable(classifierMap);
        cgReq.checkTargetsForExternalTable(classifierMap);
        TransformationStep associatedStep = (TransformationStep)classifierMap.getSteps(false).elementAt(0);
        AssociationList sourceList = classifierMap.getClassifierSources();
        AssociationList targetList = classifierMap.getClassifierTargets();
        try {
            int minInputs = 0;
            int minOutputs = 0;
            if (!associatedStep.getUsingPrototypes().isEmpty()) {
                Prototype prototype = (Prototype)associatedStep.getUsingPrototype();
                AssociationList alPrototypeProperties = prototype.getPrototypeProperties();
                for (int i = 0; i < alPrototypeProperties.size(); ++i) {
                    AssociationProperty associationProperty = (AssociationProperty)alPrototypeProperties.get(i);
                    if (associationProperty.getMetadataType().equalsIgnoreCase(OUTPUT)) {
                        outputMap.put(associationProperty.getFQID(), associationProperty);
                        minOutputs = associationProperty.getMinimum();
                        continue;
                    }
                    if (!associationProperty.getMetadataType().equalsIgnoreCase(INPUT)) continue;
                    inputMap.put(associationProperty.getFQID(), associationProperty);
                    minInputs = associationProperty.getMinimum();
                }
            }
            if (sourceList.size() < minInputs) {
                throw new CodegenException(bundle.formatString("GeneratedTransform.MinRequiredInputs.txt", (Object)Integer.toString(minInputs)));
            }
            if (targetList.size() < minOutputs) {
                throw new CodegenException(bundle.formatString("GeneratedTransform.MinRequiredOutputs.txt", (Object)Integer.toString(minOutputs)));
            }
            GeneratedTransform.generateTableMacros(cgReq, INPUT_MACRO_PREFIX, inputMap, bundle.getString("GeneratedTransform.SourceTable.comment.txt"), (List)sourceList, associatedStep, false);
            GeneratedTransform.generateTableMacros(cgReq, OUTPUT_MACRO_PREFIX, outputMap, bundle.getString("GeneratedTransform.TargetTable.comment.txt"), (List)targetList, associatedStep, true);
            if (classifierMap.getClassifierTargets().size() > 0 && classifierMap.getClassifierTargets().elementAt(0) instanceof DataTable) {
                AssociationList lColumns = ((DataTable)classifierMap.getClassifierTargets().elementAt(0)).getColumns();
                String columns = cgReq.makeColumnList((List)lColumns, false, "        ", false, " ", "");
                cgReq.addCommentLine(bundle.getString("GeneratedTransform.Keep.comment.txt")).addSourceCode("%let keep = ").addSourceCode(columns.trim()).addSourceCode(";\n\n");
            }
            if (sourceCodeBuffer != null) {
                cgReq.addSourceCode(sourceCodeBuffer).addSourceCode("\n\n");
            }
        }
        catch (MdException e) {
            e.printStackTrace();
            throw new MdException((Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (needQuotes && !vvnOption.equals("ANY")) {
            cgReq.addSourceCode("options validVarname = &etls_vvnOption;\n\n");
        }
        cgReq.genRCSetCall("&syserr", false);
        cgReq.genRCSetCall("&sysrc", false);
        cgReq.genRCSetCall("&sqlrc");
    }

    private static void generateTableMacros(CodegenRequest cgReq, String defaultPrefix, HashMap templateList, String tableComment, List tableList, TransformationStep step, boolean isOutput) throws MdException, RemoteException {
        if (!templateList.isEmpty()) {
            boolean hasGeneratedDefaultTableMacro = false;
            cgReq.addCommentLine(tableComment);
            if (!tableList.isEmpty()) {
                StringBuffer macroTarget = new StringBuffer();
                for (int i = 0; i < tableList.size(); ++i) {
                    PhysicalTable targetTable = (PhysicalTable)tableList.get(i);
                    String strVariable = GeneratedTransform.getTableMacroVariable(templateList, (DataTable)targetTable, step);
                    PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)targetTable);
                    if (i == 0) {
                        // empty if block
                    }
                    if (strVariable != null && strVariable.length() > 0) continue;
                    strVariable = defaultPrefix + Integer.toString(i);
                }
                cgReq.addSourceCode(macroTarget);
            }
            GeneratedTransform.removeDefaultsFromAssociationPropertyList(templateList);
            Iterator outputIter = templateList.values().iterator();
            int outputCnt = tableList.size();
            while (outputIter.hasNext()) {
                String strVariable = GeneratedTransform.getTableMacroNameFromAssociationProperty((AssociationProperty)outputIter.next());
                if (strVariable != null && strVariable.length() > 0) continue;
                strVariable = defaultPrefix + outputCnt;
                ++outputCnt;
            }
        }
    }

    private static String getTableMacroVariable(HashMap templateList, DataTable table, TransformationStep tStep) throws MdException, RemoteException {
        String tableMacroName = null;
        for (AssociationProperty propertyFromIncomingList : templateList.values()) {
            CMetadata object;
            Prototype templateProto = propertyFromIncomingList.getOwningPrototype();
            if (templateProto.getUsedByPrototypes(false).isEmpty() || templateProto.getUsedByPrototypes(false).get(0) != tStep || propertyFromIncomingList.getUsingPrototypes().isEmpty() || !(object = (CMetadata)propertyFromIncomingList.getUsingPrototypes().get(0)).getFQID().equalsIgnoreCase(table.getFQID())) continue;
            templateList.remove(propertyFromIncomingList.getFQID());
            return GeneratedTransform.getTableMacroNameFromAssociationProperty(propertyFromIncomingList);
        }
        return tableMacroName;
    }

    private static String getTableMacroNameFromAssociationProperty(AssociationProperty propertyFromIncomingList) {
        String tableMacroName = null;
        try {
            String partnerName = MacroPluginUtilities.getPartnerNameFromAssociationProperty(propertyFromIncomingList);
            if (!MacroPluginUtilities.isTemplateDefault(propertyFromIncomingList)) {
                tableMacroName = partnerName;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return tableMacroName;
    }

    private static void removeDefaultsFromAssociationPropertyList(HashMap templateList) throws RemoteException {
        ArrayList<String> removeItems = new ArrayList<String>();
        for (AssociationProperty p : templateList.values()) {
            if (!MacroPluginUtilities.isTemplateDefault(p)) continue;
            try {
                removeItems.add(p.getFQID());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        for (int i = 0; i < removeItems.size(); ++i) {
            templateList.remove(removeItems.get(i));
        }
    }
}

