/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenRoot;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.TransformUtilityInterface;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class EventCG
extends CodeGenRoot {
    private static WAdminResource bundle = WAdminResource.getBundle(EventCG.class);

    @Override
    public void codeGen(CodegenRequest cgReq) throws MdException, RemoteException {
        Event event = (Event)this.getMetadataClass();
        if (cgReq.onContextList(event.getFQID())) {
            return;
        }
        cgReq.addContextList(event.getFQID());
        this.codeGenSelfOnly(cgReq);
    }

    @Override
    public void codeGenSelfOnly(CodegenRequest cgReq) throws MdException, RemoteException {
        Event oEvent = (Event)this.getMetadataClass();
        if (oEvent.getTriggeringTransforms(false).size() <= 0) {
            throw new CodegenException(bundle.getString("EventCG.NoSyncSteps.msg.txt"));
        }
        TransformationStep oStep = (TransformationStep)oEvent.getTriggeringTransforms(false).get(0);
        int stepUserCode = oStep.getIsUserDefined();
        if (stepUserCode == 0) {
            this.generateCreationCode(cgReq);
        } else {
            cgReq.genUWC((AbstractTransformation)oStep);
        }
    }

    public void generateCreationCode(CodegenRequest cgReq) throws MdException, RemoteException {
        Event oEvent = (Event)this.getMetadataClass();
        TransformUtilityInterface oTransInterface = null;
        String classname = CodeGenUtil.getPluginClass((CMetadata)oEvent);
        try {
            ClassLoader loader = Workspace.getWorkspace().getPluginLoader().getClassLoader(classname);
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            Class<?> LoadedClass = Class.forName(classname, true, loader);
            oTransInterface = (TransformUtilityInterface)LoadedClass.newInstance();
        }
        catch (ClassNotFoundException ce) {
            if (oTransInterface == null) {
                throw new CodegenException(bundle.formatString("PROCESS.NoClassName.msg.txt", (Object)classname));
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        oTransInterface.executeUtility(cgReq, (CMetadata)((TransformationStep)oEvent.getTriggeringTransforms(false).get(0)));
    }
}

