/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.DataValidationMetadataHandler;
import com.sas.codegen.PhysicalTableCG;
import com.sas.codegen.ValidationUtil;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class DataValidation {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidation.class);
    private static final String ERROR_TABLE_OPTION = "ErrorTable";
    private static final String WORK_ERROR_TABLE = "work.etls_Errors";
    private static final String WORK_EXCEPTIONS_TABLE = "work.etls_Exceptions";
    private static final String WORK_DUPS_TABLE = "work.etls_Dups";
    private static final String WORK_SOURCE_TABLE = "work.etls_Source";
    private static final String WORK_FMT_TABLE = "work.etls_fmtData";
    private static final String MACRO_NAME = "etls_Validate";
    private static final String NUMERIC = "N";
    private static final String CHARACTER = "C";
    private static final String INFORMAT = "I";
    private static final String NUM_FORMAT_TO_USE = "32.";
    private static final int MIN_FORMAT_LENGTH = 32;
    private static final int MAX_START_LENGTH = 32;

    private DataValidation() {
    }

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        boolean autoExtract;
        String metaAction;
        String action;
        List rowValues;
        int i;
        cgReq.checkSourceAndTarget(classifierMap);
        cgReq.checkTargetsForExternalTable(classifierMap);
        cgReq.checkSourcesForExternalTable(classifierMap);
        DataTable sourceTable = cgReq.getSourceTable(classifierMap);
        DataTableCG sourceTableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
        DataTable targetTable = cgReq.getTargetTable(classifierMap);
        PhysicalTableCG targetTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)targetTable);
        String targetTableFullName = targetTableCG.getDataLocation(cgReq);
        String targetTableName = PhysicalTableCG.getTableName(targetTableFullName);
        String tempTargetDSName = "";
        tempTargetDSName = targetTableName.length() > 27 ? PhysicalTableCG.getLibref(targetTableFullName) + ".etls_" + cgReq.getUniqueWorkTableName() : targetTableCG.getDataLocation(cgReq, false, true, true);
        OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)classifierMap);
        String errorDSName = OP.getSpecificOptionValue(ERROR_TABLE_OPTION);
        TransformationStep step = (TransformationStep)classifierMap.getSteps(false).get(0);
        boolean createView = targetTableCG.isView(step);
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        boolean needExceptionTable = ValidationUtil.needExceptionTable(classifierMap);
        if (needExceptionTable && createView) {
            needExceptionTable = false;
            cgReq.genPercentPutStatement(bundle.getString("DataValidation.NoExceptionReport.comment.sasmacro.notrans")).addSourceCode("\n");
        }
        DataValidationMetadataHandler missingHandler = new DataValidationMetadataHandler(classifierMap, "Missing");
        List missingValues = missingHandler.getMetadataValues();
        DataValidationMetadataHandler invalidHandler = new DataValidationMetadataHandler(classifierMap, "Invalid");
        List invalidValues = invalidHandler.getMetadataValues();
        DataValidationMetadataHandler customHandler = new DataValidationMetadataHandler(classifierMap, "Custom");
        List customValues = customHandler.getMetadataValues();
        DataValidationMetadataHandler duplicateHandler = new DataValidationMetadataHandler(classifierMap, "Duplicate");
        List duplicateValues = duplicateHandler.getMetadataValues();
        String targetDSName = targetTableCG.getDataLocation(cgReq);
        boolean abort = false;
        boolean move = false;
        for (i = 0; i < missingValues.size(); ++i) {
            rowValues = (List)missingValues.get(i);
            action = (String)rowValues.get(missingHandler.getActionIndex());
            metaAction = missingHandler.getMetaAction(action);
            if (metaAction.equals("ABORT")) {
                abort = true;
            } else if (metaAction.equals("MOVE")) {
                move = true;
            }
            if (abort && move) break;
        }
        for (i = 0; i < invalidValues.size(); ++i) {
            rowValues = (List)invalidValues.get(i);
            action = (String)rowValues.get(invalidHandler.getActionIndex());
            metaAction = invalidHandler.getMetaAction(action);
            if (metaAction.equals("ABORT")) {
                abort = true;
            } else if (metaAction.equals("MOVE")) {
                move = true;
            }
            if (abort && move) break;
        }
        for (i = 0; i < customValues.size(); ++i) {
            rowValues = (List)customValues.get(i);
            action = (String)rowValues.get(customHandler.getCustomActionIndex()[0]);
            String metaAction1 = customHandler.getMetaAction(action);
            action = (String)rowValues.get(customHandler.getCustomActionIndex()[1]);
            String metaAction2 = customHandler.getMetaAction(action);
            if (metaAction1.equals("ABORT") || metaAction2.equals("ABORT")) {
                abort = true;
            } else if (metaAction1.equals("MOVE") || metaAction2.equals("MOVE")) {
                move = true;
            }
            if (abort && move) break;
        }
        boolean dupAbort = false;
        boolean dupMove = false;
        for (int i2 = 0; i2 < duplicateValues.size(); ++i2) {
            List rowValues2 = (List)duplicateValues.get(i2);
            String action2 = (String)rowValues2.get(duplicateHandler.getActionIndex());
            String metaAction2 = duplicateHandler.getMetaAction(action2);
            if (metaAction2.equals("ABORT")) {
                dupAbort = true;
            } else if (metaAction2.equals("MOVE") || metaAction2.equals("MOVEALL")) {
                dupMove = true;
            }
            if (dupAbort && dupMove) break;
        }
        if (missingValues.size() <= 0 && invalidValues.size() <= 0 && customValues.size() <= 0 && duplicateValues.size() <= 0) {
            cgReq.genTableDelete(targetDSName);
            cgReq.addCommentLine(bundle.getString("DataValidation.NoValidation.comment.txt")).addSourceCode("data ").addSourceCode(targetDSName);
            if (createView) {
                cgReq.addSourceCode(" / view = ").addSourceCode(targetDSName);
            }
            cgReq.addSourceCode(";\n").indent().addSourceCode("set &SYSLAST; \n").unIndent().addSourceCode("run; \n\n");
            cgReq.genRCSetCall("&syserr");
            return;
        }
        String keepList = "keep = " + cgReq.makeColumnList(targetTable, "                ");
        String selectList = "select " + cgReq.makeColumnList(targetTable, false, "             ", false, ",", "t");
        cgReq.addSourceCode("%macro ").addSourceCode(MACRO_NAME).addSourceCode("; \n\n").indent();
        ValidationUtil.genRunTime(cgReq);
        ValidationUtil.genMakeReportMacro(cgReq, classifierMap, sourceTableCG);
        cgReq.genTableDelete(targetTable).genTableDelete(tempTargetDSName);
        cgReq.addSourceCode("%let etls_Source = &SYSLAST;\n\n");
        ValidationUtil.setupErrorTable(cgReq, errorDSName, move || dupMove);
        DataValidation.genCustomFormats(cgReq, customValues, customHandler);
        DataValidation.genInvalidValuesFormats(cgReq, invalidValues, invalidHandler);
        cgReq.addSourceCode("%let m_excp = 0;\n");
        if (abort || dupAbort) {
            cgReq.addSourceCode("%let m_abort = 0; \n");
        }
        cgReq.addSourceCode("\n");
        List ignoreColumnsList = new ArrayList();
        if (missingValues.size() > 0 || invalidValues.size() > 0 || customValues.size() > 0) {
            if (createView && move) {
                cgReq.genPercentPutStatement(bundle.getString("DataValidation.NoView.comment.sasmacro.notrans")).addSourceCode("\n");
            }
            cgReq.addSectionComment(bundle.getString("DataValidation.DoValidations.comment.txt")).addSourceCode("data ").addSourceCode(tempTargetDSName).addSourceCode("\n").addSourceCode("        (").addSourceCode(keepList).addSourceCode(")");
            if (move) {
                cgReq.addSourceCode("\n").addSourceCode("     ").addSourceCode(WORK_ERROR_TABLE).addSourceCode("\n").addSourceCode("        (").addSourceCode(keepList).addSourceCode(")");
            }
            if (needExceptionTable) {
                cgReq.addSourceCode("\n").addSourceCode("     ").addSourceCode(WORK_EXCEPTIONS_TABLE).addSourceCode("\n").addSourceCode("        (keep = x_row x_column x_type x_action x_note)");
            }
            if (createView && !move) {
                cgReq.addSourceCode("\n     / view = ").addSourceCode(tempTargetDSName);
            }
            cgReq.addSourceCode(";\n\n").indent().addSourceCode("set &etls_Source end=eof;\n\n");
            if (needExceptionTable) {
                DataValidation.genExcpColumns(cgReq);
                cgReq.addSourceCode("retain x_note \"\";\n").addSourceCode("x_row = _n_;\n\n");
            }
            if (move) {
                cgReq.addSourceCode("i_move = 0;\n");
            }
            if (abort) {
                cgReq.addSourceCode("retain i_abort &m_abort; \n");
            }
            cgReq.addSourceCode("retain i_excp &m_excp; \n\n");
            ignoreColumnsList = DataValidation.genCustomValidation(cgReq, customValues, customHandler, needExceptionTable);
            DataValidation.genMissingValuesValidation(cgReq, missingValues, missingHandler, needExceptionTable);
            DataValidation.genInvalidValuesValidation(cgReq, invalidValues, invalidHandler, tempTargetDSName, needExceptionTable);
            ValidationUtil.genExceptionHandling(cgReq, tempTargetDSName, WORK_ERROR_TABLE, move, abort);
            cgReq.unIndent().addSourceCode("\nrun; \n\n").genRCSetCall("&syserr").addSourceCode("%let etls_Source = ").addSourceCode(tempTargetDSName).addSourceCode(";\n\n");
            if (move) {
                ValidationUtil.genUpdateErrorTable(cgReq, WORK_ERROR_TABLE, errorDSName);
                cgReq.genTableDelete(WORK_ERROR_TABLE);
            }
        } else if (needExceptionTable) {
            cgReq.addSourceCode("%macro etls_validateExTable;\n").indent().addSourceCode("%let dsid=%sysfunc(open(work.etls_Exceptions,I)); \n").addSourceCode("%if &dsid ne 0 %then \n").addSourceCode("%do; \n").indent().addSourceCode("%let colMissing=%sysfunc(varnum(&dsid,x_type))=0 or %sysfunc(varnum(&dsid,x_action))=0 or \n").addSourceCode("  %sysfunc(varnum(&dsid,x_note))=0; \n").addSourceCode("%let dsid=%sysfunc(close(&dsid)); \n").addSourceCode("%if %eval(&colMissing) = 1 %then \n").addSourceCode("%do; \n\n").indent();
            cgReq.addCommentLine(bundle.getString("DataValidation.DeleteTempTables.comment.txt")).genTableDelete(WORK_EXCEPTIONS_TABLE);
            cgReq.unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%mend; \n").addSourceCode("%etls_validateExTable;\n\n");
        }
        DataValidation.genDuplicateValuesValidation(cgReq, duplicateValues, duplicateHandler, keepList, selectList, classifierMap, tempTargetDSName, errorDSName, needExceptionTable, createView);
        ValidationUtil.genAbortJob(cgReq, abort || dupAbort);
        if (needExceptionTable) {
            cgReq.addSourceCode("%makeReport; \n\n");
        }
        if (!(autoExtract = AutoExtract.columnMapping(classifierMap, cgReq, false, targetDSName, tempTargetDSName, "", sourceTable, targetTable, createView, false, ignoreColumnsList))) {
            String metaTableName = PhysicalTableCG.getTableName(targetDSName);
            String tempTableName = PhysicalTableCG.getTableName(tempTargetDSName);
            cgReq.addSourceCode("proc datasets lib = " + PhysicalTableCG.getLibref(targetDSName) + " nolist nowarn memtype = (data view);\n").indent().addSourceCode("change ").addSourceCode(tempTableName).addSourceCode(" = ").addSourceCode(metaTableName).addSourceCode(";").unIndent().addSourceCode("\nquit;\n\n");
        }
        cgReq.addSourceCode("%goto endMacro; \n\n").unIndent().addSourceCode("%error: \n").indent().addSourceCode("%let sysrc = 9999; \n").genRCSetCall("&sysrc").unIndent().addSourceCode("%endMacro: \n\n").addSourceCode("%mend ").addSourceCode(MACRO_NAME).addSourceCode(";\n").addSourceCode("%").addSourceCode(MACRO_NAME).addSourceCode(";\n\n");
    }

    protected static void genExcpColumns(CodegenRequest cgReq) {
        cgReq.addSourceCode("attrib x_row    length = 4    label = \"").addSourceCode(bundle.getString("DataValidation.RowNumber.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_column length = $100 label = \"").addSourceCode(bundle.getString("DataValidation.ColumnName.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_type   length = $50  label = \"").addSourceCode(bundle.getString("DataValidation.TypeOfException.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_action length = $50  label = \"").addSourceCode(bundle.getString("DataValidation.ActionTaken.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_note   length = $200 label = \"").addSourceCode(bundle.getString("DataValidation.Notes.label.txt")).addSourceCode("\";\n\n");
    }

    protected static void genCustomFormats(CodegenRequest cgReq, List customValues, DataValidationMetadataHandler customHandler) throws MdException, RemoteException {
        int fmtCount = 0;
        for (int i = 0; i < customValues.size(); ++i) {
            List rowValues = (List)customValues.get(i);
            for (int j = 1; j >= 0; --j) {
                List assignList = (List)rowValues.get(customHandler.getAssignIndex()[j]);
                for (int k = 0; k < assignList.size(); ++k) {
                    List assignRowValues = (List)assignList.get(k);
                    String type = (String)assignRowValues.get(customHandler.getMetaTypeIndex());
                    Column column = (Column)assignRowValues.get(customHandler.getColumnIndex());
                    if (column == null) {
                        throw new CodegenException(bundle.getString("DataValidation.NoCustomColumn.error.txt"));
                    }
                    if (!type.equals("Translation")) continue;
                    cgReq.addSectionComment(bundle.formatString("DataValidation.CustomFormats.comment.txt", (Object)column.getSASColumnName()));
                    PhysicalTable transTable = (PhysicalTable)assignRowValues.get(customHandler.getTransTableIndex());
                    if (transTable == null) {
                        throw new CodegenException(bundle.getString("DataValidation.NoTransTable.error.txt"));
                    }
                    PhysicalTableCG transTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)transTable);
                    String unquotedTableName = transTableCG.getDataLocation(cgReq, false, false).replaceAll("\"", "\"\"");
                    String libRef = PhysicalTableCG.getLibref(unquotedTableName);
                    String tableName = PhysicalTableCG.getTableName(unquotedTableName);
                    transTableCG.accessPath(cgReq);
                    Column fromColumn = (Column)assignRowValues.get(customHandler.getTransFromIndex());
                    if (fromColumn == null) {
                        throw new CodegenException(bundle.getString("DataValidation.NoTransFrom.error.txt"));
                    }
                    String fromName = fromColumn.getSASColumnName();
                    Column toColumn = (Column)assignRowValues.get(customHandler.getTransToIndex());
                    if (toColumn == null) {
                        throw new CodegenException(bundle.getString("DataValidation.NoTransTo.error.txt"));
                    }
                    String toName = toColumn.getSASColumnName();
                    String fromType = fromColumn.getSASColumnType();
                    String toType = toColumn.getSASColumnType();
                    String formatType = toType.equals(NUMERIC) ? INFORMAT : fromType;
                    String vvnOption = "";
                    boolean needQuotes = DBMSNamesPropertyHandler.needQuotes((DataTable)transTable);
                    if (needQuotes) {
                        fromName = DBMSNamesUtil.getQuotedString((String)fromName, (boolean)false);
                        toName = DBMSNamesUtil.getQuotedString((String)toName, (boolean)false);
                        tableName = libRef + "." + DBMSNamesUtil.getQuotedString((String)tableName, (boolean)false);
                        vvnOption = cgReq.getGlobalData("ValidVarName");
                        if (!vvnOption.equals("ANY")) {
                            cgReq.addSourceCode("%let etls_vvnOption = %sysfunc(getOption(VALIDVARNAME)); \n").addSourceCode("options validVarname = ANY; \n\n");
                        }
                    } else {
                        tableName = libRef + "." + tableName;
                    }
                    cgReq.genGetNumRows(transTable, "etls_hasRows", "1");
                    cgReq.addSourceCode("%if &etls_hasRows = 0 %then \n").addSourceCode("%do;  \n").indent().genPercentPutStatement(bundle.formatString("DataValidation.Custom.NoRecords.error.sasmacro.notrans", (Object)tableName), "ERROR:").addSourceCode("%goto error; \n").unIndent().addSourceCode("%end; \n\n");
                    boolean setValueToFlag = (Boolean)assignRowValues.get(customHandler.getTransSetValueToFlagIndex());
                    String formatName = "_" + String.valueOf(fmtCount).trim() + "cFMT";
                    ++fmtCount;
                    if (formatType.equals(CHARACTER)) {
                        formatName = "$" + formatName;
                    }
                    Column sourceColumn = (Column)assignRowValues.get(customHandler.getColumnIndex());
                    int toFmtLength = 32;
                    if (sourceColumn.getSASColumnType().equals(CHARACTER)) {
                        toFmtLength = sourceColumn.getSASColumnLength();
                    }
                    cgReq.addSourceCode("data work.etls_fmtData (keep = fmtName start label type hlo default); \n").indent().addSourceCode("length hlo $1 \n");
                    if (formatType.equals(INFORMAT)) {
                        cgReq.addSourceCode("       label 8 \n");
                    } else {
                        cgReq.addSourceCode("       label $").addSourceCode(String.valueOf(Math.max(32, toFmtLength))).addSourceCode("\n");
                    }
                    if (fromType.equals(NUMERIC) && !formatType.equals(INFORMAT)) {
                        cgReq.addSourceCode("       start 8; \n\n");
                    } else {
                        cgReq.addSourceCode("       start $32; \n\n");
                    }
                    cgReq.addSourceCode("set " + tableName + " end=eof; \n\n");
                    if (fromType.equals(NUMERIC) && formatType.equals(INFORMAT)) {
                        cgReq.addSourceCode("start = left(put(").addSourceCode(fromName).addSourceCode(",32.)); \n");
                    } else {
                        cgReq.addSourceCode("start = ").addSourceCode(fromName).addSourceCode("; \n");
                    }
                    cgReq.addSourceCode("label = ").addSourceCode(toName).addSourceCode("; \n").addSourceCode("fmtName = \"").addSourceCode(formatName).addSourceCode("\"; \n").addSourceCode("type = \"").addSourceCode(formatType).addSourceCode("\"; \n").addSourceCode("default = ").addSourceCode(String.valueOf(toFmtLength)).addSourceCode("; \n").addSourceCode("hlo = \"\"; \n\n");
                    if (setValueToFlag) {
                        cgReq.addSourceCode("output; \n\n").addSourceCode("if eof then \n").addSourceCode("do; \n").indent().addSourceCode("hlo = \"O\"; \n");
                        if (fromType.equals(NUMERIC) && !formatType.equals(INFORMAT)) {
                            cgReq.addSourceCode("start = -999999; \n");
                        } else {
                            cgReq.addSourceCode("start = \"-999999\"; \n");
                        }
                        String setValueTo = (String)assignRowValues.get(customHandler.getTransSetValueToIndex());
                        cgReq.addSourceCode("label = ").addSourceCode(setValueTo).addSourceCode("; \n").addSourceCode("output; \n").unIndent().addSourceCode("end; \n");
                    }
                    cgReq.unIndent().addSourceCode("run; \n\n").addSourceCode("proc sort data = ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" nodupkey; \n").indent().addSourceCode("by start; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("proc format cntlin=").addSourceCode(WORK_FMT_TABLE).addSourceCode("; \n").addSourceCode("run; \n\n").genTableDelete(WORK_FMT_TABLE);
                    if (!needQuotes || vvnOption.equals("ANY")) continue;
                    cgReq.addSourceCode("options validVarname = &etls_vvnOption;\n\n");
                }
            }
        }
    }

    protected static void genInvalidValuesFormats(CodegenRequest cgReq, List invalidValues, DataValidationMetadataHandler invalidHandler) throws MdException, RemoteException {
        for (int i = 0; i < invalidValues.size(); ++i) {
            List rowValues = (List)invalidValues.get(i);
            Column column = (Column)rowValues.get(invalidHandler.getColumnIndex());
            if (column == null) {
                throw new CodegenException(bundle.getString("DataValidation.NoInvalidColumn.error.txt"));
            }
            int colLength = 32;
            if (column.getSASColumnType().equals(CHARACTER)) {
                colLength = column.getSASColumnLength();
            }
            cgReq.addSectionComment(bundle.formatString("DataValidation.InvalidFormat.comment.txt", (Object)column.getSASColumnName()));
            PhysicalTable lookupTable = (PhysicalTable)rowValues.get(invalidHandler.getLookupTableIndex());
            if (lookupTable == null) {
                throw new CodegenException(bundle.getString("DataValidation.NoLookupTable.error.txt"));
            }
            PhysicalTableCG lookupTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)lookupTable);
            String tableName = lookupTableCG.getDataLocation(cgReq, false, false);
            String unquotedTableName = tableName.replaceAll("\"", "\"\"");
            String libRef = PhysicalTableCG.getLibref(tableName);
            tableName = PhysicalTableCG.getTableName(tableName);
            lookupTableCG.accessPath(cgReq);
            Column lookupColumn = (Column)rowValues.get(invalidHandler.getLookupColumnIndex());
            if (lookupColumn == null) {
                throw new CodegenException(bundle.getString("DataValidation.NoLookupColumn.error.txt"));
            }
            String columnName = lookupColumn.getSASColumnName();
            String unquotedColumnName = columnName.replaceAll("\"", "\"\"");
            String columnType = lookupColumn.getSASColumnType();
            String formatName = "_" + String.valueOf(i).trim() + "iFMT";
            String blanksValue = (String)rowValues.get(invalidHandler.getBlanksIndex());
            blanksValue = invalidHandler.getBlanksMetadataValue(blanksValue);
            cgReq.addCommentLine(bundle.getString("DataValidation.InvalidCheckLookup.comment.txt")).genGetNumRows(lookupTable, "etls_hasRows", "1").addSourceCode("\n").genGetColumnExists((DataTable)lookupTable, lookupColumn, "etls_dsid", "etls_lookupVar").addSourceCode("%if &etls_dsid ne 0 %then \n").addSourceCode("%do; ").addCommentLine(bundle.getString("DataValidation.InvalidLookupOpened.comment.txt")).addSourceCode(" \n").indent().addSourceCode("%if &etls_lookupVar eq 0 %then \n").addSourceCode("%do; \n").indent().genPercentPutStatement(bundle.formatString("DataValidation.InvalidNoColumn.sasmacro.notrans", (Object)unquotedColumnName, (Object)unquotedTableName), "ERROR:").addSourceCode("%goto error; \n").unIndent().addSourceCode("%end; \n\n");
            if (!"Yes".equals(blanksValue)) {
                cgReq.addSourceCode("%if &etls_hasRows = 0 %then \n").addSourceCode("%do; \n").indent().genPercentPutStatement(bundle.formatString("DataValidation.InvalidNoRecords.sasmacro.notrans", (Object)unquotedTableName), "ERROR:").addSourceCode("%goto error; \n").unIndent().addSourceCode("%end; \n\n");
            }
            cgReq.unIndent().addSourceCode("%end; ").addCommentLine(bundle.getString("DataValidation.InvalidLookupOpened.comment.txt")).addSourceCode(" \n").addSourceCode("%else \n").addSourceCode("%do; \n").indent().genPercentPutStatement(bundle.formatString("DataValidation.InvalidOpenFailed.sasmacro.notrans", (Object)unquotedTableName), "ERROR:").addSourceCode("%goto error; \n").unIndent().addSourceCode("%end; \n\n");
            String vvnOption = "";
            boolean needQuotes = DBMSNamesPropertyHandler.needQuotes((DataTable)lookupTable);
            if (needQuotes) {
                columnName = DBMSNamesUtil.getQuotedString((String)columnName, (boolean)false);
                tableName = libRef + "." + DBMSNamesUtil.getQuotedString((String)tableName, (boolean)false);
                vvnOption = cgReq.getGlobalData("ValidVarName");
                if (!vvnOption.equals("ANY")) {
                    cgReq.addSourceCode("%let etls_vvnOption = %sysfunc(getOption(VALIDVARNAME)); \n").addSourceCode("options validVarname = ANY; \n\n");
                }
            } else {
                tableName = libRef + "." + tableName;
            }
            cgReq.addCommentLine(bundle.getString("DataValidation.InvalidMakeFormat.comment.txt")).addSourceCode("data ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" (keep = fmtName start label type hlo default); \n\n").indent().addSourceCode("length label 4 \n").addSourceCode("       start ");
            if (columnType.equalsIgnoreCase(NUMERIC)) {
                cgReq.addSourceCode("$32; \n\n");
            } else {
                cgReq.addSourceCode("$").addSourceCode(String.valueOf(colLength)).addSourceCode("; \n\n");
            }
            cgReq.addSourceCode("%if &etls_hasRows %then \n").addSourceCode("%do; ").addCommentLine(bundle.getString("DataValidation.InvalidRecords.comment.txt")).addSourceCode("\n").indent().addSourceCode("set " + tableName + " end = eof; \n\n");
            if (columnType.equals(NUMERIC)) {
                cgReq.addSourceCode("start = left(put(").addSourceCode(columnName).addSourceCode(",32.)); \n");
            } else {
                cgReq.addSourceCode("start = " + columnName + "; \n");
            }
            cgReq.addSourceCode("label = 1; \n").addSourceCode("fmtName = \"").addSourceCode(formatName).addSourceCode("\"; \n").addSourceCode("type = \"I\"; \n").addSourceCode("default = ").addSourceCode(String.valueOf(colLength)).addSourceCode("; \n").addSourceCode("output; \n\n").addSourceCode("if eof then \n\n").unIndent().addSourceCode("%end; ").addCommentLine(bundle.getString("DataValidation.InvalidRecords.comment.txt")).addSourceCode(" \n").addSourceCode("%else \n").addSourceCode("%do; \n").indent().addSourceCode("fmtName = \"").addSourceCode(formatName).addSourceCode("\"; \n").addSourceCode("type = \"I\"; \n").addSourceCode("default = ").addSourceCode(String.valueOf(colLength)).addSourceCode("; \n").unIndent().addSourceCode("%end; \n\n").addSourceCode("do;  \n\n").indent();
            if ("Yes".equals(blanksValue)) {
                if (columnType.equalsIgnoreCase(NUMERIC)) {
                    cgReq.addSourceCode("start = \".\"; \n");
                } else {
                    cgReq.addSourceCode("start = \"\"; \n\n");
                }
                cgReq.addSourceCode("label = 1; \n").addSourceCode("output; \n\n");
            }
            cgReq.addSourceCode("start = \"-9999999\"; \n\n").addSourceCode("hlo = \"O\"; \n").addSourceCode("label = -1; \n").addSourceCode("output; \n\n").unIndent().addSourceCode("end; \n\n").unIndent().addSourceCode("run; \n\n").addSourceCode("%if (&syserr gt 4) %then \n").indent().addSourceCode("%goto error; \n\n").unIndent().addCommentLine(bundle.getString("DataValidation.InvalidDeleteDups.comment.txt")).addSourceCode("proc sort data = ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" nodupkey; \n").indent().addSourceCode("by start; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("%if (&syserr gt 4) %then \n").indent().addSourceCode("%goto error; \n\n").unIndent().addCommentLine(bundle.getString("DataValidation.InvalidCreateFormat.comment.txt")).addSourceCode("proc format cntlin = ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" library = work; \n").addSourceCode("run; \n\n").addSourceCode("%if (&syserr gt 4) %then \n").indent().addSourceCode("%goto error; \n\n").unIndent().genTableDelete(WORK_FMT_TABLE);
            if (!needQuotes || vvnOption.equals("ANY")) continue;
            cgReq.addSourceCode("options validVarname = &etls_vvnOption;\n\n");
        }
    }

    protected static List genCustomValidation(CodegenRequest cgReq, List customValues, DataValidationMetadataHandler customHandler, boolean needExceptionTable) throws MdException, RemoteException {
        ArrayList<Column> ignoreColumnsList = new ArrayList<Column>();
        int fmtCount = 0;
        for (int i = 0; i < customValues.size(); ++i) {
            List rowValues = (List)customValues.get(i);
            String name = (String)rowValues.get(customHandler.getNameIndex());
            String condition = (String)rowValues.get(customHandler.getConditionIndex());
            for (int j = 1; j >= 0; --j) {
                String ifType;
                if (j == 1) {
                    cgReq.addSectionComment(bundle.formatString("DataValidation.CustomValues.comment.txt", (Object)name));
                    cgReq.addSourceCode("if (").addSourceCode(condition).addSourceCode(") then \n").addSourceCode("do; \n").indent();
                    ifType = bundle.getString("DataValidation.CustomTrue.comment.txt");
                } else {
                    cgReq.addSourceCode("else \n").addSourceCode("do; \n").indent();
                    ifType = bundle.getString("DataValidation.CustomFalse.comment.txt");
                }
                List assignList = (List)rowValues.get(customHandler.getAssignIndex()[j]);
                boolean excpFlag = (Boolean)rowValues.get(customHandler.getExceptionIndex()[j]);
                String action = (String)rowValues.get(customHandler.getCustomActionIndex()[j]);
                String metaAction = customHandler.getMetaAction(action);
                for (int k = 0; k < assignList.size(); ++k) {
                    List assignRowValues = (List)assignList.get(k);
                    String type = (String)assignRowValues.get(customHandler.getMetaTypeIndex());
                    Column column = (Column)assignRowValues.get(customHandler.getColumnIndex());
                    if (column == null) {
                        throw new CodegenException(bundle.getString("DataValidation.NoCustomColumn.error.txt"));
                    }
                    ColumnCG columnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)column);
                    String columnName = columnCG.getColumnName(cgReq, false);
                    ignoreColumnsList.add(column);
                    if (type.equals("Expression")) {
                        String expression = (String)assignRowValues.get(customHandler.getExpressionIndex());
                        cgReq.addSourceCode(columnName).addSourceCode(" = ").addSourceCode(expression).addSourceCode("; \n");
                        continue;
                    }
                    boolean transExcpFlag = (Boolean)assignRowValues.get(customHandler.getTransExceptionIndex());
                    boolean setValueToFlag = (Boolean)assignRowValues.get(customHandler.getTransSetValueToFlagIndex());
                    Column fromColumn = (Column)assignRowValues.get(customHandler.getTransFromIndex());
                    if (fromColumn == null) {
                        throw new CodegenException(bundle.getString("DataValidation.NoTransFrom.error.txt"));
                    }
                    Column toColumn = (Column)assignRowValues.get(customHandler.getTransToIndex());
                    if (toColumn == null) {
                        throw new CodegenException(bundle.getString("DataValidation.NoTransTo.error.txt"));
                    }
                    String fromType = fromColumn.getSASColumnType();
                    String toType = toColumn.getSASColumnType();
                    String formatType = toType.equals(NUMERIC) ? INFORMAT : fromType;
                    String tempName = column.getSASColumnType().equals(CHARACTER) ? "tempC" : "tempN";
                    if (transExcpFlag) {
                        cgReq.addSourceCode(tempName).addSourceCode(" = ").addSourceCode(columnName).addSourceCode(";\n");
                    }
                    String formatName = "_" + String.valueOf(fmtCount).trim() + "cFMT.";
                    ++fmtCount;
                    if (formatType.equals(CHARACTER)) {
                        formatName = "$" + formatName;
                    }
                    String columnType = column.getSASColumnType();
                    if (formatType.equals(INFORMAT) && columnType.equals(CHARACTER)) {
                        cgReq.addSourceCode(columnName).addSourceCode(" = left(put(input(").addSourceCode(columnName).addSourceCode(", ").addSourceCode(formatName).addSourceCode("),32.)); \n");
                    } else if (formatType.equals(INFORMAT)) {
                        cgReq.addSourceCode(columnName).addSourceCode(" = input(").addSourceCode("left(put(").addSourceCode(columnName).addSourceCode(",32.)), ").addSourceCode(formatName).addSourceCode("); \n");
                    } else if (formatType.equals(CHARACTER) && columnType.equals(NUMERIC)) {
                        cgReq.addSourceCode(columnName).addSourceCode(" = input(put(left(put(").addSourceCode(columnName).addSourceCode(",32.)), ").addSourceCode(formatName).addSourceCode("), 32.); \n");
                    } else if (formatType.equals(NUMERIC) && columnType.equals(CHARACTER)) {
                        cgReq.addSourceCode(columnName).addSourceCode(" = put(input(").addSourceCode(columnName).addSourceCode(", 32.), ").addSourceCode(formatName).addSourceCode("); \n");
                    } else if (columnType.equals(NUMERIC)) {
                        cgReq.addSourceCode(columnName).addSourceCode(" = input(put(").addSourceCode(columnName).addSourceCode(", ").addSourceCode(formatName).addSourceCode("), 32.); \n");
                    } else {
                        cgReq.addSourceCode(columnName).addSourceCode(" = put(").addSourceCode(columnName).addSourceCode(", ").addSourceCode(formatName).addSourceCode("); \n");
                    }
                    if (!transExcpFlag) continue;
                    if (setValueToFlag) {
                        String setValueTo = (String)assignRowValues.get(customHandler.getTransSetValueToIndex());
                        cgReq.addSourceCode("if ").addSourceCode(columnName).addSourceCode(" eq ").addSourceCode(setValueTo).addSourceCode(" then \n");
                    } else {
                        cgReq.addSourceCode("if ").addSourceCode(columnName).addSourceCode(" eq ").addSourceCode(tempName).addSourceCode(" then \n");
                    }
                    cgReq.addSourceCode("do; \n").indent();
                    if (needExceptionTable) {
                        cgReq.addSourceCode("x_column = \"").addSourceCode(column.getSASColumnName().replaceAll("\"", "\"\"")).addSourceCode("\"; \n").addSourceCode("x_type = \"").addSourceCode(bundle.getString("DataValidation.CustomTransType.label.txt")).addSourceCode("\"; \n").addSourceCode("x_action = \"\"; \n").addSourceCode("x_note = \"").addSourceCode(column.getSASColumnName()).addSourceCode(" = \" || ");
                        if (column.getSASColumnType().equals(CHARACTER)) {
                            cgReq.addSourceCode(tempName).addSourceCode("; \n");
                        } else {
                            cgReq.addSourceCode("compress(put(").addSourceCode(tempName).addSourceCode(", 20.)); \n");
                        }
                        cgReq.addSourceCode("output ").addSourceCode(WORK_EXCEPTIONS_TABLE).addSourceCode("; \n").addSourceCode("x_note=\"\"; \n");
                    }
                    cgReq.addSourceCode("i_excp = 1;\n").unIndent().addSourceCode("end; \n\n");
                }
                if (excpFlag) {
                    if (action.length() <= 0) {
                        action = bundle.getString("DataValidation.NoAction.txt");
                    }
                    if (needExceptionTable) {
                        cgReq.addSourceCode("x_column = \"\"; \n").addSourceCode("x_type = \"").addSourceCode(name).addSourceCode(": ").addSourceCode(ifType).addSourceCode("\"; \n").addSourceCode("x_action = \"").addSourceCode(action).addSourceCode("\"; \n").addSourceCode("output ").addSourceCode(WORK_EXCEPTIONS_TABLE).addSourceCode("; \n\n");
                    }
                    cgReq.addSourceCode("i_excp = 1; \n");
                }
                if (metaAction.equals("MOVE")) {
                    cgReq.addSourceCode("i_move = 1; \n");
                } else if (metaAction.equals("ABORT")) {
                    cgReq.addSourceCode("i_abort = 1; \n");
                }
                if (j == 1) {
                    cgReq.unIndent().addSourceCode("end;  /* if (").addSourceCode(condition).addSourceCode(") */\n");
                    continue;
                }
                cgReq.unIndent().addSourceCode("end;  /* else */\n");
            }
            cgReq.addSourceCode("\n");
        }
        return ignoreColumnsList;
    }

    protected static void genMissingValuesValidation(CodegenRequest cgReq, List missingValues, DataValidationMetadataHandler missingHandler, boolean needExceptionTable) throws MdException, RemoteException {
        for (int i = 0; i < missingValues.size(); ++i) {
            List rowValues = (List)missingValues.get(i);
            String action = (String)rowValues.get(missingHandler.getActionIndex());
            String metaAction = missingHandler.getMetaAction(action);
            Column column = (Column)rowValues.get(missingHandler.getColumnIndex());
            if (column == null) {
                throw new CodegenException(bundle.getString("DataValidation.NoMissingColumn.error.txt"));
            }
            ColumnCG columnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)column);
            String columnName = columnCG.getColumnName(cgReq, false);
            cgReq.addSectionComment(bundle.formatString("DataValidation.MissingValue.comment.txt", (Object)column.getSASColumnName()));
            if (column.getSASColumnType().equalsIgnoreCase(CHARACTER)) {
                cgReq.addSourceCode("if (").addSourceCode(columnName).addSourceCode(" eq \"\") then \n").addSourceCode("do;\n\n");
            } else {
                cgReq.addSourceCode("if (").addSourceCode(columnName).addSourceCode(" eq .) then \n").addSourceCode("do;\n\n");
            }
            cgReq.indent();
            String expression = "";
            if (metaAction.equals("CHANGE")) {
                expression = " " + (String)rowValues.get(missingHandler.getExpressionIndex());
            }
            if (needExceptionTable) {
                cgReq.addCommentLine(bundle.getString("DataValidation.ETLExceptionsSave.comment.txt")).addSourceCode("x_column = \"").addSourceCode(column.getSASColumnName().replaceAll("\"", "\"\"")).addSourceCode("\";\n").addSourceCode("x_type = \"").addSourceCode(bundle.getString("DataValidation.MissingException.msg.txt")).addSourceCode("\";\n").addSourceCode("x_action = \"").addSourceCode(action).addSourceCode(" ").addSourceCode(expression.replaceAll("\"", "\"\"")).addSourceCode("\";\n").addSourceCode("output ").addSourceCode(WORK_EXCEPTIONS_TABLE).addSourceCode(";\n\n");
            }
            cgReq.addCommentLine(bundle.getString("DataValidation.SetFlags.comment.txt")).addSourceCode("i_excp = 1;\n");
            if (metaAction.equals("MOVE")) {
                cgReq.addSourceCode("i_move = 1;\n");
            } else if (metaAction.equals("ABORT")) {
                cgReq.addSourceCode("i_abort = 1;\n");
            } else if (metaAction.equals("CHANGE") && !expression.trim().equals("")) {
                cgReq.addCommentLine(bundle.formatString("DataValidation.ResetValue.comment.txt", (Object)column.getSASColumnName())).addSourceCode(columnName).addSourceCode(" = ").addSourceCode(expression).addSourceCode(";\n");
            }
            cgReq.unIndent().addSourceCode("\n").addSourceCode("end;  ").addCommentLine(bundle.formatString("DataValidation.ColumnIsMissing.comment.txt", (Object)column.getSASColumnName())).addSourceCode("\n");
        }
    }

    protected static void genInvalidValuesValidation(CodegenRequest cgReq, List invalidValues, DataValidationMetadataHandler invalidHandler, String targetDSName, boolean needExceptionTable) throws MdException, RemoteException {
        for (int i = 0; i < invalidValues.size(); ++i) {
            Column column;
            List rowValues = (List)invalidValues.get(i);
            String action = (String)rowValues.get(invalidHandler.getActionIndex());
            String metaAction = invalidHandler.getMetaAction(action);
            String expression = "";
            if (metaAction.equals("CHANGE")) {
                expression = (String)rowValues.get(invalidHandler.getExpressionIndex());
                action = action + " ";
                action = action + expression;
                action = action.replaceAll("\"", "'");
            }
            if ((column = (Column)rowValues.get(invalidHandler.getColumnIndex())) == null) {
                throw new CodegenException(bundle.getString("DataValidation.NoInvalidColumn.error.txt"));
            }
            ColumnCG columnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)column);
            String columnName = columnCG.getColumnName(cgReq, false);
            String unquotedColumnName = column.getSASColumnName().replaceAll("\"", "\"\"");
            String columnType = column.getSASColumnType();
            String formatName = "_" + String.valueOf(i).trim() + "iFMT.";
            String exceptionType = bundle.getString("DataValidation.InvalidException.msg.txt");
            cgReq.addSectionComment(bundle.formatString("DataValidation.InvalidColumn.comment.txt", (Object)unquotedColumnName)).addCommentLine(bundle.getString("DataValidation.InvalidApplyFormat.comment.txt"));
            cgReq.addSourceCode("etls_valid_flg = input(");
            if (columnType.equals(NUMERIC)) {
                cgReq.addSourceCode("left(put(").addSourceCode(columnName).addSourceCode(",32.))");
            } else {
                cgReq.addSourceCode(columnName);
            }
            cgReq.addSourceCode(", ").addSourceCode(formatName).addSourceCode("); \n\n").addSourceCode("if (etls_valid_flg ne 1) then \n").addSourceCode("do; ").addCommentLine(bundle.getString("DataValidation.InvalidFoundInvalid.comment.txt")).addSourceCode("\n").indent().addCommentLine(bundle.getString("DataValidation.SetFlags.comment.txt")).addSourceCode("i_excp = 1; \n");
            if (needExceptionTable) {
                cgReq.addSourceCode("\n").addCommentLine(bundle.getString("DataValidation.InvalidUpdateExcp.comment.txt")).addSourceCode("x_row    = _n_; \n").addSourceCode("x_column = \"").addSourceCode(unquotedColumnName).addSourceCode("\"; \n").addSourceCode("x_type   = \"").addSourceCode(exceptionType).addSourceCode("\"; \n").addSourceCode("x_action = \"").addSourceCode(action).addSourceCode("\"; \n").addSourceCode("output ").addSourceCode(WORK_EXCEPTIONS_TABLE).addSourceCode("; \n\n");
            }
            if (metaAction.equals("MOVE")) {
                cgReq.addSourceCode("i_move = 1; \n\n");
            } else if (metaAction.equals("ABORT")) {
                cgReq.addSourceCode("i_abort = 1; \n\n");
            } else if (metaAction.equals("CHANGE") && expression.length() > 0) {
                cgReq.addSourceCode(columnName).addSourceCode(" = ").addSourceCode(expression).addSourceCode("; \n\n");
            }
            cgReq.unIndent().addSourceCode("end; ").addCommentLine(bundle.getString("DataValidation.InvalidFoundInvalid.comment.txt")).addSourceCode("\n");
        }
    }

    protected static void genDuplicateValuesValidation(CodegenRequest cgReq, List duplicateValues, DataValidationMetadataHandler duplicateHandler, String keepList, String selectList, ClassifierMap classifierMap, String targetDSName, String errorDSName, boolean needExceptionTable, boolean createView) throws MdException, RemoteException {
        if (duplicateValues.size() > 0) {
            cgReq.addSectionComment(bundle.getString("DataValidation.Duplicates.comment.txt"));
        }
        for (int i = 0; i < duplicateValues.size(); ++i) {
            List rowValues = (List)duplicateValues.get(i);
            String action = (String)rowValues.get(duplicateHandler.getActionIndex());
            String metaAction = duplicateHandler.getMetaAction(action);
            String table = (String)rowValues.get(duplicateHandler.getTableIndex());
            String metatable = duplicateHandler.getMetaTable(table);
            List columnList = (List)rowValues.get(duplicateHandler.getColumnListIndex());
            if (columnList.isEmpty()) {
                throw new CodegenException(bundle.getString("DataValidation.Duplicates.NoByColumns.msg.txt"));
            }
            String colNames = cgReq.makeColumnList(columnList, "   ").trim();
            ArrayList<String> columnNamesList = new ArrayList<String>();
            for (int j = 0; j < columnList.size(); ++j) {
                columnNamesList.add(((Column)columnList.get(j)).getSASColumnName());
            }
            String colNamesString = cgReq.makeColumnList(columnNamesList, "   ").trim();
            String lastColumn = null;
            for (int j = columnList.size() - 1; j >= 0; --j) {
                Column column = (Column)columnList.get(j);
                if (column == null) continue;
                ColumnCG columnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)column);
                lastColumn = columnCG.getColumnName(cgReq, false);
                break;
            }
            boolean move = metaAction.equals("MOVE");
            boolean moveall = metaAction.equals("MOVEALL");
            boolean abort = metaAction.equals("ABORT");
            cgReq.addCommentLine(bundle.formatString("DataValidation.Duplicates.Heading.comment.txt", (Object)"Source", (Object)colNamesString.trim()));
            if (needExceptionTable) {
                cgReq.addCommentLine(bundle.getString("DataValidation.CreateRow.comment.txt")).addSourceCode("data ").addSourceCode(WORK_SOURCE_TABLE).addSourceCode("; \n").indent().addSourceCode("set &etls_Source; \n").addSourceCode("attrib x_row length=4 label=\"Row Number\"; \n").addSourceCode("x_row = _n_; \n").unIndent().addSourceCode("run; \n\n").addCommentLine(bundle.getString("DataValidation.Sort.comment.txt")).addSourceCode("proc sort data = ").addSourceCode(WORK_SOURCE_TABLE).addSourceCode("; \n");
            } else {
                cgReq.addCommentLine(bundle.getString("DataValidation.Sort.comment.txt")).addSourceCode("proc sort data = &etls_Source out = ").addSourceCode(WORK_SOURCE_TABLE).addSourceCode("; \n");
            }
            cgReq.indent().addSourceCode("by ").addSourceCode(colNames).addSourceCode(";\n").unIndent().addSourceCode("run; \n\n");
            cgReq.genTableDelete(targetDSName);
            if (createView && (move || moveall)) {
                cgReq.genPercentPutStatement(bundle.getString("DataValidation.NoView.comment.sasmacro.notrans")).addSourceCode("\n");
            }
            cgReq.addSourceCode("data ").addSourceCode(targetDSName).addSourceCode("\n").addSourceCode("        (").addSourceCode(keepList);
            if (metatable.equals("TARGET") && needExceptionTable) {
                cgReq.addSourceCode(" x_row");
            }
            cgReq.addSourceCode(")\n");
            if (move || moveall) {
                cgReq.addSourceCode("     ").addSourceCode(WORK_ERROR_TABLE).addSourceCode("\n").addSourceCode("        (" + keepList.toString() + ")");
            }
            if (needExceptionTable) {
                cgReq.addSourceCode("\n").addSourceCode("     ").addSourceCode(WORK_DUPS_TABLE).addSourceCode("\n").addSourceCode("        (keep = x_row x_column x_type x_action x_note)");
            }
            if (createView && !move && !moveall) {
                cgReq.addSourceCode("\n / view = ").addSourceCode(targetDSName);
            }
            cgReq.addSourceCode(";\n\n").indent().addSourceCode("set ").addSourceCode(WORK_SOURCE_TABLE).addSourceCode(" end=eof;\n").addSourceCode("by ").addSourceCode(colNames).addSourceCode(";\n\n");
            if (needExceptionTable) {
                DataValidation.genExcpColumns(cgReq);
                cgReq.addSourceCode("retain x_type \"").addSourceCode(bundle.getString("DataValidation.DuplicateException.msg.txt")).addSourceCode("\";\n").addSourceCode("retain x_action \"").addSourceCode(action).addSourceCode("\"; \n").addSourceCode("retain x_column \"").addSourceCode(colNamesString.replaceAll("\"", "\"\"")).addSourceCode("\"; \n\n");
            }
            if (abort) {
                cgReq.addSourceCode("retain i_abort &m_abort; \n");
            }
            cgReq.addSourceCode("retain i_excp &m_excp; \n\n");
            StringBuffer note = new StringBuffer();
            if (needExceptionTable) {
                note = new StringBuffer("x_note = \"ColumnValues:\"");
                for (int j = 0; j < columnList.size(); ++j) {
                    Column column = (Column)columnList.get(j);
                    if (column == null) {
                        throw new CodegenException(bundle.getString("DataValidation.NoDuplicateColumn.error.txt"));
                    }
                    ColumnCG columnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)column);
                    String columnName = columnCG.getColumnName(cgReq).trim();
                    note.append(" || \n         \" ").append(column.getSASColumnName()).append("=\" || ");
                    if (column.getSASColumnType().equals(CHARACTER)) {
                        note.append("trim(left(" + columnName + "))");
                        continue;
                    }
                    note.append("compress(put(" + columnName + ",15.))");
                }
            }
            String startingQuote = "";
            String tempLastColumn = lastColumn;
            if (lastColumn.startsWith("'")) {
                startingQuote = "'";
            } else if (lastColumn.startsWith("\"")) {
                startingQuote = "\"";
            }
            if (startingQuote.length() > 0) {
                tempLastColumn = lastColumn.substring(1);
            }
            cgReq.addSourceCode("if not (").addSourceCode(startingQuote).addSourceCode("first.").addSourceCode(tempLastColumn).addSourceCode(" and \n").addSourceCode("        ").addSourceCode(startingQuote).addSourceCode("last.").addSourceCode(tempLastColumn).addSourceCode(") then \n").addSourceCode("do; \n\n").indent();
            if (needExceptionTable) {
                cgReq.addCommentLine(bundle.getString("DataValidation.ETLExceptionsSave.comment.txt")).addSourceCode(note.toString()).addSourceCode(";\n\n").addSourceCode("output ").addSourceCode(WORK_DUPS_TABLE).addSourceCode("; \n\n");
            }
            if (move) {
                cgReq.addSourceCode("if ").addSourceCode(startingQuote).addSourceCode("first.").addSourceCode(tempLastColumn).addSourceCode(" then \n").indent().addSourceCode("output ").addSourceCode(targetDSName).addSourceCode(";  ").addCommentLine(bundle.getString("DataValidation.MoveOne.comment.txt")).unIndent().addSourceCode("else \n").indent();
            }
            if (move || moveall) {
                cgReq.addSourceCode("output ").addSourceCode(WORK_ERROR_TABLE).addSourceCode(";  ").addCommentLine(bundle.getString("DataValidation.MoveToError.comment.txt")).addSourceCode("\n");
                if (move) {
                    cgReq.unIndent();
                }
            } else if (abort) {
                cgReq.addCommentLine(bundle.getString("DataValidation.SetFlags.comment.txt")).addSourceCode("\n").addSourceCode("i_abort=1; \n");
            }
            cgReq.addSourceCode("i_excp = 1; \n\n").unIndent().addSourceCode("end; ").addCommentLine(bundle.getString("DataValidation.DuplicateValue.comment.txt")).addSourceCode("\n").addCommentLine(bundle.getString("DataValidation.MoveToOutput.comment.txt")).addSourceCode("else \n").indent().addSourceCode("output ").addSourceCode(targetDSName).addSourceCode("; \n\n").unIndent();
            cgReq.addSourceCode("if eof then \n").addSourceCode("do; \n").indent().addCommentLine(bundle.getString("DataValidation.CreateFlags.comment.txt")).addSourceCode("call symput(\"m_excp\", put(i_excp, 1.)); \n");
            if (abort) {
                cgReq.addSourceCode("call symput(\"m_abort\", put(i_abort, 1.)); \n");
            }
            cgReq.unIndent().addSourceCode("end; \n\n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
            if (needExceptionTable) {
                cgReq.addCommentLine(bundle.getString("DataValidation.UpdateExceptions.comment.txt")).addSourceCode("proc append base=").addSourceCode(WORK_EXCEPTIONS_TABLE).addSourceCode(" data=").addSourceCode(WORK_DUPS_TABLE).addSourceCode(" force; \n").addSourceCode("run; \n\n");
            }
            if (move || moveall) {
                ValidationUtil.genUpdateErrorTable(cgReq, WORK_ERROR_TABLE, errorDSName);
            }
            ArrayList<String> tables = new ArrayList<String>(3);
            if (needExceptionTable) {
                tables.add(WORK_DUPS_TABLE);
            }
            tables.add(WORK_SOURCE_TABLE);
            if (move || moveall) {
                tables.add(WORK_ERROR_TABLE);
            }
            cgReq.addCommentLine(bundle.getString("DataValidation.DeleteTempTables.comment.txt")).genTableDelete(tables);
            cgReq.addSourceCode("%let etls_Source=").addSourceCode(targetDSName).addSourceCode(";\n\n");
            if (!metatable.equals("TARGET")) continue;
            PhysicalTable lastTable = DataValidation.getNextPhysicalTable(cgReq, classifierMap);
            PhysicalTableCG lastTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)lastTable);
            String lastTableName = lastTableCG.getDataLocation(cgReq, false, true);
            cgReq.addCommentLine(bundle.formatString("DataValidation.Duplicates.Heading.comment.txt", (Object)"Source+Target", (Object)colNamesString));
            lastTableCG.accessPath(cgReq);
            cgReq.addCommentLine(bundle.getString("DataValidation.Exist.comment.txt")).genTableExist(lastTableName, "DATA", "etls_exist").addSourceCode("%if &etls_exist > 0 %then \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DataValidation.TargetExists.comment.txt")).indent().addCommentLine(bundle.getString("DataValidation.SQL.comment.txt")).addSourceCode("proc sql;\n").indent().addSourceCode("create table ").addSourceCode(WORK_ERROR_TABLE).addSourceCode(" as \n").indent().addSourceCode(selectList);
            if (needExceptionTable) {
                cgReq.addSourceCode(", x_row");
            }
            cgReq.addSourceCode("\n").indent().addSourceCode("from ").addSourceCode(lastTableName).addSourceCode(" as t \n").addSourceCode("       inner join \n").addSourceCode("     &etls_Source as s \n");
            StringBuffer onClause = new StringBuffer("on ");
            for (int j = 0; j < columnList.size(); ++j) {
                Column column = (Column)columnList.get(j);
                if (column == null) {
                    throw new CodegenException(bundle.getString("DataValidation.NoDuplicateColumn.error.txt"));
                }
                ColumnCG columnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)column);
                String columnName = columnCG.getColumnName(cgReq).trim();
                if (j > 0) {
                    onClause.append(" and \n   ");
                }
                onClause.append("t.").append(columnName).append(" = s.").append(columnName);
            }
            cgReq.addSourceCode(onClause.toString()).addSourceCode("\n").unIndent().unIndent().addSourceCode("; \n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
            if (move || moveall) {
                StringBuffer errTable = new StringBuffer(WORK_ERROR_TABLE);
                if (needExceptionTable) {
                    errTable.append(" (drop = x_row)");
                }
                ValidationUtil.genUpdateErrorTable(cgReq, errTable.toString(), errorDSName);
            }
            if (needExceptionTable) {
                cgReq.addSourceCode("data ").addSourceCode(WORK_DUPS_TABLE).addSourceCode(" (keep = x_row x_column x_type x_action x_note);\n\n").indent().addSourceCode("set ").addSourceCode(WORK_ERROR_TABLE).addSourceCode(" end=eof; \n").addCommentLine(bundle.getString("DataValidation.ETLExceptionsColumns.comment.txt"));
                DataValidation.genExcpColumns(cgReq);
                cgReq.addSourceCode("retain x_type \"").addSourceCode(bundle.getString("DataValidation.DuplicateException.msg.txt")).addSourceCode("\";\n").addSourceCode("retain x_action \"").addSourceCode(action).addSourceCode("\";\n\n").addSourceCode("x_column = \"").addSourceCode(colNamesString.replaceAll("\"", "\"\"")).addSourceCode("\"; \n").addSourceCode(note.toString()).addSourceCode("; \n\n").addSourceCode("if eof then \n").addSourceCode("do; \n").indent().addSourceCode("call symput(\"m_excp\", \"1\"); \n");
                if (abort) {
                    cgReq.addSourceCode("call symput(\"m_abort\", \"1\"); \n");
                }
                cgReq.unIndent().addSourceCode("end; \n").unIndent().addSourceCode("  run; \n\n");
                cgReq.addCommentLine(bundle.getString("DataValidation.UpdateExceptions.comment.txt")).addSourceCode("proc append base=").addSourceCode(WORK_EXCEPTIONS_TABLE).addSourceCode(" data=").addSourceCode(WORK_DUPS_TABLE).addSourceCode(" force; \n").addSourceCode("run; \n\n");
            } else {
                cgReq.genGetNumRows(WORK_ERROR_TABLE, "etls_hasRows", false, "1").addSourceCode("%if &etls_hasRows %then \n").addSourceCode("%do; \n").indent().addSourceCode("%let m_excp = 1; \n");
                if (abort) {
                    cgReq.addSourceCode("%let m_abort = 1; \n");
                }
                cgReq.unIndent().addSourceCode("%end; \n\n");
            }
            if (move || moveall) {
                StringBuffer dropVars = new StringBuffer();
                if (needExceptionTable) {
                    dropVars.append(" x_row");
                }
                if (errorDSName.length() > 0) {
                    dropVars.append(" ETL_Error_JobRunTime");
                }
                if (dropVars.length() > 0) {
                    dropVars.insert(0, "(drop =").append(") ");
                }
                cgReq.addSourceCode("proc sort data = ").addSourceCode(WORK_ERROR_TABLE).addSourceCode(dropVars).addSourceCode(" nodupkey; \n").indent().addSourceCode("by " + colNames + "; \n").unIndent().addSourceCode("run; \n\n");
                dropVars = new StringBuffer();
                if (needExceptionTable) {
                    dropVars.append(" (drop = x_row)");
                }
                cgReq.addSourceCode("data ").addSourceCode(targetDSName).addSourceCode(";\n").indent().addSourceCode("merge &etls_Source").addSourceCode(dropVars).addSourceCode("\n").addSourceCode("      ").addSourceCode(WORK_ERROR_TABLE).addSourceCode(" (in=inDups); \n").addSourceCode("by ").addSourceCode(colNames).addSourceCode("; \n").addSourceCode("if inDups then \n").indent().addSourceCode("delete; \n").unIndent().unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
            }
            tables.clear();
            if (needExceptionTable) {
                tables.add(WORK_DUPS_TABLE);
            }
            if (move || moveall) {
                tables.add(WORK_ERROR_TABLE);
            }
            if (!tables.isEmpty()) {
                cgReq.addCommentLine(bundle.getString("DataValidation.DeleteTempTables.comment.txt")).genTableDelete(tables);
            }
            cgReq.unIndent().addSourceCode("%end; ").addCommentLine(bundle.getString("DataValidation.TargetExists.comment.txt")).addSourceCode("\n");
            if (!needExceptionTable) continue;
            cgReq.addSourceCode("%else \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DataValidation.TargetDoesNotExist.comment.txt")).indent().addSourceCode("data ").addSourceCode(targetDSName).addSourceCode("; \n").indent().addSourceCode("set ").addSourceCode(targetDSName).addSourceCode(" (drop = x_row); \n").unIndent().addSourceCode("run; \n").unIndent().addSourceCode("%end; ").addCommentLine(bundle.getString("DataValidation.TargetDoesNotExist.comment.txt")).addSourceCode("\n");
        }
    }

    protected static PhysicalTable getNextPhysicalTable(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        PhysicalTable lastTable = null;
        TransformationStep step = (TransformationStep)classifierMap.getSteps(false).get(0);
        AssociationList spList = step.getPredecessorDependencies();
        for (int j = 0; j < spList.size(); ++j) {
            TransformationStep nextStep;
            StepPrecedence stepPrec = (StepPrecedence)spList.get(j);
            AssociationList succList = stepPrec.getSuccessors();
            for (int k = 0; k < succList.size() && (nextStep = (TransformationStep)succList.get(k)) != step; ++k) {
                step = nextStep;
                AssociationList cmList = step.getTransformations();
                for (int l = 0; l < cmList.size(); ++l) {
                    ClassifierMap cm = (ClassifierMap)cmList.get(l);
                    AssociationList cmTargets = cm.getClassifierTargets();
                    for (int m = 0; m < cmTargets.size(); ++m) {
                        DataTable dt = (DataTable)cmTargets.get(m);
                        if (!(dt instanceof PhysicalTable) || dt instanceof WorkTable) continue;
                        return (PhysicalTable)dt;
                    }
                    PhysicalTable pt = DataValidation.getNextPhysicalTable(cgReq, cm);
                    if (pt == null) continue;
                    return pt;
                }
            }
        }
        if (lastTable == null) {
            throw new CodegenException(bundle.getString("DataValidation.NoFinalTarget.msg.txt"));
        }
        return lastTable;
    }
}

