/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.ClassifierMapUtilityInterface;
import com.sas.codegen.CodeGenInterface;
import com.sas.codegen.CodeGenRoot;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DBMSSTORE;
import com.sas.codegen.Loader;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformNoPostIndexAndConstraintCreationInterface;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ClassifierMapCG
extends CodeGenRoot
implements CodeGenInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(ClassifierMapCG.class);
    private static final String MACRO_ROLE = "ESMACRO";
    private static final String UWC_ROLE = "SASUserExit";

    @Override
    public void codeGen(CodegenRequest cgReq) throws MdException, RemoteException {
        ClassifierMap classifierMap = (ClassifierMap)this.getMetadataClass();
        if (cgReq.onContextList(classifierMap.getFQID())) {
            return;
        }
        cgReq.addContextList(classifierMap.getFQID());
        this.codeGenSelfOnly(cgReq);
    }

    @Override
    public void codeGenSelfOnly(CodegenRequest cgReq) throws MdException, RemoteException {
        String macroVars;
        ClassifierMap classifierMap = (ClassifierMap)this.getMetadataClass();
        if (classifierMap.getSteps(false).size() <= 0) {
            throw new CodegenException(bundle.getString("PROCESS.NoTransformationSteps.msg.txt"));
        }
        TransformationStep step = (TransformationStep)classifierMap.getSteps(false).get(0);
        cgReq.addStepComment(step);
        cgReq.genParameterDefaultValueCode((Root)step);
        if (classifierMap.getIsActive() <= 0) {
            return;
        }
        String transformRole = step.getTransformRole().toUpperCase();
        if (transformRole.indexOf("LOADER") < 0 && transformRole.indexOf("READER") < 0 && transformRole.indexOf("WRITER") < 0) {
            cgReq.checkSourcesForExternalTable(classifierMap);
            cgReq.checkTargetsForExternalTable(classifierMap);
        }
        ArrayList<Object> sourceTables = new ArrayList<Object>();
        ArrayList<Object> targetTables = new ArrayList<Object>();
        for (int i = 0; i < step.getTransformations().size(); ++i) {
            int j;
            ClassifierMap cMap = (ClassifierMap)step.getTransformations().get(i);
            for (j = 0; j < cMap.getClassifierSources().size(); ++j) {
                if (sourceTables.contains(cMap.getClassifierSources().get(j))) continue;
                sourceTables.add(cMap.getClassifierSources().get(j));
            }
            for (j = 0; j < cMap.getClassifierTargets().size(); ++j) {
                if (targetTables.contains(cMap.getClassifierTargets().get(j))) continue;
                targetTables.add(cMap.getClassifierTargets().get(j));
            }
        }
        ArrayList<Object> tableList = new ArrayList<Object>();
        tableList.addAll(sourceTables);
        tableList.addAll(targetTables);
        if (!cgReq.getGlobalData("TransferStep").equals("Y")) {
            for (int i = 0; i < tableList.size(); ++i) {
                AssociationList libraries;
                if (!(tableList.get(i) instanceof PhysicalTable)) continue;
                PhysicalTable table = (PhysicalTable)tableList.get(i);
                if (!(table instanceof WorkTable) && (libraries = table.getTablePackages()).size() <= 0) {
                    throw new CodegenException(bundle.formatString("PROCESS.NoLibraryForTable.msg.txt", (Object)table.getSASTableName()));
                }
                if (cgReq.getGlobalData("ContentsStep").equals("Y") && (!cgReq.getGlobalData("ContentsStep").equals("Y") || !targetTables.contains(table))) continue;
                PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
                tableCG.accessPath(cgReq);
            }
        }
        if (!CodeGenUtil.isLoaderTransformation((CMetadata)step, false)) {
            int targets = targetTables.size();
            for (int i = 0; i < targets; ++i) {
                Classifier dTable = (Classifier)targetTables.get(i);
                if (!dTable.getCMetadataType().equals("PhysicalTable")) continue;
                cgReq.genJobStatusUpdateBefore((PhysicalTable)dTable);
            }
        }
        if (!cgReq.getGlobalData("TransferStep").equals("Y") && !cgReq.getGlobalData("ContentsStep").equals("Y")) {
            cgReq.genSyslast(classifierMap);
        }
        if ((macroVars = cgReq.getGlobalData("Macro Variables")).equals("Y")) {
            cgReq.addSourceCode("%let transformID = %quote(").addSourceCode(step.getFQID()).addSourceCode("); \n\n");
        }
        cgReq.addSourceCode("%let trans_rc = 0; \n\n");
        int cmUserCode = classifierMap.getIsUserDefined();
        if (step.getTransformRole().indexOf(UWC_ROLE) > -1 && cmUserCode == 0) {
            throw new CodegenException(bundle.getString("ClassifierMapCG.UserExitNotUserDefined.msg.txt"));
        }
        int stepUserCode = step.getIsUserDefined();
        if (cmUserCode == 0 && stepUserCode == 0) {
            this.genTransformCode(cgReq);
        } else {
            this.genUserWrittenCode(cgReq, classifierMap, step, cmUserCode, targetTables);
        }
        if (!CodeGenUtil.isLoaderTransformation((CMetadata)step, false)) {
            int targets = targetTables.size();
            for (int i = 0; i < targets; ++i) {
                TransformInterface interf;
                Classifier dTable = (Classifier)targetTables.get(i);
                if (!(dTable instanceof PhysicalTable)) continue;
                PhysicalTableCG pTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)dTable);
                if (pTableCG instanceof DBMSSTORE & !((interf = CodeGenUtil.getPluginInterface((CMetadata)step)) instanceof TransformNoPostIndexAndConstraintCreationInterface) && !pTableCG.isView(step) && cmUserCode == 0 && stepUserCode == 0) {
                    Loader tempLoader = new Loader(cgReq, (PhysicalTable)dTable);
                    tempLoader.createIndexes2();
                }
                if (!dTable.getCMetadataType().equals("PhysicalTable")) continue;
                cgReq.genJobStatusUpdateAfter((PhysicalTable)dTable);
            }
        }
    }

    private void genTransformCode(CodegenRequest cgReq) throws MdException, RemoteException {
        ClassifierMap classifierMap = (ClassifierMap)this.getMetadataClass();
        ClassifierMapUtilityInterface cmUtility = null;
        String classname = CodeGenUtil.getPluginClass((CMetadata)classifierMap);
        try {
            ClassLoader loader = Workspace.getWorkspace().getPluginLoader().getClassLoader(classname);
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            Class<?> LoadedClass = Class.forName(classname, true, loader);
            cmUtility = (ClassifierMapUtilityInterface)LoadedClass.newInstance();
        }
        catch (ClassNotFoundException ce) {
            String role = CodeGenUtil.getPluginClassPropertyRole((CMetadata)classifierMap);
            try {
                TransformInterface intTransform;
                if (role.indexOf(MACRO_ROLE) > -1 && (intTransform = TransformManager.getInstance().getTransform(classname)) instanceof ClassifierMapUtilityInterface) {
                    cmUtility = (ClassifierMapUtilityInterface)((Object)intTransform);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cmUtility == null) {
                throw new CodegenException(bundle.formatString("PROCESS.NoClassName.msg.txt", (Object)classname));
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        cmUtility.executeUtility(cgReq, classifierMap);
    }

    private void genUserWrittenCode(CodegenRequest cgReq, ClassifierMap classifierMap, TransformationStep step, int cmUserCode, List targetTables) throws MdException, RemoteException {
        DataTable table;
        Text text;
        if (cmUserCode != 0) {
            text = classifierMap.getSourceCode();
        } else {
            text = step.getSourceCode();
            AssociationList cmapList = step.getTransformations();
            for (int i = 1; i < cmapList.size(); ++i) {
                ClassifierMap tempMap = (ClassifierMap)cmapList.get(i);
                if (cgReq.onContextList(tempMap.getFQID())) continue;
                cgReq.addContextList(tempMap.getFQID());
            }
        }
        if (text == null) {
            throw new CodegenException(bundle.getString("PROCESS.NoSourceCode.msg.txt"));
        }
        if (targetTables.size() == 1 && (table = (DataTable)targetTables.get(0)) instanceof PhysicalTable) {
            PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
            cgReq.addSourceCode("%let _OUTPUT = %nrquote(").addSourceCode(tableCG.getDataLocation(cgReq, false, true)).addSourceCode("); \n\n");
        }
        cgReq.genUWC(text, false, true);
    }
}

