/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config.httpclient;

import java.util.Arrays;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.springframework.beans.factory.FactoryBean;

public class CommonsHttpStateProxyCredentialFactoryBean
implements FactoryBean<CredentialsProvider> {
    private String proxyUsername;
    private byte[] proxyPassword;
    private String proxyRealm;
    private String proxyScheme;
    private CredentialsProvider provider = new BasicCredentialsProvider();

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword.getBytes();
    }

    public void setProxyRealm(String proxyAuthRealm) {
        this.proxyRealm = proxyAuthRealm;
    }

    public void setProxyScheme(String proxyAuthScheme) {
        this.proxyScheme = proxyAuthScheme;
    }

    public CredentialsProvider getObject() throws Exception {
        if (null == this.provider) {
            this.provider = new BasicCredentialsProvider();
            if (null != this.proxyUsername) {
                AuthScope authscope = new AuthScope(null, -1, this.proxyRealm, this.proxyScheme);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.proxyUsername, new String(this.proxyPassword));
                Arrays.fill(this.proxyPassword, (byte)0);
                this.provider.setCredentials(authscope, (Credentials)credentials);
            }
        }
        return this.provider;
    }

    public Class<?> getObjectType() {
        return CredentialsProvider.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

