/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.cluster.balance.RandomPolicy;
import com.sas.svcs.cluster.httpinvoker.AutoDiscoveredHttpService;
import com.sas.svcs.cluster.httpinvoker.AutoDiscoveredHttpServiceExporter;
import com.sas.svcs.cluster.httpinvoker.AvailabilityChecker;
import com.sas.svcs.cluster.httpinvoker.AvailabilityInterface;
import com.sas.svcs.cluster.httpinvoker.AvailabilityService;
import com.sas.svcs.cluster.httpinvoker.ServicePublisher;
import com.sas.svcs.cluster.httpinvoker.content.AutoDiscoveredContentServiceExporter;
import com.sas.svcs.cluster.httpinvoker.content.ContentServicePublisher;
import com.sas.svcs.cluster.httpinvoker.content.DiscoveredServices;
import com.sas.svcs.cluster.httpinvoker.stateful.AutoDiscoveredCreatesStatefulHttpService;
import com.sas.svcs.cluster.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceURIProcessor;
import com.sas.svcs.registry.client.ServiceRegistryInterface;
import com.sas.svcs.remoting.client.SASClientCreatesStatefulHttpServiceProxy;
import com.sas.svcs.remoting.client.SASClientHttpServiceProxy;
import com.sas.svcs.remoting.client.SASClientTicketingProxy;
import com.sas.svcs.remoting.client.SocketFactoryHelper;
import com.sas.svcs.remoting.httpinvoker.ProxyAwareCommonsRequestExecutor;
import com.sas.svcs.remoting.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceIdProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceResultIdProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceResultProxyProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceDeletionProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceHolderInterface;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceProxyInterceptor;
import com.sas.svcs.springframework.config.EnvPropertiesBeanDefinitionParser;
import com.sas.svcs.springframework.config.EnvServicesBeanDefinitionParser;
import com.sas.svcs.springframework.config.HttpJavaServiceBeanDefinitionParser;
import com.sas.svcs.springframework.config.NamespaceHelper;
import com.sas.svcs.springframework.config.PublisherBeanDefinitionParser;
import com.sas.svcs.springframework.config.httpclient.CommonsHttpStateProxyCredentialFactoryBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Registry;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.remoting.support.DefaultRemoteInvocationExecutor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SvcsNamespaceHandler
extends NamespaceHandlerSupport {
    static final Logger logger = LogManager.getLogger(SvcsNamespaceHandler.class);
    static final String CACHE_ELEMENT = "cache";
    static final String DISCOVERED_SERVICE_ELEMENT = "discoveredService";
    static final String DISCOVERED_SERVICES_ELEMENT = "discoveredServices";
    static final String EXECUTOR_ELEMENT = "executor";
    static final String PUBLISHED_SERVICE_ELEMENT = "publishedService";
    static final String PUBLISHED_SERVICES_ELEMENT = "publishedServices";
    static final String PUBLISHER_ELEMENT = "publisher";
    static final String POLICY_ELEMENT = "policy";
    static final String CLIENT_SERVICE_ELEMENT = "clientService";
    static final String CLIENT_SERVICES_ELEMENT = "clientServices";
    static final String SERVICEURLDAO_ELEMENT = "serviceURLDAO";
    static final String AVAILABILITY_CHECKER_ELEMENT = "availabilityChecker";
    static final String AVAILABLE_TASK_ELEMENT = "availableTask";
    static final String DISCOVERED_CONTENT_SERVICE_ELEMENT = "discoveredContentService";
    static final String DISCOVERED_CONTENT_SERVICES_ELEMENT = "discoveredContentServices";
    static final String PUBLISHED_CONTENT_SERVICES_ELEMENT = "publishedContentServices";
    static final String PUBLISHED_CONTENT_SERVICE_ELEMENT = "publishedContentService";
    static final String REGISTRY_ELEMENT = "registry";
    static final String ENV_SERVICES_ELEMENT = "environment-discovered-services";
    static final String CLASS_ATTRIBUTE = "class";
    static final String SERVICE_INTERFACE_ATTRIBUTE = "serviceInterface";
    @Deprecated
    static final String CACHE_MULTICAST_PORT_ATTRIBUTE = "multicastPort";
    @Deprecated
    static final String CACHE_MULTICAST_ADDRESS_ATTRIBUTE = "multicastAddress";
    static final String SERVICE_ATTRIBUTE = "service";
    static final String PUBLISHER_CONTEXT_ATTRIBUTE = "context";
    static final String PUBLISHER_PORT_ATTRIBUTE = "port";
    static final String PUBLISHER_ID_ATTRIBUTE = "publisher-id";
    static final String DELETE_STATEFUL_METHOD_NAME_ATTRIBUTE = "deleteStatefulMethodName";
    static final String DELETE_STATEFUL_METHOD_NAMES_ATTRIBUTE = "deleteStatefulMethodNames";
    static final String RETURNS_STATEFUL_METHOD_NAMES_ATTRIBUTE = "returnsStatefulMethodNames";
    static final String RETURNS_STATEFUL_BEAN_NAMES_ATTRIBUTE = "returnsStatefulBeanNames";
    private static final String SERVICEURLDAOREF_ATTRIBUTE = "serviceURLDAO-ref";
    private static final String SOURCELIST_ATTRIBUTE = "sourceList";
    static final String SERVICEURLDAO_BEAN_ID = "com.sas.svcs.serviceURLDAO";
    static final String PUBLISH_EXECUTOR_BEAN_ID = "com.sas.svcs.remote.executor";
    static final String DISCOVER_EXECUTOR_BEAN_ID = "com.sas.svcs.http.executor";
    static final String CLIENT_EXECUTOR_BEAN_ID = "com.sas.svcs.http.executor.client";
    static final String COMMONS_HTTP_HOST_STATE_ID = "com.sas.svcs.commons.http.state";
    static final String POLICY_BEAN_ID = "com.sas.svcs.loadBalancePolicy";
    static final String REGISTRY_BEAN_ID = "com.sas.svcs.serviceRegistry";
    static final String HTTP_CLIENT_ID = "com.sas.svcs.httpClient";
    static final String HTTP_CONNECTION_MANAGER_ID = "com.sas.svcs.httpConnectionManager";
    static final String STATEFUL_SERVICE_PROXY_INTERCEPTOR_BEAN_ID = "sas.svcs.statefulServiceProxyInterceptor";
    static final String STATEFUL_SERVICE_HOLDER_BEAN_ID = "sas.svcs.statefulServiceHolder";
    static final String RETURNS_STATEFUL_METHODS_MAP = "returnsStatefulMethodsMap";
    static final String OBJECT_TYPE_ATTRIBUTE = "objectType";
    static final String CONTENT_OBJECT_TYPE_ATTRIBUTE = "contentObjectType";
    static final int DEFAULT_MIN_PER_HOST_CONNECTIONS = 512;
    static final int DEFAULT_POOL_WAIT_TIMEOUT_SEC = 120;
    public static final int DEFAULT_TIMEOUT = 0;
    public static final String SERVICE_URL_ATTRIBUTE = "serviceUrl";
    private static Pattern listDelim = Pattern.compile("([\\s]*,[\\s]*)+");

    public void init() {
        this.registerBeanDefinitionParser(DISCOVERED_SERVICES_ELEMENT, (BeanDefinitionParser)new DiscoveredServicesBeanDefinitionParser());
        this.registerBeanDefinitionParser(DISCOVERED_CONTENT_SERVICES_ELEMENT, (BeanDefinitionParser)new DiscoveredContentServicesBeanDefinitionParser());
        this.registerBeanDefinitionParser(PUBLISHED_SERVICES_ELEMENT, (BeanDefinitionParser)new PublishedServicesBeanDefinitionParser());
        this.registerBeanDefinitionParser(PUBLISHED_CONTENT_SERVICES_ELEMENT, (BeanDefinitionParser)new PublishedServicesBeanDefinitionParser());
        this.registerBeanDefinitionParser(CLIENT_SERVICES_ELEMENT, (BeanDefinitionParser)new ClientServicesBeanDefinitionParser());
        this.registerBeanDefinitionParser(PUBLISHER_ELEMENT, (BeanDefinitionParser)new PublisherBeanDefinitionParser());
        this.registerBeanDefinitionParser(REGISTRY_ELEMENT, (BeanDefinitionParser)new RegistryBeanDefinitionParser());
        this.registerBeanDefinitionParser("httpJavaServices", (BeanDefinitionParser)new HttpJavaServiceBeanDefinitionParser());
        this.registerBeanDefinitionParser(AVAILABILITY_CHECKER_ELEMENT, (BeanDefinitionParser)new AvailabilityCheckerBeanDefinitionParser());
        this.registerBeanDefinitionParser(ENV_SERVICES_ELEMENT, (BeanDefinitionParser)new EnvServicesBeanDefinitionParser());
    }

    protected static boolean areProxySettingsSet() {
        return StringUtils.hasText((String)System.getProperty("http.proxyHost")) || StringUtils.hasText((String)System.getProperty("https.proxyHost"));
    }

    protected CredentialsProvider getCredentialsProvider() {
        String proxyUser = System.getProperty("http.proxyUser");
        String proxyPass = System.getProperty("http.proxyPassword");
        if (proxyUser == null && null != (proxyUser = System.getProperty("https.proxyUser"))) {
            proxyPass = System.getProperty("https.proxyPassword");
        }
        String proxyRealm = System.getProperty("http.proxyRealm");
        String proxyScheme = System.getProperty("http.proxyScheme");
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        if (proxyUser != null) {
            AuthScope authscope = new AuthScope(null, -1, proxyRealm, proxyScheme);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, new String(proxyPass));
            provider.setCredentials(authscope, (Credentials)credentials);
        }
        return provider;
    }

    protected String registerCredentials(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(COMMONS_HTTP_HOST_STATE_ID)) {
            return COMMONS_HTTP_HOST_STATE_ID;
        }
        Class<CommonsHttpStateProxyCredentialFactoryBean> credentialsProviderClass = CommonsHttpStateProxyCredentialFactoryBean.class;
        BeanDefinitionBuilder credentialsProviderBean = BeanDefinitionBuilder.rootBeanDefinition(credentialsProviderClass);
        String proxyUser = System.getProperty("http.proxyUser");
        String proxyPass = System.getProperty("http.proxyPassword");
        if (proxyUser == null && null != (proxyUser = System.getProperty("https.proxyUser"))) {
            proxyPass = System.getProperty("https.proxyPassword");
        }
        String proxyRealm = System.getProperty("http.proxyRealm");
        String proxyScheme = System.getProperty("http.proxyScheme");
        if (proxyUser != null) {
            credentialsProviderBean.addPropertyValue("proxyUsername", (Object)proxyUser);
            credentialsProviderBean.addPropertyValue("proxyPassword", (Object)proxyPass);
            credentialsProviderBean.addPropertyValue("proxyRealm", (Object)proxyRealm);
            credentialsProviderBean.addPropertyValue("proxyScheme", (Object)proxyScheme);
        }
        registry.registerBeanDefinition(COMMONS_HTTP_HOST_STATE_ID, (BeanDefinition)credentialsProviderBean.getBeanDefinition());
        return COMMONS_HTTP_HOST_STATE_ID;
    }

    protected String parseExecutorInformation(String defaultId, Element element, BeanDefinitionRegistry registry) {
        Registry socketFactoryRegistry = SocketFactoryHelper.registerSocketFactories();
        String id = element.getAttribute("executor-id");
        String className = element.getAttribute("executor-class");
        String maxConnections = element.getAttribute("executor-max-connections");
        String totalConnections = element.getAttribute("executor-max-total-connections");
        String timeoutAttr = element.getAttribute("executor-timeout");
        String poolWaitTimeoutAttr = element.getAttribute("http-pool-wait-timeout");
        if (!StringUtils.hasText((String)id)) {
            id = defaultId;
        }
        if (registry.containsBeanDefinition(id)) {
            return id;
        }
        BeanDefinitionBuilder executorBean = null;
        if (!StringUtils.hasText((String)className)) {
            logger.debug("No specific executor specified, using a default one.");
            Class<HttpComponentsHttpInvokerRequestExecutor> executorClass = HttpComponentsHttpInvokerRequestExecutor.class;
            Class<PoolingHttpClientConnectionManager> managerClass = PoolingHttpClientConnectionManager.class;
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            boolean proxySettingsSet = SvcsNamespaceHandler.areProxySettingsSet();
            if (proxySettingsSet) {
                logger.debug("Using commons proxy aware executor");
                executorClass = ProxyAwareCommonsRequestExecutor.class;
            }
            int connectionMax = StringUtils.hasText((String)maxConnections) ? Integer.parseInt(maxConnections) : Integer.getInteger("sas.svcs.http.max.connections", 512);
            int connectionsTotal = NamespaceHelper.getIntegerValue(totalConnections, "sas.svcs.http.max.total.connections", Math.max(connectionMax, 20));
            int timeout = NamespaceHelper.getIntegerValue(timeoutAttr, "sas.svcs.http.timeout", 0) * 1000;
            int poolWaitTimeoutSec = StringUtils.hasText((String)poolWaitTimeoutAttr) ? Integer.parseInt(poolWaitTimeoutAttr) : Integer.getInteger("sas.svcs.http.poolWaitTimeout", 120);
            int poolWaitTimeoutMillSec = poolWaitTimeoutSec * 1000;
            httpClientBuilder.setMaxConnTotal(connectionsTotal);
            httpClientBuilder.setMaxConnPerRoute(connectionMax);
            httpClientBuilder.setConnectionTimeToLive((long)poolWaitTimeoutMillSec, TimeUnit.MILLISECONDS);
            BeanDefinitionBuilder managerBean = BeanDefinitionBuilder.rootBeanDefinition(managerClass);
            managerBean.addPropertyValue("defaultMaxPerRoute", (Object)connectionMax);
            managerBean.addPropertyValue("maxTotal", (Object)connectionsTotal);
            managerBean.addConstructorArgValue((Object)socketFactoryRegistry);
            managerBean.addConstructorArgValue(null);
            managerBean.addConstructorArgValue(null);
            managerBean.addConstructorArgValue(null);
            managerBean.addConstructorArgValue((Object)poolWaitTimeoutMillSec);
            managerBean.addConstructorArgValue((Object)TimeUnit.MILLISECONDS);
            registry.registerBeanDefinition(HTTP_CONNECTION_MANAGER_ID, (BeanDefinition)managerBean.getBeanDefinition());
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, null, null, null, (long)poolWaitTimeoutMillSec, TimeUnit.MILLISECONDS);
            connectionManager.setDefaultMaxPerRoute(connectionMax);
            connectionManager.setMaxTotal(connectionsTotal);
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
            CredentialsProvider credentialsProvider = null;
            if (proxySettingsSet) {
                credentialsProvider = this.getCredentialsProvider();
            }
            executorBean = BeanDefinitionBuilder.rootBeanDefinition(executorClass);
            if (credentialsProvider != null) {
                executorBean.addPropertyValue("httpClient", (Object)httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).build());
            } else {
                executorBean.addPropertyValue("httpClient", (Object)httpClientBuilder.build());
            }
            executorBean.addPropertyValue("readTimeout", (Object)timeout);
        } else {
            Class klazz = ClassUtils.resolveClassName((String)className, null);
            executorBean = BeanDefinitionBuilder.rootBeanDefinition((Class)klazz);
        }
        registry.registerBeanDefinition(id, (BeanDefinition)executorBean.getBeanDefinition());
        return id;
    }

    static void parseStatefulServiceProxyInformation(Element element, BeanDefinitionRegistry registry, String serviceName, String serviceInterface) {
        if (!registry.containsBeanDefinition(STATEFUL_SERVICE_PROXY_INTERCEPTOR_BEAN_ID)) {
            BeanDefinitionBuilder statefulServiceProxyInterceptorBean = BeanDefinitionBuilder.rootBeanDefinition(StatefulServiceProxyInterceptor.class);
            registry.registerBeanDefinition(STATEFUL_SERVICE_PROXY_INTERCEPTOR_BEAN_ID, (BeanDefinition)statefulServiceProxyInterceptorBean.getBeanDefinition());
        }
        BeanDefinitionBuilder statefulServiceProxyBean = BeanDefinitionBuilder.rootBeanDefinition(ProxyFactoryBean.class);
        statefulServiceProxyBean.addPropertyValue("targetName", (Object)STATEFUL_SERVICE_HOLDER_BEAN_ID);
        ArrayList<String> proxyInterfaces = new ArrayList<String>(2);
        proxyInterfaces.add(StatefulServiceHolderInterface.class.getName());
        proxyInterfaces.add(serviceInterface);
        statefulServiceProxyBean.addPropertyValue("proxyInterfaces", proxyInterfaces);
        ArrayList<String> interceptorNames = new ArrayList<String>(1);
        interceptorNames.add(STATEFUL_SERVICE_PROXY_INTERCEPTOR_BEAN_ID);
        statefulServiceProxyBean.addPropertyValue("interceptorNames", interceptorNames);
        registry.registerBeanDefinition(serviceName, (BeanDefinition)statefulServiceProxyBean.getBeanDefinition());
    }

    String parseServiceURLDAOInformation(Element element, ParserContext context) {
        String ref = element.getAttribute(SERVICEURLDAOREF_ATTRIBUTE);
        String beanID = StringUtils.hasText((String)ref) ? ref : this.getServiceURLDAOBeanDefinition(element, context);
        return beanID;
    }

    static String parseId(String serviceID, String serviceInterface) {
        String id = serviceID;
        if (!StringUtils.hasText((String)id)) {
            int lastDotIndex = serviceInterface.lastIndexOf(46);
            int lastInterfaceIndex = serviceInterface.lastIndexOf("Interface");
            id = lastInterfaceIndex > -1 ? serviceInterface.substring(lastDotIndex + 1, lastInterfaceIndex) : serviceInterface.substring(lastDotIndex + 1);
            id = id.substring(0, 1).toLowerCase() + id.substring(1);
        }
        return id;
    }

    static void addStatefulMethodsMap(BeanDefinitionBuilder serviceBean, List<String> returnsStatefulMethodNameList, List<String> returnsStatefulBeanNameList, String elementName) {
        if (returnsStatefulBeanNameList == null || returnsStatefulBeanNameList.size() == 0) {
            throw new IllegalStateException("The " + elementName + " element must contain " + RETURNS_STATEFUL_BEAN_NAMES_ATTRIBUTE + " element when " + RETURNS_STATEFUL_METHOD_NAMES_ATTRIBUTE + " element is specified.");
        }
        if (returnsStatefulBeanNameList.size() != returnsStatefulMethodNameList.size()) {
            throw new IllegalStateException("The " + elementName + " element must have same number of values in " + RETURNS_STATEFUL_METHOD_NAMES_ATTRIBUTE + " element and " + RETURNS_STATEFUL_BEAN_NAMES_ATTRIBUTE + " element.");
        }
        ManagedMap returnsStatefulMethodsMap = new ManagedMap();
        for (int i = 0; i < returnsStatefulMethodNameList.size(); ++i) {
            if (returnsStatefulBeanNameList.get(i).length() > 0) {
                returnsStatefulMethodsMap.put((Object)returnsStatefulMethodNameList.get(i), (Object)new RuntimeBeanReference(returnsStatefulBeanNameList.get(i)));
                continue;
            }
            returnsStatefulMethodsMap.put((Object)returnsStatefulMethodNameList.get(i), (Object)returnsStatefulBeanNameList.get(i));
        }
        serviceBean.addPropertyValue(RETURNS_STATEFUL_METHODS_MAP, (Object)returnsStatefulMethodsMap);
    }

    static List<String> parseReturnsStatefulBeanNames(Element service) {
        String returnsStatefulMethodNames = service.getAttribute(RETURNS_STATEFUL_BEAN_NAMES_ATTRIBUTE);
        return SvcsNamespaceHandler.parseDelimitedString(returnsStatefulMethodNames);
    }

    static List<String> parseReturnsStatefulMethodNames(Element service) {
        String returnsStatefulMethodNames = service.getAttribute(RETURNS_STATEFUL_METHOD_NAMES_ATTRIBUTE);
        List<String> names = SvcsNamespaceHandler.parseDelimitedString(returnsStatefulMethodNames);
        if (null == names) {
            names = Collections.emptyList();
        }
        return names;
    }

    static Set<String> parseDeleteStatefulMethodNames(Element service) {
        String deleteStatefulMethodNames = service.getAttribute(DELETE_STATEFUL_METHOD_NAMES_ATTRIBUTE);
        List<String> list = SvcsNamespaceHandler.parseDelimitedString(deleteStatefulMethodNames);
        if (list != null) {
            return new HashSet<String>(list);
        }
        return null;
    }

    static Set<String> getDeleteMethodNames(Element nextService) {
        String deleteStatefulMethodName = nextService.getAttribute(DELETE_STATEFUL_METHOD_NAME_ATTRIBUTE);
        if (StringUtils.hasText((String)deleteStatefulMethodName)) {
            return Collections.singleton(deleteStatefulMethodName);
        }
        Set<String> deleteStatefulMethodNameSet = SvcsNamespaceHandler.parseDeleteStatefulMethodNames(nextService);
        if (null == deleteStatefulMethodNameSet) {
            deleteStatefulMethodNameSet = Collections.emptySet();
        }
        return deleteStatefulMethodNameSet;
    }

    static List<String> parseDelimitedString(String str) {
        Pattern ld;
        String[] nameArr;
        List<String> itemList = null;
        if (null != str && 0 != str.trim().length() && null != (nameArr = (ld = listDelim).split(str.trim(), -1)) && 0 != nameArr.length) {
            itemList = Arrays.asList(nameArr);
        }
        if (null == itemList) {
            return Collections.emptyList();
        }
        return itemList;
    }

    private String getServiceURLDAOBeanDefinition(Element element, ParserContext parserContext) {
        String beanName = null;
        BeanDefinitionRegistry beanDefinitionRegistry = parserContext.getRegistry();
        String svcsBeanName = SERVICEURLDAO_BEAN_ID;
        if (beanDefinitionRegistry.containsBeanDefinition(SERVICEURLDAO_BEAN_ID)) {
            beanName = SERVICEURLDAO_BEAN_ID;
        } else {
            String dataSourceRef;
            String dataSourceBeanName = "datasource";
            String string = dataSourceRef = beanDefinitionRegistry.containsBeanDefinition("datasource") ? "datasource" : EnvPropertiesBeanDefinitionParser.getDataSourceReference(element, parserContext);
            if (null == dataSourceRef) {
                return null;
            }
            BeanDefinitionBuilder serviceUrlDaoBuilder = BeanDefinitionBuilder.rootBeanDefinition(ServiceURLDAO.class);
            serviceUrlDaoBuilder.addPropertyReference("dataSource", dataSourceRef);
            AbstractBeanDefinition serviceURLDAOBean = serviceUrlDaoBuilder.getBeanDefinition();
            beanName = SERVICEURLDAO_BEAN_ID;
            beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)serviceURLDAOBean);
            if (logger.isDebugEnabled()) {
                logger.debug("A " + ServiceURLDAO.class.getName() + " bean named " + beanName + " has been created using " + DataSource.class.getName() + ' ' + dataSourceRef);
            }
        }
        return beanName;
    }

    class DiscoveredServicesBeanDefinitionParser
    extends AbstractBeanDefinitionParser {
        DiscoveredServicesBeanDefinitionParser() {
        }

        protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
            BeanDefinitionRegistry registry = context.getRegistry();
            BeanDefinitionBuilder listBean = BeanDefinitionBuilder.rootBeanDefinition(ListFactoryBean.class);
            ArrayList<String> list = new ArrayList<String>();
            listBean.addPropertyValue(SvcsNamespaceHandler.SOURCELIST_ATTRIBUTE, list);
            String serviceURLDAOId = SvcsNamespaceHandler.this.parseServiceURLDAOInformation(element, context);
            String loadBalancePolicyId = this.parseLoadBalancePolicyElement(element, registry, serviceURLDAOId);
            String executorId = SvcsNamespaceHandler.this.parseExecutorInformation(SvcsNamespaceHandler.DISCOVER_EXECUTOR_BEAN_ID, element, registry);
            List serviceElements = DomUtils.getChildElementsByTagName((Element)element, (String)SvcsNamespaceHandler.DISCOVERED_SERVICE_ELEMENT);
            for (Element nextService : serviceElements) {
                BeanDefinitionBuilder serviceBean;
                String serviceInterface = nextService.getAttribute(SvcsNamespaceHandler.SERVICE_INTERFACE_ATTRIBUTE);
                String id = SvcsNamespaceHandler.parseId(nextService.getAttribute("id"), serviceInterface);
                List<String> returnsStatefulMethodNameList = SvcsNamespaceHandler.parseReturnsStatefulMethodNames(nextService);
                if (returnsStatefulMethodNameList == null || returnsStatefulMethodNameList.size() == 0) {
                    serviceBean = BeanDefinitionBuilder.rootBeanDefinition(AutoDiscoveredHttpService.class);
                } else {
                    serviceBean = BeanDefinitionBuilder.rootBeanDefinition(AutoDiscoveredCreatesStatefulHttpService.class);
                    List<String> returnsStatefulBeanNameList = SvcsNamespaceHandler.parseReturnsStatefulBeanNames(nextService);
                    SvcsNamespaceHandler.addStatefulMethodsMap(serviceBean, returnsStatefulMethodNameList, returnsStatefulBeanNameList, SvcsNamespaceHandler.DISCOVERED_SERVICE_ELEMENT);
                }
                String thisLoadBalancePolicyId = this.parseServiceLoadBalancePolicyElement(nextService, registry, serviceURLDAOId);
                if (!StringUtils.hasText((String)thisLoadBalancePolicyId)) {
                    thisLoadBalancePolicyId = loadBalancePolicyId;
                }
                serviceBean.addPropertyValue(SvcsNamespaceHandler.SERVICE_INTERFACE_ATTRIBUTE, (Object)serviceInterface);
                serviceBean.addPropertyReference("loadBalancePolicy", thisLoadBalancePolicyId);
                if (null != executorId) {
                    serviceBean.addPropertyReference("httpInvokerRequestExecutor", executorId);
                }
                registry.registerBeanDefinition(id, (BeanDefinition)serviceBean.getBeanDefinition());
                list.add(serviceInterface);
            }
            return listBean.getBeanDefinition();
        }

        protected String parseLoadBalancePolicyElement(Element element, BeanDefinitionRegistry registry, String serviceURLDAOId) {
            String id = element.getAttribute("policy-id");
            String className = element.getAttribute("policy-class");
            if (!StringUtils.hasText((String)className)) {
                Element policyElement = DomUtils.getChildElementByTagName((Element)element, (String)SvcsNamespaceHandler.POLICY_ELEMENT);
                if (null == policyElement) {
                    logger.debug("No specific policy specified, using a default one.");
                } else {
                    logger.warn("The <sas-svcs:policy ...> element is deprecated. Please switch to using policy-class and policy-id [optional] on the parent sas-svcs:*Services element.");
                    id = policyElement.getAttribute("id");
                    className = policyElement.getAttribute(SvcsNamespaceHandler.CLASS_ATTRIBUTE);
                }
            }
            if (!StringUtils.hasText((String)id)) {
                id = SvcsNamespaceHandler.POLICY_BEAN_ID;
            }
            if (!StringUtils.hasText((String)className)) {
                className = RandomPolicy.class.getName();
                if (registry.containsBeanDefinition(id)) {
                    return id;
                }
            }
            Class klazz = ClassUtils.resolveClassName((String)className, null);
            BeanDefinitionBuilder executorBean = BeanDefinitionBuilder.rootBeanDefinition((Class)klazz);
            if (StringUtils.hasText((String)serviceURLDAOId)) {
                executorBean.addPropertyReference(SvcsNamespaceHandler.SERVICEURLDAO_ELEMENT, serviceURLDAOId);
            } else {
                logger.warn("A ServiceURLDAO is not available to wire to load balancer " + id);
            }
            registry.registerBeanDefinition(id, (BeanDefinition)executorBean.getBeanDefinition());
            return id;
        }

        protected String parseServiceLoadBalancePolicyElement(Element element, BeanDefinitionRegistry registry, String serviceURLDAOId) {
            String id = element.getAttribute("policy-id");
            String className = element.getAttribute("policy-class");
            if (StringUtils.hasText((String)id) && StringUtils.hasText((String)className)) {
                if (registry.containsBeanDefinition(id)) {
                    return id;
                }
                Class klazz = ClassUtils.resolveClassName((String)className, null);
                BeanDefinitionBuilder executorBean = BeanDefinitionBuilder.rootBeanDefinition((Class)klazz);
                if (StringUtils.hasText((String)serviceURLDAOId)) {
                    executorBean.addPropertyReference(SvcsNamespaceHandler.SERVICEURLDAO_ELEMENT, serviceURLDAOId);
                }
                registry.registerBeanDefinition(id, (BeanDefinition)executorBean.getBeanDefinition());
            }
            return id;
        }
    }

    class DiscoveredContentServicesBeanDefinitionParser
    extends DiscoveredServicesBeanDefinitionParser {
        DiscoveredContentServicesBeanDefinitionParser() {
        }

        @Override
        protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
            BeanDefinitionRegistry registry = context.getRegistry();
            BeanDefinitionBuilder listBean = BeanDefinitionBuilder.rootBeanDefinition(ListFactoryBean.class);
            ArrayList<String> list = new ArrayList<String>();
            listBean.addPropertyValue(SvcsNamespaceHandler.SOURCELIST_ATTRIBUTE, list);
            String serviceURLDAOId = SvcsNamespaceHandler.this.parseServiceURLDAOInformation(element, context);
            String loadBalancePolicyId = this.parseLoadBalancePolicyElement(element, registry, serviceURLDAOId);
            String executorId = SvcsNamespaceHandler.this.parseExecutorInformation(SvcsNamespaceHandler.DISCOVER_EXECUTOR_BEAN_ID, element, registry);
            List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)SvcsNamespaceHandler.DISCOVERED_CONTENT_SERVICE_ELEMENT);
            for (Element nextService : childElements) {
                String serviceInterface = nextService.getAttribute(SvcsNamespaceHandler.SERVICE_INTERFACE_ATTRIBUTE);
                String id = SvcsNamespaceHandler.parseId(nextService.getAttribute("id"), serviceInterface);
                BeanDefinitionBuilder serviceBean = BeanDefinitionBuilder.rootBeanDefinition(DiscoveredServices.class);
                serviceBean.addConstructorArgValue((Object)serviceInterface);
                serviceBean.addPropertyReference("loadBalancePolicy", loadBalancePolicyId);
                if (null != executorId) {
                    serviceBean.addPropertyReference(SvcsNamespaceHandler.EXECUTOR_ELEMENT, executorId);
                }
                if (StringUtils.hasText((String)serviceURLDAOId)) {
                    serviceBean.addPropertyReference(SvcsNamespaceHandler.SERVICEURLDAO_ELEMENT, serviceURLDAOId);
                }
                registry.registerBeanDefinition(id, (BeanDefinition)serviceBean.getBeanDefinition());
                list.add(serviceInterface);
            }
            return listBean.getBeanDefinition();
        }
    }

    class PublishedServicesBeanDefinitionParser
    extends AbstractBeanDefinitionParser {
        PublishedServicesBeanDefinitionParser() {
        }

        protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
            boolean isContentService = SvcsNamespaceHandler.PUBLISHED_CONTENT_SERVICES_ELEMENT.equals(element.getLocalName());
            BeanDefinitionRegistry registry = context.getRegistry();
            BeanDefinitionBuilder listBean = BeanDefinitionBuilder.rootBeanDefinition(ListFactoryBean.class);
            ArrayList<String> list = new ArrayList<String>();
            listBean.addPropertyValue(SvcsNamespaceHandler.SOURCELIST_ATTRIBUTE, list);
            String serviceURLDAOId = SvcsNamespaceHandler.this.parseServiceURLDAOInformation(element, context);
            String executorId = this.parseExecutorInformation(element, registry);
            String publisherId = this.parsePublisherInformation(element, registry, serviceURLDAOId, isContentService);
            if (publisherId != null) {
                listBean.addDependsOn(publisherId);
                listBean.setLazyInit(false);
            }
            List serviceElements = isContentService ? DomUtils.getChildElementsByTagName((Element)element, (String)SvcsNamespaceHandler.PUBLISHED_CONTENT_SERVICE_ELEMENT) : DomUtils.getChildElementsByTagName((Element)element, (String)SvcsNamespaceHandler.PUBLISHED_SERVICE_ELEMENT);
            for (Element nextService : serviceElements) {
                BeanDefinitionBuilder serviceBean;
                String serviceInterface = nextService.getAttribute(SvcsNamespaceHandler.SERVICE_INTERFACE_ATTRIBUTE);
                String id = SvcsNamespaceHandler.parseId(nextService.getAttribute("id"), serviceInterface);
                String serviceName = nextService.getAttribute(SvcsNamespaceHandler.SERVICE_ATTRIBUTE);
                Set<String> deleteStatefulMethodNameSet = SvcsNamespaceHandler.getDeleteMethodNames(nextService);
                if (!StringUtils.hasText((String)serviceName)) {
                    serviceName = id.substring(0, 1).toLowerCase() + id.substring(1);
                }
                if (!isContentService) {
                    serviceBean = BeanDefinitionBuilder.rootBeanDefinition(AutoDiscoveredHttpServiceExporter.class);
                } else {
                    serviceBean = BeanDefinitionBuilder.rootBeanDefinition(AutoDiscoveredContentServiceExporter.class);
                    String objectType = nextService.getAttribute(SvcsNamespaceHandler.OBJECT_TYPE_ATTRIBUTE);
                    serviceBean.addPropertyValue(SvcsNamespaceHandler.OBJECT_TYPE_ATTRIBUTE, (Object)objectType);
                    id = id + "-" + objectType;
                }
                ArrayList<Object> preprocessors = null;
                ManagedList postprocessors = null;
                if (!deleteStatefulMethodNameSet.isEmpty()) {
                    preprocessors = new ArrayList<Object>(2);
                    preprocessors.add(new ServerRemoteInvocationStatefulServiceIdProcessor());
                    preprocessors.add(new ServerRemoteInvocationStatefulServiceURIProcessor());
                    postprocessors = new ManagedList(3);
                    StatefulServiceDeletionProcessor deletionProcessor = new StatefulServiceDeletionProcessor();
                    deletionProcessor.setDeleteStatefulMethodNames(deleteStatefulMethodNameSet);
                    postprocessors.add((Object)deletionProcessor);
                    SvcsNamespaceHandler.parseStatefulServiceProxyInformation(nextService, registry, serviceName, serviceInterface);
                }
                serviceBean.addPropertyReference(SvcsNamespaceHandler.SERVICE_ATTRIBUTE, serviceName);
                serviceBean.addPropertyValue(SvcsNamespaceHandler.SERVICE_INTERFACE_ATTRIBUTE, (Object)serviceInterface);
                List<String> returnsStatefulMethodNameList = SvcsNamespaceHandler.parseReturnsStatefulMethodNames(nextService);
                if (null != returnsStatefulMethodNameList && !returnsStatefulMethodNameList.isEmpty()) {
                    if (preprocessors == null) {
                        preprocessors = new ArrayList(1);
                        preprocessors.add(new ServerRemoteInvocationStatefulServiceURIProcessor());
                    }
                    if (postprocessors == null) {
                        postprocessors = new ManagedList(2);
                    }
                    BeanDefinitionBuilder resultProxyProcessorBean = BeanDefinitionBuilder.rootBeanDefinition(ServerRemoteInvocationStatefulServiceResultProxyProcessor.class);
                    ServerRemoteInvocationStatefulServiceResultIdProcessor resultIdProcessor = new ServerRemoteInvocationStatefulServiceResultIdProcessor();
                    List<String> returnsStatefulBeanNameList = SvcsNamespaceHandler.parseReturnsStatefulBeanNames(nextService);
                    SvcsNamespaceHandler.addStatefulMethodsMap(resultProxyProcessorBean, returnsStatefulMethodNameList, returnsStatefulBeanNameList, SvcsNamespaceHandler.PUBLISHED_SERVICE_ELEMENT);
                    String resultProxyProcessorId = id + "ResultProxyProcessor";
                    registry.registerBeanDefinition(resultProxyProcessorId, (BeanDefinition)resultProxyProcessorBean.getBeanDefinition());
                    postprocessors.add((Object)new RuntimeBeanReference(resultProxyProcessorId));
                    resultIdProcessor.setReturnsStatefulMethodNames(new HashSet<String>(returnsStatefulMethodNameList));
                    postprocessors.add((Object)resultIdProcessor);
                }
                if (preprocessors != null) {
                    serviceBean.addPropertyValue("preProcessors", preprocessors);
                }
                if (postprocessors != null) {
                    serviceBean.addPropertyValue("postProcessors", (Object)postprocessors);
                }
                if (null != executorId) {
                    serviceBean.addPropertyReference("remoteInvocationExecutor", executorId);
                }
                if (publisherId != null) {
                    serviceBean.addDependsOn(publisherId);
                    serviceBean.setLazyInit(false);
                }
                registry.registerBeanDefinition("/" + id, (BeanDefinition)serviceBean.getBeanDefinition());
                list.add(serviceInterface);
            }
            return listBean.getBeanDefinition();
        }

        private String parsePublisherInformation(Element element, BeanDefinitionRegistry registry, String serviceURLDAOId, boolean isContent) {
            BeanDefinitionBuilder publisherBean;
            String port = element.getAttribute("publisher-port");
            String context = element.getAttribute("publisher-context");
            String publisherId = element.getAttribute(SvcsNamespaceHandler.PUBLISHER_ID_ATTRIBUTE);
            if (StringUtils.hasText((String)publisherId)) {
                return publisherId;
            }
            if (!StringUtils.hasText((String)context)) {
                Element publisherElement = DomUtils.getChildElementByTagName((Element)element, (String)SvcsNamespaceHandler.PUBLISHER_ELEMENT);
                port = publisherElement.getAttribute(SvcsNamespaceHandler.PUBLISHER_PORT_ATTRIBUTE);
                context = publisherElement.getAttribute(SvcsNamespaceHandler.PUBLISHER_CONTEXT_ATTRIBUTE);
            }
            BeanDefinitionBuilder beanDefinitionBuilder = publisherBean = isContent ? BeanDefinitionBuilder.rootBeanDefinition(ContentServicePublisher.class) : BeanDefinitionBuilder.rootBeanDefinition(ServicePublisher.class);
            if (StringUtils.hasText((String)port)) {
                publisherBean.addPropertyValue(SvcsNamespaceHandler.PUBLISHER_PORT_ATTRIBUTE, (Object)port);
            }
            publisherBean.addPropertyValue(SvcsNamespaceHandler.PUBLISHER_CONTEXT_ATTRIBUTE, (Object)context);
            if (StringUtils.hasText((String)serviceURLDAOId)) {
                publisherBean.addPropertyReference(SvcsNamespaceHandler.SERVICEURLDAO_ELEMENT, serviceURLDAOId);
            }
            if (isContent) {
                registry.registerBeanDefinition("contentServicePublisher", (BeanDefinition)publisherBean.getBeanDefinition());
            } else {
                registry.registerBeanDefinition("servicePublisher", (BeanDefinition)publisherBean.getBeanDefinition());
            }
            return null;
        }

        private String parseExecutorInformation(Element element, BeanDefinitionRegistry registry) {
            String id = element.getAttribute("executor-id");
            String className = element.getAttribute("executor-class");
            if (!StringUtils.hasText((String)className)) {
                Element executorElement = DomUtils.getChildElementByTagName((Element)element, (String)SvcsNamespaceHandler.EXECUTOR_ELEMENT);
                if (null == executorElement) {
                    logger.debug("No specific executor specified, using a default one.");
                } else {
                    logger.warn("The <sas-svcs:executor ...> element is deprecated. Please switch to using executor-class and executor-id [optional] on the parent sas-svcs:*Services element.");
                    id = executorElement.getAttribute("id");
                    className = executorElement.getAttribute(SvcsNamespaceHandler.CLASS_ATTRIBUTE);
                }
            }
            if (!StringUtils.hasText((String)id)) {
                id = SvcsNamespaceHandler.PUBLISH_EXECUTOR_BEAN_ID;
            }
            if (!StringUtils.hasText((String)className)) {
                className = DefaultRemoteInvocationExecutor.class.getName();
            }
            Class klazz = ClassUtils.resolveClassName((String)className, null);
            BeanDefinitionBuilder executorBean = BeanDefinitionBuilder.rootBeanDefinition((Class)klazz);
            registry.registerBeanDefinition(id, (BeanDefinition)executorBean.getBeanDefinition());
            return id;
        }
    }

    class ClientServicesBeanDefinitionParser
    extends AbstractBeanDefinitionParser {
        ClientServicesBeanDefinitionParser() {
        }

        protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
            BeanDefinitionRegistry registry = context.getRegistry();
            BeanDefinitionBuilder listBean = BeanDefinitionBuilder.rootBeanDefinition(ListFactoryBean.class);
            ArrayList<String> list = new ArrayList<String>();
            listBean.addPropertyValue(SvcsNamespaceHandler.SOURCELIST_ATTRIBUTE, list);
            String registryId = this.parseRegistryInformation(element, registry);
            String executorId = SvcsNamespaceHandler.this.parseExecutorInformation(SvcsNamespaceHandler.CLIENT_EXECUTOR_BEAN_ID, element, registry);
            List serviceElements = DomUtils.getChildElementsByTagName((Element)element, (String)SvcsNamespaceHandler.CLIENT_SERVICE_ELEMENT);
            for (Element nextService : serviceElements) {
                BeanDefinitionBuilder serviceBean;
                String serviceInterface = nextService.getAttribute(SvcsNamespaceHandler.SERVICE_INTERFACE_ATTRIBUTE);
                String id = SvcsNamespaceHandler.parseId(nextService.getAttribute("id"), serviceInterface);
                List<String> returnsStatefulMethodNameList = SvcsNamespaceHandler.parseReturnsStatefulMethodNames(nextService);
                if (returnsStatefulMethodNameList == null || returnsStatefulMethodNameList.size() == 0) {
                    serviceBean = BeanDefinitionBuilder.rootBeanDefinition(SASClientHttpServiceProxy.class);
                } else {
                    serviceBean = BeanDefinitionBuilder.rootBeanDefinition(SASClientCreatesStatefulHttpServiceProxy.class);
                    List<String> returnsStatefulBeanNameList = SvcsNamespaceHandler.parseReturnsStatefulBeanNames(nextService);
                    SvcsNamespaceHandler.addStatefulMethodsMap(serviceBean, returnsStatefulMethodNameList, returnsStatefulBeanNameList, SvcsNamespaceHandler.CLIENT_SERVICE_ELEMENT);
                }
                serviceBean.addPropertyReference("serviceRegistry", registryId);
                serviceBean.addPropertyValue(SvcsNamespaceHandler.SERVICE_INTERFACE_ATTRIBUTE, (Object)serviceInterface);
                if (null != executorId) {
                    serviceBean.addPropertyReference("httpInvokerRequestExecutor", executorId);
                }
                registry.registerBeanDefinition(id, (BeanDefinition)serviceBean.getBeanDefinition());
                list.add(serviceInterface);
            }
            return listBean.getBeanDefinition();
        }

        private String parseRegistryInformation(Element element, BeanDefinitionRegistry registry) {
            String url;
            String ref = element.getAttribute("registry-ref");
            if (StringUtils.hasText((String)ref)) {
                return ref;
            }
            String id = element.getAttribute("registry-id");
            if (!StringUtils.hasText((String)id)) {
                id = SvcsNamespaceHandler.REGISTRY_BEAN_ID;
            }
            if (!StringUtils.hasText((String)(url = element.getAttribute("registry-url")))) {
                throw new IllegalStateException("The clientServices element must contain either a registry-ref or registry-url element.");
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(HttpInvokerProxyFactoryBean.class);
            builder.addPropertyValue(SvcsNamespaceHandler.SERVICE_URL_ATTRIBUTE, (Object)url);
            builder.addPropertyValue(SvcsNamespaceHandler.SERVICE_INTERFACE_ATTRIBUTE, (Object)ServiceRegistryInterface.class.getName());
            registry.registerBeanDefinition(id, (BeanDefinition)builder.getBeanDefinition());
            return id;
        }
    }

    class RegistryBeanDefinitionParser
    extends AbstractBeanDefinitionParser {
        RegistryBeanDefinitionParser() {
        }

        protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
            String executorId;
            BeanDefinitionRegistry registry = context.getRegistry();
            BeanDefinitionBuilder bean = BeanDefinitionBuilder.rootBeanDefinition(SASClientTicketingProxy.class);
            String serviceUrl = element.getAttribute(SvcsNamespaceHandler.SERVICE_URL_ATTRIBUTE);
            if (serviceUrl != null) {
                bean.addPropertyValue(SvcsNamespaceHandler.SERVICE_URL_ATTRIBUTE, (Object)serviceUrl);
            }
            if ((executorId = SvcsNamespaceHandler.this.parseExecutorInformation(SvcsNamespaceHandler.CLIENT_EXECUTOR_BEAN_ID, element, registry)) != null) {
                bean.addPropertyReference("httpInvokerRequestExecutor", executorId);
            }
            bean.addPropertyValue(SvcsNamespaceHandler.SERVICE_INTERFACE_ATTRIBUTE, (Object)ServiceRegistryInterface.class.getName());
            return bean.getBeanDefinition();
        }
    }

    class AvailabilityCheckerBeanDefinitionParser
    extends AbstractBeanDefinitionParser {
        AvailabilityCheckerBeanDefinitionParser() {
        }

        protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
            BeanDefinitionRegistry registry = context.getRegistry();
            BeanDefinitionBuilder exporter = BeanDefinitionBuilder.rootBeanDefinition(HttpInvokerServiceExporter.class);
            exporter.addPropertyValue(SvcsNamespaceHandler.SERVICE_INTERFACE_ATTRIBUTE, AvailabilityInterface.class);
            exporter.addPropertyValue(SvcsNamespaceHandler.SERVICE_ATTRIBUTE, (Object)new AvailabilityService());
            registry.registerBeanDefinition("/availabilityCheck", (BeanDefinition)exporter.getBeanDefinition());
            BeanDefinitionBuilder checkerBean = BeanDefinitionBuilder.rootBeanDefinition(AvailabilityChecker.class);
            ManagedList checksToRun = new ManagedList();
            List taskElements = DomUtils.getChildElementsByTagName((Element)element, (String)SvcsNamespaceHandler.AVAILABLE_TASK_ELEMENT);
            for (Element taskElement : taskElements) {
                String beanId = taskElement.getAttribute("ref");
                checksToRun.add((Object)new RuntimeBeanReference(beanId));
            }
            checkerBean.addConstructorArgValue((Object)checksToRun);
            return checkerBean.getBeanDefinition();
        }
    }
}

