/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import com.sas.svcs.cluster.httpinvoker.ServicePublisher;
import com.sas.svcs.cluster.httpinvoker.annotation.DefaultPublishableServiceScanner;
import com.sas.svcs.cluster.httpinvoker.annotation.PublishableServiceAnnotationPostProcessor;
import com.sas.svcs.cluster.httpinvoker.content.ContentServicePublisher;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class PublisherBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        BeanDefinitionRegistry registry = context.getRegistry();
        boolean annotationDriven = Boolean.parseBoolean(element.getAttribute("annotation-driven"));
        boolean includeContent = Boolean.parseBoolean(element.getAttribute("include-content"));
        String serviceURLDAORef = element.getAttribute("serviceURLDAO-ref");
        String basePackage = element.getAttribute("base-package");
        String excludedPackage = element.getAttribute("excluded-package");
        String servletContext = element.getAttribute("context");
        String portStr = element.getAttribute("port");
        BeanDefinitionBuilder publisherDefinition = BeanDefinitionBuilder.rootBeanDefinition(ServicePublisher.class);
        publisherDefinition.addPropertyValue("context", (Object)servletContext);
        if (StringUtils.hasText((String)serviceURLDAORef)) {
            publisherDefinition.addPropertyReference("serviceURLDAO", serviceURLDAORef);
        }
        if (StringUtils.hasText((String)portStr)) {
            publisherDefinition.addPropertyValue("port", (Object)Integer.valueOf(portStr));
        }
        if (includeContent) {
            BeanDefinitionBuilder contentPublisherDefinition = BeanDefinitionBuilder.rootBeanDefinition(ContentServicePublisher.class);
            contentPublisherDefinition.addPropertyValue("context", (Object)servletContext);
            if (StringUtils.hasText((String)serviceURLDAORef)) {
                contentPublisherDefinition.addPropertyReference("serviceURLDAO", serviceURLDAORef);
            }
            registry.registerBeanDefinition("com.sas.svcs.ContentServicePublisher", (BeanDefinition)contentPublisherDefinition.getBeanDefinition());
        }
        if (annotationDriven) {
            BeanDefinitionBuilder annotationProcessor = BeanDefinitionBuilder.rootBeanDefinition(PublishableServiceAnnotationPostProcessor.class);
            if (StringUtils.hasText((String)excludedPackage)) {
                annotationProcessor.addPropertyValue("excludedPackage", (Object)excludedPackage);
            }
            if (StringUtils.hasText((String)basePackage)) {
                DefaultPublishableServiceScanner annotationScanner = new DefaultPublishableServiceScanner();
                annotationScanner.setBasePackage(basePackage);
                annotationProcessor.addPropertyValue("scanner", (Object)annotationScanner);
            }
            registry.registerBeanDefinition("com.sas.svcs.PublishableAnnotationProcessor", (BeanDefinition)annotationProcessor.getBeanDefinition());
        }
        return publisherDefinition.getBeanDefinition();
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

