/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import jakarta.servlet.ServletContext;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.ServletContextResource;

public class PropertyAwareServletContextResource
extends ServletContextResource {
    private static final Logger LOGGER = LogManager.getLogger(PropertyAwareServletContextResource.class);
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    private Properties properties = new Properties();

    public PropertyAwareServletContextResource(ServletContext servletContext, String path, Properties properties) {
        super(servletContext, path);
        this.properties = properties;
    }

    public Resource createRelative(String relativePath) {
        String relPath = relativePath;
        relPath = this.resolvePlaceholders(relPath);
        return super.createRelative(relPath);
    }

    private String resolvePlaceholders(String text) {
        StringBuilder buf = new StringBuilder(text);
        int startIndex = text.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                int nextIndex;
                block8: {
                    String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                    nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                    try {
                        String propVal = this.properties.getProperty(placeholder);
                        if (propVal != null) {
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info("Resolved '" + placeholder + "' in [" + text + "] via properties object. You can safely ignore previous ERROR level log messages related to this placeholder for this application.");
                            }
                            buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                            nextIndex = startIndex + propVal.length();
                        } else if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("Could not resolve placeholder '" + placeholder + "' in [" + text + "]: via properties object.");
                        }
                    }
                    catch (Throwable ex) {
                        if (!LOGGER.isWarnEnabled()) break block8;
                        LOGGER.warn("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: " + ex);
                    }
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }
}

