/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

public class PasswordDecoder
implements BeanFactoryPostProcessor,
Ordered {
    private static final Logger LOGGER = LogManager.getLogger(PasswordDecoder.class);
    private int order = Integer.MAX_VALUE;
    private final BeanDefinitionVisitor visitor = new PasswordVisitor();

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanNames[i]);
            this.visitor.visitBeanDefinition(definition);
        }
    }

    static class PasswordVisitor
    extends BeanDefinitionVisitor {
        PasswordVisitor() {
        }

        protected String resolveStringValue(String s) {
            try {
                if (SasPasswordString.isEncoded((String)s)) {
                    return SasPasswordString.decode((String)s);
                }
            }
            catch (SasPasswordEncodingException e) {
                LOGGER.error("String appeared to be a SAS Password value, but was unable to be decoded.", (Throwable)e);
            }
            return s;
        }
    }
}

