/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import com.sas.svcs.cluster.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceResultURIProcessor;
import com.sas.svcs.cluster.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceURIProcessor;
import com.sas.svcs.remoting.httpinvoker.PostProcessingHttpInvokerServiceExporter;
import com.sas.svcs.remoting.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceIdProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceResultIdProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceResultProxyProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceDeletionProcessor;
import com.sas.svcs.springframework.config.SvcsNamespaceHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpJavaServiceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final Logger LOGGER = LogManager.getLogger(HttpJavaServiceBeanDefinitionParser.class);
    public static final String REMOTE_SERVICE_EXECUTOR_REF_ATTR = "executor-ref";
    public static final String REMOTE_SERVICES_ELEMENT = "httpJavaServices";
    public static final String REMOTE_SERVICE_ELEMENT = "httpJavaService";

    private static boolean doesAnyElementReturnStatefulBean(List<Element> elements) {
        for (Element nextService : elements) {
            List<String> returnsStatefulBeanNameList = SvcsNamespaceHandler.parseReturnsStatefulBeanNames(nextService);
            if (returnsStatefulBeanNameList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsing bean definition httpJavaServices");
        }
        BeanDefinitionRegistry registry = context.getRegistry();
        BeanDefinitionBuilder listBean = BeanDefinitionBuilder.rootBeanDefinition(ListFactoryBean.class);
        ArrayList<String> list = new ArrayList<String>();
        listBean.addPropertyValue("sourceList", list);
        String containerElId = element.getAttribute("id");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsing bean definition httpJavaServices(" + containerElId + ")");
        }
        String executorRef = element.getAttribute(REMOTE_SERVICE_EXECUTOR_REF_ATTR);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found remote invocation executor for httpJavaServices with reference '" + executorRef + "'");
        }
        List serviceElements = DomUtils.getChildElementsByTagName((Element)element, (String)REMOTE_SERVICE_ELEMENT);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found " + serviceElements.size() + " " + REMOTE_SERVICE_ELEMENT + "(s) for " + REMOTE_SERVICES_ELEMENT + "(" + containerElId + ")");
        }
        boolean proxyingLocalBeans = HttpJavaServiceBeanDefinitionParser.doesAnyElementReturnStatefulBean(serviceElements);
        for (Element nextService : serviceElements) {
            BeanDefinitionBuilder serviceBean;
            String serviceInterface = nextService.getAttribute("serviceInterface");
            String serviceName = nextService.getAttribute("service");
            String id = nextService.getAttribute("id");
            if (!StringUtils.hasText((String)id)) {
                id = serviceName;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing httpJavaService(" + id + ")  serviceInterface=" + serviceInterface + ", serviceName=" + serviceName);
            }
            ArrayList<Object> preprocessors = new ArrayList<Object>(2);
            ManagedList postprocessors = new ManagedList(2);
            List<String> returnsStatefulMethodNameList = SvcsNamespaceHandler.parseReturnsStatefulMethodNames(nextService);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(id + " has " + returnsStatefulMethodNameList.size() + " stateful return methods: " + returnsStatefulMethodNameList);
            }
            List<String> returnsStatefulBeanNameList = SvcsNamespaceHandler.parseReturnsStatefulBeanNames(nextService);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(id + " has " + returnsStatefulBeanNameList.size() + " returned stateful beans: " + returnsStatefulBeanNameList);
            }
            Set<String> deleteMethods = SvcsNamespaceHandler.getDeleteMethodNames(nextService);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(id + " has " + deleteMethods.size() + " delete methods: " + deleteMethods);
            }
            ServerRemoteInvocationStatefulServiceURIProcessor uriProcessor = null;
            if (!deleteMethods.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(HttpJavaServiceBeanDefinitionParser.getLogMessageAddingPreprocessor(ServerRemoteInvocationStatefulServiceIdProcessor.class.getName(), id));
                }
                preprocessors.add(new ServerRemoteInvocationStatefulServiceIdProcessor());
                uriProcessor = new ServerRemoteInvocationStatefulServiceURIProcessor();
                if (proxyingLocalBeans) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(HttpJavaServiceBeanDefinitionParser.getLogMessageAddingPostprocessor(StatefulServiceDeletionProcessor.class.getName(), id));
                    }
                    StatefulServiceDeletionProcessor deletionProcessor = new StatefulServiceDeletionProcessor();
                    deletionProcessor.setDeleteStatefulMethodNames(deleteMethods);
                    postprocessors.add(deletionProcessor);
                    SvcsNamespaceHandler.parseStatefulServiceProxyInformation(element, registry, serviceName, serviceInterface);
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Setting delete methods on " + ServerRemoteInvocationStatefulServiceURIProcessor.class.getName() + " for " + id);
                    }
                    uriProcessor.setDeleteStatefulMethodNames(deleteMethods);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(HttpJavaServiceBeanDefinitionParser.getLogMessageAddingPreprocessor(ServerRemoteInvocationStatefulServiceURIProcessor.class.getName(), id));
                }
                preprocessors.add(uriProcessor);
            }
            if (!returnsStatefulMethodNameList.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(HttpJavaServiceBeanDefinitionParser.getLogMessageAddingPostprocessor(ServerRemoteInvocationStatefulServiceResultIdProcessor.class.getName(), id));
                }
                HashSet<String> statefulMethodNamesSet = new HashSet<String>(returnsStatefulMethodNameList);
                ServerRemoteInvocationStatefulServiceResultIdProcessor resultIdProcessor = new ServerRemoteInvocationStatefulServiceResultIdProcessor();
                resultIdProcessor.setReturnsStatefulMethodNames(statefulMethodNamesSet);
                if (proxyingLocalBeans) {
                    if (null == uriProcessor) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Adding " + ServerRemoteInvocationStatefulServiceURIProcessor.class.getName() + " as preprocessor for " + id + " since one was not already added and we have a return stateful method name list");
                        }
                        uriProcessor = new ServerRemoteInvocationStatefulServiceURIProcessor();
                        preprocessors.add(uriProcessor);
                    }
                    String resultProxyProcessorId = id + "ResultProxyProcessor";
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Registering bean of type " + ServerRemoteInvocationStatefulServiceResultProxyProcessor.class.getName() + " with id " + resultProxyProcessorId + " and adding it as a postprocessor for " + id);
                    }
                    BeanDefinitionBuilder resultProxyProcessorBean = BeanDefinitionBuilder.rootBeanDefinition(ServerRemoteInvocationStatefulServiceResultProxyProcessor.class);
                    SvcsNamespaceHandler.addStatefulMethodsMap(resultProxyProcessorBean, returnsStatefulMethodNameList, returnsStatefulBeanNameList, REMOTE_SERVICE_ELEMENT);
                    registry.registerBeanDefinition(resultProxyProcessorId, (BeanDefinition)resultProxyProcessorBean.getBeanDefinition());
                    postprocessors.add(new RuntimeBeanReference(resultProxyProcessorId));
                    postprocessors.add(resultIdProcessor);
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(HttpJavaServiceBeanDefinitionParser.getLogMessageAddingPostprocessor(ServerRemoteInvocationStatefulServiceResultURIProcessor.class.getName(), id));
                    }
                    ServerRemoteInvocationStatefulServiceResultURIProcessor uriResultProcessor = new ServerRemoteInvocationStatefulServiceResultURIProcessor();
                    uriResultProcessor.setReturnsStatefulMethodNames(statefulMethodNamesSet);
                    postprocessors.add(resultIdProcessor);
                    postprocessors.add(uriResultProcessor);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created a total of " + preprocessors.size() + " preprocessors and " + postprocessors.size() + " postprocessors for " + id);
            }
            if (preprocessors.isEmpty() && postprocessors.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Preprocessors and postprocessors are empty, using bean type " + HttpInvokerServiceExporter.class.getName() + " for bean " + id);
                }
                serviceBean = BeanDefinitionBuilder.rootBeanDefinition(HttpInvokerServiceExporter.class);
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Preprocessors and postprocessors are not empty, using bean type " + PostProcessingHttpInvokerServiceExporter.class.getName() + " for bean " + id);
                }
                serviceBean = BeanDefinitionBuilder.rootBeanDefinition(PostProcessingHttpInvokerServiceExporter.class);
                if (!preprocessors.isEmpty()) {
                    serviceBean.addPropertyValue("preProcessors", preprocessors);
                }
                if (!postprocessors.isEmpty()) {
                    serviceBean.addPropertyValue("postProcessors", (Object)postprocessors);
                }
            }
            serviceBean.addPropertyReference("remoteInvocationExecutor", executorRef);
            serviceBean.addPropertyReference("service", serviceName);
            serviceBean.addPropertyValue("serviceInterface", (Object)serviceInterface);
            String registeredId = "/" + id;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registering exported bean as " + registeredId);
            }
            registry.registerBeanDefinition(registeredId, (BeanDefinition)serviceBean.getBeanDefinition());
            list.add(serviceInterface);
        }
        return listBean.getBeanDefinition();
    }

    private static String getLogMessageAddingPreprocessor(String className, String id) {
        return "Adding " + className + " as preprocessor for " + id;
    }

    private static String getLogMessageAddingPostprocessor(String className, String id) {
        return "Adding " + className + " as postprocessor for " + id;
    }
}

