/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import com.sas.framework.services.config.dao.PropertySetFactoryBean;
import com.sas.svcs.springframework.config.DatasourceBeanDefinitionParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jdbc.datasource.lookup.DataSourceLookupFailureException;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class EnvPropertiesBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final Logger LOGGER = LogManager.getLogger(EnvPropertiesBeanDefinitionParser.class);
    static final List<String> DEFAULT_JNDI_NAMES = Arrays.asList("java:comp/env/jdbc/SASAPP", "sas/jdbc/SharedServices");
    private static JndiDataSourceLookup locator = new JndiDataSourceLookup();

    private static String getFirstValidJndiDatasourceName(List<String> jndiNames) {
        for (String name : jndiNames) {
            try {
                DataSource dataSource = locator.getDataSource(name);
                if (null == dataSource) continue;
                return name;
            }
            catch (DataSourceLookupFailureException e) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Datasource with name '" + name + "' does not exist", (Throwable)e);
            }
        }
        return null;
    }

    static String getDataSourceReference(Element element, ParserContext parserContext) {
        String datasourceRef = element.getAttribute("datasource-ref");
        if (!StringUtils.hasText((String)datasourceRef)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("No data source reference specified");
            }
            String jndiName = element.getAttribute("jndi-name");
            List<String> jndiNames = null;
            if (!StringUtils.hasText((String)jndiName)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Searching for data source using default JNDI names: " + StringUtils.collectionToDelimitedString(DEFAULT_JNDI_NAMES, (String)", "));
                }
                jndiNames = DEFAULT_JNDI_NAMES;
                jndiName = EnvPropertiesBeanDefinitionParser.getFirstValidJndiDatasourceName(jndiNames);
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Searching for data source using JNDI name: " + jndiName);
                }
                jndiNames = Collections.singletonList(jndiName);
                jndiName = EnvPropertiesBeanDefinitionParser.getFirstValidJndiDatasourceName(jndiNames);
            }
            if (!StringUtils.hasText((String)jndiName)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Could not find data source using JNDI names: ");
                sb.append(StringUtils.collectionToDelimitedString(jndiNames, (String)", "));
                String msg = sb.toString();
                LOGGER.warn(msg);
                return null;
            }
            DatasourceBeanDefinitionParser datasourceParser = new DatasourceBeanDefinitionParser();
            BeanDefinition definition = datasourceParser.parse(element, parserContext);
            definition.getPropertyValues().addPropertyValue("jndiName", (Object)jndiName);
            String beanName = parserContext.getReaderContext().generateBeanName(definition);
            parserContext.getRegistry().registerBeanDefinition(beanName, definition);
            return beanName;
        }
        return datasourceRef;
    }

    static BeanDefinitionHolder getEnvironmentPropertiesDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder propertiesBuilder = BeanDefinitionBuilder.rootBeanDefinition(PropertySetFactoryBean.class);
        ParserContext innerContext = new ParserContext(parserContext.getReaderContext(), parserContext.getDelegate(), (BeanDefinition)propertiesBuilder.getRawBeanDefinition());
        String datasourceRef = EnvPropertiesBeanDefinitionParser.getDataSourceReference(element, innerContext);
        if (null == datasourceRef) {
            LOGGER.debug("Could not find data source using JNDI.");
            return null;
        }
        propertiesBuilder.addPropertyReference("dataSource", datasourceRef);
        AbstractBeanDefinition definition = propertiesBuilder.getBeanDefinition();
        String beanName = element.getAttribute("id");
        if (!StringUtils.hasText((String)beanName)) {
            beanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)definition);
        }
        if (null != parserContext.getContainingBeanDefinition()) {
            parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)definition);
        }
        BeanDefinitionHolder namedDefinition = new BeanDefinitionHolder((BeanDefinition)definition, beanName);
        return namedDefinition;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionHolder holder = EnvPropertiesBeanDefinitionParser.getEnvironmentPropertiesDefinition(element, parserContext);
        if (null == holder) {
            throw new IllegalStateException("Could not find data source using JNDI.");
        }
        return (AbstractBeanDefinition)holder.getBeanDefinition();
    }
}

