/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import com.sas.svcs.springframework.config.DefaultProvidedPropertyPlaceholderConfigurer;
import com.sas.svcs.springframework.config.EnvPropertiesBeanDefinitionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class EnvConfigurerBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static Logger logger = LogManager.getLogger(EnvConfigurerBeanDefinitionParser.class);

    String getEnvPropertiesRef(Element element, ParserContext parserContext, BeanDefinition parent) {
        ParserContext innerContext;
        BeanDefinitionHolder namedDefinition;
        String environmentRef = element.getAttribute("environment-ref");
        if (StringUtils.hasText((String)environmentRef)) {
            if (logger.isInfoEnabled()) {
                logger.info("Using pre-existing environment properties bean named '" + environmentRef + "'");
            }
            return environmentRef;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Generating environment properties");
        }
        if (null == (namedDefinition = EnvPropertiesBeanDefinitionParser.getEnvironmentPropertiesDefinition(element, innerContext = new ParserContext(parserContext.getReaderContext(), parserContext.getDelegate(), parent)))) {
            return null;
        }
        return namedDefinition.getBeanName();
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder configurerBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultProvidedPropertyPlaceholderConfigurer.class);
        String prefix = element.getAttribute("placeholder-prefix");
        String suffix = element.getAttribute("placeholder-suffix");
        String envRef = this.getEnvPropertiesRef(element, parserContext, (BeanDefinition)configurerBuilder.getRawBeanDefinition());
        if (null != envRef) {
            configurerBuilder.addPropertyReference("properties", envRef);
        }
        if (StringUtils.hasText((String)prefix)) {
            configurerBuilder.addPropertyValue("placeholderPrefix", (Object)prefix);
        } else {
            configurerBuilder.addPropertyValue("placeholderPrefix", (Object)"@{");
        }
        if (StringUtils.hasText((String)suffix)) {
            configurerBuilder.addPropertyValue("placeholderSuffix", (Object)suffix);
        } else {
            configurerBuilder.addPropertyValue("placeholderSuffix", (Object)"}");
        }
        return configurerBuilder.getBeanDefinition();
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

