/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class DefaultProvidedPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final Logger LOGGER = LogManager.getLogger(DefaultProvidedPropertyPlaceholderConfigurer.class);
    private static final String DEFAULT_DELIMITER = ":";
    private String delimiter = ":";

    public void setDelimiter(String d) {
        this.delimiter = d;
    }

    protected String resolvePlaceholder(String placeholder, Properties props, int systemPropertiesMode) {
        boolean debug = LOGGER.isDebugEnabled();
        int colonIndex = placeholder.indexOf(this.delimiter);
        if (colonIndex > 0) {
            String holder = placeholder.substring(0, colonIndex);
            String defaultValue = placeholder.substring(colonIndex + 1);
            if (debug) {
                LOGGER.debug("Resolving '" + holder + "', with default value '" + defaultValue + "'.");
            }
            String resolvedValue = super.resolvePlaceholder(holder, props, systemPropertiesMode);
            if (debug) {
                LOGGER.debug("Resolved value is '" + resolvedValue + "'.");
            }
            if (null == resolvedValue || resolvedValue.trim().length() == 0) {
                return defaultValue;
            }
            return resolvedValue;
        }
        return super.resolvePlaceholder(placeholder, props, systemPropertiesMode);
    }
}

